/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.OptionalDouble;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}4AAC\u0006\u0001%!Iq\u0004\u0001BC\u0002\u0013\u00051\u0002\t\u0005\t_\u0001\u0011\t\u0011)A\u0005C!I\u0001\u0007\u0001BC\u0002\u0013\u00051\"\r\u0005\tq\u0001\u0011\t\u0011)A\u0005e!)\u0011\b\u0001C\u0001u!)q\b\u0001C\u0001\u0001\")q\b\u0001C\u0005#\")\u0011\r\u0001C\u0001E\")\u0011\u000e\u0001C\u0001U\nQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe*\u0011A\"D\u0001\t[\u0016$\u0018\rZ1uC*\u0011abD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u0010\u0003\u0015)H/\u001b7t\u0013\tq2DA\u0004M_\u001e<\u0017N\\4\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\u0005\t\u0003C\u0001\u0012-\u001d\t\u0019#F\u0004\u0002%S9\u0011Q\u0005K\u0007\u0002M)\u0011q%E\u0001\u0007yI|w\u000e\u001e \n\u0003AI!AD\b\n\u0005-j\u0011\u0001D)v_R\fg)Y2u_JL\u0018BA\u0017/\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u00111&D\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/F\u00013!\t\u0019d'D\u00015\u0015\t)t\"A\u0004oKR<xN]6\n\u0005]\"$\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mjd\b\u0005\u0002=\u00015\t1\u0002C\u0003 \u000b\u0001\u0007\u0011\u0005C\u00031\u000b\u0001\u0007!'\u0001\u0004va\u0012\fG/\u001a\u000b\u0003\u0003\u0012\u0003\"\u0001\u0006\"\n\u0005\r+\"\u0001B+oSRDQ!\u0012\u0004A\u0002\u0019\u000b1\"];pi\u0006\u001cH)\u001a7uCB\u0011qiT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0006S6\fw-\u001a\u0006\u0003!-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001\u000b\u0013\u0002\u0012\u00072LWM\u001c;Rk>$\u0018m\u001d#fYR\fGcA!S9\")1k\u0002a\u0001)\u00061QM\u001c;jif\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u000bE,x\u000e^1\u000b\u0005eS\u0015AB2p[6|g.\u0003\u0002\\-\n\t2\t\\5f]R\fVo\u001c;b\u000b:$\u0018\u000e^=\t\u000bu;\u0001\u0019\u00010\u0002\u0015E,x\u000e^1EK2$\u0018\r\u0005\u0002H?&\u0011\u0001\r\u0013\u0002\u0011\u00072LWM\u001c;Rk>$\u0018\rR3mi\u0006\fQ\u0002[1oI2,\u0017\n])v_R\fGcA!dQ\")A\r\u0003a\u0001K\u0006A\u0011\u000e]#oi&$\u0018\u0010\u0005\u0002=M&\u0011qm\u0003\u0002\f#V|G/Y#oi&$\u0018\u0010C\u0003^\u0011\u0001\u0007a,A\u000eiC:$G.Z+tKJ\u001cE.[3oiF+x\u000e^1DQ\u0006tw-\u001a\u000b\u0005\u0003.lw\u000fC\u0003m\u0013\u0001\u0007Q-A\u0006rk>$\u0018-\u00128uSRL\b\"\u00028\n\u0001\u0004y\u0017aA6fsB\u0011\u0001\u000f\u001e\b\u0003cJ\u0004\"!J\u000b\n\u0005M,\u0012A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a]\u000b\t\u000baL\u0001\u0019A=\u0002\u00119,wOV1mk\u0016\u00042\u0001\u0006>}\u0013\tYXC\u0001\u0004PaRLwN\u001c\t\u0003)uL!A`\u000b\u0003\r\u0011{WO\u00197f\u0001")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().entrySet().forEach(e -> this.update((ClientQuotaEntity)e.getKey(), (ClientQuotaDelta)e.getValue()));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            this.handleIpQuota((QuotaEntity)product, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().entrySet().forEach(e -> this.handleUserClientQuotaChange((QuotaEntity)userClientEntity, (String)e.getKey(), (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble((OptionalDouble)e.getValue())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> x$1)));
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Ignoring unsupported quota entity ").append(entity).append(".").toString());
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            Some some;
            String ip = ((IpEntity)ipEntity).ip();
            try {
                some = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unable to resolve address ").append(ip).toString());
            }
            none$ = some;
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        quotaDelta.changes().entrySet().forEach(arg_0 -> ClientQuotaMetadataManager.$anonfun$handleIpQuota$1(this, ipEntity, (Option)none$, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        void var14_16;
        void var13_15;
        Some some;
        None$ none$;
        ClientQuotaManager clientQuotaManager;
        if ("consumer_byte_rate".equals(key)) {
            clientQuotaManager = this.quotaManagers().fetch();
        } else if ("producer_byte_rate".equals(key)) {
            clientQuotaManager = this.quotaManagers().produce();
        } else if ("request_percentage".equals(key)) {
            clientQuotaManager = this.quotaManagers().request();
        } else if ("controller_mutation_rate".equals(key)) {
            clientQuotaManager = this.quotaManagers().controllerMutation();
        } else {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(key).append(" for entity ").append(quotaEntity).toString());
            return;
        }
        if (quotaEntity instanceof UserEntity) {
            String user = ((UserEntity)quotaEntity).user();
            none$ = None$.MODULE$;
            some = new Some((Object)Sanitizer.sanitize((String)user));
        } else if (DefaultUserEntity$.MODULE$.equals(quotaEntity)) {
            none$ = None$.MODULE$;
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (quotaEntity instanceof ClientIdEntity) {
            String clientId = ((ClientIdEntity)quotaEntity).clientId();
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
            some = None$.MODULE$;
        } else if (DefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
            some = None$.MODULE$;
        } else if (quotaEntity instanceof ExplicitUserExplicitClientIdEntity) {
            ExplicitUserExplicitClientIdEntity explicitUserExplicitClientIdEntity = (ExplicitUserExplicitClientIdEntity)quotaEntity;
            String user = explicitUserExplicitClientIdEntity.user();
            String clientId = explicitUserExplicitClientIdEntity.clientId();
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
            some = new Some((Object)Sanitizer.sanitize((String)user));
        } else if (quotaEntity instanceof ExplicitUserDefaultClientIdEntity) {
            String user = ((ExplicitUserDefaultClientIdEntity)quotaEntity).user();
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
            some = new Some((Object)Sanitizer.sanitize((String)user));
        } else if (quotaEntity instanceof DefaultUserExplicitClientIdEntity) {
            String clientId = ((DefaultUserExplicitClientIdEntity)quotaEntity).clientId();
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else {
            boolean bl = quotaEntity instanceof IpEntity ? true : DefaultIpEntity$.MODULE$.equals(quotaEntity);
            if (bl) {
                throw new IllegalStateException("Should not see IP quota entities here");
            }
            throw new MatchError((Object)quotaEntity);
        }
        Option sanitizedUser = (Option)some;
        Option sanitizedClientId = (Option)none$;
        void sanitizedUser2 = var13_15;
        void sanitizedClientId2 = var14_16;
        Option quotaValue = newValue.map((Function1 & Serializable & scala.Serializable)x$4 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble((Object)x$4)));
        try {
            clientQuotaManager.updateQuota((Option<String>)sanitizedUser2, (Option<String>)sanitizedClientId2.map((Function1 & Serializable & scala.Serializable)x$1 -> Sanitizer.desanitize((String)x$1)), (Option<String>)sanitizedClientId2, (Option<Quota>)quotaValue);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Failed to update user-client quota ").append(quotaEntity).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleIpQuota$1(ClientQuotaMetadataManager $this, QuotaEntity ipEntity$1, Option inetAddress$1, Map.Entry e) {
        String quotaName = (String)e.getKey();
        OptionalDouble quotaValue = (OptionalDouble)e.getValue();
        if (!quotaName.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaName).append(" for entity ").append(ipEntity$1).toString());
            return;
        }
        try {
            $this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)inetAddress$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to update IP quota ").append(ipEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$4) {
        return new Quota(x$4, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
        Logging.$init$(this);
    }
}

