/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.log.UnifiedLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r%b\u0001\u0002!B\u0001\u0019C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"AA\u000f\u0001B\u0001B\u0003%a\r\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0001w\u0011%\t\t\u0002\u0001B\u0001B\u0003%q\u000f\u0003\u0006\u0002\u0014\u0001\u0011)\u0019!C\u0001\u0003+A!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\f\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011%\tY\u0004\u0001a\u0001\n\u0013\ti\u0004C\u0005\u0002@\u0001\u0001\r\u0011\"\u0003\u0002B!9\u0011Q\n\u0001!B\u0013\u0001\u0007BCA,\u0001\t\u0007I\u0011A!\u0002Z!A\u0011\u0011\r\u0001!\u0002\u0013\tY\u0006\u0003\u0006\u0002d\u0001\u0011\r\u0011\"\u0001B\u0003KB\u0001\"!\u001c\u0001A\u0003%\u0011q\r\u0005\u000b\u0003_\u0002!\u0019!C\u0001\u0003\u0006E\u0004\u0002\u0003B#\u0001\u0001\u0006I!a\u001d\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J!A!1\f\u0001\u0005\u0002\u0005\u0013i\u0006C\u0004\u0003`\u0001!\t!a:\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002h\"9!1\r\u0001\u0005B\t\u0015\u0004b\u0002B7\u0001\u0011\u0005#q\u000e\u0005\b\u0005w\u0002A\u0011\tB?\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqAa#\u0001\t\u0003\u0011i\tC\u0005\u0003\u001e\u0002\t\n\u0011\"\u0001\u0003 \"9!Q\u0017\u0001\u0005\u0002\t]\u0006b\u0002Bb\u0001\u0011\u0005!Q\u0019\u0005\b\u0005\u0017\u0004A\u0011\u0001Bg\u0011\u001d\u00119\u000e\u0001C\u0001\u00053DqA!8\u0001\t\u0003\u0011y\u000eC\u0004\u0003l\u0002!\tA!<\t\u0013\t]\b!%A\u0005\u0002\te\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\t\u0007\u0013\u0001A\u0011A\"\u0002>!A11\u0002\u0001\u0005\u0002\u0005\u0013iFB\u0004\u0002\u0004\u0002\u0001\u0011)!\"\t\u0015\u00055uE!A!\u0002\u0013\ty\tC\u0004\u0002,\u001d\"\t!!&\t\u000f\u0005eu\u0005\"\u0015\u0002\u001c\"I\u0011\u0011V\u0014C\u0002\u0013\u0005\u00111\u0016\u0005\t\u0003g;\u0003\u0015!\u0003\u0002.\"I\u0011QW\u0014A\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003\u007f;\u0003\u0019!C\u0001\u0003\u0003D\u0001\"!2(A\u0003&\u0011\u0011\u0018\u0005\n\u0003\u0013<\u0003\u0019!C\u0001\u0003\u0017D\u0011\"a5(\u0001\u0004%\t!!6\t\u0011\u0005ew\u0005)Q\u0005\u0003\u001bDq!!8(\t\u0013\ty\u000eC\u0004\u0002f\u001e\"\t%a:\t\u000f\u0005%x\u0005\"\u0003\u0002l\"9\u00111_\u0014\u0005\n\u0005-\bb\u0002B\u0003O\u0011%!q\u0001\u0005\b\u0005'9C\u0011\u0001B\u000b\u000f\u001d\u0019i!\u0011E\u0001\u0007\u001f1a\u0001Q!\t\u0002\rE\u0001bBA\u0016u\u0011\u000511\u0003\u0005\n\u0007+Q$\u0019!C\u0001\u0007/A\u0001ba\u0007;A\u0003%1\u0011\u0004\u0005\b\u0007;QD\u0011AB\u0010\u0011%\u0019\u0019COI\u0001\n\u0003\u0019)C\u0001\u0006M_\u001e\u001cE.Z1oKJT!AQ\"\u0002\u00071|wMC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019R\u0001A$N'f\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013a!\u00118z%\u00164\u0007C\u0001(R\u001b\u0005y%B\u0001)D\u0003\u0015)H/\u001b7t\u0013\t\u0011vJA\u0004M_\u001e<\u0017N\\4\u0011\u0005Q;V\"A+\u000b\u0005Y\u001b\u0015aB7fiJL7m]\u0005\u00031V\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\tQV,D\u0001\\\u0015\ta6)\u0001\u0004tKJ4XM]\u0005\u0003=n\u0013AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017!D5oSRL\u0017\r\\\"p]\u001aLw\r\u0005\u0002bE6\t\u0011)\u0003\u0002d\u0003\ni1\t\\3b]\u0016\u00148i\u001c8gS\u001e\fq\u0001\\8h\t&\u00148/F\u0001g!\r9'\u000e\\\u0007\u0002Q*\u0011\u0011.S\u0001\u000bG>dG.Z2uS>t\u0017BA6i\u0005\r\u0019V-\u001d\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\f!![8\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0003]\u0004RA\u0014={\u0003\u0017I!!_(\u0003\tA{w\u000e\u001c\t\u0004w\u0006\u001dQ\"\u0001?\u000b\u0005ut\u0018AB2p[6|gN\u0003\u0002E\u007f*!\u0011\u0011AA\u0002\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QA\u0001\u0004_J<\u0017bAA\u0005y\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cA1\u0002\u000e%\u0019\u0011qB!\u0003\u0015Us\u0017NZ5fI2{w-A\u0003m_\u001e\u001c\b%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0003\u0003/\u00012AWA\r\u0013\r\tYb\u0017\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u0005!A/[7f!\u0011\t\u0019#a\n\u000e\u0005\u0005\u0015\"B\u0001)}\u0013\u0011\tI#!\n\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0011\u0005\u0005\u0004\u0001\"B0\n\u0001\u0004\u0001\u0007\"\u00023\n\u0001\u00041\u0007\"B;\n\u0001\u00049\bbBA\n\u0013\u0001\u0007\u0011q\u0003\u0005\n\u0003?I\u0001\u0013!a\u0001\u0003C\taaY8oM&<W#\u00011\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002D\u0005%\u0003c\u0001%\u0002F%\u0019\u0011qI%\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0017Z\u0011\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA!\u001aA\"!\u0015\u0011\u0007!\u000b\u0019&C\u0002\u0002V%\u0013\u0001B^8mCRLG.Z\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\t\tY\u0006E\u0002b\u0003;J1!a\u0018B\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM]\u0001\u0010G2,\u0017M\\3s\u001b\u0006t\u0017mZ3sA\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u0003O\u00022ATA5\u0013\r\tYg\u0014\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!\u0019G.Z1oKJ\u001cXCAA:!\u0019\t)(a\u001f\u0002\u00005\u0011\u0011q\u000f\u0006\u0004\u0003sB\u0017aB7vi\u0006\u0014G.Z\u0005\u0005\u0003{\n9HA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcAAAO5\t\u0001AA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0004O\u0005\u001d\u0005c\u0001(\u0002\n&\u0019\u00111R(\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\rZ\u0001\ti\"\u0014X-\u00193JIB\u0019\u0001*!%\n\u0007\u0005M\u0015JA\u0002J]R$B!a \u0002\u0018\"9\u0011QR\u0015A\u0002\u0005=\u0015A\u00037pO\u001e,'OT1nKV\u0011\u0011Q\u0014\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u00159\u0002\t1\fgnZ\u0005\u0005\u0003O\u000b\tK\u0001\u0004TiJLgnZ\u0001\bG2,\u0017M\\3s+\t\ti\u000bE\u0002b\u0003_K1!!-B\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\nY\u0006\u001cHo\u0015;biN,\"!!/\u0011\u0007\u0005\fY,C\u0002\u0002>\u0006\u0013Ab\u00117fC:,'o\u0015;biN\fQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA\"\u0003\u0007D\u0011\"a\u0013/\u0003\u0003\u0005\r!!/\u0002\u00151\f7\u000f^*uCR\u001c\b\u0005K\u00020\u0003#\n\u0011\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t+\t\ti\rE\u0002b\u0003\u001fL1!!5B\u00055\u0001&/Z\"mK\u0006t7\u000b^1ug\u0006)B.Y:u!J,7\t\\3b]N#\u0018\r^:`I\u0015\fH\u0003BA\"\u0003/D\u0011\"a\u00132\u0003\u0003\u0005\r!!4\u0002%1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8\u000f\t\u0015\u0004e\u0005E\u0013!C2iK\u000e\\Gi\u001c8f)\u0011\t\u0019%!9\t\r\u0005\r8\u00071\u0001{\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0001Z8X_J\\GCAA\"\u0003Q!(/_\"mK\u0006tg)\u001b7uQ&,7\u000f\u001e'pOR\u0011\u0011Q\u001e\t\u0004\u0011\u0006=\u0018bAAy\u0013\n9!i\\8mK\u0006t\u0017!E2mK\u0006tg)\u001b7uQ&,7\u000f\u001e'pO\"*a'a>\u0003\u0004A)\u0001*!?\u0002~&\u0019\u00111`%\u0003\rQD'o\\<t!\r\t\u0017q`\u0005\u0004\u0005\u0003\t%\u0001\u0006'pO\u000ecW-\u00198j]\u001e,\u0005pY3qi&|gn\t\u0002\u0002~\u0006A1\r\\3b]2{w\r\u0006\u0003\u0002D\t%\u0001b\u0002B\u0006o\u0001\u0007!QB\u0001\nG2,\u0017M\\1cY\u0016\u00042!\u0019B\b\u0013\r\u0011\t\"\u0011\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u0003:fG>\u0014Hm\u0015;biN$B\"a\u0011\u0003\u0018\tm!1\u0007B\u001f\u0005\u0003BqA!\u00079\u0001\u0004\ty)\u0001\u0002jI\"9!Q\u0004\u001dA\u0002\t}\u0011\u0001\u00028b[\u0016\u0004BA!\t\u000309!!1\u0005B\u0016!\r\u0011)#S\u0007\u0003\u0005OQ1A!\u000bF\u0003\u0019a$o\\8u}%\u0019!QF%\u0002\rA\u0013X\rZ3g\u0013\u0011\t9K!\r\u000b\u0007\t5\u0012\nC\u0004\u00036a\u0002\rAa\u000e\u0002\t\u0019\u0014x.\u001c\t\u0004\u0011\ne\u0012b\u0001B\u001e\u0013\n!Aj\u001c8h\u0011\u001d\u0011y\u0004\u000fa\u0001\u0005o\t!\u0001^8\t\u000f\t\r\u0003\b1\u0001\u0002:\u0006)1\u000f^1ug\u0006I1\r\\3b]\u0016\u00148\u000fI\u0001\u0016[\u0006DxJ^3s\u00072,\u0017M\\3s)\"\u0014X-\u00193t)\u0011\tyIa\u0013\t\u000f\t53\u00031\u0001\u0003P\u0005\ta\rE\u0004I\u0005#\nyH!\u0016\n\u0007\tM\u0013JA\u0005Gk:\u001cG/[8ocA\u0019\u0001Ja\u0016\n\u0007\te\u0013J\u0001\u0004E_V\u0014G.Z\u0001\u0010I\u0016\fG\r\u00165sK\u0006$7i\\;oiV\u0011\u0011qR\u0001\bgR\f'\u000f^;q\u0003!\u0019\b.\u001e;e_^t\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005O\u0002Ra\u001aB5\u0005?I1Aa\u001bi\u0005\r\u0019V\r^\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$B!a\u0011\u0003r!9!1\u000f\rA\u0002\tU\u0014!\u00038fo\u000e{gNZ5h!\rQ&qO\u0005\u0004\u0005sZ&aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1\u00111\tB@\u0005\u0007CqA!!\u001a\u0001\u0004\u0011)(A\u0005pY\u0012\u001cuN\u001c4jO\"9!1O\rA\u0002\tU\u0014!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002D\t%\u0005BBAr5\u0001\u0007!0A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$b!a\u0011\u0003\u0010\nM\u0005B\u0002BI7\u0001\u0007A.A\u0004eCR\fG)\u001b:\t\u0013\tU5\u0004%AA\u0002\t]\u0015!\u00059beRLG/[8o)>\u0014V-\\8wKB!\u0001J!'{\u0013\r\u0011Y*\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u00027U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tK\u000b\u0003\u0003\u0018\n\r6F\u0001BS!\u0011\u00119K!-\u000e\u0005\t%&\u0002\u0002BV\u0005[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=\u0016*\u0001\u0006b]:|G/\u0019;j_:LAAa-\u0003*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\t\u0003\u0007\u0012ILa/\u0003@\"1\u00111]\u000fA\u0002iDaA!0\u001e\u0001\u0004a\u0017\u0001D:pkJ\u001cW\rT8h\t&\u0014\bB\u0002Ba;\u0001\u0007A.\u0001\u0006eKN$Hj\\4ESJ\f1\u0003[1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016$B!a\u0011\u0003H\"9!\u0011\u001a\u0010A\u0002\t}\u0011a\u00013je\u00069R.Y=cKR\u0013XO\\2bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\t\u0003\u0007\u0012yM!5\u0003T\"1!\u0011S\u0010A\u00021Da!a9 \u0001\u0004Q\bb\u0002Bk?\u0001\u0007!qG\u0001\u0007_\u001a47/\u001a;\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u00111\tBn\u0011\u0019\t\u0019\u000f\ta\u0001u\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA\"\u0005CDqAa9\"\u0001\u0004\u0011)/A\bu_BL7\rU1si&$\u0018n\u001c8t!\u00119'q\u001d>\n\u0007\t%\bN\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u00031\tw/Y5u\u00072,\u0017M\\3e)!\tiOa<\u0003r\nM\bBBArE\u0001\u0007!\u0010C\u0004\u0003V\n\u0002\rAa\u000e\t\u0013\tU(\u0005%AA\u0002\t]\u0012!C7bq^\u000b\u0017\u000e^'t\u0003Y\tw/Y5u\u00072,\u0017M\\3eI\u0011,g-Y;mi\u0012\u001aTC\u0001B~U\u0011\u00119Da)\u0002MA\fWo]3DY\u0016\fg.\u001b8h\r>\u0014hj\u001c8D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0004\u0002A)qMa:\u0004\u0004A1\u0001j!\u0002{\u0003\u0017I1aa\u0002J\u0005\u0019!V\u000f\u001d7fe\u0005i1-\u001e:sK:$8i\u001c8gS\u001e\fAb\u00197fC:,'oQ8v]R\f!\u0002T8h\u00072,\u0017M\\3s!\t\t'h\u0005\u0002;\u000fR\u00111qB\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0019I\u0002E\u0003h\u0005S\ni*\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u00035\u0019G.Z1oKJ\u001cuN\u001c4jOR\u0019\u0001m!\t\t\u000f\u0005mb\b1\u0001\u0003v\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"aa\n+\t\u0005\u0005\"1\u0015")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond();
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(ltc);
            }
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            int n;
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    n = log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(null);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

