# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vcenter.guest.
#---------------------------------------------------------------------------

"""
The ``com.vmware.vcenter.guest_client`` module provides classes for managing
guest customization specifications in the vCenter Server.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class HostnameGenerator(VapiStruct):
    """
    The ``HostnameGenerator`` class specifies various mechanisms of generating
    the hostname for the guest inside the virtual machine while customization.
    This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'FIXED' : [('fixed_name', True)],
                'PREFIX' : [('prefix', True)],
                'VIRTUAL_MACHINE' : [],
                'USER_INPUT_REQUIRED' : [],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 fixed_name=None,
                 prefix=None,
                ):
        """
        :type  type: :class:`HostnameGenerator.Type`
        :param type: The type of the Name Generator. This attribute was added in vSphere
            API 7.0.0.0.
        :type  fixed_name: :class:`str`
        :param fixed_name: The virtual machine name specified by the client. This attribute
            was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`HostnameGenerator.Type.FIXED`.
        :type  prefix: :class:`str`
        :param prefix: Base prefix, to which a unique number is appended. This attribute
            was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`HostnameGenerator.Type.PREFIX`.
        """
        self.type = type
        self.fixed_name = fixed_name
        self.prefix = prefix
        VapiStruct.__init__(self)


    class Type(Enum):
        """
        The ``HostnameGenerator.Type`` class specifies different types of Name
        Generators. This enumeration was added in vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        FIXED = None
        """
        Specifies that a fixed name should be used for the hostname for the virtual
        machine during the customization. This class attribute was added in vSphere
        API 7.0.0.0.

        """
        PREFIX = None
        """
        Specifies that a unique name should be generated by concatenating the base
        string with a number including the network name of the guest. 
        
        Virtual machine names are unique across the set of hosts and virtual
        machines known to the VirtualCenter instance. VirtualCenter tracks the
        network names of virtual machines as well as hosts. VMware Tools runs in a
        guest operating system and reports information to VirtualCenter.. This
        class attribute was added in vSphere API 7.0.0.0.

        """
        VIRTUAL_MACHINE = None
        """
        Specifies that the VirtualCenter should generate a virtual machine name. 
        
        The name is generated from a base prefix comprising the virtual machine
        entity name. A number is appended, if necessary, to make it unique. 
        
        Virtual machine names are unique across the set of hosts and virtual
        machines known to the VirtualCenter instance. VirtualCenter tracks the
        network names of the virtual machines as well as hosts. VMware Tools runs
        in a guest operating system and reports information to VirtualCenter,
        including the network name of the guest.. This class attribute was added in
        vSphere API 7.0.0.0.

        """
        USER_INPUT_REQUIRED = None
        """
        Indicates that the host name is not specified in advance. The user must
        provide a valid value when the actual customization spec is applied to a
        virtual machine. This class attribute was added in vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Type` instance.
            """
            Enum.__init__(string)

    Type._set_values({
        'FIXED': Type('FIXED'),
        'PREFIX': Type('PREFIX'),
        'VIRTUAL_MACHINE': Type('VIRTUAL_MACHINE'),
        'USER_INPUT_REQUIRED': Type('USER_INPUT_REQUIRED'),
    })
    Type._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.hostname_generator.type',
        Type))

HostnameGenerator._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.hostname_generator', {
        'type': type.ReferenceType(__name__, 'HostnameGenerator.Type'),
        'fixed_name': type.OptionalType(type.StringType()),
        'prefix': type.OptionalType(type.StringType()),
    },
    HostnameGenerator,
    False,
    None))



class UserData(VapiStruct):
    """
    The ``UserData`` class specifies the personal data pertaining to the user
    of the Windows guest operating system. This class maps to the UserData key
    in the sysprep.xml answer file. These values are transferred directly into
    the sysprep.xml file that VirtualCenter stores on the target virtual disk.
    For more detailed information about performing unattended installation,
    check https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx.
    This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 computer_name=None,
                 full_name=None,
                 organization=None,
                 product_key=None,
                ):
        """
        :type  computer_name: :class:`HostnameGenerator`
        :param computer_name: The computer name of the (Windows) virtual machine. A computer name
            may contain letters (A-Z), numbers(0-9) and hyphens (-) but no
            spaces or periods (.). The name may not consist entirely of digits.
            A computer name is restricted to 15 characters in length. If the
            computer name is longer than 15 characters, it will be truncated to
            15 characters. Check :class:`HostnameGenerator` for various
            options. This attribute was added in vSphere API 7.0.0.0.
        :type  full_name: :class:`str`
        :param full_name: Full name of the end user. Note that this is not the username but
            full name specified in "Firstname Lastname" format. This attribute
            was added in vSphere API 7.0.0.0.
        :type  organization: :class:`str`
        :param organization: Name of the organization that owns the computer. This attribute was
            added in vSphere API 7.0.0.0.
        :type  product_key: :class:`str`
        :param product_key: The product Key to use for activating Windows guest operating
            system. This attribute was added in vSphere API 7.0.0.0.
        """
        self.computer_name = computer_name
        self.full_name = full_name
        self.organization = organization
        self.product_key = product_key
        VapiStruct.__init__(self)


UserData._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.user_data', {
        'computer_name': type.ReferenceType(__name__, 'HostnameGenerator'),
        'full_name': type.StringType(),
        'organization': type.StringType(),
        'product_key': type.StringType(),
    },
    UserData,
    False,
    None))



class Domain(VapiStruct):
    """
    The ``Domain`` class specifies the information needed to join a workgroup
    or domain. This structure maps to the Identification key in the sysprep.xml
    answer file. These values are transferred into the sysprep.xml file that
    VirtualCenter stores on the target virtual disk. For more information about
    performing unattended installation, check
    https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx. This
    class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'WORKGROUP' : [('workgroup', True)],
                'DOMAIN' : [('domain', True), ('domain_username', True), ('domain_password', True)],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 workgroup=None,
                 domain=None,
                 domain_username=None,
                 domain_password=None,
                ):
        """
        :type  type: :class:`Domain.Type`
        :param type: The type of network to join after the customization. This attribute
            was added in vSphere API 7.0.0.0.
        :type  workgroup: :class:`str`
        :param workgroup: The workgroup that the virtual machine should join. This attribute
            was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Domain.Type.WORKGROUP`.
        :type  domain: :class:`str`
        :param domain: The domain to which the virtual machine should be joined. This
            attribute was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Domain.Type.DOMAIN`.
        :type  domain_username: :class:`str`
        :param domain_username: The domain user that has permission to join the domain after
            virtual machine is joined. This attribute was added in vSphere API
            7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Domain.Type.DOMAIN`.
        :type  domain_password: :class:`str`
        :param domain_password: The domain user password that has permission to join the
            :attr:`Domain.domain_username` after customization. This attribute
            was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Domain.Type.DOMAIN`.
        """
        self.type = type
        self.workgroup = workgroup
        self.domain = domain
        self.domain_username = domain_username
        self.domain_password = domain_password
        VapiStruct.__init__(self)


    class Type(Enum):
        """
        The ``Domain.Type`` class defines the types of network the virtual machine
        should join to after the customization is completed. This enumeration was
        added in vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        WORKGROUP = None
        """
        The virtual machine should be be joined to a workgroup. This class
        attribute was added in vSphere API 7.0.0.0.

        """
        DOMAIN = None
        """
        The virtual machine should be be joined to a domain. This class attribute
        was added in vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Type` instance.
            """
            Enum.__init__(string)

    Type._set_values({
        'WORKGROUP': Type('WORKGROUP'),
        'DOMAIN': Type('DOMAIN'),
    })
    Type._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.domain.type',
        Type))

Domain._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.domain', {
        'type': type.ReferenceType(__name__, 'Domain.Type'),
        'workgroup': type.OptionalType(type.StringType()),
        'domain': type.OptionalType(type.StringType()),
        'domain_username': type.OptionalType(type.StringType()),
        'domain_password': type.OptionalType(type.SecretType()),
    },
    Domain,
    False,
    None))



class GuiUnattended(VapiStruct):
    """
    The ``GuiUnattended`` class maps to the GuiUnattended key in the
    sysprep.xml answer file. These values are plugged directly into the
    sysprep.xml file that VirtualCenter stores on the target virtual disk. For
    more detailed information about performing unattended installations, check
    https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx. This
    class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 auto_logon=None,
                 auto_logon_count=None,
                 password=None,
                 time_zone=None,
                ):
        """
        :type  auto_logon: :class:`bool`
        :param auto_logon: Flag to determine whether or not the machine automatically logs on
            as Administrator. See the :attr:`GuiUnattended.password` property.
            If :attr:`GuiUnattended.auto_logon` flag is set, then
            :attr:`GuiUnattended.password` must not be None or the guest
            customization will fail. This attribute was added in vSphere API
            7.0.0.0.
        :type  auto_logon_count: :class:`long`
        :param auto_logon_count: If the :attr:`GuiUnattended.auto_logon` flag is :class:`set`, then
            this property specifies the number of times the machine should
            automatically log on as Administrator. Generally it should be 1,
            but if the setup requires a number of reboots, you may want to
            increase it. This number may be determined by the list of commands.
            This attribute was added in vSphere API 7.0.0.0.
        :type  password: :class:`str` or ``None``
        :param password: The new administrator password for the machine. To specify that the
            password should be set to blank (that is, no password), leave it
            unset. This attribute was added in vSphere API 7.0.0.0.
            If None, blank password will be used.
        :type  time_zone: :class:`long`
        :param time_zone: The time zone index for the virtual machine. Numbers correspond to
            time zones at
            https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values.
            This attribute was added in vSphere API 7.0.0.0.
        """
        self.auto_logon = auto_logon
        self.auto_logon_count = auto_logon_count
        self.password = password
        self.time_zone = time_zone
        VapiStruct.__init__(self)


GuiUnattended._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.gui_unattended', {
        'auto_logon': type.BooleanType(),
        'auto_logon_count': type.IntegerType(),
        'password': type.OptionalType(type.SecretType()),
        'time_zone': type.IntegerType(),
    },
    GuiUnattended,
    False,
    None))



class WindowsSysprep(VapiStruct):
    """
    The ``WindowsSysprep`` class provides all the settings like user details,
    administrator details, etc that need to applied for a windows guest
    operating system during customization. This class was added in vSphere API
    7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 gui_run_once_commands=None,
                 user_data=None,
                 domain=None,
                 gui_unattended=None,
                ):
        """
        :type  gui_run_once_commands: :class:`list` of :class:`str` or ``None``
        :param gui_run_once_commands: A list of commands to run at first user logon, after customizing
            the guest. These commands are directly mapped to the GuiRunOnce key
            in the sysprep.xml answer file. These commands are transferred into
            the sysprep.xml file that VirtualCenter stores on the target
            virtual disk. For more information about performing unattended
            installation, check
            https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx
            The commands listed here ar executed when a user logs on the first
            time after customization completes. The logon may be driven by
            :attr:`GuiUnattended.auto_logon` setting. These commands are
            directly mapped to the GuiRunOnce key in the. This attribute was
            added in vSphere API 7.0.0.0.
            If None, no commands are run.
        :type  user_data: :class:`UserData`
        :param user_data: Personal data pertaining to the owner of the virtual machine. This
            attribute was added in vSphere API 7.0.0.0.
        :type  domain: :class:`Domain` or ``None``
        :param domain: Information needed to join a workgroup or domain. This attribute
            was added in vSphere API 7.0.0.0.
            If None, the guest will not be joined to any workgroup or a domain.
        :type  gui_unattended: :class:`GuiUnattended`
        :param gui_unattended: Information related to unattended installation. This attribute was
            added in vSphere API 7.0.0.0.
        """
        self.gui_run_once_commands = gui_run_once_commands
        self.user_data = user_data
        self.domain = domain
        self.gui_unattended = gui_unattended
        VapiStruct.__init__(self)


WindowsSysprep._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.windows_sysprep', {
        'gui_run_once_commands': type.OptionalType(type.ListType(type.StringType())),
        'user_data': type.ReferenceType(__name__, 'UserData'),
        'domain': type.OptionalType(type.ReferenceType(__name__, 'Domain')),
        'gui_unattended': type.ReferenceType(__name__, 'GuiUnattended'),
    },
    WindowsSysprep,
    False,
    None))



class WindowsConfiguration(VapiStruct):
    """
    The ``WindowsConfiguration`` class specifies the settings for customizing a
    windows guest operating system. This class was added in vSphere API
    7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 reboot=None,
                 sysprep=None,
                 sysprep_xml=None,
                ):
        """
        :type  reboot: :class:`WindowsConfiguration.RebootOption` or ``None``
        :param reboot: A value specifying the action that should be taken after
            customization. This attribute was added in vSphere API 7.0.0.0.
            If None, the :attr:`WindowsConfiguration.RebootOption.REBOOT`
            option will be chosen.
        :type  sysprep: :class:`WindowsSysprep` or ``None``
        :param sysprep: Customization settings like user details, administrator details,
            etc for the windows guest operating system. Exactly one of
            ``sysprep`` or ``sysprepXml`` must be specified. This attribute was
            added in vSphere API 7.0.0.0.
            If None, sysprep settings will not be applied to the windows guest
            operating system.
        :type  sysprep_xml: :class:`str` or ``None``
        :param sysprep_xml: All settings specified in a XML format. This is the content of a
            typical answer.xml file that is used by System administrators
            during the Windows image customization. Check
            https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/update-windows-settings-and-scripts-create-your-own-answer-file-sxs
            Exactly one of ``sysprep`` or ``sysprepXml`` must be specified.
            This attribute was added in vSphere API 7.0.0.0.
            If None, sysprep settings will not be applied to the windows guest
            operating system.
        """
        self.reboot = reboot
        self.sysprep = sysprep
        self.sysprep_xml = sysprep_xml
        VapiStruct.__init__(self)


    class RebootOption(Enum):
        """
        The ``WindowsConfiguration.RebootOption`` class specifies what should be
        done to the guest after the customization. This enumeration was added in
        vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        REBOOT = None
        """
        Reboot the guest after customization. This class attribute was added in
        vSphere API 7.0.0.0.

        """
        NO_REBOOT = None
        """
        Take no action. Leave the guest OS running after customization. This option
        can be used to look at values for debugging purposes. This class attribute
        was added in vSphere API 7.0.0.0.

        """
        SHUTDOWN = None
        """
        Shutdown the guest after customization. This class attribute was added in
        vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`RebootOption` instance.
            """
            Enum.__init__(string)

    RebootOption._set_values({
        'REBOOT': RebootOption('REBOOT'),
        'NO_REBOOT': RebootOption('NO_REBOOT'),
        'SHUTDOWN': RebootOption('SHUTDOWN'),
    })
    RebootOption._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.windows_configuration.reboot_option',
        RebootOption))

WindowsConfiguration._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.windows_configuration', {
        'reboot': type.OptionalType(type.ReferenceType(__name__, 'WindowsConfiguration.RebootOption')),
        'sysprep': type.OptionalType(type.ReferenceType(__name__, 'WindowsSysprep')),
        'sysprep_xml': type.OptionalType(type.StringType()),
    },
    WindowsConfiguration,
    False,
    None))



class LinuxConfiguration(VapiStruct):
    """
    Guest customization Settings to customize a Linux guest operating system. 
    
    The ``LinuxConfiguration`` class contains settings that identify a Linux
    machine in the same way that the :class:`WindowsConfiguration` class
    identifies a Windows machine.. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 hostname=None,
                 domain=None,
                 time_zone=None,
                 script_text=None,
                ):
        """
        :type  hostname: :class:`HostnameGenerator`
        :param hostname: The network host name of the Linux virtual machine. This attribute
            was added in vSphere API 7.0.0.0.
        :type  domain: :class:`str`
        :param domain: The fully qualified domain name. This attribute was added in
            vSphere API 7.0.0.0.
        :type  time_zone: :class:`str` or ``None``
        :param time_zone: The case-sensitive time zone, such as Europe/Sofia. Valid time zone
            values are based on the tz (time zone) database used by Linux. The
            values are strings (:class:`str`) in the form "Area/Location," in
            which Area is a continent or ocean name, and Location is the city,
            island, or other regional designation. 
            
            See the https://kb.vmware.com/kb/2145518 for a list of supported
            time zones for different versions in Linux.. This attribute was
            added in vSphere API 7.0.0.0.
            If None, time zone is not modified inside guest operating system.
        :type  script_text: :class:`str` or ``None``
        :param script_text: The script to run before and after Linux guest customization.
            The max size of the script is 65536 bytes. As long as the script
            (shell, perl, python...) has the right "#!" in the header, it is
            supported. The caller should not assume any environment variables
            when the script is run. 
            
            The script is invoked by the customization engine using the command
            line: 1) with argument "precustomization" before customization, 2)
            with argument "postcustomization" after customization. The script
            should parse this argument and implement pre-customization or
            post-customization task code details in the corresponding block. 
            
             A Linux shell script example: 
            
             ``#!/bin/sh
             if [ x$1 == x"precustomization" ]; then
             echo "Do Precustomization tasks"
             #code for pre-customization actions...
             elif [ x$1 == x"postcustomization" ]; then
             echo "Do Postcustomization tasks"
             #code for post-customization actions...
             fi``. This attribute was added in vSphere API 7.0.0.0.
            If None, no script will be executed.
        """
        self.hostname = hostname
        self.domain = domain
        self.time_zone = time_zone
        self.script_text = script_text
        VapiStruct.__init__(self)


LinuxConfiguration._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.linux_configuration', {
        'hostname': type.ReferenceType(__name__, 'HostnameGenerator'),
        'domain': type.StringType(),
        'time_zone': type.OptionalType(type.StringType()),
        'script_text': type.OptionalType(type.StringType()),
    },
    LinuxConfiguration,
    False,
    None))



class CloudinitConfiguration(VapiStruct):
    """
    Guest customization settings to customize a Linux guest operating system
    with raw cloud-init data. 
    
    The ``CloudinitConfiguration`` class contains settings that configure a
    Linux machine with raw cloud-init data. See
    https://cloudinit.readthedocs.io/en/latest about cloud-init.. This class
    was added in vSphere API 7.0.3.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 metadata=None,
                 userdata=None,
                ):
        """
        :type  metadata: :class:`str`
        :param metadata: Metadata includes the network, instance id and hostname that
            cloud-init processes to configure the virtual machine. It is in
            json or yaml format. The max size of the metadata is 524288 bytes.
            See
            https://cloudinit.readthedocs.io/en/latest/topics/datasources/ovf.html
            about supported meta data formats. This attribute was added in
            vSphere API 7.0.3.0.
        :type  userdata: :class:`str` or ``None``
        :param userdata: Userdata is the user customized content that cloud-init processes
            to configure the virtual machine. See
            https://cloudinit.readthedocs.io/en/latest/topics/format.html about
            user data formats. See
            https://cloudinit.readthedocs.io/en/latest/topics/modules.html#
            about user data modules. The max size of the userdata is 524288
            bytes. This attribute was added in vSphere API 7.0.3.0.
            If None, no cloud-init user data will be used as part of the
            cloud-init configuration.
        """
        self.metadata = metadata
        self.userdata = userdata
        VapiStruct.__init__(self)


CloudinitConfiguration._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.cloudinit_configuration', {
        'metadata': type.StringType(),
        'userdata': type.OptionalType(type.StringType()),
    },
    CloudinitConfiguration,
    False,
    None))



class CloudConfiguration(VapiStruct):
    """
    Guest customization settings to customize a guest operating system with
    cloud configuration. 
    
    The ``CloudConfiguration`` class contains the type of cloud configuration
    and the settings of that cloud configuration.. This class was added in
    vSphere API 7.0.3.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'CLOUDINIT' : [('cloudinit', True)],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 cloudinit=None,
                ):
        """
        :type  type: :class:`CloudConfiguration.Type`
        :param type: The type of the cloud configuration. This attribute was added in
            vSphere API 7.0.3.0.
        :type  cloudinit: :class:`CloudinitConfiguration`
        :param cloudinit: cloud-init configuration. This attribute was added in vSphere API
            7.0.3.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`CloudConfiguration.Type.CLOUDINIT`.
        """
        self.type = type
        self.cloudinit = cloudinit
        VapiStruct.__init__(self)


    class Type(Enum):
        """
        The ``CloudConfiguration.Type`` class specifies different types of the
        cloud configuration. This enumeration was added in vSphere API 7.0.3.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        CLOUDINIT = None
        """
        cloud-init configuration. This class attribute was added in vSphere API
        7.0.3.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Type` instance.
            """
            Enum.__init__(string)

    Type._set_values({
        'CLOUDINIT': Type('CLOUDINIT'),
    })
    Type._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.cloud_configuration.type',
        Type))

CloudConfiguration._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.cloud_configuration', {
        'type': type.ReferenceType(__name__, 'CloudConfiguration.Type'),
        'cloudinit': type.OptionalType(type.ReferenceType(__name__, 'CloudinitConfiguration')),
    },
    CloudConfiguration,
    False,
    None))



class ConfigurationSpec(VapiStruct):
    """
    The ``ConfigurationSpec`` class specifies the settings for customizing a
    guest operating system. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 windows_config=None,
                 linux_config=None,
                 cloud_config=None,
                ):
        """
        :type  windows_config: :class:`WindowsConfiguration` or ``None``
        :param windows_config: Guest customization specification for a Windows guest operating
            system. This attribute was added in vSphere API 7.0.0.0.
            If None, :attr:`ConfigurationSpec.linux_config` or
            :attr:`ConfigurationSpec.cloud_config` must be set. Otherwise, an
            appropriate fault will be thrown.
        :type  linux_config: :class:`LinuxConfiguration` or ``None``
        :param linux_config: Guest customization specification for a linux guest operating
            system. This attribute was added in vSphere API 7.0.0.0.
            If None, :attr:`ConfigurationSpec.windows_config` or
            :attr:`ConfigurationSpec.cloud_config` must be set. Otherwise, an
            appropriate fault will be thrown.
        :type  cloud_config: :class:`CloudConfiguration` or ``None``
        :param cloud_config: Guest customization specification with cloud configuration. This
            attribute was added in vSphere API 7.0.3.0.
            If None, :attr:`ConfigurationSpec.windows_config` or
            :attr:`ConfigurationSpec.linux_config` must be set. Otherwise, an
            appropriate fault will be thrown.
        """
        self.windows_config = windows_config
        self.linux_config = linux_config
        self.cloud_config = cloud_config
        VapiStruct.__init__(self)


ConfigurationSpec._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.configuration_spec', {
        'windows_config': type.OptionalType(type.ReferenceType(__name__, 'WindowsConfiguration')),
        'linux_config': type.OptionalType(type.ReferenceType(__name__, 'LinuxConfiguration')),
        'cloud_config': type.OptionalType(type.ReferenceType(__name__, 'CloudConfiguration')),
    },
    ConfigurationSpec,
    False,
    None))



class GlobalDNSSettings(VapiStruct):
    """
    The ``GlobalDNSSettings`` class specifies a collection of global IP
    settings in the guest operating system. In Linux, DNS server settings are
    global. The settings can either be statically set or supplied by a DHCP
    server. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 dns_suffix_list=None,
                 dns_servers=None,
                ):
        """
        :type  dns_suffix_list: :class:`list` of :class:`str` or ``None``
        :param dns_suffix_list: List of name resolution suffixes for the virtual network adapter.
            This list applies to both Windows and Linux guest customization.
            For Linux, this setting is global, whereas in Windows, this setting
            is listed on a per-adapter basis. This attribute was added in
            vSphere API 7.0.0.0.
            If None, no DNS suffixes are set.
        :type  dns_servers: :class:`list` of :class:`str` or ``None``
        :param dns_servers: List of DNS servers, for a virtual network adapter with a static IP
            address. If this list is empty, then the guest operating system is
            expected to use a DHCP server to get its DNS server settings. These
            settings configure the virtual machine to use the specified DNS
            servers. These DNS server settings are listed in the order of
            preference. This attribute was added in vSphere API 7.0.0.0.
            If None, no DNS servers are set.
        """
        self.dns_suffix_list = dns_suffix_list
        self.dns_servers = dns_servers
        VapiStruct.__init__(self)


GlobalDNSSettings._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.global_DNS_settings', {
        'dns_suffix_list': type.OptionalType(type.ListType(type.StringType())),
        'dns_servers': type.OptionalType(type.ListType(type.StringType())),
    },
    GlobalDNSSettings,
    False,
    None))



class Ipv4(VapiStruct):
    """
    The ``Ipv4`` class specifies the IPv4 settings that need to be applied to a
    virtual network adapter. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'STATIC' : [('ip_address', True), ('prefix', True)],
                'DHCP' : [],
                'USER_INPUT_REQUIRED' : [],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 ip_address=None,
                 prefix=None,
                 gateways=None,
                ):
        """
        :type  type: :class:`Ipv4.Type`
        :param type: The type of the IPv4 configuration. This attribute was added in
            vSphere API 7.0.0.0.
        :type  ip_address: :class:`str`
        :param ip_address: The static IPv4 address. This attribute was added in vSphere API
            7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Ipv4.Type.STATIC`.
        :type  prefix: :class:`long`
        :param prefix: The IPv4 CIDR prefix, for example, 24. See
            http://www.oav.net/mirrors/cidr.html for netmask-to-prefix
            conversion. This attribute was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Ipv4.Type.STATIC`.
        :type  gateways: :class:`list` of :class:`str` or ``None``
        :param gateways: Gateways for the IPv4 address. This attribute was added in vSphere
            API 7.0.0.0.
            If None, no gateways are set.
        """
        self.type = type
        self.ip_address = ip_address
        self.prefix = prefix
        self.gateways = gateways
        VapiStruct.__init__(self)


    class Type(Enum):
        """
        The ``Ipv4.Type`` class specifies different types of the IPv4
        configuration. This enumeration was added in vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        DHCP = None
        """
        DHCP configuration. This class attribute was added in vSphere API 7.0.0.0.

        """
        STATIC = None
        """
        Static configuration. This class attribute was added in vSphere API
        7.0.0.0.

        """
        USER_INPUT_REQUIRED = None
        """
        Indicates that the IPv4 settings are not specified in advance. The user
        must provide a valid value when the actual customization spec is applied to
        a virtual machine. This class attribute was added in vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Type` instance.
            """
            Enum.__init__(string)

    Type._set_values({
        'DHCP': Type('DHCP'),
        'STATIC': Type('STATIC'),
        'USER_INPUT_REQUIRED': Type('USER_INPUT_REQUIRED'),
    })
    Type._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.ipv4.type',
        Type))

Ipv4._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.ipv4', {
        'type': type.ReferenceType(__name__, 'Ipv4.Type'),
        'ip_address': type.OptionalType(type.StringType()),
        'prefix': type.OptionalType(type.IntegerType()),
        'gateways': type.OptionalType(type.ListType(type.StringType())),
    },
    Ipv4,
    False,
    None))



class Ipv6Address(VapiStruct):
    """
    The ``Ipv6Address`` class specifies the the settings for a Static IPv6
    configuration. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 ip_address=None,
                 prefix=None,
                ):
        """
        :type  ip_address: :class:`str`
        :param ip_address: Static IPv6 Address. This attribute was added in vSphere API
            7.0.0.0.
        :type  prefix: :class:`long`
        :param prefix: The CIDR prefix for the interface. This attribute was added in
            vSphere API 7.0.0.0.
        """
        self.ip_address = ip_address
        self.prefix = prefix
        VapiStruct.__init__(self)


Ipv6Address._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.ipv6_address', {
        'ip_address': type.StringType(),
        'prefix': type.IntegerType(),
    },
    Ipv6Address,
    False,
    None))



class Ipv6(VapiStruct):
    """
    The ``Ipv6`` class specifies the IPv6 settings that need to be applied to a
    virtual network adapter. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """

    _validator_list = [
        UnionValidator(
            'type',
            {
                'STATIC' : [('ipv6', True)],
                'DHCP' : [],
                'USER_INPUT_REQUIRED' : [],
            }
        ),
    ]



    def __init__(self,
                 type=None,
                 ipv6=None,
                 gateways=None,
                ):
        """
        :type  type: :class:`Ipv6.Type`
        :param type: The IPv6 configuration type. This attribute was added in vSphere
            API 7.0.0.0.
        :type  ipv6: :class:`list` of :class:`Ipv6Address`
        :param ipv6: IPv6 address. This attribute was added in vSphere API 7.0.0.0.
            This attribute is optional and it is only relevant when the value
            of ``type`` is :attr:`Ipv6.Type.STATIC`.
        :type  gateways: :class:`list` of :class:`str` or ``None``
        :param gateways: gateways for the IPv6 address. This attribute was added in vSphere
            API 7.0.0.0.
            If None, no gateways are set.
        """
        self.type = type
        self.ipv6 = ipv6
        self.gateways = gateways
        VapiStruct.__init__(self)


    class Type(Enum):
        """
        The ``Ipv6.Type`` class specifies different types of the IPv6
        configuration. This enumeration was added in vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        DHCP = None
        """
        DHCP IPv6 configuration. This class attribute was added in vSphere API
        7.0.0.0.

        """
        STATIC = None
        """
        Static IPv6 configuration. This class attribute was added in vSphere API
        7.0.0.0.

        """
        USER_INPUT_REQUIRED = None
        """
        Indicates that the IPv6 settings are not specified in advance. The user
        must provide a valid value when the actual customization spec is applied to
        a virtual machine. This class attribute was added in vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Type` instance.
            """
            Enum.__init__(string)

    Type._set_values({
        'DHCP': Type('DHCP'),
        'STATIC': Type('STATIC'),
        'USER_INPUT_REQUIRED': Type('USER_INPUT_REQUIRED'),
    })
    Type._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.ipv6.type',
        Type))

Ipv6._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.ipv6', {
        'type': type.ReferenceType(__name__, 'Ipv6.Type'),
        'ipv6': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Ipv6Address'))),
        'gateways': type.OptionalType(type.ListType(type.StringType())),
    },
    Ipv6,
    False,
    None))



class WindowsNetworkAdapterSettings(VapiStruct):
    """
    The ``WindowsNetworkAdapterSettings`` class specifies Windows specific
    Network settings for a virtual network adapter. This class was added in
    vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'net_BIOS_mode': 'net_bios_mode',
                            }

    def __init__(self,
                 dns_servers=None,
                 dns_domain=None,
                 wins_servers=None,
                 net_bios_mode=None,
                ):
        """
        :type  dns_servers: :class:`list` of :class:`str` or ``None``
        :param dns_servers: A list of server IP addresses to use for DNS lookup in a Windows
            guest operating system. 
            
            These servers should be specified in the order of preference. If
            this list is not empty, and if a DHCP IP address is used, then
            these settings override the DHCP settings.. This attribute was
            added in vSphere API 7.0.0.0.
            If None, no DNS servers are set.
        :type  dns_domain: :class:`str` or ``None``
        :param dns_domain: A DNS domain suffix such as vmware.com. This attribute was added in
            vSphere API 7.0.0.0.
            If None, no DNS domain is set.
        :type  wins_servers: :class:`list` of :class:`str` or ``None``
        :param wins_servers: List of WINS Servers to set for the Windows guest operating system.
            A Maximum of two IP addresses can be specified in this list. The
            first IP address will be set as the primary WINS server. The second
            IP address will be set as the secondary WINS server. This attribute
            was added in vSphere API 7.0.0.0.
            If None, no WINS Servers are set.
        :type  net_bios_mode: :class:`WindowsNetworkAdapterSettings.NetBIOSMode` or ``None``
        :param net_bios_mode: NetBIOS setting for Windows. This attribute was added in vSphere
            API 7.0.0.0.
            If None, existing NetBIOS mode will be retained.
        """
        self.dns_servers = dns_servers
        self.dns_domain = dns_domain
        self.wins_servers = wins_servers
        self.net_bios_mode = net_bios_mode
        VapiStruct.__init__(self)


    class NetBIOSMode(Enum):
        """
        The ``WindowsNetworkAdapterSettings.NetBIOSMode`` class specifies different
        NetBIOS settings for Windows guest operating systems. This enumeration was
        added in vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        USE_DHCP = None
        """
        DHCP server decides whether or not to use NetBIOS. This class attribute was
        added in vSphere API 7.0.0.0.

        """
        ENABLE = None
        """
        Always use NetBIOS. This class attribute was added in vSphere API 7.0.0.0.

        """
        DISABLE = None
        """
        Never use NetBIOS. This class attribute was added in vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`NetBIOSMode` instance.
            """
            Enum.__init__(string)

    NetBIOSMode._set_values({
        'USE_DHCP': NetBIOSMode('USE_DHCP'),
        'ENABLE': NetBIOSMode('ENABLE'),
        'DISABLE': NetBIOSMode('DISABLE'),
    })
    NetBIOSMode._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.windows_network_adapter_settings.net_BIOS_mode',
        NetBIOSMode))

WindowsNetworkAdapterSettings._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.windows_network_adapter_settings', {
        'dns_servers': type.OptionalType(type.ListType(type.StringType())),
        'dns_domain': type.OptionalType(type.StringType()),
        'wins_servers': type.OptionalType(type.ListType(type.StringType())),
        'net_BIOS_mode': type.OptionalType(type.ReferenceType(__name__, 'WindowsNetworkAdapterSettings.NetBIOSMode')),
    },
    WindowsNetworkAdapterSettings,
    False,
    None))



class IPSettings(VapiStruct):
    """
    The ``IPSettings`` class specifies the IP settings for a virtual network
    adapter. This class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 ipv4=None,
                 ipv6=None,
                 windows=None,
                ):
        """
        :type  ipv4: :class:`Ipv4` or ``None``
        :param ipv4: Specification to configure IPv4 address, subnet mask and gateway
            info for this virtual network adapter. This attribute was added in
            vSphere API 7.0.0.0.
            If None, no IPv4 addresses are set.
        :type  ipv6: :class:`Ipv6` or ``None``
        :param ipv6: Specification to configure IPv6 address, subnet mask and gateway
            info for this virtual network adapter. This attribute was added in
            vSphere API 7.0.0.0.
            If None, no IPv6 addresses are set.
        :type  windows: :class:`WindowsNetworkAdapterSettings` or ``None``
        :param windows: Windows settings to be configured for this specific virtual Network
            adapter. This is valid only for Windows guest operating systems.
            This attribute was added in vSphere API 7.0.0.0.
            If None, no specific Windows settings are set.
        """
        self.ipv4 = ipv4
        self.ipv6 = ipv6
        self.windows = windows
        VapiStruct.__init__(self)


IPSettings._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.IP_settings', {
        'ipv4': type.OptionalType(type.ReferenceType(__name__, 'Ipv4')),
        'ipv6': type.OptionalType(type.ReferenceType(__name__, 'Ipv6')),
        'windows': type.OptionalType(type.ReferenceType(__name__, 'WindowsNetworkAdapterSettings')),
    },
    IPSettings,
    False,
    None))



class AdapterMapping(VapiStruct):
    """
    The ``AdapterMapping`` class specifies the association between a virtual
    network adapter and its IP settings. This class was added in vSphere API
    7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 mac_address=None,
                 adapter=None,
                ):
        """
        :type  mac_address: :class:`str` or ``None``
        :param mac_address: The MAC address of a network adapter being customized. 
            
            In vSphere 7.0 series, the MAC addresses must be specified in the
            ascending order of pciSlotNumber, otherwise a MAC address mismatch
            error will be reported. For further details, see the
            https://kb.vmware.com/s/article/87648 
            
            . This attribute was added in vSphere API 7.0.0.0.
            If None, the customization process maps the the settings from the
            list of AdapterMappings.IPSettings in the
            :attr:`CustomizationSpec.interfaces` to the virtual machine's
            network adapters, in PCI slot order. The first virtual network
            adapter on the PCI bus is assigned interfaces[0].IPSettings, the
            second adapter is assigned interfaces[1].IPSettings, and so on.
        :type  adapter: :class:`IPSettings`
        :param adapter: The IP settings for the associated virtual network adapter. This
            attribute was added in vSphere API 7.0.0.0.
        """
        self.mac_address = mac_address
        self.adapter = adapter
        VapiStruct.__init__(self)


AdapterMapping._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.adapter_mapping', {
        'mac_address': type.OptionalType(type.StringType()),
        'adapter': type.ReferenceType(__name__, 'IPSettings'),
    },
    AdapterMapping,
    False,
    None))



class CustomizationSpec(VapiStruct):
    """
    The ``CustomizationSpec`` class contains information required to customize
    a virtual machine when deploying it or migrating it to a new host. This
    class was added in vSphere API 7.0.0.0.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'global_DNS_settings': 'global_dns_settings',
                            }

    def __init__(self,
                 configuration_spec=None,
                 global_dns_settings=None,
                 interfaces=None,
                ):
        """
        :type  configuration_spec: :class:`ConfigurationSpec`
        :param configuration_spec: Settings to be applied to the guest during the customization. This
            attribute was added in vSphere API 7.0.0.0.
        :type  global_dns_settings: :class:`GlobalDNSSettings`
        :param global_dns_settings: Global DNS settings constitute the DNS settings that are not
            specific to a particular virtual network adapter. This attribute
            was added in vSphere API 7.0.0.0.
        :type  interfaces: :class:`list` of :class:`AdapterMapping`
        :param interfaces: IP settings that are specific to a particular virtual network
            adapter. The :class:`AdapterMapping` class maps a network adapter's
            MAC address to its :class:`IPSettings`. May be empty if there are
            no network adapters, else should match number of network adapters
            configured for the VM. This attribute was added in vSphere API
            7.0.0.0.
        """
        self.configuration_spec = configuration_spec
        self.global_dns_settings = global_dns_settings
        self.interfaces = interfaces
        VapiStruct.__init__(self)


CustomizationSpec._set_binding_type(type.StructType(
    'com.vmware.vcenter.guest.customization_spec', {
        'configuration_spec': type.ReferenceType(__name__, 'ConfigurationSpec'),
        'global_DNS_settings': type.ReferenceType(__name__, 'GlobalDNSSettings'),
        'interfaces': type.ListType(type.ReferenceType(__name__, 'AdapterMapping')),
    },
    CustomizationSpec,
    False,
    None))



class CustomizationSpecs(VapiInterface):
    """
    The ``CustomizationSpecs`` class provides methods to manage guest
    customization specifications in the vCenter Server. This class was added in
    vSphere API 6.7.1.
    """
    RESOURCE_TYPE = "com.vmware.vcenter.guest.CustomizationSpec"
    """
    The resource type for a vCenter guest customization specification. This class
    attribute was added in vSphere API 6.7.1.

    """

    _VAPI_SERVICE_ID = 'com.vmware.vcenter.guest.customization_specs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CustomizationSpecsStub)
        self._VAPI_OPERATION_IDS = {}

    class OsType(Enum):
        """
        The ``CustomizationSpecs.OsType`` class defines the types of guest
        operating systems for which guest customization is supported. This
        enumeration was added in vSphere API 6.7.1.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        WINDOWS = None
        """
        A customization specification for a Windows guest operating system. This
        class attribute was added in vSphere API 6.7.1.

        """
        LINUX = None
        """
        A customization specification for a Linux guest operating system. This
        class attribute was added in vSphere API 6.7.1.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`OsType` instance.
            """
            Enum.__init__(string)

    OsType._set_values({
        'WINDOWS': OsType('WINDOWS'),
        'LINUX': OsType('LINUX'),
    })
    OsType._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.customization_specs.os_type',
        OsType))


    class Format(Enum):
        """
        The ``CustomizationSpecs.Format`` class specifies the formats the
        customization specification can be exported to. This enumeration was added
        in vSphere API 7.0.0.0.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        JSON = None
        """
        JSON format. This class attribute was added in vSphere API 7.0.0.0.

        """
        XML = None
        """
        XML format. This class attribute was added in vSphere API 7.0.0.0.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Format` instance.
            """
            Enum.__init__(string)

    Format._set_values({
        'JSON': Format('JSON'),
        'XML': Format('XML'),
    })
    Format._set_binding_type(type.EnumType(
        'com.vmware.vcenter.guest.customization_specs.format',
        Format))


    class Metadata(VapiStruct):
        """
        The ``CustomizationSpecs.Metadata`` class contains metadata i.e. name and
        description related to a customization specification. This class was added
        in vSphere API 7.0.0.0.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     description=None,
                     name=None,
                    ):
            """
            :type  description: :class:`str`
            :param description: Description of the specification. This attribute was added in
                vSphere API 7.0.0.0.
            :type  name: :class:`str`
            :param name: Name of the specification. This attribute was added in vSphere API
                7.0.0.0.
            """
            self.description = description
            self.name = name
            VapiStruct.__init__(self)


    Metadata._set_binding_type(type.StructType(
        'com.vmware.vcenter.guest.customization_specs.metadata', {
            'description': type.StringType(),
            'name': type.StringType(),
        },
        Metadata,
        False,
        None))


    class CreateSpec(VapiStruct):
        """
        The ``CustomizationSpecs.CreateSpec`` class contains specification
        information and specification object that can be passed to the
        :func:`CustomizationSpecs.create` method. This class was added in vSphere
        API 7.0.0.0.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     spec=None,
                     description=None,
                     name=None,
                    ):
            """
            :type  spec: :class:`CustomizationSpec`
            :param spec: The specification object. This attribute was added in vSphere API
                7.0.0.0.
            :type  description: :class:`str`
            :param description: Description of the specification. This attribute was added in
                vSphere API 7.0.0.0.
            :type  name: :class:`str`
            :param name: Name of the specification. This attribute was added in vSphere API
                7.0.0.0.
            """
            self.spec = spec
            self.description = description
            self.name = name
            VapiStruct.__init__(self)


    CreateSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.guest.customization_specs.create_spec', {
            'spec': type.ReferenceType(__name__, 'CustomizationSpec'),
            'description': type.StringType(),
            'name': type.StringType(),
        },
        CreateSpec,
        False,
        None))


    class Spec(VapiStruct):
        """
        The ``CustomizationSpecs.Spec`` class contains the specification
        information and specification object. This is passed to the
        :func:`CustomizationSpecs.set` method. This class was added in vSphere API
        7.0.0.0.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     fingerprint=None,
                     spec=None,
                     description=None,
                     name=None,
                    ):
            """
            :type  fingerprint: :class:`str`
            :param fingerprint: The fingerprint is a unique identifier for a given version of the
                configuration. Each change to the configuration will update this
                value. A client cannot change this value. If specified when
                updating a specification, the changes will only be applied if the
                current fingerprint matches the specified fingerprint. This field
                can be used to guard against updates that has happened between the
                specification content was read and until it is applied. This
                attribute was added in vSphere API 7.0.0.0.
            :type  spec: :class:`CustomizationSpec`
            :param spec: The specification object. This attribute was added in vSphere API
                7.0.0.0.
            :type  description: :class:`str`
            :param description: Description of the specification. This attribute was added in
                vSphere API 7.0.0.0.
            :type  name: :class:`str`
            :param name: Name of the specification. This attribute was added in vSphere API
                7.0.0.0.
            """
            self.fingerprint = fingerprint
            self.spec = spec
            self.description = description
            self.name = name
            VapiStruct.__init__(self)


    Spec._set_binding_type(type.StructType(
        'com.vmware.vcenter.guest.customization_specs.spec', {
            'fingerprint': type.StringType(),
            'spec': type.ReferenceType(__name__, 'CustomizationSpec'),
            'description': type.StringType(),
            'name': type.StringType(),
        },
        Spec,
        False,
        None))


    class Info(VapiStruct):
        """
        The ``CustomizationSpecs.Info`` class describes a guest customization
        specification and the timestamp when it was last modified. This is returned
        by the :func:`CustomizationSpecs.get` method. This class was added in
        vSphere API 7.0.0.0.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     last_modified=None,
                     spec=None,
                    ):
            """
            :type  last_modified: :class:`datetime.datetime`
            :param last_modified: Time when the specification was last modified. This attribute was
                added in vSphere API 7.0.0.0.
            :type  spec: :class:`CustomizationSpecs.Spec`
            :param spec: The Spec object including specification and metadata information.
                This attribute was added in vSphere API 7.0.0.0.
            """
            self.last_modified = last_modified
            self.spec = spec
            VapiStruct.__init__(self)


    Info._set_binding_type(type.StructType(
        'com.vmware.vcenter.guest.customization_specs.info', {
            'last_modified': type.DateTimeType(),
            'spec': type.ReferenceType(__name__, 'CustomizationSpecs.Spec'),
        },
        Info,
        False,
        None))


    class FilterSpec(VapiStruct):
        """
        The ``CustomizationSpecs.FilterSpec`` class contains attributes used to
        filter the results when listing guest customization specifications (see
        :func:`CustomizationSpecs.list`). If multiple attributes are specified,
        only guest customization specifications matching all of the attributes
        match the filter. This class was added in vSphere API 6.7.1.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """



        _canonical_to_pep_names = {
                                'OS_type': 'os_type',
                                }

        def __init__(self,
                     names=None,
                     os_type=None,
                    ):
            """
            :type  names: :class:`set` of :class:`str` or ``None``
            :param names: Names that guest customization specifications must have to match
                the filter (see :attr:`CustomizationSpecs.Summary.name`). This
                attribute was added in vSphere API 6.7.1.
                When clients pass a value of this class as a parameter, the
                attribute must contain identifiers for the resource type:
                ``com.vmware.vcenter.guest.CustomizationSpec``. When methods return
                a value of this class as a return value, the attribute will contain
                identifiers for the resource type:
                ``com.vmware.vcenter.guest.CustomizationSpec``.
                If None or empty, guest customization specifications with any name
                match the filter.
            :type  os_type: :class:`CustomizationSpecs.OsType` or ``None``
            :param os_type: Guest operating system type that guest customization specifications
                must have to match the filter (see
                :attr:`CustomizationSpecs.Summary.os_type`). This attribute was
                added in vSphere API 6.7.1.
                If None, guest customization specifications with any guest
                operating system type match the filter.
            """
            self.names = names
            self.os_type = os_type
            VapiStruct.__init__(self)


    FilterSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.guest.customization_specs.filter_spec', {
            'names': type.OptionalType(type.SetType(type.IdType())),
            'OS_type': type.OptionalType(type.ReferenceType(__name__, 'CustomizationSpecs.OsType')),
        },
        FilterSpec,
        False,
        None))


    class Summary(VapiStruct):
        """
        The ``CustomizationSpecs.Summary`` class contains commonly used information
        about a guest customization specification. This class was added in vSphere
        API 6.7.1.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """



        _canonical_to_pep_names = {
                                'OS_type': 'os_type',
                                }

        def __init__(self,
                     name=None,
                     description=None,
                     os_type=None,
                     last_modified=None,
                    ):
            """
            :type  name: :class:`str`
            :param name: Name of the guest customization specification. This attribute was
                added in vSphere API 6.7.1.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``com.vmware.vcenter.guest.CustomizationSpec``. When methods return
                a value of this class as a return value, the attribute will be an
                identifier for the resource type:
                ``com.vmware.vcenter.guest.CustomizationSpec``.
            :type  description: :class:`str`
            :param description: Description of the guest customization specification. This
                attribute was added in vSphere API 6.7.1.
            :type  os_type: :class:`CustomizationSpecs.OsType`
            :param os_type: Guest operating system type for which that this guest customization
                specification applies. This attribute was added in vSphere API
                6.7.1.
            :type  last_modified: :class:`datetime.datetime`
            :param last_modified: Date and tme when this guest customization specification was last
                modified. This attribute was added in vSphere API 6.7.1.
            """
            self.name = name
            self.description = description
            self.os_type = os_type
            self.last_modified = last_modified
            VapiStruct.__init__(self)


    Summary._set_binding_type(type.StructType(
        'com.vmware.vcenter.guest.customization_specs.summary', {
            'name': type.IdType(resource_types='com.vmware.vcenter.guest.CustomizationSpec'),
            'description': type.StringType(),
            'OS_type': type.ReferenceType(__name__, 'CustomizationSpecs.OsType'),
            'last_modified': type.DateTimeType(),
        },
        Summary,
        False,
        None))



    def list(self,
             filter=None,
             ):
        """
        Returns information about at most 1000 visible (subject to permission
        checks) guest customization specifications in vCenter matching the
        :class:`CustomizationSpecs.FilterSpec`. This method was added in
        vSphere API 6.7.1.

        :type  filter: :class:`CustomizationSpecs.FilterSpec` or ``None``
        :param filter: Specification of matching guest customization specifications for
            which information should be returned.
            If None, the behavior is equivalent to a
            :class:`CustomizationSpecs.FilterSpec` with all attributes None
            which means all guest customization specifications match the
            filter.
        :rtype: :class:`list` of :class:`CustomizationSpecs.Summary`
        :return: Commonly used information about the guest customization
            specifications matching the :class:`CustomizationSpecs.FilterSpec`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if the :attr:`CustomizationSpecs.FilterSpec.os_type` attribute
            contains a value that is not supported by the server.
        :raise: :class:`com.vmware.vapi.std.errors_client.UnableToAllocateResource` 
            if more than 1000 guest customization specifications match the
            :class:`CustomizationSpecs.FilterSpec`.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ReadCustSpecs``.
        """
        return self._invoke('list',
                            {
                            'filter': filter,
                            })

    def create(self,
               spec,
               ):
        """
        Creates a customization specification. This method was added in vSphere
        API 7.0.0.0.

        :type  spec: :class:`CustomizationSpecs.CreateSpec`
        :param spec: The information i.e. name, description and the settings i.e
            hostname, ip address etc for the new customization specification
            that needs to be created.
        :rtype: :class:`str`
        :return: The name of the customization specification that is created.
            The return value will be an identifier for the resource type:
            ``com.vmware.vcenter.guest.CustomizationSpec``.
        :raise: :class:`com.vmware.vapi.std.errors_client.AlreadyExists` 
            if a customization specification is already present with the same
            name.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if the specified specification is not a valid one.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ModifyCustSpecs``.
        """
        return self._invoke('create',
                            {
                            'spec': spec,
                            })

    def get(self,
            name,
            ):
        """
        Returns the guest customization specification from vCenter with the
        specified identifier. This method was added in vSphere API 7.0.0.0.

        :type  name: :class:`str`
        :param name: The name of the customization specification.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.guest.CustomizationSpec``.
        :rtype: :class:`CustomizationSpecs.Info`
        :return: A customization spec with the specified identifier.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if a customization specification is not found.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ReadCustSpecs``.
        """
        return self._invoke('get',
                            {
                            'name': name,
                            })

    def set(self,
            name,
            spec,
            ):
        """
        Sets an existing specification, possibly after retrieving (by using
        :func:`CustomizationSpecs.get`) and editing it. This method was added
        in vSphere API 7.0.0.0.

        :type  name: :class:`str`
        :param name: The name of the customization specification that needs to be set.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.guest.CustomizationSpec``.
        :type  spec: :class:`CustomizationSpecs.Spec`
        :param spec: The new specification that will overwrite the existing
            specification.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            If, based on the item's fingerprint value, the set process detects
            that the specification has changed since its retrieval, then the
            method throws InvalidArgument exception to warn the client that he
            might overwrite another client's change.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            If the settings in ``spec`` are not valid.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if a customization specification is not found.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ModifyCustSpecs``.
        """
        return self._invoke('set',
                            {
                            'name': name,
                            'spec': spec,
                            })

    def delete(self,
               name,
               ):
        """
        Deletes a customization specification with the specified identifier.
        This method was added in vSphere API 7.0.0.0.

        :type  name: :class:`str`
        :param name: The name of the customization specification that needs to be
            deleted.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.guest.CustomizationSpec``.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if a customization specification is not found.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ModifyCustSpecs``.
        """
        return self._invoke('delete',
                            {
                            'name': name,
                            })

    def export(self,
               name,
               format,
               ):
        """
        Returns the content of the customization specification in the specified
        format. Note that any passwords in the customization specification will
        be set to blank values during the export method. This method was added
        in vSphere API 7.0.0.0.

        :type  name: :class:`str`
        :param name: The name of the customization specification that has to be
            returned.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.guest.CustomizationSpec``.
        :type  format: :class:`CustomizationSpecs.Format`
        :param format: The format in which the customization specification has to be
            returned.
        :rtype: :class:`str`
        :return: The string representation of the customization specification in the
            specified format.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            If value of ``format`` is not valid.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if the customization specification is not found.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ReadCustSpecs``.
        """
        return self._invoke('export',
                            {
                            'name': name,
                            'format': format,
                            })

    def import_specification(self,
                             customization_spec,
                             ):
        """
        Converts a well formatted string to a
        :class:`CustomizationSpecs.CreateSpec`. The resulting object can be
        passed to :func:`CustomizationSpecs.create` method. This method was
        added in vSphere API 7.0.0.0.

        :type  customization_spec: :class:`str`
        :param customization_spec: content to be converted to the spec.
        :rtype: :class:`CustomizationSpecs.CreateSpec`
        :return: A proper specification of type
            :class:`CustomizationSpecs.CreateSpec`
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if the specified content cannot be properly converted into a proper
            valid :class:`CustomizationSpecs.CreateSpec` object.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            if the system is unable to communicate with a service to complete
            the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user doesn't have the required privileges.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized`
            if you do not have all of the privileges described as follows: 
            
            * Method execution requires
              ``VirtualMachine.Provisioning.ModifyCustSpecs``.
        """
        return self._invoke('import_specification',
                            {
                            'customization_spec': customization_spec,
                            })
class _CustomizationSpecsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'filter': type.OptionalType(type.ReferenceType(__name__, 'CustomizationSpecs.FilterSpec')),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.unable_to_allocate_resource':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'UnableToAllocateResource'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/guest/customization-specs',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            }
        )

        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'spec': type.ReferenceType(__name__, 'CustomizationSpecs.CreateSpec'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.already_exists':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'AlreadyExists'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/guest/customization-specs',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            }
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'name': type.IdType(resource_types='com.vmware.vcenter.guest.CustomizationSpec'),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/guest/customization-specs/{name}',
            path_variables={
                'name': 'name',
            },
             header_parameters={
               },
            query_parameters={
            }
        )

        # properties for set operation
        set_input_type = type.StructType('operation-input', {
            'name': type.IdType(resource_types='com.vmware.vcenter.guest.CustomizationSpec'),
            'spec': type.ReferenceType(__name__, 'CustomizationSpecs.Spec'),
        })
        set_error_dict = {
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        set_input_value_validator_list = [
        ]
        set_output_validator_list = [
        ]
        set_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/guest/customization-specs/{name}',
            path_variables={
                'name': 'name',
            },
             header_parameters={
                 },
            query_parameters={
            }
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'name': type.IdType(resource_types='com.vmware.vcenter.guest.CustomizationSpec'),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/vcenter/guest/customization-specs/{name}',
            path_variables={
                'name': 'name',
            },
             header_parameters={
               },
            query_parameters={
            }
        )

        # properties for export operation
        export_input_type = type.StructType('operation-input', {
            'name': type.IdType(resource_types='com.vmware.vcenter.guest.CustomizationSpec'),
            'format': type.ReferenceType(__name__, 'CustomizationSpecs.Format'),
        })
        export_error_dict = {
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        export_input_value_validator_list = [
        ]
        export_output_validator_list = [
        ]
        export_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/guest/customization-specs/{name}',
            path_variables={
                'name': 'name',
            },
             header_parameters={
                 },
            query_parameters={
            }
        )

        # properties for import_specification operation
        import_specification_input_type = type.StructType('operation-input', {
            'customization_spec': type.StringType(),
        })
        import_specification_error_dict = {
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        import_specification_input_value_validator_list = [
        ]
        import_specification_output_validator_list = [
        ]
        import_specification_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/guest/customization-specs',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            }
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ListType(type.ReferenceType(__name__, 'CustomizationSpecs.Summary')),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'create': {
                'input_type': create_input_type,
                'output_type': type.IdType(resource_types='com.vmware.vcenter.guest.CustomizationSpec'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'CustomizationSpecs.Info'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'set': {
                'input_type': set_input_type,
                'output_type': type.VoidType(),
                'errors': set_error_dict,
                'input_value_validator_list': set_input_value_validator_list,
                'output_validator_list': set_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'export': {
                'input_type': export_input_type,
                'output_type': type.StringType(),
                'errors': export_error_dict,
                'input_value_validator_list': export_input_value_validator_list,
                'output_validator_list': export_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'import_specification': {
                'input_type': import_specification_input_type,
                'output_type': type.ReferenceType(__name__, 'CustomizationSpecs.CreateSpec'),
                'errors': import_specification_error_dict,
                'input_value_validator_list': import_specification_input_value_validator_list,
                'output_validator_list': import_specification_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
            'create': create_rest_metadata,
            'get': get_rest_metadata,
            'set': set_rest_metadata,
            'delete': delete_rest_metadata,
            'export': export_rest_metadata,
            'import_specification': import_specification_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vcenter.guest.customization_specs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'CustomizationSpecs': CustomizationSpecs,
    }

