# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class AlbAnalyticsProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_analytics_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbAnalyticsProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_analyticsprofile_id,
               force=None,
               ):
        """
        Delete the ALBAnalyticsProfile along with all the entities contained by
        this ALBAnalyticsProfile. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_analyticsprofile_id: :class:`str`
        :param alb_analyticsprofile_id: ALBAnalyticsProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAnalyticsProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_analyticsprofile_id': alb_analyticsprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_analyticsprofile_id,
            ):
        """
        Read a ALBAnalyticsProfile. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_analyticsprofile_id: :class:`str`
        :param alb_analyticsprofile_id: ALBAnalyticsProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAnalyticsProfile`
        :return: com.vmware.nsx_policy.model.ALBAnalyticsProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAnalyticsProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_analyticsprofile_id': alb_analyticsprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBAnalyticsProfile for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAnalyticsProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBAnalyticsProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAnalyticsProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_analyticsprofile_id,
              a_lb_analytics_profile,
              ):
        """
        If a ALBanalyticsprofile with the alb-analyticsprofile-id is not
        already present, create a new ALBanalyticsprofile. If it already
        exists, update the ALBanalyticsprofile. This is a full replace. This is
        a deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_analyticsprofile_id: :class:`str`
        :param alb_analyticsprofile_id: ALBanalyticsprofile ID (required)
        :type  a_lb_analytics_profile: :class:`com.vmware.nsx_policy.model_client.ALBAnalyticsProfile`
        :param a_lb_analytics_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAnalyticsProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_analyticsprofile_id': alb_analyticsprofile_id,
                            'a_lb_analytics_profile': a_lb_analytics_profile,
                            })

    def update(self,
               alb_analyticsprofile_id,
               a_lb_analytics_profile,
               ):
        """
        If a ALBAnalyticsProfile with the alb-AnalyticsProfile-id is not
        already present, create a new ALBAnalyticsProfile. If it already
        exists, update the ALBAnalyticsProfile. This is a full replace. This is
        a deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_analyticsprofile_id: :class:`str`
        :param alb_analyticsprofile_id: ALBAnalyticsProfile ID (required)
        :type  a_lb_analytics_profile: :class:`com.vmware.nsx_policy.model_client.ALBAnalyticsProfile`
        :param a_lb_analytics_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAnalyticsProfile`
        :return: com.vmware.nsx_policy.model.ALBAnalyticsProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAnalyticsProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_analyticsprofile_id': alb_analyticsprofile_id,
                            'a_lb_analytics_profile': a_lb_analytics_profile,
                            })
class AlbApplicationPersistenceProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_application_persistence_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbApplicationPersistenceProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_applicationpersistenceprofile_id,
               force=None,
               ):
        """
        Delete the ALBApplicationPersistenceProfile along with all the entities
        contained by this ALBApplicationPersistenceProfile. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_applicationpersistenceprofile_id: :class:`str`
        :param alb_applicationpersistenceprofile_id: ALBApplicationPersistenceProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_applicationpersistenceprofile_id': alb_applicationpersistenceprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_applicationpersistenceprofile_id,
            ):
        """
        Read a ALBApplicationPersistenceProfile. This is a deprecated API. It
        is recommennded to use NSX Advanced Load Balancer (Avi) Controller UI
        or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_applicationpersistenceprofile_id: :class:`str`
        :param alb_applicationpersistenceprofile_id: ALBApplicationPersistenceProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBApplicationPersistenceProfile`
        :return: com.vmware.nsx_policy.model.ALBApplicationPersistenceProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_applicationpersistenceprofile_id': alb_applicationpersistenceprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBApplicationPersistenceProfile for infra. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBApplicationPersistenceProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBApplicationPersistenceProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_applicationpersistenceprofile_id,
              a_lb_application_persistence_profile,
              ):
        """
        If a ALBapplicationpersistenceprofile with the
        alb-applicationpersistenceprofile-id is not already present, create a
        new ALBapplicationpersistenceprofile. If it already exists, update the
        ALBapplicationpersistenceprofile. This is a full replace. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_applicationpersistenceprofile_id: :class:`str`
        :param alb_applicationpersistenceprofile_id: ALBapplicationpersistenceprofile ID (required)
        :type  a_lb_application_persistence_profile: :class:`com.vmware.nsx_policy.model_client.ALBApplicationPersistenceProfile`
        :param a_lb_application_persistence_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_applicationpersistenceprofile_id': alb_applicationpersistenceprofile_id,
                            'a_lb_application_persistence_profile': a_lb_application_persistence_profile,
                            })

    def update(self,
               alb_applicationpersistenceprofile_id,
               a_lb_application_persistence_profile,
               ):
        """
        If a ALBApplicationPersistenceProfile with the
        alb-ApplicationPersistenceProfile-id is not already present, create a
        new ALBApplicationPersistenceProfile. If it already exists, update the
        ALBApplicationPersistenceProfile. This is a full replace. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_applicationpersistenceprofile_id: :class:`str`
        :param alb_applicationpersistenceprofile_id: ALBApplicationPersistenceProfile ID (required)
        :type  a_lb_application_persistence_profile: :class:`com.vmware.nsx_policy.model_client.ALBApplicationPersistenceProfile`
        :param a_lb_application_persistence_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBApplicationPersistenceProfile`
        :return: com.vmware.nsx_policy.model.ALBApplicationPersistenceProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_applicationpersistenceprofile_id': alb_applicationpersistenceprofile_id,
                            'a_lb_application_persistence_profile': a_lb_application_persistence_profile,
                            })
class AlbApplicationProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_application_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbApplicationProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_applicationprofile_id,
               force=None,
               ):
        """
        Delete the ALBApplicationProfile along with all the entities contained
        by this ALBApplicationProfile. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_applicationprofile_id: :class:`str`
        :param alb_applicationprofile_id: ALBApplicationProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_applicationprofile_id': alb_applicationprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_applicationprofile_id,
            ):
        """
        Read a ALBApplicationProfile. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_applicationprofile_id: :class:`str`
        :param alb_applicationprofile_id: ALBApplicationProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBApplicationProfile`
        :return: com.vmware.nsx_policy.model.ALBApplicationProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_applicationprofile_id': alb_applicationprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBApplicationProfile for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBApplicationProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBApplicationProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_applicationprofile_id,
              a_lb_application_profile,
              ):
        """
        If a ALBapplicationprofile with the alb-applicationprofile-id is not
        already present, create a new ALBapplicationprofile. If it already
        exists, update the ALBapplicationprofile. This is a full replace. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  alb_applicationprofile_id: :class:`str`
        :param alb_applicationprofile_id: ALBapplicationprofile ID (required)
        :type  a_lb_application_profile: :class:`com.vmware.nsx_policy.model_client.ALBApplicationProfile`
        :param a_lb_application_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_applicationprofile_id': alb_applicationprofile_id,
                            'a_lb_application_profile': a_lb_application_profile,
                            })

    def update(self,
               alb_applicationprofile_id,
               a_lb_application_profile,
               ):
        """
        If a ALBApplicationProfile with the alb-ApplicationProfile-id is not
        already present, create a new ALBApplicationProfile. If it already
        exists, update the ALBApplicationProfile. This is a full replace. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  alb_applicationprofile_id: :class:`str`
        :param alb_applicationprofile_id: ALBApplicationProfile ID (required)
        :type  a_lb_application_profile: :class:`com.vmware.nsx_policy.model_client.ALBApplicationProfile`
        :param a_lb_application_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBApplicationProfile`
        :return: com.vmware.nsx_policy.model.ALBApplicationProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbApplicationProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_applicationprofile_id': alb_applicationprofile_id,
                            'a_lb_application_profile': a_lb_application_profile,
                            })
class AlbAuthProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_auth_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbAuthProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_authprofile_id,
               force=None,
               ):
        """
        Delete the ALBAuthProfile along with all the entities contained by this
        ALBAuthProfile. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_authprofile_id: :class:`str`
        :param alb_authprofile_id: ALBAuthProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAuthProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_authprofile_id': alb_authprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_authprofile_id,
            ):
        """
        Read a ALBAuthProfile. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_authprofile_id: :class:`str`
        :param alb_authprofile_id: ALBAuthProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAuthProfile`
        :return: com.vmware.nsx_policy.model.ALBAuthProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAuthProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_authprofile_id': alb_authprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBAuthProfile for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAuthProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBAuthProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAuthProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_authprofile_id,
              a_lb_auth_profile,
              ):
        """
        If a ALBauthprofile with the alb-authprofile-id is not already present,
        create a new ALBauthprofile. If it already exists, update the
        ALBauthprofile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_authprofile_id: :class:`str`
        :param alb_authprofile_id: ALBauthprofile ID (required)
        :type  a_lb_auth_profile: :class:`com.vmware.nsx_policy.model_client.ALBAuthProfile`
        :param a_lb_auth_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAuthProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_authprofile_id': alb_authprofile_id,
                            'a_lb_auth_profile': a_lb_auth_profile,
                            })

    def update(self,
               alb_authprofile_id,
               a_lb_auth_profile,
               ):
        """
        If a ALBAuthProfile with the alb-AuthProfile-id is not already present,
        create a new ALBAuthProfile. If it already exists, update the
        ALBAuthProfile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_authprofile_id: :class:`str`
        :param alb_authprofile_id: ALBAuthProfile ID (required)
        :type  a_lb_auth_profile: :class:`com.vmware.nsx_policy.model_client.ALBAuthProfile`
        :param a_lb_auth_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAuthProfile`
        :return: com.vmware.nsx_policy.model.ALBAuthProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAuthProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_authprofile_id': alb_authprofile_id,
                            'a_lb_auth_profile': a_lb_auth_profile,
                            })
class AlbAuthToken(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_auth_token'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbAuthTokenStub)
        self._VAPI_OPERATION_IDS = {}


    def update(self,
               a_lb_auth_token,
               ):
        """
        Passthorugh API calls to Avi controller using the Auth of policy API
        request send to this API will be passthrough to Avi controller and Avi
        controller response will be embedded for this API.

        :type  a_lb_auth_token: :class:`com.vmware.nsx_policy.model_client.ALBAuthToken`
        :param a_lb_auth_token: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAuthToken`
        :return: com.vmware.nsx_policy.model.ALBAuthToken
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'a_lb_auth_token': a_lb_auth_token,
                            })
class AlbAutoScaleLaunchConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_auto_scale_launch_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbAutoScaleLaunchConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_autoscalelaunchconfig_id,
               force=None,
               ):
        """
        Delete the ALBAutoScaleLaunchConfig along with all the entities
        contained by this ALBAutoScaleLaunchConfig. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_autoscalelaunchconfig_id: :class:`str`
        :param alb_autoscalelaunchconfig_id: ALBAutoScaleLaunchConfig ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_autoscalelaunchconfig_id': alb_autoscalelaunchconfig_id,
                            'force': force,
                            })

    def get(self,
            alb_autoscalelaunchconfig_id,
            ):
        """
        Read a ALBAutoScaleLaunchConfig. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_autoscalelaunchconfig_id: :class:`str`
        :param alb_autoscalelaunchconfig_id: ALBAutoScaleLaunchConfig ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAutoScaleLaunchConfig`
        :return: com.vmware.nsx_policy.model.ALBAutoScaleLaunchConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_autoscalelaunchconfig_id': alb_autoscalelaunchconfig_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBAutoScaleLaunchConfig for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAutoScaleLaunchConfigApiResponse`
        :return: com.vmware.nsx_policy.model.ALBAutoScaleLaunchConfigApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_autoscalelaunchconfig_id,
              a_lb_auto_scale_launch_config,
              ):
        """
        If a ALBautoscalelaunchconfig with the alb-autoscalelaunchconfig-id is
        not already present, create a new ALBautoscalelaunchconfig. If it
        already exists, update the ALBautoscalelaunchconfig. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_autoscalelaunchconfig_id: :class:`str`
        :param alb_autoscalelaunchconfig_id: ALBautoscalelaunchconfig ID (required)
        :type  a_lb_auto_scale_launch_config: :class:`com.vmware.nsx_policy.model_client.ALBAutoScaleLaunchConfig`
        :param a_lb_auto_scale_launch_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_autoscalelaunchconfig_id': alb_autoscalelaunchconfig_id,
                            'a_lb_auto_scale_launch_config': a_lb_auto_scale_launch_config,
                            })

    def update(self,
               alb_autoscalelaunchconfig_id,
               a_lb_auto_scale_launch_config,
               ):
        """
        If a ALBAutoScaleLaunchConfig with the alb-AutoScaleLaunchConfig-id is
        not already present, create a new ALBAutoScaleLaunchConfig. If it
        already exists, update the ALBAutoScaleLaunchConfig. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_autoscalelaunchconfig_id: :class:`str`
        :param alb_autoscalelaunchconfig_id: ALBAutoScaleLaunchConfig ID (required)
        :type  a_lb_auto_scale_launch_config: :class:`com.vmware.nsx_policy.model_client.ALBAutoScaleLaunchConfig`
        :param a_lb_auto_scale_launch_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAutoScaleLaunchConfig`
        :return: com.vmware.nsx_policy.model.ALBAutoScaleLaunchConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_autoscalelaunchconfig_id': alb_autoscalelaunchconfig_id,
                            'a_lb_auto_scale_launch_config': a_lb_auto_scale_launch_config,
                            })
class AlbControllerVersion(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_controller_version'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbControllerVersionStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read an ALBControllerSupportVersion. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown


        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBControllerVersion`
        :return: com.vmware.nsx_policy.model.ALBControllerVersion
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbControllerVersion.get is deprecated.', DeprecationWarning)
        return self._invoke('get', None)
class AlbDnsPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_dns_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbDnsPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_dnspolicy_id,
               force=None,
               ):
        """
        Delete the ALBDnsPolicy along with all the entities contained by this
        ALBDnsPolicy. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_dnspolicy_id: :class:`str`
        :param alb_dnspolicy_id: ALBDnsPolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbDnsPolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_dnspolicy_id': alb_dnspolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_dnspolicy_id,
            ):
        """
        Read a ALBDnsPolicy. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_dnspolicy_id: :class:`str`
        :param alb_dnspolicy_id: ALBDnsPolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBDnsPolicy`
        :return: com.vmware.nsx_policy.model.ALBDnsPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbDnsPolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_dnspolicy_id': alb_dnspolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBDnsPolicy for infra. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBDnsPolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBDnsPolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbDnsPolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_dnspolicy_id,
              a_lb_dns_policy,
              ):
        """
        If a ALBdnspolicy with the alb-dnspolicy-id is not already present,
        create a new ALBdnspolicy. If it already exists, update the
        ALBdnspolicy. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_dnspolicy_id: :class:`str`
        :param alb_dnspolicy_id: ALBdnspolicy ID (required)
        :type  a_lb_dns_policy: :class:`com.vmware.nsx_policy.model_client.ALBDnsPolicy`
        :param a_lb_dns_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbDnsPolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_dnspolicy_id': alb_dnspolicy_id,
                            'a_lb_dns_policy': a_lb_dns_policy,
                            })

    def update(self,
               alb_dnspolicy_id,
               a_lb_dns_policy,
               ):
        """
        If a ALBDnsPolicy with the alb-DnsPolicy-id is not already present,
        create a new ALBDnsPolicy. If it already exists, update the
        ALBDnsPolicy. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_dnspolicy_id: :class:`str`
        :param alb_dnspolicy_id: ALBDnsPolicy ID (required)
        :type  a_lb_dns_policy: :class:`com.vmware.nsx_policy.model_client.ALBDnsPolicy`
        :param a_lb_dns_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBDnsPolicy`
        :return: com.vmware.nsx_policy.model.ALBDnsPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbDnsPolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_dnspolicy_id': alb_dnspolicy_id,
                            'a_lb_dns_policy': a_lb_dns_policy,
                            })
class AlbErrorPageBodies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_error_page_bodies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbErrorPageBodiesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_errorpagebody_id,
               force=None,
               ):
        """
        Delete the ALBErrorPageBody along with all the entities contained by
        this ALBErrorPageBody. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_errorpagebody_id: :class:`str`
        :param alb_errorpagebody_id: ALBErrorPageBody ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageBodies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_errorpagebody_id': alb_errorpagebody_id,
                            'force': force,
                            })

    def get(self,
            alb_errorpagebody_id,
            ):
        """
        Read a ALBErrorPageBody. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_errorpagebody_id: :class:`str`
        :param alb_errorpagebody_id: ALBErrorPageBody ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageBody`
        :return: com.vmware.nsx_policy.model.ALBErrorPageBody
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageBodies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_errorpagebody_id': alb_errorpagebody_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBErrorPageBody for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageBodyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBErrorPageBodyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageBodies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_errorpagebody_id,
              a_lb_error_page_body,
              ):
        """
        If a ALBerrorpagebody with the alb-errorpagebody-id is not already
        present, create a new ALBerrorpagebody. If it already exists, update
        the ALBerrorpagebody. This is a full replace. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_errorpagebody_id: :class:`str`
        :param alb_errorpagebody_id: ALBerrorpagebody ID (required)
        :type  a_lb_error_page_body: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageBody`
        :param a_lb_error_page_body: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageBodies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_errorpagebody_id': alb_errorpagebody_id,
                            'a_lb_error_page_body': a_lb_error_page_body,
                            })

    def update(self,
               alb_errorpagebody_id,
               a_lb_error_page_body,
               ):
        """
        If a ALBErrorPageBody with the alb-ErrorPageBody-id is not already
        present, create a new ALBErrorPageBody. If it already exists, update
        the ALBErrorPageBody. This is a full replace. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_errorpagebody_id: :class:`str`
        :param alb_errorpagebody_id: ALBErrorPageBody ID (required)
        :type  a_lb_error_page_body: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageBody`
        :param a_lb_error_page_body: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageBody`
        :return: com.vmware.nsx_policy.model.ALBErrorPageBody
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageBodies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_errorpagebody_id': alb_errorpagebody_id,
                            'a_lb_error_page_body': a_lb_error_page_body,
                            })
class AlbErrorPageProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_error_page_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbErrorPageProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_errorpageprofile_id,
               force=None,
               ):
        """
        Delete the ALBErrorPageProfile along with all the entities contained by
        this ALBErrorPageProfile. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_errorpageprofile_id: :class:`str`
        :param alb_errorpageprofile_id: ALBErrorPageProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_errorpageprofile_id': alb_errorpageprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_errorpageprofile_id,
            ):
        """
        Read a ALBErrorPageProfile. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_errorpageprofile_id: :class:`str`
        :param alb_errorpageprofile_id: ALBErrorPageProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageProfile`
        :return: com.vmware.nsx_policy.model.ALBErrorPageProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_errorpageprofile_id': alb_errorpageprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBErrorPageProfile for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBErrorPageProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_errorpageprofile_id,
              a_lb_error_page_profile,
              ):
        """
        If a ALBerrorpageprofile with the alb-errorpageprofile-id is not
        already present, create a new ALBerrorpageprofile. If it already
        exists, update the ALBerrorpageprofile. This is a full replace. This is
        a deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_errorpageprofile_id: :class:`str`
        :param alb_errorpageprofile_id: ALBerrorpageprofile ID (required)
        :type  a_lb_error_page_profile: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageProfile`
        :param a_lb_error_page_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_errorpageprofile_id': alb_errorpageprofile_id,
                            'a_lb_error_page_profile': a_lb_error_page_profile,
                            })

    def update(self,
               alb_errorpageprofile_id,
               a_lb_error_page_profile,
               ):
        """
        If a ALBErrorPageProfile with the alb-ErrorPageProfile-id is not
        already present, create a new ALBErrorPageProfile. If it already
        exists, update the ALBErrorPageProfile. This is a full replace. This is
        a deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_errorpageprofile_id: :class:`str`
        :param alb_errorpageprofile_id: ALBErrorPageProfile ID (required)
        :type  a_lb_error_page_profile: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageProfile`
        :param a_lb_error_page_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBErrorPageProfile`
        :return: com.vmware.nsx_policy.model.ALBErrorPageProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbErrorPageProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_errorpageprofile_id': alb_errorpageprofile_id,
                            'a_lb_error_page_profile': a_lb_error_page_profile,
                            })
class AlbHardwareSecurityModuleGroups(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_hardware_security_module_groups'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbHardwareSecurityModuleGroupsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_hardwaresecuritymodulegroup_id,
               force=None,
               ):
        """
        Delete the ALBHardwareSecurityModuleGroup along with all the entities
        contained by this ALBHardwareSecurityModuleGroup. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_hardwaresecuritymodulegroup_id: :class:`str`
        :param alb_hardwaresecuritymodulegroup_id: ALBHardwareSecurityModuleGroup ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_hardwaresecuritymodulegroup_id': alb_hardwaresecuritymodulegroup_id,
                            'force': force,
                            })

    def get(self,
            alb_hardwaresecuritymodulegroup_id,
            ):
        """
        Read a ALBHardwareSecurityModuleGroup. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_hardwaresecuritymodulegroup_id: :class:`str`
        :param alb_hardwaresecuritymodulegroup_id: ALBHardwareSecurityModuleGroup ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHardwareSecurityModuleGroup`
        :return: com.vmware.nsx_policy.model.ALBHardwareSecurityModuleGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_hardwaresecuritymodulegroup_id': alb_hardwaresecuritymodulegroup_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBHardwareSecurityModuleGroup for infra. This is
        a deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHardwareSecurityModuleGroupApiResponse`
        :return: com.vmware.nsx_policy.model.ALBHardwareSecurityModuleGroupApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_hardwaresecuritymodulegroup_id,
              a_lb_hardware_security_module_group,
              ):
        """
        If a ALBhardwaresecuritymodulegroup with the
        alb-hardwaresecuritymodulegroup-id is not already present, create a new
        ALBhardwaresecuritymodulegroup. If it already exists, update the
        ALBhardwaresecuritymodulegroup. This is a full replace. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_hardwaresecuritymodulegroup_id: :class:`str`
        :param alb_hardwaresecuritymodulegroup_id: ALBhardwaresecuritymodulegroup ID (required)
        :type  a_lb_hardware_security_module_group: :class:`com.vmware.nsx_policy.model_client.ALBHardwareSecurityModuleGroup`
        :param a_lb_hardware_security_module_group: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_hardwaresecuritymodulegroup_id': alb_hardwaresecuritymodulegroup_id,
                            'a_lb_hardware_security_module_group': a_lb_hardware_security_module_group,
                            })

    def update(self,
               alb_hardwaresecuritymodulegroup_id,
               a_lb_hardware_security_module_group,
               ):
        """
        If a ALBHardwareSecurityModuleGroup with the
        alb-HardwareSecurityModuleGroup-id is not already present, create a new
        ALBHardwareSecurityModuleGroup. If it already exists, update the
        ALBHardwareSecurityModuleGroup. This is a full replace. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_hardwaresecuritymodulegroup_id: :class:`str`
        :param alb_hardwaresecuritymodulegroup_id: ALBHardwareSecurityModuleGroup ID (required)
        :type  a_lb_hardware_security_module_group: :class:`com.vmware.nsx_policy.model_client.ALBHardwareSecurityModuleGroup`
        :param a_lb_hardware_security_module_group: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHardwareSecurityModuleGroup`
        :return: com.vmware.nsx_policy.model.ALBHardwareSecurityModuleGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_hardwaresecuritymodulegroup_id': alb_hardwaresecuritymodulegroup_id,
                            'a_lb_hardware_security_module_group': a_lb_hardware_security_module_group,
                            })
class AlbHealthMonitors(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_health_monitors'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbHealthMonitorsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_healthmonitor_id,
               force=None,
               ):
        """
        Delete the ALBHealthMonitor along with all the entities contained by
        this ALBHealthMonitor. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_healthmonitor_id: :class:`str`
        :param alb_healthmonitor_id: ALBHealthMonitor ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHealthMonitors.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_healthmonitor_id': alb_healthmonitor_id,
                            'force': force,
                            })

    def get(self,
            alb_healthmonitor_id,
            ):
        """
        Read a ALBHealthMonitor. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_healthmonitor_id: :class:`str`
        :param alb_healthmonitor_id: ALBHealthMonitor ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHealthMonitor`
        :return: com.vmware.nsx_policy.model.ALBHealthMonitor
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHealthMonitors.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_healthmonitor_id': alb_healthmonitor_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBHealthMonitor for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHealthMonitorApiResponse`
        :return: com.vmware.nsx_policy.model.ALBHealthMonitorApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHealthMonitors.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_healthmonitor_id,
              a_lb_health_monitor,
              ):
        """
        If a ALBhealthmonitor with the alb-healthmonitor-id is not already
        present, create a new ALBhealthmonitor. If it already exists, update
        the ALBhealthmonitor. This is a full replace. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_healthmonitor_id: :class:`str`
        :param alb_healthmonitor_id: ALBhealthmonitor ID (required)
        :type  a_lb_health_monitor: :class:`com.vmware.nsx_policy.model_client.ALBHealthMonitor`
        :param a_lb_health_monitor: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHealthMonitors.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_healthmonitor_id': alb_healthmonitor_id,
                            'a_lb_health_monitor': a_lb_health_monitor,
                            })

    def update(self,
               alb_healthmonitor_id,
               a_lb_health_monitor,
               ):
        """
        If a ALBHealthMonitor with the alb-HealthMonitor-id is not already
        present, create a new ALBHealthMonitor. If it already exists, update
        the ALBHealthMonitor. This is a full replace. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_healthmonitor_id: :class:`str`
        :param alb_healthmonitor_id: ALBHealthMonitor ID (required)
        :type  a_lb_health_monitor: :class:`com.vmware.nsx_policy.model_client.ALBHealthMonitor`
        :param a_lb_health_monitor: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHealthMonitor`
        :return: com.vmware.nsx_policy.model.ALBHealthMonitor
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHealthMonitors.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_healthmonitor_id': alb_healthmonitor_id,
                            'a_lb_health_monitor': a_lb_health_monitor,
                            })
class AlbHttpPolicySets(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_http_policy_sets'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbHttpPolicySetsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_httppolicyset_id,
               force=None,
               ):
        """
        Delete the ALBHTTPPolicySet along with all the entities contained by
        this ALBHTTPPolicySet. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_httppolicyset_id: :class:`str`
        :param alb_httppolicyset_id: ALBHTTPPolicySet ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHttpPolicySets.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_httppolicyset_id': alb_httppolicyset_id,
                            'force': force,
                            })

    def get(self,
            alb_httppolicyset_id,
            ):
        """
        Read a ALBHTTPPolicySet. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_httppolicyset_id: :class:`str`
        :param alb_httppolicyset_id: ALBHTTPPolicySet ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHTTPPolicySet`
        :return: com.vmware.nsx_policy.model.ALBHTTPPolicySet
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHttpPolicySets.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_httppolicyset_id': alb_httppolicyset_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBHTTPPolicySet for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHTTPPolicySetApiResponse`
        :return: com.vmware.nsx_policy.model.ALBHTTPPolicySetApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHttpPolicySets.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_httppolicyset_id,
              a_lbhttp_policy_set,
              ):
        """
        If a ALBhttppolicyset with the alb-httppolicyset-id is not already
        present, create a new ALBhttppolicyset. If it already exists, update
        the ALBhttppolicyset. This is a full replace. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_httppolicyset_id: :class:`str`
        :param alb_httppolicyset_id: ALBhttppolicyset ID (required)
        :type  a_lbhttp_policy_set: :class:`com.vmware.nsx_policy.model_client.ALBHTTPPolicySet`
        :param a_lbhttp_policy_set: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHttpPolicySets.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_httppolicyset_id': alb_httppolicyset_id,
                            'a_lbhttp_policy_set': a_lbhttp_policy_set,
                            })

    def update(self,
               alb_httppolicyset_id,
               a_lbhttp_policy_set,
               ):
        """
        If a ALBHTTPPolicySet with the alb-HTTPPolicySet-id is not already
        present, create a new ALBHTTPPolicySet. If it already exists, update
        the ALBHTTPPolicySet. This is a full replace. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_httppolicyset_id: :class:`str`
        :param alb_httppolicyset_id: ALBHTTPPolicySet ID (required)
        :type  a_lbhttp_policy_set: :class:`com.vmware.nsx_policy.model_client.ALBHTTPPolicySet`
        :param a_lbhttp_policy_set: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBHTTPPolicySet`
        :return: com.vmware.nsx_policy.model.ALBHTTPPolicySet
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbHttpPolicySets.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_httppolicyset_id': alb_httppolicyset_id,
                            'a_lbhttp_policy_set': a_lbhttp_policy_set,
                            })
class AlbIpAddrGroups(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_ip_addr_groups'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbIpAddrGroupsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_ipaddrgroup_id,
               force=None,
               ):
        """
        Delete the ALBIpAddrGroup along with all the entities contained by this
        ALBIpAddrGroup. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ipaddrgroup_id: :class:`str`
        :param alb_ipaddrgroup_id: ALBIpAddrGroup ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbIpAddrGroups.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_ipaddrgroup_id': alb_ipaddrgroup_id,
                            'force': force,
                            })

    def get(self,
            alb_ipaddrgroup_id,
            ):
        """
        Read a ALBIpAddrGroup. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ipaddrgroup_id: :class:`str`
        :param alb_ipaddrgroup_id: ALBIpAddrGroup ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBIpAddrGroup`
        :return: com.vmware.nsx_policy.model.ALBIpAddrGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbIpAddrGroups.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_ipaddrgroup_id': alb_ipaddrgroup_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBIpAddrGroup for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBIpAddrGroupApiResponse`
        :return: com.vmware.nsx_policy.model.ALBIpAddrGroupApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbIpAddrGroups.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_ipaddrgroup_id,
              a_lb_ip_addr_group,
              ):
        """
        If a ALBipaddrgroup with the alb-ipaddrgroup-id is not already present,
        create a new ALBipaddrgroup. If it already exists, update the
        ALBipaddrgroup. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ipaddrgroup_id: :class:`str`
        :param alb_ipaddrgroup_id: ALBipaddrgroup ID (required)
        :type  a_lb_ip_addr_group: :class:`com.vmware.nsx_policy.model_client.ALBIpAddrGroup`
        :param a_lb_ip_addr_group: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbIpAddrGroups.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_ipaddrgroup_id': alb_ipaddrgroup_id,
                            'a_lb_ip_addr_group': a_lb_ip_addr_group,
                            })

    def update(self,
               alb_ipaddrgroup_id,
               a_lb_ip_addr_group,
               ):
        """
        If a ALBIpAddrGroup with the alb-IpAddrGroup-id is not already present,
        create a new ALBIpAddrGroup. If it already exists, update the
        ALBIpAddrGroup. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ipaddrgroup_id: :class:`str`
        :param alb_ipaddrgroup_id: ALBIpAddrGroup ID (required)
        :type  a_lb_ip_addr_group: :class:`com.vmware.nsx_policy.model_client.ALBIpAddrGroup`
        :param a_lb_ip_addr_group: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBIpAddrGroup`
        :return: com.vmware.nsx_policy.model.ALBIpAddrGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbIpAddrGroups.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_ipaddrgroup_id': alb_ipaddrgroup_id,
                            'a_lb_ip_addr_group': a_lb_ip_addr_group,
                            })
class AlbL4PolicySets(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_l4_policy_sets'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbL4PolicySetsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_l4policyset_id,
               force=None,
               ):
        """
        Delete the ALBL4PolicySet along with all the entities contained by this
        ALBL4PolicySet. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_l4policyset_id: :class:`str`
        :param alb_l4policyset_id: ALBL4PolicySet ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbL4PolicySets.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_l4policyset_id': alb_l4policyset_id,
                            'force': force,
                            })

    def get(self,
            alb_l4policyset_id,
            ):
        """
        Read a ALBL4PolicySet. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_l4policyset_id: :class:`str`
        :param alb_l4policyset_id: ALBL4PolicySet ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBL4PolicySet`
        :return: com.vmware.nsx_policy.model.ALBL4PolicySet
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbL4PolicySets.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_l4policyset_id': alb_l4policyset_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBL4PolicySet for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBL4PolicySetApiResponse`
        :return: com.vmware.nsx_policy.model.ALBL4PolicySetApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbL4PolicySets.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_l4policyset_id,
              a_lb_l4_policy_set,
              ):
        """
        If a ALBl4policyset with the alb-l4policyset-id is not already present,
        create a new ALBl4policyset. If it already exists, update the
        ALBl4policyset. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_l4policyset_id: :class:`str`
        :param alb_l4policyset_id: ALBl4policyset ID (required)
        :type  a_lb_l4_policy_set: :class:`com.vmware.nsx_policy.model_client.ALBL4PolicySet`
        :param a_lb_l4_policy_set: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbL4PolicySets.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_l4policyset_id': alb_l4policyset_id,
                            'a_lb_l4_policy_set': a_lb_l4_policy_set,
                            })

    def update(self,
               alb_l4policyset_id,
               a_lb_l4_policy_set,
               ):
        """
        If a ALBL4PolicySet with the alb-L4PolicySet-id is not already present,
        create a new ALBL4PolicySet. If it already exists, update the
        ALBL4PolicySet. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_l4policyset_id: :class:`str`
        :param alb_l4policyset_id: ALBL4PolicySet ID (required)
        :type  a_lb_l4_policy_set: :class:`com.vmware.nsx_policy.model_client.ALBL4PolicySet`
        :param a_lb_l4_policy_set: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBL4PolicySet`
        :return: com.vmware.nsx_policy.model.ALBL4PolicySet
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbL4PolicySets.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_l4policyset_id': alb_l4policyset_id,
                            'a_lb_l4_policy_set': a_lb_l4_policy_set,
                            })
class AlbNetworkProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_network_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbNetworkProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_networkprofile_id,
               force=None,
               ):
        """
        Delete the ALBNetworkProfile along with all the entities contained by
        this ALBNetworkProfile. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networkprofile_id: :class:`str`
        :param alb_networkprofile_id: ALBNetworkProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_networkprofile_id': alb_networkprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_networkprofile_id,
            ):
        """
        Read a ALBNetworkProfile. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networkprofile_id: :class:`str`
        :param alb_networkprofile_id: ALBNetworkProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBNetworkProfile`
        :return: com.vmware.nsx_policy.model.ALBNetworkProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_networkprofile_id': alb_networkprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBNetworkProfile for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBNetworkProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBNetworkProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_networkprofile_id,
              a_lb_network_profile,
              ):
        """
        If a ALBnetworkprofile with the alb-networkprofile-id is not already
        present, create a new ALBnetworkprofile. If it already exists, update
        the ALBnetworkprofile. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networkprofile_id: :class:`str`
        :param alb_networkprofile_id: ALBnetworkprofile ID (required)
        :type  a_lb_network_profile: :class:`com.vmware.nsx_policy.model_client.ALBNetworkProfile`
        :param a_lb_network_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_networkprofile_id': alb_networkprofile_id,
                            'a_lb_network_profile': a_lb_network_profile,
                            })

    def update(self,
               alb_networkprofile_id,
               a_lb_network_profile,
               ):
        """
        If a ALBNetworkProfile with the alb-NetworkProfile-id is not already
        present, create a new ALBNetworkProfile. If it already exists, update
        the ALBNetworkProfile. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networkprofile_id: :class:`str`
        :param alb_networkprofile_id: ALBNetworkProfile ID (required)
        :type  a_lb_network_profile: :class:`com.vmware.nsx_policy.model_client.ALBNetworkProfile`
        :param a_lb_network_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBNetworkProfile`
        :return: com.vmware.nsx_policy.model.ALBNetworkProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_networkprofile_id': alb_networkprofile_id,
                            'a_lb_network_profile': a_lb_network_profile,
                            })
class AlbNetworkSecurityPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_network_security_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbNetworkSecurityPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_networksecuritypolicy_id,
               force=None,
               ):
        """
        Delete the ALBNetworkSecurityPolicy along with all the entities
        contained by this ALBNetworkSecurityPolicy. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networksecuritypolicy_id: :class:`str`
        :param alb_networksecuritypolicy_id: ALBNetworkSecurityPolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_networksecuritypolicy_id': alb_networksecuritypolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_networksecuritypolicy_id,
            ):
        """
        Read a ALBNetworkSecurityPolicy. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networksecuritypolicy_id: :class:`str`
        :param alb_networksecuritypolicy_id: ALBNetworkSecurityPolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBNetworkSecurityPolicy`
        :return: com.vmware.nsx_policy.model.ALBNetworkSecurityPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_networksecuritypolicy_id': alb_networksecuritypolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBNetworkSecurityPolicy for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBNetworkSecurityPolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBNetworkSecurityPolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_networksecuritypolicy_id,
              a_lb_network_security_policy,
              ):
        """
        If a ALBnetworksecuritypolicy with the alb-networksecuritypolicy-id is
        not already present, create a new ALBnetworksecuritypolicy. If it
        already exists, update the ALBnetworksecuritypolicy. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networksecuritypolicy_id: :class:`str`
        :param alb_networksecuritypolicy_id: ALBnetworksecuritypolicy ID (required)
        :type  a_lb_network_security_policy: :class:`com.vmware.nsx_policy.model_client.ALBNetworkSecurityPolicy`
        :param a_lb_network_security_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_networksecuritypolicy_id': alb_networksecuritypolicy_id,
                            'a_lb_network_security_policy': a_lb_network_security_policy,
                            })

    def update(self,
               alb_networksecuritypolicy_id,
               a_lb_network_security_policy,
               ):
        """
        If a ALBNetworkSecurityPolicy with the alb-NetworkSecurityPolicy-id is
        not already present, create a new ALBNetworkSecurityPolicy. If it
        already exists, update the ALBNetworkSecurityPolicy. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_networksecuritypolicy_id: :class:`str`
        :param alb_networksecuritypolicy_id: ALBNetworkSecurityPolicy ID (required)
        :type  a_lb_network_security_policy: :class:`com.vmware.nsx_policy.model_client.ALBNetworkSecurityPolicy`
        :param a_lb_network_security_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBNetworkSecurityPolicy`
        :return: com.vmware.nsx_policy.model.ALBNetworkSecurityPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_networksecuritypolicy_id': alb_networksecuritypolicy_id,
                            'a_lb_network_security_policy': a_lb_network_security_policy,
                            })
class AlbOnboardingWorkflow(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_onboarding_workflow'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbOnboardingWorkflowStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               managed_by,
               ):
        """
        Delete the EnforcementPoint along with Infra Admin credentials.

        :type  managed_by: :class:`str`
        :param managed_by: On Boarding flow managed by LCM/VCF. (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'managed_by': managed_by,
                            })

    def update(self,
               a_lb_controller_configuration,
               ):
        """
        Set the post deployment cluster configuration for Advanced Load
        Balancer controller cluster.

        :type  a_lb_controller_configuration: :class:`com.vmware.nsx_policy.model_client.ALBControllerConfiguration`
        :param a_lb_controller_configuration: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EnforcementPoint`
        :return: com.vmware.nsx_policy.model.EnforcementPoint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'a_lb_controller_configuration': a_lb_controller_configuration,
                            })
class AlbPkiProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_pki_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbPkiProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_pkiprofile_id,
               force=None,
               ):
        """
        Delete the ALBPKIProfile along with all the entities contained by this
        ALBPKIProfile. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pkiprofile_id: :class:`str`
        :param alb_pkiprofile_id: ALBPKIProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPkiProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_pkiprofile_id': alb_pkiprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_pkiprofile_id,
            ):
        """
        Read a ALBPKIProfile. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pkiprofile_id: :class:`str`
        :param alb_pkiprofile_id: ALBPKIProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPKIProfile`
        :return: com.vmware.nsx_policy.model.ALBPKIProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPkiProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_pkiprofile_id': alb_pkiprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBPKIProfile for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPKIProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBPKIProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPkiProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_pkiprofile_id,
              a_lbpki_profile,
              ):
        """
        If a ALBpkiprofile with the alb-pkiprofile-id is not already present,
        create a new ALBpkiprofile. If it already exists, update the
        ALBpkiprofile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pkiprofile_id: :class:`str`
        :param alb_pkiprofile_id: ALBpkiprofile ID (required)
        :type  a_lbpki_profile: :class:`com.vmware.nsx_policy.model_client.ALBPKIProfile`
        :param a_lbpki_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPkiProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_pkiprofile_id': alb_pkiprofile_id,
                            'a_lbpki_profile': a_lbpki_profile,
                            })

    def update(self,
               alb_pkiprofile_id,
               a_lbpki_profile,
               ):
        """
        If a ALBPKIProfile with the alb-PKIProfile-id is not already present,
        create a new ALBPKIProfile. If it already exists, update the
        ALBPKIProfile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pkiprofile_id: :class:`str`
        :param alb_pkiprofile_id: ALBPKIProfile ID (required)
        :type  a_lbpki_profile: :class:`com.vmware.nsx_policy.model_client.ALBPKIProfile`
        :param a_lbpki_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPKIProfile`
        :return: com.vmware.nsx_policy.model.ALBPKIProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPkiProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_pkiprofile_id': alb_pkiprofile_id,
                            'a_lbpki_profile': a_lbpki_profile,
                            })
class AlbPoolGroupDeploymentPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_pool_group_deployment_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbPoolGroupDeploymentPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_poolgroupdeploymentpolicy_id,
               force=None,
               ):
        """
        Delete the ALBPoolGroupDeploymentPolicy along with all the entities
        contained by this ALBPoolGroupDeploymentPolicy. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_poolgroupdeploymentpolicy_id: :class:`str`
        :param alb_poolgroupdeploymentpolicy_id: ALBPoolGroupDeploymentPolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_poolgroupdeploymentpolicy_id': alb_poolgroupdeploymentpolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_poolgroupdeploymentpolicy_id,
            ):
        """
        Read a ALBPoolGroupDeploymentPolicy. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_poolgroupdeploymentpolicy_id: :class:`str`
        :param alb_poolgroupdeploymentpolicy_id: ALBPoolGroupDeploymentPolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroupDeploymentPolicy`
        :return: com.vmware.nsx_policy.model.ALBPoolGroupDeploymentPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_poolgroupdeploymentpolicy_id': alb_poolgroupdeploymentpolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBPoolGroupDeploymentPolicy for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroupDeploymentPolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBPoolGroupDeploymentPolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_poolgroupdeploymentpolicy_id,
              a_lb_pool_group_deployment_policy,
              ):
        """
        If a ALBpoolgroupdeploymentpolicy with the
        alb-poolgroupdeploymentpolicy-id is not already present, create a new
        ALBpoolgroupdeploymentpolicy. If it already exists, update the
        ALBpoolgroupdeploymentpolicy. This is a full replace. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_poolgroupdeploymentpolicy_id: :class:`str`
        :param alb_poolgroupdeploymentpolicy_id: ALBpoolgroupdeploymentpolicy ID (required)
        :type  a_lb_pool_group_deployment_policy: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroupDeploymentPolicy`
        :param a_lb_pool_group_deployment_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_poolgroupdeploymentpolicy_id': alb_poolgroupdeploymentpolicy_id,
                            'a_lb_pool_group_deployment_policy': a_lb_pool_group_deployment_policy,
                            })

    def update(self,
               alb_poolgroupdeploymentpolicy_id,
               a_lb_pool_group_deployment_policy,
               ):
        """
        If a ALBPoolGroupDeploymentPolicy with the
        alb-PoolGroupDeploymentPolicy-id is not already present, create a new
        ALBPoolGroupDeploymentPolicy. If it already exists, update the
        ALBPoolGroupDeploymentPolicy. This is a full replace. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  alb_poolgroupdeploymentpolicy_id: :class:`str`
        :param alb_poolgroupdeploymentpolicy_id: ALBPoolGroupDeploymentPolicy ID (required)
        :type  a_lb_pool_group_deployment_policy: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroupDeploymentPolicy`
        :param a_lb_pool_group_deployment_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroupDeploymentPolicy`
        :return: com.vmware.nsx_policy.model.ALBPoolGroupDeploymentPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_poolgroupdeploymentpolicy_id': alb_poolgroupdeploymentpolicy_id,
                            'a_lb_pool_group_deployment_policy': a_lb_pool_group_deployment_policy,
                            })
class AlbPoolGroups(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_pool_groups'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbPoolGroupsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_poolgroup_id,
               force=None,
               ):
        """
        Delete the ALBPoolGroup along with all the entities contained by this
        ALBPoolGroup. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_poolgroup_id: :class:`str`
        :param alb_poolgroup_id: ALBPoolGroup ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroups.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_poolgroup_id': alb_poolgroup_id,
                            'force': force,
                            })

    def get(self,
            alb_poolgroup_id,
            ):
        """
        Read a ALBPoolGroup. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_poolgroup_id: :class:`str`
        :param alb_poolgroup_id: ALBPoolGroup ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroup`
        :return: com.vmware.nsx_policy.model.ALBPoolGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroups.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_poolgroup_id': alb_poolgroup_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBPoolGroup for infra. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroupApiResponse`
        :return: com.vmware.nsx_policy.model.ALBPoolGroupApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroups.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_poolgroup_id,
              a_lb_pool_group,
              ):
        """
        If a ALBpoolgroup with the alb-poolgroup-id is not already present,
        create a new ALBpoolgroup. If it already exists, update the
        ALBpoolgroup. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_poolgroup_id: :class:`str`
        :param alb_poolgroup_id: ALBpoolgroup ID (required)
        :type  a_lb_pool_group: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroup`
        :param a_lb_pool_group: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroups.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_poolgroup_id': alb_poolgroup_id,
                            'a_lb_pool_group': a_lb_pool_group,
                            })

    def update(self,
               alb_poolgroup_id,
               a_lb_pool_group,
               ):
        """
        If a ALBPoolGroup with the alb-PoolGroup-id is not already present,
        create a new ALBPoolGroup. If it already exists, update the
        ALBPoolGroup. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_poolgroup_id: :class:`str`
        :param alb_poolgroup_id: ALBPoolGroup ID (required)
        :type  a_lb_pool_group: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroup`
        :param a_lb_pool_group: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolGroup`
        :return: com.vmware.nsx_policy.model.ALBPoolGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPoolGroups.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_poolgroup_id': alb_poolgroup_id,
                            'a_lb_pool_group': a_lb_pool_group,
                            })
class AlbPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_pool_id,
               force=None,
               ):
        """
        Delete the ALBPool along with all the entities contained by this
        ALBPool. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pool_id: :class:`str`
        :param alb_pool_id: ALBPool ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPools.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_pool_id': alb_pool_id,
                            'force': force,
                            })

    def get(self,
            alb_pool_id,
            ):
        """
        Read a ALBPool. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pool_id: :class:`str`
        :param alb_pool_id: ALBPool ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPool`
        :return: com.vmware.nsx_policy.model.ALBPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPools.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_pool_id': alb_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBPool for infra. This is a deprecated API. It
        is recommennded to use NSX Advanced Load Balancer (Avi) Controller UI
        or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPoolApiResponse`
        :return: com.vmware.nsx_policy.model.ALBPoolApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPools.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_pool_id,
              a_lb_pool,
              ):
        """
        If a ALBpool with the alb-pool-id is not already present, create a new
        ALBpool. If it already exists, update the ALBpool. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pool_id: :class:`str`
        :param alb_pool_id: ALBpool ID (required)
        :type  a_lb_pool: :class:`com.vmware.nsx_policy.model_client.ALBPool`
        :param a_lb_pool: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPools.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_pool_id': alb_pool_id,
                            'a_lb_pool': a_lb_pool,
                            })

    def update(self,
               alb_pool_id,
               a_lb_pool,
               ):
        """
        If a ALBPool with the alb-Pool-id is not already present, create a new
        ALBPool. If it already exists, update the ALBPool. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_pool_id: :class:`str`
        :param alb_pool_id: ALBPool ID (required)
        :type  a_lb_pool: :class:`com.vmware.nsx_policy.model_client.ALBPool`
        :param a_lb_pool: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPool`
        :return: com.vmware.nsx_policy.model.ALBPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPools.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_pool_id': alb_pool_id,
                            'a_lb_pool': a_lb_pool,
                            })
class AlbPriorityLabels(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_priority_labels'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbPriorityLabelsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_prioritylabels_id,
               force=None,
               ):
        """
        Delete the ALBPriorityLabels along with all the entities contained by
        this ALBPriorityLabels. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_prioritylabels_id: :class:`str`
        :param alb_prioritylabels_id: ALBPriorityLabels ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPriorityLabels.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_prioritylabels_id': alb_prioritylabels_id,
                            'force': force,
                            })

    def get(self,
            alb_prioritylabels_id,
            ):
        """
        Read a ALBPriorityLabels. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_prioritylabels_id: :class:`str`
        :param alb_prioritylabels_id: ALBPriorityLabels ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPriorityLabels`
        :return: com.vmware.nsx_policy.model.ALBPriorityLabels
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPriorityLabels.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_prioritylabels_id': alb_prioritylabels_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBPriorityLabels for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPriorityLabelsApiResponse`
        :return: com.vmware.nsx_policy.model.ALBPriorityLabelsApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPriorityLabels.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_prioritylabels_id,
              a_lb_priority_labels,
              ):
        """
        If a ALBprioritylabels with the alb-prioritylabels-id is not already
        present, create a new ALBprioritylabels. If it already exists, update
        the ALBprioritylabels. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_prioritylabels_id: :class:`str`
        :param alb_prioritylabels_id: ALBprioritylabels ID (required)
        :type  a_lb_priority_labels: :class:`com.vmware.nsx_policy.model_client.ALBPriorityLabels`
        :param a_lb_priority_labels: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPriorityLabels.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_prioritylabels_id': alb_prioritylabels_id,
                            'a_lb_priority_labels': a_lb_priority_labels,
                            })

    def update(self,
               alb_prioritylabels_id,
               a_lb_priority_labels,
               ):
        """
        If a ALBPriorityLabels with the alb-PriorityLabels-id is not already
        present, create a new ALBPriorityLabels. If it already exists, update
        the ALBPriorityLabels. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_prioritylabels_id: :class:`str`
        :param alb_prioritylabels_id: ALBPriorityLabels ID (required)
        :type  a_lb_priority_labels: :class:`com.vmware.nsx_policy.model_client.ALBPriorityLabels`
        :param a_lb_priority_labels: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBPriorityLabels`
        :return: com.vmware.nsx_policy.model.ALBPriorityLabels
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbPriorityLabels.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_prioritylabels_id': alb_prioritylabels_id,
                            'a_lb_priority_labels': a_lb_priority_labels,
                            })
class AlbProtocolParsers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_protocol_parsers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbProtocolParsersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_protocolparser_id,
               force=None,
               ):
        """
        Delete the ALBProtocolParser along with all the entities contained by
        this ALBProtocolParser. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_protocolparser_id: :class:`str`
        :param alb_protocolparser_id: ALBProtocolParser ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbProtocolParsers.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_protocolparser_id': alb_protocolparser_id,
                            'force': force,
                            })

    def get(self,
            alb_protocolparser_id,
            ):
        """
        Read a ALBProtocolParser. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_protocolparser_id: :class:`str`
        :param alb_protocolparser_id: ALBProtocolParser ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBProtocolParser`
        :return: com.vmware.nsx_policy.model.ALBProtocolParser
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbProtocolParsers.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_protocolparser_id': alb_protocolparser_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBProtocolParser for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBProtocolParserApiResponse`
        :return: com.vmware.nsx_policy.model.ALBProtocolParserApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbProtocolParsers.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_protocolparser_id,
              a_lb_protocol_parser,
              ):
        """
        If a ALBprotocolparser with the alb-protocolparser-id is not already
        present, create a new ALBprotocolparser. If it already exists, update
        the ALBprotocolparser. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_protocolparser_id: :class:`str`
        :param alb_protocolparser_id: ALBprotocolparser ID (required)
        :type  a_lb_protocol_parser: :class:`com.vmware.nsx_policy.model_client.ALBProtocolParser`
        :param a_lb_protocol_parser: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbProtocolParsers.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_protocolparser_id': alb_protocolparser_id,
                            'a_lb_protocol_parser': a_lb_protocol_parser,
                            })

    def update(self,
               alb_protocolparser_id,
               a_lb_protocol_parser,
               ):
        """
        If a ALBProtocolParser with the alb-ProtocolParser-id is not already
        present, create a new ALBProtocolParser. If it already exists, update
        the ALBProtocolParser. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_protocolparser_id: :class:`str`
        :param alb_protocolparser_id: ALBProtocolParser ID (required)
        :type  a_lb_protocol_parser: :class:`com.vmware.nsx_policy.model_client.ALBProtocolParser`
        :param a_lb_protocol_parser: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBProtocolParser`
        :return: com.vmware.nsx_policy.model.ALBProtocolParser
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbProtocolParsers.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_protocolparser_id': alb_protocolparser_id,
                            'a_lb_protocol_parser': a_lb_protocol_parser,
                            })
class AlbSecurityPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_security_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbSecurityPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_securitypolicy_id,
               force=None,
               ):
        """
        Delete the ALBSecurityPolicy along with all the entities contained by
        this ALBSecurityPolicy. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_securitypolicy_id: :class:`str`
        :param alb_securitypolicy_id: ALBSecurityPolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSecurityPolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_securitypolicy_id': alb_securitypolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_securitypolicy_id,
            ):
        """
        Read a ALBSecurityPolicy. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_securitypolicy_id: :class:`str`
        :param alb_securitypolicy_id: ALBSecurityPolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSecurityPolicy`
        :return: com.vmware.nsx_policy.model.ALBSecurityPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSecurityPolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_securitypolicy_id': alb_securitypolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBSecurityPolicy for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSecurityPolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBSecurityPolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSecurityPolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_securitypolicy_id,
              a_lb_security_policy,
              ):
        """
        If a ALBsecuritypolicy with the alb-securitypolicy-id is not already
        present, create a new ALBsecuritypolicy. If it already exists, update
        the ALBsecuritypolicy. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_securitypolicy_id: :class:`str`
        :param alb_securitypolicy_id: ALBsecuritypolicy ID (required)
        :type  a_lb_security_policy: :class:`com.vmware.nsx_policy.model_client.ALBSecurityPolicy`
        :param a_lb_security_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSecurityPolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_securitypolicy_id': alb_securitypolicy_id,
                            'a_lb_security_policy': a_lb_security_policy,
                            })

    def update(self,
               alb_securitypolicy_id,
               a_lb_security_policy,
               ):
        """
        If a ALBSecurityPolicy with the alb-SecurityPolicy-id is not already
        present, create a new ALBSecurityPolicy. If it already exists, update
        the ALBSecurityPolicy. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_securitypolicy_id: :class:`str`
        :param alb_securitypolicy_id: ALBSecurityPolicy ID (required)
        :type  a_lb_security_policy: :class:`com.vmware.nsx_policy.model_client.ALBSecurityPolicy`
        :param a_lb_security_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSecurityPolicy`
        :return: com.vmware.nsx_policy.model.ALBSecurityPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSecurityPolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_securitypolicy_id': alb_securitypolicy_id,
                            'a_lb_security_policy': a_lb_security_policy,
                            })
class AlbServerAutoScalePolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_server_auto_scale_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbServerAutoScalePoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_serverautoscalepolicy_id,
               force=None,
               ):
        """
        Delete the ALBServerAutoScalePolicy along with all the entities
        contained by this ALBServerAutoScalePolicy. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_serverautoscalepolicy_id: :class:`str`
        :param alb_serverautoscalepolicy_id: ALBServerAutoScalePolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_serverautoscalepolicy_id': alb_serverautoscalepolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_serverautoscalepolicy_id,
            ):
        """
        Read a ALBServerAutoScalePolicy. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_serverautoscalepolicy_id: :class:`str`
        :param alb_serverautoscalepolicy_id: ALBServerAutoScalePolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBServerAutoScalePolicy`
        :return: com.vmware.nsx_policy.model.ALBServerAutoScalePolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_serverautoscalepolicy_id': alb_serverautoscalepolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBServerAutoScalePolicy for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBServerAutoScalePolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBServerAutoScalePolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_serverautoscalepolicy_id,
              a_lb_server_auto_scale_policy,
              ):
        """
        If a ALBserverautoscalepolicy with the alb-serverautoscalepolicy-id is
        not already present, create a new ALBserverautoscalepolicy. If it
        already exists, update the ALBserverautoscalepolicy. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_serverautoscalepolicy_id: :class:`str`
        :param alb_serverautoscalepolicy_id: ALBserverautoscalepolicy ID (required)
        :type  a_lb_server_auto_scale_policy: :class:`com.vmware.nsx_policy.model_client.ALBServerAutoScalePolicy`
        :param a_lb_server_auto_scale_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_serverautoscalepolicy_id': alb_serverautoscalepolicy_id,
                            'a_lb_server_auto_scale_policy': a_lb_server_auto_scale_policy,
                            })

    def update(self,
               alb_serverautoscalepolicy_id,
               a_lb_server_auto_scale_policy,
               ):
        """
        If a ALBServerAutoScalePolicy with the alb-ServerAutoScalePolicy-id is
        not already present, create a new ALBServerAutoScalePolicy. If it
        already exists, update the ALBServerAutoScalePolicy. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_serverautoscalepolicy_id: :class:`str`
        :param alb_serverautoscalepolicy_id: ALBServerAutoScalePolicy ID (required)
        :type  a_lb_server_auto_scale_policy: :class:`com.vmware.nsx_policy.model_client.ALBServerAutoScalePolicy`
        :param a_lb_server_auto_scale_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBServerAutoScalePolicy`
        :return: com.vmware.nsx_policy.model.ALBServerAutoScalePolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_serverautoscalepolicy_id': alb_serverautoscalepolicy_id,
                            'a_lb_server_auto_scale_policy': a_lb_server_auto_scale_policy,
                            })
class AlbSslKeyAndCertificates(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_ssl_key_and_certificates'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbSslKeyAndCertificatesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_sslkeyandcertificate_id,
               force=None,
               ):
        """
        Delete the ALBSSLKeyAndCertificate along with all the entities
        contained by this ALBSSLKeyAndCertificate. This is a deprecated API. It
        is recommennded to use NSX Advanced Load Balancer (Avi) Controller UI
        or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslkeyandcertificate_id: :class:`str`
        :param alb_sslkeyandcertificate_id: ALBSSLKeyAndCertificate ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_sslkeyandcertificate_id': alb_sslkeyandcertificate_id,
                            'force': force,
                            })

    def get(self,
            alb_sslkeyandcertificate_id,
            ):
        """
        Read a ALBSSLKeyAndCertificate. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslkeyandcertificate_id: :class:`str`
        :param alb_sslkeyandcertificate_id: ALBSSLKeyAndCertificate ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSLKeyAndCertificate`
        :return: com.vmware.nsx_policy.model.ALBSSLKeyAndCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_sslkeyandcertificate_id': alb_sslkeyandcertificate_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBSSLKeyAndCertificate for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSLKeyAndCertificateApiResponse`
        :return: com.vmware.nsx_policy.model.ALBSSLKeyAndCertificateApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_sslkeyandcertificate_id,
              a_lbssl_key_and_certificate,
              ):
        """
        If a ALBsslkeyandcertificate with the alb-sslkeyandcertificate-id is
        not already present, create a new ALBsslkeyandcertificate. If it
        already exists, update the ALBsslkeyandcertificate. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslkeyandcertificate_id: :class:`str`
        :param alb_sslkeyandcertificate_id: ALBsslkeyandcertificate ID (required)
        :type  a_lbssl_key_and_certificate: :class:`com.vmware.nsx_policy.model_client.ALBSSLKeyAndCertificate`
        :param a_lbssl_key_and_certificate: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_sslkeyandcertificate_id': alb_sslkeyandcertificate_id,
                            'a_lbssl_key_and_certificate': a_lbssl_key_and_certificate,
                            })

    def update(self,
               alb_sslkeyandcertificate_id,
               a_lbssl_key_and_certificate,
               ):
        """
        If a ALBSSLKeyAndCertificate with the alb-SSLKeyAndCertificate-id is
        not already present, create a new ALBSSLKeyAndCertificate. If it
        already exists, update the ALBSSLKeyAndCertificate. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslkeyandcertificate_id: :class:`str`
        :param alb_sslkeyandcertificate_id: ALBSSLKeyAndCertificate ID (required)
        :type  a_lbssl_key_and_certificate: :class:`com.vmware.nsx_policy.model_client.ALBSSLKeyAndCertificate`
        :param a_lbssl_key_and_certificate: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSLKeyAndCertificate`
        :return: com.vmware.nsx_policy.model.ALBSSLKeyAndCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_sslkeyandcertificate_id': alb_sslkeyandcertificate_id,
                            'a_lbssl_key_and_certificate': a_lbssl_key_and_certificate,
                            })
class AlbSslProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_ssl_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbSslProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_sslprofile_id,
               force=None,
               ):
        """
        Delete the ALBSSLProfile along with all the entities contained by this
        ALBSSLProfile. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslprofile_id: :class:`str`
        :param alb_sslprofile_id: ALBSSLProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_sslprofile_id': alb_sslprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_sslprofile_id,
            ):
        """
        Read a ALBSSLProfile. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslprofile_id: :class:`str`
        :param alb_sslprofile_id: ALBSSLProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSLProfile`
        :return: com.vmware.nsx_policy.model.ALBSSLProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_sslprofile_id': alb_sslprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBSSLProfile for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSLProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBSSLProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_sslprofile_id,
              a_lbssl_profile,
              ):
        """
        If a ALBsslprofile with the alb-sslprofile-id is not already present,
        create a new ALBsslprofile. If it already exists, update the
        ALBsslprofile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslprofile_id: :class:`str`
        :param alb_sslprofile_id: ALBsslprofile ID (required)
        :type  a_lbssl_profile: :class:`com.vmware.nsx_policy.model_client.ALBSSLProfile`
        :param a_lbssl_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_sslprofile_id': alb_sslprofile_id,
                            'a_lbssl_profile': a_lbssl_profile,
                            })

    def update(self,
               alb_sslprofile_id,
               a_lbssl_profile,
               ):
        """
        If a ALBSSLProfile with the alb-SSLProfile-id is not already present,
        create a new ALBSSLProfile. If it already exists, update the
        ALBSSLProfile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_sslprofile_id: :class:`str`
        :param alb_sslprofile_id: ALBSSLProfile ID (required)
        :type  a_lbssl_profile: :class:`com.vmware.nsx_policy.model_client.ALBSSLProfile`
        :param a_lbssl_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSLProfile`
        :return: com.vmware.nsx_policy.model.ALBSSLProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSslProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_sslprofile_id': alb_sslprofile_id,
                            'a_lbssl_profile': a_lbssl_profile,
                            })
class AlbSsoPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_sso_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbSsoPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_ssopolicy_id,
               force=None,
               ):
        """
        Delete the ALBSSOPolicy along with all the entities contained by this
        ALBSSOPolicy. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ssopolicy_id: :class:`str`
        :param alb_ssopolicy_id: ALBSSOPolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSsoPolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_ssopolicy_id': alb_ssopolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_ssopolicy_id,
            ):
        """
        Read a ALBSSOPolicy. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ssopolicy_id: :class:`str`
        :param alb_ssopolicy_id: ALBSSOPolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSOPolicy`
        :return: com.vmware.nsx_policy.model.ALBSSOPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSsoPolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_ssopolicy_id': alb_ssopolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBSSOPolicy for infra. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSOPolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBSSOPolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSsoPolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_ssopolicy_id,
              a_lbsso_policy,
              ):
        """
        If a ALBssopolicy with the alb-ssopolicy-id is not already present,
        create a new ALBssopolicy. If it already exists, update the
        ALBssopolicy. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ssopolicy_id: :class:`str`
        :param alb_ssopolicy_id: ALBssopolicy ID (required)
        :type  a_lbsso_policy: :class:`com.vmware.nsx_policy.model_client.ALBSSOPolicy`
        :param a_lbsso_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSsoPolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_ssopolicy_id': alb_ssopolicy_id,
                            'a_lbsso_policy': a_lbsso_policy,
                            })

    def update(self,
               alb_ssopolicy_id,
               a_lbsso_policy,
               ):
        """
        If a ALBSSOPolicy with the alb-SSOPolicy-id is not already present,
        create a new ALBSSOPolicy. If it already exists, update the
        ALBSSOPolicy. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_ssopolicy_id: :class:`str`
        :param alb_ssopolicy_id: ALBSSOPolicy ID (required)
        :type  a_lbsso_policy: :class:`com.vmware.nsx_policy.model_client.ALBSSOPolicy`
        :param a_lbsso_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBSSOPolicy`
        :return: com.vmware.nsx_policy.model.ALBSSOPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbSsoPolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_ssopolicy_id': alb_ssopolicy_id,
                            'a_lbsso_policy': a_lbsso_policy,
                            })
class AlbStringGroups(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_string_groups'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbStringGroupsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_stringgroup_id,
               force=None,
               ):
        """
        Delete the ALBStringGroup along with all the entities contained by this
        ALBStringGroup. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_stringgroup_id: :class:`str`
        :param alb_stringgroup_id: ALBStringGroup ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbStringGroups.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_stringgroup_id': alb_stringgroup_id,
                            'force': force,
                            })

    def get(self,
            alb_stringgroup_id,
            ):
        """
        Read a ALBStringGroup. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_stringgroup_id: :class:`str`
        :param alb_stringgroup_id: ALBStringGroup ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBStringGroup`
        :return: com.vmware.nsx_policy.model.ALBStringGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbStringGroups.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_stringgroup_id': alb_stringgroup_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBStringGroup for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBStringGroupApiResponse`
        :return: com.vmware.nsx_policy.model.ALBStringGroupApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbStringGroups.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_stringgroup_id,
              a_lb_string_group,
              ):
        """
        If a ALBstringgroup with the alb-stringgroup-id is not already present,
        create a new ALBstringgroup. If it already exists, update the
        ALBstringgroup. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_stringgroup_id: :class:`str`
        :param alb_stringgroup_id: ALBstringgroup ID (required)
        :type  a_lb_string_group: :class:`com.vmware.nsx_policy.model_client.ALBStringGroup`
        :param a_lb_string_group: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbStringGroups.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_stringgroup_id': alb_stringgroup_id,
                            'a_lb_string_group': a_lb_string_group,
                            })

    def update(self,
               alb_stringgroup_id,
               a_lb_string_group,
               ):
        """
        If a ALBStringGroup with the alb-StringGroup-id is not already present,
        create a new ALBStringGroup. If it already exists, update the
        ALBStringGroup. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_stringgroup_id: :class:`str`
        :param alb_stringgroup_id: ALBStringGroup ID (required)
        :type  a_lb_string_group: :class:`com.vmware.nsx_policy.model_client.ALBStringGroup`
        :param a_lb_string_group: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBStringGroup`
        :return: com.vmware.nsx_policy.model.ALBStringGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbStringGroups.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_stringgroup_id': alb_stringgroup_id,
                            'a_lb_string_group': a_lb_string_group,
                            })
class AlbTrafficCloneProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_traffic_clone_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbTrafficCloneProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_trafficcloneprofile_id,
               force=None,
               ):
        """
        Delete the ALBTrafficCloneProfile along with all the entities contained
        by this ALBTrafficCloneProfile. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_trafficcloneprofile_id: :class:`str`
        :param alb_trafficcloneprofile_id: ALBTrafficCloneProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_trafficcloneprofile_id': alb_trafficcloneprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_trafficcloneprofile_id,
            ):
        """
        Read a ALBTrafficCloneProfile. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_trafficcloneprofile_id: :class:`str`
        :param alb_trafficcloneprofile_id: ALBTrafficCloneProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBTrafficCloneProfile`
        :return: com.vmware.nsx_policy.model.ALBTrafficCloneProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_trafficcloneprofile_id': alb_trafficcloneprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBTrafficCloneProfile for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBTrafficCloneProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBTrafficCloneProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_trafficcloneprofile_id,
              a_lb_traffic_clone_profile,
              ):
        """
        If a ALBtrafficcloneprofile with the alb-trafficcloneprofile-id is not
        already present, create a new ALBtrafficcloneprofile. If it already
        exists, update the ALBtrafficcloneprofile. This is a full replace. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  alb_trafficcloneprofile_id: :class:`str`
        :param alb_trafficcloneprofile_id: ALBtrafficcloneprofile ID (required)
        :type  a_lb_traffic_clone_profile: :class:`com.vmware.nsx_policy.model_client.ALBTrafficCloneProfile`
        :param a_lb_traffic_clone_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_trafficcloneprofile_id': alb_trafficcloneprofile_id,
                            'a_lb_traffic_clone_profile': a_lb_traffic_clone_profile,
                            })

    def update(self,
               alb_trafficcloneprofile_id,
               a_lb_traffic_clone_profile,
               ):
        """
        If a ALBTrafficCloneProfile with the alb-TrafficCloneProfile-id is not
        already present, create a new ALBTrafficCloneProfile. If it already
        exists, update the ALBTrafficCloneProfile. This is a full replace. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  alb_trafficcloneprofile_id: :class:`str`
        :param alb_trafficcloneprofile_id: ALBTrafficCloneProfile ID (required)
        :type  a_lb_traffic_clone_profile: :class:`com.vmware.nsx_policy.model_client.ALBTrafficCloneProfile`
        :param a_lb_traffic_clone_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBTrafficCloneProfile`
        :return: com.vmware.nsx_policy.model.ALBTrafficCloneProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_trafficcloneprofile_id': alb_trafficcloneprofile_id,
                            'a_lb_traffic_clone_profile': a_lb_traffic_clone_profile,
                            })
class AlbVirtualServices(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_virtual_services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbVirtualServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_virtualservice_id,
               force=None,
               ):
        """
        Delete the ALBVirtualService along with all the entities contained by
        this ALBVirtualService. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_virtualservice_id: :class:`str`
        :param alb_virtualservice_id: ALBVirtualService ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVirtualServices.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_virtualservice_id': alb_virtualservice_id,
                            'force': force,
                            })

    def get(self,
            alb_virtualservice_id,
            ):
        """
        Read a ALBVirtualService. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_virtualservice_id: :class:`str`
        :param alb_virtualservice_id: ALBVirtualService ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVirtualService`
        :return: com.vmware.nsx_policy.model.ALBVirtualService
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVirtualServices.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_virtualservice_id': alb_virtualservice_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBVirtualService for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVirtualServiceApiResponse`
        :return: com.vmware.nsx_policy.model.ALBVirtualServiceApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVirtualServices.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_virtualservice_id,
              a_lb_virtual_service,
              ):
        """
        If a ALBvirtualservice with the alb-virtualservice-id is not already
        present, create a new ALBvirtualservice. If it already exists, update
        the ALBvirtualservice. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_virtualservice_id: :class:`str`
        :param alb_virtualservice_id: ALBvirtualservice ID (required)
        :type  a_lb_virtual_service: :class:`com.vmware.nsx_policy.model_client.ALBVirtualService`
        :param a_lb_virtual_service: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVirtualServices.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_virtualservice_id': alb_virtualservice_id,
                            'a_lb_virtual_service': a_lb_virtual_service,
                            })

    def update(self,
               alb_virtualservice_id,
               a_lb_virtual_service,
               ):
        """
        If a ALBVirtualService with the alb-VirtualService-id is not already
        present, create a new ALBVirtualService. If it already exists, update
        the ALBVirtualService. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_virtualservice_id: :class:`str`
        :param alb_virtualservice_id: ALBVirtualService ID (required)
        :type  a_lb_virtual_service: :class:`com.vmware.nsx_policy.model_client.ALBVirtualService`
        :param a_lb_virtual_service: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVirtualService`
        :return: com.vmware.nsx_policy.model.ALBVirtualService
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVirtualServices.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_virtualservice_id': alb_virtualservice_id,
                            'a_lb_virtual_service': a_lb_virtual_service,
                            })
class AlbVsDataScriptSets(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_vs_data_script_sets'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbVsDataScriptSetsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_vsdatascriptset_id,
               force=None,
               ):
        """
        Delete the ALBVSDataScriptSet along with all the entities contained by
        this ALBVSDataScriptSet. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsdatascriptset_id: :class:`str`
        :param alb_vsdatascriptset_id: ALBVSDataScriptSet ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsDataScriptSets.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_vsdatascriptset_id': alb_vsdatascriptset_id,
                            'force': force,
                            })

    def get(self,
            alb_vsdatascriptset_id,
            ):
        """
        Read a ALBVSDataScriptSet. This is a deprecated API. It is recommennded
        to use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsdatascriptset_id: :class:`str`
        :param alb_vsdatascriptset_id: ALBVSDataScriptSet ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVSDataScriptSet`
        :return: com.vmware.nsx_policy.model.ALBVSDataScriptSet
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsDataScriptSets.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_vsdatascriptset_id': alb_vsdatascriptset_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBVSDataScriptSet for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVSDataScriptSetApiResponse`
        :return: com.vmware.nsx_policy.model.ALBVSDataScriptSetApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsDataScriptSets.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_vsdatascriptset_id,
              a_lbvs_data_script_set,
              ):
        """
        If a ALBvsdatascriptset with the alb-vsdatascriptset-id is not already
        present, create a new ALBvsdatascriptset. If it already exists, update
        the ALBvsdatascriptset. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsdatascriptset_id: :class:`str`
        :param alb_vsdatascriptset_id: ALBvsdatascriptset ID (required)
        :type  a_lbvs_data_script_set: :class:`com.vmware.nsx_policy.model_client.ALBVSDataScriptSet`
        :param a_lbvs_data_script_set: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsDataScriptSets.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_vsdatascriptset_id': alb_vsdatascriptset_id,
                            'a_lbvs_data_script_set': a_lbvs_data_script_set,
                            })

    def update(self,
               alb_vsdatascriptset_id,
               a_lbvs_data_script_set,
               ):
        """
        If a ALBVSDataScriptSet with the alb-VSDataScriptSet-id is not already
        present, create a new ALBVSDataScriptSet. If it already exists, update
        the ALBVSDataScriptSet. This is a full replace. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsdatascriptset_id: :class:`str`
        :param alb_vsdatascriptset_id: ALBVSDataScriptSet ID (required)
        :type  a_lbvs_data_script_set: :class:`com.vmware.nsx_policy.model_client.ALBVSDataScriptSet`
        :param a_lbvs_data_script_set: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVSDataScriptSet`
        :return: com.vmware.nsx_policy.model.ALBVSDataScriptSet
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsDataScriptSets.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_vsdatascriptset_id': alb_vsdatascriptset_id,
                            'a_lbvs_data_script_set': a_lbvs_data_script_set,
                            })
class AlbVsVips(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_vs_vips'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbVsVipsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_vsvip_id,
               force=None,
               ):
        """
        Delete the ALBVsVip along with all the entities contained by this
        ALBVsVip. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsvip_id: :class:`str`
        :param alb_vsvip_id: ALBVsVip ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsVips.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_vsvip_id': alb_vsvip_id,
                            'force': force,
                            })

    def get(self,
            alb_vsvip_id,
            ):
        """
        Read a ALBVsVip. This is a deprecated API. It is recommennded to use
        NSX Advanced Load Balancer (Avi) Controller UI or API directly instead
        of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsvip_id: :class:`str`
        :param alb_vsvip_id: ALBVsVip ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVsVip`
        :return: com.vmware.nsx_policy.model.ALBVsVip
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsVips.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_vsvip_id': alb_vsvip_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBVsVip for infra. This is a deprecated API. It
        is recommennded to use NSX Advanced Load Balancer (Avi) Controller UI
        or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVsVipApiResponse`
        :return: com.vmware.nsx_policy.model.ALBVsVipApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsVips.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_vsvip_id,
              a_lb_vs_vip,
              ):
        """
        If a ALBvsvip with the alb-vsvip-id is not already present, create a
        new ALBvsvip. If it already exists, update the ALBvsvip. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsvip_id: :class:`str`
        :param alb_vsvip_id: ALBvsvip ID (required)
        :type  a_lb_vs_vip: :class:`com.vmware.nsx_policy.model_client.ALBVsVip`
        :param a_lb_vs_vip: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsVips.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_vsvip_id': alb_vsvip_id,
                            'a_lb_vs_vip': a_lb_vs_vip,
                            })

    def update(self,
               alb_vsvip_id,
               a_lb_vs_vip,
               ):
        """
        If a ALBVsVip with the alb-VsVip-id is not already present, create a
        new ALBVsVip. If it already exists, update the ALBVsVip. This is a full
        replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_vsvip_id: :class:`str`
        :param alb_vsvip_id: ALBVsVip ID (required)
        :type  a_lb_vs_vip: :class:`com.vmware.nsx_policy.model_client.ALBVsVip`
        :param a_lb_vs_vip: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBVsVip`
        :return: com.vmware.nsx_policy.model.ALBVsVip
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbVsVips.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_vsvip_id': alb_vsvip_id,
                            'a_lb_vs_vip': a_lb_vs_vip,
                            })
class AlbWafCrs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_waf_crs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbWafCrsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_wafcrs_id,
               force=None,
               ):
        """
        Delete the ALBWafCRS along with all the entities contained by this
        ALBWafCRS. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafcrs_id: :class:`str`
        :param alb_wafcrs_id: ALBWafCRS ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafCrs.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_wafcrs_id': alb_wafcrs_id,
                            'force': force,
                            })

    def get(self,
            alb_wafcrs_id,
            ):
        """
        Read a ALBWafCRS. This is a deprecated API. It is recommennded to use
        NSX Advanced Load Balancer (Avi) Controller UI or API directly instead
        of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafcrs_id: :class:`str`
        :param alb_wafcrs_id: ALBWafCRS ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafCRS`
        :return: com.vmware.nsx_policy.model.ALBWafCRS
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafCrs.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_wafcrs_id': alb_wafcrs_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBWafCRS for infra. This is a deprecated API. It
        is recommennded to use NSX Advanced Load Balancer (Avi) Controller UI
        or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafCRSApiResponse`
        :return: com.vmware.nsx_policy.model.ALBWafCRSApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafCrs.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_wafcrs_id,
              a_lb_waf_crs,
              ):
        """
        If a ALBwafcrs with the alb-wafcrs-id is not already present, create a
        new ALBwafcrs. If it already exists, update the ALBwafcrs. This is a
        full replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafcrs_id: :class:`str`
        :param alb_wafcrs_id: ALBwafcrs ID (required)
        :type  a_lb_waf_crs: :class:`com.vmware.nsx_policy.model_client.ALBWafCRS`
        :param a_lb_waf_crs: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafCrs.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_wafcrs_id': alb_wafcrs_id,
                            'a_lb_waf_crs': a_lb_waf_crs,
                            })

    def update(self,
               alb_wafcrs_id,
               a_lb_waf_crs,
               ):
        """
        If a ALBWafCRS with the alb-WafCRS-id is not already present, create a
        new ALBWafCRS. If it already exists, update the ALBWafCRS. This is a
        full replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafcrs_id: :class:`str`
        :param alb_wafcrs_id: ALBWafCRS ID (required)
        :type  a_lb_waf_crs: :class:`com.vmware.nsx_policy.model_client.ALBWafCRS`
        :param a_lb_waf_crs: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafCRS`
        :return: com.vmware.nsx_policy.model.ALBWafCRS
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafCrs.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_wafcrs_id': alb_wafcrs_id,
                            'a_lb_waf_crs': a_lb_waf_crs,
                            })
class AlbWafPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_waf_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbWafPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_wafpolicy_id,
               force=None,
               ):
        """
        Delete the ALBWafPolicy along with all the entities contained by this
        ALBWafPolicy. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicy_id: :class:`str`
        :param alb_wafpolicy_id: ALBWafPolicy ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicies.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_wafpolicy_id': alb_wafpolicy_id,
                            'force': force,
                            })

    def get(self,
            alb_wafpolicy_id,
            ):
        """
        Read a ALBWafPolicy. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicy_id: :class:`str`
        :param alb_wafpolicy_id: ALBWafPolicy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicy`
        :return: com.vmware.nsx_policy.model.ALBWafPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicies.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_wafpolicy_id': alb_wafpolicy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBWafPolicy for infra. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicyApiResponse`
        :return: com.vmware.nsx_policy.model.ALBWafPolicyApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicies.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_wafpolicy_id,
              a_lb_waf_policy,
              ):
        """
        If a ALBwafpolicy with the alb-wafpolicy-id is not already present,
        create a new ALBwafpolicy. If it already exists, update the
        ALBwafpolicy. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicy_id: :class:`str`
        :param alb_wafpolicy_id: ALBwafpolicy ID (required)
        :type  a_lb_waf_policy: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicy`
        :param a_lb_waf_policy: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicies.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_wafpolicy_id': alb_wafpolicy_id,
                            'a_lb_waf_policy': a_lb_waf_policy,
                            })

    def update(self,
               alb_wafpolicy_id,
               a_lb_waf_policy,
               ):
        """
        If a ALBWafPolicy with the alb-WafPolicy-id is not already present,
        create a new ALBWafPolicy. If it already exists, update the
        ALBWafPolicy. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicy_id: :class:`str`
        :param alb_wafpolicy_id: ALBWafPolicy ID (required)
        :type  a_lb_waf_policy: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicy`
        :param a_lb_waf_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicy`
        :return: com.vmware.nsx_policy.model.ALBWafPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicies.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_wafpolicy_id': alb_wafpolicy_id,
                            'a_lb_waf_policy': a_lb_waf_policy,
                            })
class AlbWafPolicyPsmGroups(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_waf_policy_psm_groups'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbWafPolicyPsmGroupsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_wafpolicypsmgroup_id,
               force=None,
               ):
        """
        Delete the ALBWafPolicyPSMGroup along with all the entities contained
        by this ALBWafPolicyPSMGroup. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicypsmgroup_id: :class:`str`
        :param alb_wafpolicypsmgroup_id: ALBWafPolicyPSMGroup ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_wafpolicypsmgroup_id': alb_wafpolicypsmgroup_id,
                            'force': force,
                            })

    def get(self,
            alb_wafpolicypsmgroup_id,
            ):
        """
        Read a ALBWafPolicyPSMGroup. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicypsmgroup_id: :class:`str`
        :param alb_wafpolicypsmgroup_id: ALBWafPolicyPSMGroup ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicyPSMGroup`
        :return: com.vmware.nsx_policy.model.ALBWafPolicyPSMGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_wafpolicypsmgroup_id': alb_wafpolicypsmgroup_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBWafPolicyPSMGroup for infra. This is a
        deprecated API. It is recommennded to use NSX Advanced Load Balancer
        (Avi) Controller UI or API directly instead of NSX-T ALB Policy UI and
        API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicyPSMGroupApiResponse`
        :return: com.vmware.nsx_policy.model.ALBWafPolicyPSMGroupApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_wafpolicypsmgroup_id,
              a_lb_waf_policy_psm_group,
              ):
        """
        If a ALBwafpolicypsmgroup with the alb-wafpolicypsmgroup-id is not
        already present, create a new ALBwafpolicypsmgroup. If it already
        exists, update the ALBwafpolicypsmgroup. This is a full replace. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicypsmgroup_id: :class:`str`
        :param alb_wafpolicypsmgroup_id: ALBwafpolicypsmgroup ID (required)
        :type  a_lb_waf_policy_psm_group: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicyPSMGroup`
        :param a_lb_waf_policy_psm_group: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_wafpolicypsmgroup_id': alb_wafpolicypsmgroup_id,
                            'a_lb_waf_policy_psm_group': a_lb_waf_policy_psm_group,
                            })

    def update(self,
               alb_wafpolicypsmgroup_id,
               a_lb_waf_policy_psm_group,
               ):
        """
        If a ALBWafPolicyPSMGroup with the alb-WafPolicyPSMGroup-id is not
        already present, create a new ALBWafPolicyPSMGroup. If it already
        exists, update the ALBWafPolicyPSMGroup. This is a full replace. This
        is a deprecated API. It is recommennded to use NSX Advanced Load
        Balancer (Avi) Controller UI or API directly instead of NSX-T ALB
        Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafpolicypsmgroup_id: :class:`str`
        :param alb_wafpolicypsmgroup_id: ALBWafPolicyPSMGroup ID (required)
        :type  a_lb_waf_policy_psm_group: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicyPSMGroup`
        :param a_lb_waf_policy_psm_group: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafPolicyPSMGroup`
        :return: com.vmware.nsx_policy.model.ALBWafPolicyPSMGroup
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_wafpolicypsmgroup_id': alb_wafpolicypsmgroup_id,
                            'a_lb_waf_policy_psm_group': a_lb_waf_policy_psm_group,
                            })
class AlbWafProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_waf_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbWafProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_wafprofile_id,
               force=None,
               ):
        """
        Delete the ALBWafProfile along with all the entities contained by this
        ALBWafProfile. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafprofile_id: :class:`str`
        :param alb_wafprofile_id: ALBWafProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_wafprofile_id': alb_wafprofile_id,
                            'force': force,
                            })

    def get(self,
            alb_wafprofile_id,
            ):
        """
        Read a ALBWafProfile. This is a deprecated API. It is recommennded to
        use NSX Advanced Load Balancer (Avi) Controller UI or API directly
        instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafprofile_id: :class:`str`
        :param alb_wafprofile_id: ALBWafProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafProfile`
        :return: com.vmware.nsx_policy.model.ALBWafProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_wafprofile_id': alb_wafprofile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBWafProfile for infra. This is a deprecated
        API. It is recommennded to use NSX Advanced Load Balancer (Avi)
        Controller UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafProfileApiResponse`
        :return: com.vmware.nsx_policy.model.ALBWafProfileApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_wafprofile_id,
              a_lb_waf_profile,
              ):
        """
        If a ALBwafprofile with the alb-wafprofile-id is not already present,
        create a new ALBwafprofile. If it already exists, update the
        ALBwafprofile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafprofile_id: :class:`str`
        :param alb_wafprofile_id: ALBwafprofile ID (required)
        :type  a_lb_waf_profile: :class:`com.vmware.nsx_policy.model_client.ALBWafProfile`
        :param a_lb_waf_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_wafprofile_id': alb_wafprofile_id,
                            'a_lb_waf_profile': a_lb_waf_profile,
                            })

    def update(self,
               alb_wafprofile_id,
               a_lb_waf_profile,
               ):
        """
        If a ALBWafProfile with the alb-WafProfile-id is not already present,
        create a new ALBWafProfile. If it already exists, update the
        ALBWafProfile. This is a full replace. This is a deprecated API. It is
        recommennded to use NSX Advanced Load Balancer (Avi) Controller UI or
        API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_wafprofile_id: :class:`str`
        :param alb_wafprofile_id: ALBWafProfile ID (required)
        :type  a_lb_waf_profile: :class:`com.vmware.nsx_policy.model_client.ALBWafProfile`
        :param a_lb_waf_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWafProfile`
        :return: com.vmware.nsx_policy.model.ALBWafProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWafProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_wafprofile_id': alb_wafprofile_id,
                            'a_lb_waf_profile': a_lb_waf_profile,
                            })
class AlbWebhooks(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_webhooks'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbWebhooksStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               alb_webhook_id,
               force=None,
               ):
        """
        Delete the ALBWebhook along with all the entities contained by this
        ALBWebhook. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_webhook_id: :class:`str`
        :param alb_webhook_id: ALBWebhook ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWebhooks.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'alb_webhook_id': alb_webhook_id,
                            'force': force,
                            })

    def get(self,
            alb_webhook_id,
            ):
        """
        Read a ALBWebhook. This is a deprecated API. It is recommennded to use
        NSX Advanced Load Balancer (Avi) Controller UI or API directly instead
        of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_webhook_id: :class:`str`
        :param alb_webhook_id: ALBWebhook ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWebhook`
        :return: com.vmware.nsx_policy.model.ALBWebhook
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWebhooks.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'alb_webhook_id': alb_webhook_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all ALBWebhook for infra. This is a deprecated API.
        It is recommennded to use NSX Advanced Load Balancer (Avi) Controller
        UI or API directly instead of NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWebhookApiResponse`
        :return: com.vmware.nsx_policy.model.ALBWebhookApiResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWebhooks.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              alb_webhook_id,
              a_lb_webhook,
              ):
        """
        If a ALBwebhook with the alb-webhook-id is not already present, create
        a new ALBwebhook. If it already exists, update the ALBwebhook. This is
        a full replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_webhook_id: :class:`str`
        :param alb_webhook_id: ALBwebhook ID (required)
        :type  a_lb_webhook: :class:`com.vmware.nsx_policy.model_client.ALBWebhook`
        :param a_lb_webhook: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWebhooks.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'alb_webhook_id': alb_webhook_id,
                            'a_lb_webhook': a_lb_webhook,
                            })

    def update(self,
               alb_webhook_id,
               a_lb_webhook,
               ):
        """
        If a ALBWebhook with the alb-Webhook-id is not already present, create
        a new ALBWebhook. If it already exists, update the ALBWebhook. This is
        a full replace. This is a deprecated API. It is recommennded to use NSX
        Advanced Load Balancer (Avi) Controller UI or API directly instead of
        NSX-T ALB Policy UI and API.

        .. deprecated:: unknown

        :type  alb_webhook_id: :class:`str`
        :param alb_webhook_id: ALBWebhook ID (required)
        :type  a_lb_webhook: :class:`com.vmware.nsx_policy.model_client.ALBWebhook`
        :param a_lb_webhook: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBWebhook`
        :return: com.vmware.nsx_policy.model.ALBWebhook
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.AlbWebhooks.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'alb_webhook_id': alb_webhook_id,
                            'a_lb_webhook': a_lb_webhook,
                            })
class BfdProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.bfd_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _BfdProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               bfd_profile_id,
               override=None,
               ):
        """
        Delete BFD Config and all the entities contained by this BfdProfile.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            'override': override,
                            })

    def get(self,
            bfd_profile_id,
            ):
        """
        Read a BfdProfile.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :return: com.vmware.nsx_policy.model.BfdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all BfdProfiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.BfdProfileListResult`
        :return: com.vmware.nsx_policy.model.BfdProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              bfd_profile_id,
              bfd_profile,
              override=None,
              ):
        """
        If a BfdProfile with the bfd-profile-id is not already present, create
        a new BfdProfile. If it already exists, update the BfdProfile. This
        operation will fully replace the object.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :type  bfd_profile: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :param bfd_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            'bfd_profile': bfd_profile,
                            'override': override,
                            })

    def update(self,
               bfd_profile_id,
               bfd_profile,
               override=None,
               ):
        """
        If a BfdProfile with the bfd-profile-id is not already present, create
        a new BfdProfile. If it already exists, update the BfdProfile. This
        operation will fully replace the object.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :type  bfd_profile: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :param bfd_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :return: com.vmware.nsx_policy.model.BfdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            'bfd_profile': bfd_profile,
                            'override': override,
                            })
class Cabundles(VapiInterface):
    """
    
    """
    LIST_TYPE_CLUSTER_API_CERTIFICATE = "cluster_api_certificate"
    """
    Possible value for ``type`` of method :func:`Cabundles.list`.

    """
    LIST_TYPE_API_CERTIFICATE = "api_certificate"
    """
    Possible value for ``type`` of method :func:`Cabundles.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.cabundles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CabundlesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               cabundle_id,
               ):
        """
        Deletes the specified bundle of trusted CA certificates.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle to delete (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'cabundle_id': cabundle_id,
                            })

    def get(self,
            cabundle_id,
            ):
        """
        Returns information about the specified bundle of trusted CA
        certificates.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle to retrieve (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :return: com.vmware.nsx_policy.model.CaBundle
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'cabundle_id': cabundle_id,
                            })

    def list(self,
             cursor=None,
             details=None,
             included_fields=None,
             node_id=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Returns information about all the bundles of trusted CA certificates.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of certificate to return (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type of certificate to return (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundleListResult`
        :return: com.vmware.nsx_policy.model.CaBundleListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'details': details,
                            'included_fields': included_fields,
                            'node_id': node_id,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def patch(self,
              cabundle_id,
              ca_bundle,
              ):
        """
        Adds or updates a new bundle of trusted CA certificates. The bundle
        must be a concatenation of one or more PEM-encoded certificates. The
        PEM-encoded bundle is replaced with the one provided in the request.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle being updated (required)
        :type  ca_bundle: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :param ca_bundle: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :return: com.vmware.nsx_policy.model.CaBundle
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'cabundle_id': cabundle_id,
                            'ca_bundle': ca_bundle,
                            })

    def update(self,
               cabundle_id,
               ca_bundle,
               ):
        """
        Adds or replaces a new bundle of trusted CA certificates. The bundle
        must be a concatenation of one or more PEM-encoded certificates.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle being uploaded (required)
        :type  ca_bundle: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :param ca_bundle: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :return: com.vmware.nsx_policy.model.CaBundle
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'cabundle_id': cabundle_id,
                            'ca_bundle': ca_bundle,
                            })
class Certificates(VapiInterface):
    """
    
    """
    LIST_TYPE_CLUSTER_API_CERTIFICATE = "cluster_api_certificate"
    """
    Possible value for ``type`` of method :func:`Certificates.list`.

    """
    LIST_TYPE_API_CERTIFICATE = "api_certificate"
    """
    Possible value for ``type`` of method :func:`Certificates.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.certificates'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CertificatesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               certificate_id,
               ):
        """
        Removes the specified certificate. The private key associated with the
        certificate is also deleted.

        :type  certificate_id: :class:`str`
        :param certificate_id: ID of certificate to delete (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'certificate_id': certificate_id,
                            })

    def get(self,
            certificate_id,
            details=None,
            ):
        """
        Returns information for the specified certificate ID, including the
        certificate's id; pem_encoded data; and history of the certificate (who
        created or modified it and when). For additional information, include
        the ?details=true modifier at the end of the request URI.

        :type  certificate_id: :class:`str`
        :param certificate_id: ID of certificate to read (required)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'certificate_id': certificate_id,
                            'details': details,
                            })

    def list(self,
             cursor=None,
             details=None,
             included_fields=None,
             node_id=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Returns all certificate information viewable by the user, including
        each certificate's id; pem_encoded data; and history of the certificate
        (who created or modified it and when). For additional information,
        include the ?details=true modifier at the end of the request URI.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of certificate to return (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type of certificate to return (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificateList`
        :return: com.vmware.nsx_policy.model.TlsCertificateList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'details': details,
                            'included_fields': included_fields,
                            'node_id': node_id,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def patch(self,
              certificate_id,
              tls_trust_data,
              ):
        """
        Adds a new private-public certificate and, optionally, a private key
        that can be applied to one of the user-facing components (appliance
        management or edge). The certificate and the key should be stored in
        PEM format. If no private key is provided, the certificate is used as a
        client certificate in the trust store. A private key can be uploaded
        for a CA certificate only if the \"purpose\" parameter is set to
        \"signing-ca\". A certificate chain will not be expanded into separate
        certificate instances for reference, but would be pushed to the
        enforcement point as a single certificate. This patch method does not
        modify an existing certificate.

        :type  certificate_id: :class:`str`
        :param certificate_id: (required)
        :type  tls_trust_data: :class:`com.vmware.nsx_policy.model_client.TlsTrustData`
        :param tls_trust_data: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'certificate_id': certificate_id,
                            'tls_trust_data': tls_trust_data,
                            })

    def update(self,
               certificate_id,
               tls_trust_data,
               ):
        """
        Adds a new private-public certificate and, optionally, a private key
        that can be applied to one of the user-facing components (appliance
        management or edge). The certificate and the key should be stored in
        PEM format. If no private key is provided, the certificate is used as a
        client certificate in the trust store. A private key can be uploaded
        for a CA certificate only if the \"purpose\" parameter is set to
        \"signing-ca\". A certificate chain will not be expanded into separate
        certificate instances for reference, but would be pushed to the
        enforcement point as a single certificate. This PUT method does not
        modify an existing certificate.

        :type  certificate_id: :class:`str`
        :param certificate_id: (required)
        :type  tls_trust_data: :class:`com.vmware.nsx_policy.model_client.TlsTrustData`
        :param tls_trust_data: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'certificate_id': certificate_id,
                            'tls_trust_data': tls_trust_data,
                            })
class CloudNativeServiceGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.cloud_native_service_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CloudNativeServiceGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cns_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given Cloud Native Service Instance is
        a member.

        :type  cns_external_id: :class:`str`
        :param cns_external_id: Cloud Native Service external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cns_external_id': cns_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class ConnectivityGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.connectivity_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConnectivityGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read the connectivity global configuration


        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def patch(self,
              global_config,
              ):
        """
        Update the connectivity global configuration

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'global_config': global_config,
                            })

    def update(self,
               global_config,
               ):
        """
        Update the connectivity global configuration

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'global_config': global_config,
                            })
class Constraints(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.constraints'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConstraintsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               constraint_id,
               ):
        """
        Delete tenant constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'constraint_id': constraint_id,
                            })

    def get(self,
            constraint_id,
            ):
        """
        Read tenant constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :return: com.vmware.nsx_policy.model.Constraint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'constraint_id': constraint_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List tenant constraints.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ConstraintListResult`
        :return: com.vmware.nsx_policy.model.ConstraintListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              constraint_id,
              constraint,
              ):
        """
        Create tenant constraint if not exists, otherwise update the existing
        constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :type  constraint: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :param constraint: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'constraint_id': constraint_id,
                            'constraint': constraint,
                            })

    def update(self,
               constraint_id,
               constraint,
               ):
        """
        Create tenant constraint if it does not exist, otherwise replace the
        existing constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :type  constraint: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :param constraint: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :return: com.vmware.nsx_policy.model.Constraint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'constraint_id': constraint_id,
                            'constraint': constraint,
                            })
class ContextProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.context_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ContextProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               context_profile_id,
               force=None,
               override=None,
               ):
        """
        Deletes the specified Policy Context Profile. If the Policy Context
        Profile is consumed in a firewall rule, it won't get deleted.

        :type  context_profile_id: :class:`str`
        :param context_profile_id: Policy Context Profile Id (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :type  override: :class:`bool` or ``None``
        :param override: Delete the locally overriden global object (optional, default to
            false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'context_profile_id': context_profile_id,
                            'force': force,
                            'override': override,
                            })

    def get(self,
            context_profile_id,
            ):
        """
        Get a single PolicyContextProfile by id

        :type  context_profile_id: :class:`str`
        :param context_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :return: com.vmware.nsx_policy.model.PolicyContextProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'context_profile_id': context_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get all PolicyContextProfiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyContextProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              context_profile_id,
              policy_context_profile,
              override=None,
              ):
        """
        Creates/Updates a PolicyContextProfile, which encapsulates attribute
        and sub-attributes of network services. Rules for using attributes and
        sub-attributes in single PolicyContextProfile 1. One type of attribute
        can't have multiple occurrences. ( Eg. - Attribute type APP_ID can be
        used only once per PolicyContextProfile.) 2. For specifying multiple
        values for an attribute, provide them in an array. 3. If sub-attribtes
        are mentioned for an attribute, then only single value is allowed for
        that attribute. 4. To get a list of supported attributes and
        sub-attributes fire the following REST API GET
        https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5.
        Do not create context profile with \"custom_attributes\" id

        :type  context_profile_id: :class:`str`
        :param context_profile_id: (required)
        :type  policy_context_profile: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :param policy_context_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'context_profile_id': context_profile_id,
                            'policy_context_profile': policy_context_profile,
                            'override': override,
                            })

    def update(self,
               context_profile_id,
               policy_context_profile,
               override=None,
               ):
        """
        Creates/Updates a PolicyContextProfile, which encapsulates attribute
        and sub-attributes of network services. Rules for using attributes and
        sub-attributes in single PolicyContextProfile 1. One type of attribute
        can't have multiple occurrences. ( Eg. - Attribute type APP_ID can be
        used only once per PolicyContextProfile.) 2. For specifying multiple
        values for an attribute, provide them in an array. 3. If sub-attribtes
        are mentioned for an attribute, then only single value is allowed for
        that attribute. 4. To get a list of supported attributes and
        sub-attributes fire the following REST API GET
        https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5.
        Do not create context profile with \"custom_attributes\" id

        :type  context_profile_id: :class:`str`
        :param context_profile_id: (required)
        :type  policy_context_profile: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :param policy_context_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :return: com.vmware.nsx_policy.model.PolicyContextProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'context_profile_id': context_profile_id,
                            'policy_context_profile': policy_context_profile,
                            'override': override,
                            })
class Crls(VapiInterface):
    """
    
    """
    LIST_TYPE_CLUSTER_API_CERTIFICATE = "cluster_api_certificate"
    """
    Possible value for ``type`` of method :func:`Crls.list`.

    """
    LIST_TYPE_API_CERTIFICATE = "api_certificate"
    """
    Possible value for ``type`` of method :func:`Crls.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.crls'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CrlsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               crl_id,
               ):
        """
        Deletes an existing CRL.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'crl_id': crl_id,
                            })

    def get(self,
            crl_id,
            details=None,
            ):
        """
        Returns information about the specified CRL. For additional
        information, include the ?details=true modifier at the end of the
        request URI.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :return: com.vmware.nsx_policy.model.TlsCrl
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'crl_id': crl_id,
                            'details': details,
                            })

    def importcrl(self,
                  crl_id,
                  tls_crl,
                  ):
        """
        Adds a new certificate revocation list (CRLs). The CRL is used to
        verify the client certificate status against the revocation lists
        published by the CA. For this reason, the administrator needs to add
        the CRL in certificate repository as well. A CRL can be in the PEM
        X.509 format (crl_type=X509) or JSON OneCRL (crl_type=OneCRL). If
        crl_type is not specified, it is auto-detected based on the presence of
        fields pem_encoded or one_crl. An X.509 CRL can contain a single CRL or
        multiple CRLs depending on the PEM data. - Single CRL: a single CRL is
        created with the given id. - Composite CRL: multiple CRLs are
        generated. Each of the CRL is created with an id generated based on the
        given id. First CRL is created with crl-id, second with crl-id-1, third
        with crl-id-2, etc.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  tls_crl: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :param tls_crl: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrlListResult`
        :return: com.vmware.nsx_policy.model.TlsCrlListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('importcrl',
                            {
                            'crl_id': crl_id,
                            'tls_crl': tls_crl,
                            })

    def list(self,
             cursor=None,
             details=None,
             included_fields=None,
             node_id=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Returns information about all CRLs. For additional information, include
        the ?details=true modifier at the end of the request URI.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of certificate to return (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type of certificate to return (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrlListResult`
        :return: com.vmware.nsx_policy.model.TlsCrlListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'details': details,
                            'included_fields': included_fields,
                            'node_id': node_id,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def patch(self,
              crl_id,
              tls_crl,
              ):
        """
        Create or patch a Certificate Revocation List for the given id. The CRL
        is used to verify the client certificate status against the revocation
        lists published by the CA. For this reason, the administrator needs to
        add the CRL in certificate repository as well. The CRL must contain PEM
        data for a single CRL. A CRL can be in the PEM X.509 format
        (crl_type=X509) or JSON OneCRL (crl_type=OneCRL). If crl_type is not
        specified, it is auto-detected based on the presence of fields
        pem_encoded or one_crl.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  tls_crl: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :param tls_crl: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'crl_id': crl_id,
                            'tls_crl': tls_crl,
                            })

    def update(self,
               crl_id,
               tls_crl,
               ):
        """
        Create or replace a Certificate Revocation List for the given id. The
        CRL is used to verify the client certificate status against the
        revocation lists published by the CA. For this reason, the
        administrator needs to add the CRL in certificate repository as well.
        The CRL must contain PEM data for a single CRL. Revision is required. A
        CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
        (crl_type=OneCRL). If crl_type is not specified, it is auto-detected
        based on the presence of fields pem_encoded or one_crl.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  tls_crl: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :param tls_crl: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :return: com.vmware.nsx_policy.model.TlsCrl
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'crl_id': crl_id,
                            'tls_crl': tls_crl,
                            })
class Csrs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.csrs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CsrsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               csr_id,
               tls_csr,
               ):
        """
        Creates a new certificate signing request (CSR). A CSR is encrypted
        text that contains information about your organization (organization
        name, country, and so on) and your Web server's public key, which is a
        public certificate the is generated on the server that can be used to
        forward this request to a certificate authority (CA). A private key is
        also usually created at the same time as the CSR.

        :type  csr_id: :class:`str`
        :param csr_id: ID of CSR to create (required)
        :type  tls_csr: :class:`com.vmware.nsx_policy.model_client.TlsCsr`
        :param tls_csr: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCsr`
        :return: com.vmware.nsx_policy.model.TlsCsr
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'csr_id': csr_id,
                            'tls_csr': tls_csr,
                            })

    def delete(self,
               csr_id,
               ):
        """
        Removes a specified CSR. If a CSR is not used for verification, you can
        delete it. Note that the CSR import and upload POST actions
        automatically delete the associated CSR.

        :type  csr_id: :class:`str`
        :param csr_id: ID of CSR to delete (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'csr_id': csr_id,
                            })

    def get(self,
            csr_id,
            ):
        """
        Returns information about the specified CSR.

        :type  csr_id: :class:`str`
        :param csr_id: ID of CSR to read (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCsr`
        :return: com.vmware.nsx_policy.model.TlsCsr
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'csr_id': csr_id,
                            })

    def importcsr(self,
                  csr_id,
                  tls_trust_data,
                  ):
        """
        Imports a certificate authority (CA)-signed certificate for a CSR. This
        action links the certificate to the private key created by the CSR. The
        pem_encoded string in the request body is the signed certificate
        provided by your CA in response to the CSR that you provide to them.
        The import POST action automatically deletes the associated CSR.

        :type  csr_id: :class:`str`
        :param csr_id: CSR this certificate is associated with (required)
        :type  tls_trust_data: :class:`com.vmware.nsx_policy.model_client.TlsTrustData`
        :param tls_trust_data: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('importcsr',
                            {
                            'csr_id': csr_id,
                            'tls_trust_data': tls_trust_data,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Returns information about all of the CSRs that have been created.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCsrListResult`
        :return: com.vmware.nsx_policy.model.TlsCsrListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def selfsign(self,
                 csr_id,
                 days_valid,
                 ):
        """
        Self-signs the previously generated CSR. This action is similar to the
        import certificate action, but instead of using a public certificate
        signed by a CA, the self_sign POST action uses a certificate that is
        signed with NSX's own private key. For validity of non-CA certificates,
        if a value greater than 825 days is provided, it will be set to 825
        days. No limit is set for CA certificates.

        :type  csr_id: :class:`str`
        :param csr_id: CSR this certificate is associated with (required)
        :type  days_valid: :class:`long`
        :param days_valid: Number of days the certificate will be valid, default 825 days
            (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('selfsign',
                            {
                            'csr_id': csr_id,
                            'days_valid': days_valid,
                            })

    def selfsign_0(self,
                   tls_csr_with_days_valid,
                   ):
        """
        Creates a new self-signed certificate. A private key is also created at
        the same time. This is convenience call that will generate a CSR and
        then self-sign it. For validity of non-CA certificates, if a value
        greater than 825 days is provided, it will be set to 825 days. No limit
        is set for CA certificates.

        :type  tls_csr_with_days_valid: :class:`com.vmware.nsx_policy.model_client.TlsCsrWithDaysValid`
        :param tls_csr_with_days_valid: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('selfsign_0',
                            {
                            'tls_csr_with_days_valid': tls_csr_with_days_valid,
                            })
class DeploymentZones(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.deployment_zones'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DeploymentZonesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            deployment_zone_id,
            ):
        """
        Read a Deployment Zone. 
        This is a deprecated API. DeploymentZone has been renamed to Site. Use
        GET /infra/sites/site-id.

        .. deprecated:: unknown

        :type  deployment_zone_id: :class:`str`
        :param deployment_zone_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DeploymentZone`
        :return: com.vmware.nsx_policy.model.DeploymentZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.DeploymentZones.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'deployment_zone_id': deployment_zone_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Deployment zones for infra. 
        This is a deprecated API. DeploymentZone has been renamed to Site. Use
        GET /infra/sites.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DeploymentZoneListResult`
        :return: com.vmware.nsx_policy.model.DeploymentZoneListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.DeploymentZones.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class DhcpRelayConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dhcp_relay_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DhcpRelayConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dhcp_relay_config_id,
               ):
        """
        Delete DHCP relay configuration

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            })

    def get(self,
            dhcp_relay_config_id,
            ):
        """
        Read DHCP relay configuration

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :return: com.vmware.nsx_policy.model.DhcpRelayConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all DHCP relay config instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfigListResult`
        :return: com.vmware.nsx_policy.model.DhcpRelayConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dhcp_relay_config_id,
              dhcp_relay_config,
              ):
        """
        If DHCP relay config with the dhcp-relay-config-id is not already
        present, create a new DHCP relay config instance. If it already exists,
        update the DHCP relay config instance with specified attributes.

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :type  dhcp_relay_config: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :param dhcp_relay_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            'dhcp_relay_config': dhcp_relay_config,
                            })

    def update(self,
               dhcp_relay_config_id,
               dhcp_relay_config,
               ):
        """
        If DHCP relay config with the dhcp-relay-config-id is not already
        present, create a new DHCP relay config instance. If it already exists,
        replace the DHCP relay config instance with this object.

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :type  dhcp_relay_config: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :param dhcp_relay_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :return: com.vmware.nsx_policy.model.DhcpRelayConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            'dhcp_relay_config': dhcp_relay_config,
                            })
class DhcpServerConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dhcp_server_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DhcpServerConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dhcp_server_config_id,
               ):
        """
        Delete DHCP server configuration

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            })

    def get(self,
            dhcp_server_config_id,
            ):
        """
        Read DHCP server configuration

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :return: com.vmware.nsx_policy.model.DhcpServerConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all DHCP server config instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfigListResult`
        :return: com.vmware.nsx_policy.model.DhcpServerConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dhcp_server_config_id,
              dhcp_server_config,
              ):
        """
        If DHCP server config with the dhcp-server-config-id is not already
        present, create a new DHCP server config instance. If it already
        exists, update the DHCP server config instance with specified
        attributes. Realized entities of this API can be found using the path
        of Tier-0, Tier1, or Segment where this config is applied on.
        Modification of edge_cluster_path in DhcpServerConfig will lose all
        existing DHCP leases. If both the preferred_edge_paths in the
        DhcpServerConfig are changed in a same PATCH API, e.g. change from
        [a,b] to [x,y], the current DHCP server leases will be lost, which
        could cause network connectivity issues. It is recommended to change
        only one member index in an update call, e.g. from [a, b] to [a,y].
        Clearing preferred_edge_paths will not reassign edge nodes from the
        edge cluster. Instead, the previously-allocated edge nodes will be
        retained to avoid loss of leases.

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :type  dhcp_server_config: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :param dhcp_server_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            'dhcp_server_config': dhcp_server_config,
                            })

    def update(self,
               dhcp_server_config_id,
               dhcp_server_config,
               ):
        """
        If DHCP server config with the dhcp-server-config-id is not already
        present, create a new DHCP server config instance. If it already
        exists, replace the DHCP server config instance with this object.
        Realized entities of this API can be found using the path of Tier-0,
        Tier1, or Segment where this config is applied on. Modification of
        edge_cluster_path in DhcpServerConfig will lose all existing DHCP
        leases. If both the preferred_edge_paths in the DhcpServerConfig are
        changed in a same PUT API, e.g. change from [a,b] to [x,y], the current
        DHCP server leases will be lost, which could cause network connectivity
        issues. It is recommended to change only one member index in an update
        call, e.g. from [a, b] to [a,y]. Clearing preferred_edge_paths will not
        reassign edge nodes from the edge cluster. Instead, the
        previously-allocated edge nodes will be retained to avoid loss of
        leases.

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :type  dhcp_server_config: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :param dhcp_server_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :return: com.vmware.nsx_policy.model.DhcpServerConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            'dhcp_server_config': dhcp_server_config,
                            })
class DnsForwarderZones(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dns_forwarder_zones'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DnsForwarderZonesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dns_forwarder_zone_id,
               ):
        """
        Delete the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            })

    def get(self,
            dns_forwarder_zone_id,
            ):
        """
        Read the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :return: com.vmware.nsx_policy.model.PolicyDnsForwarderZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Dns Forwarder Zones

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZoneListResult`
        :return: com.vmware.nsx_policy.model.PolicyDnsForwarderZoneListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dns_forwarder_zone_id,
              policy_dns_forwarder_zone,
              ):
        """
        Create or update the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :type  policy_dns_forwarder_zone: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :param policy_dns_forwarder_zone: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            'policy_dns_forwarder_zone': policy_dns_forwarder_zone,
                            })

    def update(self,
               dns_forwarder_zone_id,
               policy_dns_forwarder_zone,
               ):
        """
        Create or update the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :type  policy_dns_forwarder_zone: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :param policy_dns_forwarder_zone: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :return: com.vmware.nsx_policy.model.PolicyDnsForwarderZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            'policy_dns_forwarder_zone': policy_dns_forwarder_zone,
                            })
class DnsSecurityProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dns_security_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DnsSecurityProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               profile_id,
               override=None,
               ):
        """
        Delete DNS security profile

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'profile_id': profile_id,
                            'override': override,
                            })

    def get(self,
            profile_id,
            ):
        """
        Read the DNS Forwarder for the given tier-0 instance

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :return: com.vmware.nsx_policy.model.DnsSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'profile_id': profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all DNS security profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfileListResult`
        :return: com.vmware.nsx_policy.model.DnsSecurityProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              profile_id,
              dns_security_profile,
              override=None,
              ):
        """
        Create or update DNS security profile

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :type  dns_security_profile: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :param dns_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'profile_id': profile_id,
                            'dns_security_profile': dns_security_profile,
                            'override': override,
                            })

    def update(self,
               profile_id,
               dns_security_profile,
               override=None,
               ):
        """
        Create or update DNS security profile

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :type  dns_security_profile: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :param dns_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :return: com.vmware.nsx_policy.model.DnsSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'profile_id': profile_id,
                            'dns_security_profile': dns_security_profile,
                            'override': override,
                            })
class Domains(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.domains'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DomainsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               domain_id,
               ):
        """
        Delete the domain along with all the entities contained by this domain.
        The groups that are a part of this domain are also deleted along with
        the domain.

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'domain_id': domain_id,
                            })

    def get(self,
            domain_id,
            ):
        """
        Read a domain.

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Domain`
        :return: com.vmware.nsx_policy.model.Domain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'domain_id': domain_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all domains for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DomainListResult`
        :return: com.vmware.nsx_policy.model.DomainListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              domain_id,
              domain,
              ):
        """
        If a domain with the domain-id is not already present, create a new
        domain. If it already exists, patch the domain

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :type  domain: :class:`com.vmware.nsx_policy.model_client.Domain`
        :param domain: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'domain_id': domain_id,
                            'domain': domain,
                            })

    def update(self,
               domain_id,
               domain,
               ):
        """
        If a domain with the domain-id is not already present, create a new
        domain. If it already exists, update the domain including the nested
        groups. This is a full replace

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :type  domain: :class:`com.vmware.nsx_policy.model_client.Domain`
        :param domain: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Domain`
        :return: com.vmware.nsx_policy.model.Domain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'domain_id': domain_id,
                            'domain': domain,
                            })
class Drafts(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.drafts'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DraftsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               draft_id,
               ):
        """
        Delete a manual draft.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'draft_id': draft_id,
                            })

    def get(self,
            draft_id,
            ):
        """
        Read a draft for a given draft identifier.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :return: com.vmware.nsx_policy.model.PolicyDraft
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'draft_id': draft_id,
                            })

    def list(self,
             auto_drafts=None,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List policy drafts.

        :type  auto_drafts: :class:`bool` or ``None``
        :param auto_drafts: Fetch list of draft based on is_auto_draft flag (optional)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDraftListResult`
        :return: com.vmware.nsx_policy.model.PolicyDraftListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'auto_drafts': auto_drafts,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              draft_id,
              policy_draft,
              ):
        """
        Create a new manual draft if the specified draft id does not correspond
        to an existing draft. Update the manual draft otherwise. Auto draft can
        not be updated.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :type  policy_draft: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :param policy_draft: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'draft_id': draft_id,
                            'policy_draft': policy_draft,
                            })

    def publish(self,
                draft_id,
                infra,
                ):
        """
        Read a draft and publish it by applying changes onto current
        configuration. If there are additional changes on top of draft
        configuration, pass it as a request body, in form of Infra object.
        Otherwise, if there are no additional changes, then pass empty Infra
        object as a request body.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :type  infra: :class:`com.vmware.nsx_policy.model_client.Infra`
        :param infra: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('publish',
                            {
                            'draft_id': draft_id,
                            'infra': infra,
                            })

    def update(self,
               draft_id,
               policy_draft,
               ):
        """
        Create a new manual draft if the specified draft id does not correspond
        to an existing draft. Update the manual draft otherwise. Auto draft can
        not be updated.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :type  policy_draft: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :param policy_draft: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :return: com.vmware.nsx_policy.model.PolicyDraft
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'draft_id': draft_id,
                            'policy_draft': policy_draft,
                            })
class EvpnTenantConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.evpn_tenant_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EvpnTenantConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               config_id,
               ):
        """
        Delete evpn tunnel endpoint configuration.

        :type  config_id: :class:`str`
        :param config_id: tier0 id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'config_id': config_id,
                            })

    def get(self,
            config_id,
            ):
        """
        Read Evpn Tenant Configuration.

        :type  config_id: :class:`str`
        :param config_id: config id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :return: com.vmware.nsx_policy.model.EvpnTenantConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'config_id': config_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all evpn tunnel endpoint configuration.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfigListResult`
        :return: com.vmware.nsx_policy.model.EvpnTenantConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              config_id,
              evpn_tenant_config,
              ):
        """
        Create a global evpn tenant configuration if it is not already present,
        otherwise update the evpn tenant configuration.

        :type  config_id: :class:`str`
        :param config_id: Evpn Tenant config id (required)
        :type  evpn_tenant_config: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :param evpn_tenant_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'config_id': config_id,
                            'evpn_tenant_config': evpn_tenant_config,
                            })

    def update(self,
               config_id,
               evpn_tenant_config,
               ):
        """
        Create or update Evpn Tenant configuration.

        :type  config_id: :class:`str`
        :param config_id: Evpn Tenant config id (required)
        :type  evpn_tenant_config: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :param evpn_tenant_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :return: com.vmware.nsx_policy.model.EvpnTenantConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'config_id': config_id,
                            'evpn_tenant_config': evpn_tenant_config,
                            })
class FederationConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.federation_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FederationConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read a federation config from Global Manager.


        :rtype: :class:`com.vmware.nsx_policy.model_client.FederationConfig`
        :return: com.vmware.nsx_policy.model.FederationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)
class FirewallIdentityStoreLdapServer(VapiInterface):
    """
    
    """
    CREATE_ACTION_CONNECTIVITY = "CONNECTIVITY"
    """
    Possible value for ``action`` of method
    :func:`FirewallIdentityStoreLdapServer.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_store_ldap_server'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoreLdapServerStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               directory_ldap_server,
               action,
               enforcement_point_path=None,
               ):
        """
        This API tests a LDAP server connectivity before the actual domain or
        LDAP server is configured. If the connectivity is good, the response
        will be HTTP status 200. Otherwise the response will be HTTP status 500
        and corresponding error message will be returned.

        :type  directory_ldap_server: :class:`com.vmware.nsx_policy.model_client.DirectoryLdapServer`
        :param directory_ldap_server: (required)
        :type  action: :class:`str`
        :param action: LDAP server test requested (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryLdapServerStatus`
        :return: com.vmware.nsx_policy.model.DirectoryLdapServerStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'directory_ldap_server': directory_ldap_server,
                            'action': action,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIdentityStoreSize(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_store_size'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoreSizeStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               directory_domain,
               enforcement_point_path=None,
               ):
        """
        This call scans the size of a directory domain. It may be very |
        expensive to run this call in some AD domain deployments. Please | use
        it with caution.

        :type  directory_domain: :class:`vmware.vapi.struct.VapiStruct`
        :param directory_domain: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryDomainSize`
        :return: com.vmware.nsx_policy.model.DirectoryDomainSize
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'directory_domain': directory_domain,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIdentityStores(VapiInterface):
    """
    
    """
    CREATE_ACTION_FULL_SYNC = "FULL_SYNC"
    """
    Possible value for ``action`` of method :func:`FirewallIdentityStores.create`.

    """
    CREATE_ACTION_DELTA_SYNC = "DELTA_SYNC"
    """
    Possible value for ``action`` of method :func:`FirewallIdentityStores.create`.

    """
    CREATE_ACTION_STOP_SYNC = "STOP_SYNC"
    """
    Possible value for ``action`` of method :func:`FirewallIdentityStores.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_stores'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoresStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               firewall_identity_store_id,
               action,
               delay=None,
               enforcement_point_path=None,
               ):
        """
        Invoke full sync or delta sync for a specific domain, with additional
        delay in seconds if needed. Stop sync will try to stop any pending sync
        if any to return to idle state.

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: Firewall identity store identifier (required)
        :type  action: :class:`str`
        :param action: Sync type requested (required)
        :type  delay: :class:`long` or ``None``
        :param delay: Request to execute the sync with some delay in seconds (optional,
            default to 0)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'action': action,
                            'delay': delay,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def delete(self,
               firewall_identity_store_id,
               enforcement_point_path=None,
               ):
        """
        If the firewall identity store is removed, it will stop the identity
        store synchronization. User will not be able to define new IDFW rules

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            firewall_identity_store_id,
            enforcement_point_path=None,
            ):
        """
        Return a firewall identity store based on the store identifier

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.DirectoryDomain
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def list(self,
             cursor=None,
             enforcement_point_path=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all firewall identity stores

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryDomainListResults`
        :return: com.vmware.nsx_policy.model.DirectoryDomainListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              firewall_identity_store_id,
              directory_domain,
              enforcement_point_path=None,
              ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, update the firewall identity store with specified attributes.

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  directory_domain: :class:`vmware.vapi.struct.VapiStruct`
        :param directory_domain: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'directory_domain': directory_domain,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               firewall_identity_store_id,
               directory_domain,
               enforcement_point_path=None,
               ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, replace the firewall identity store instance with the new
        object.

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  directory_domain: :class:`vmware.vapi.struct.VapiStruct`
        :param directory_domain: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.DirectoryDomain
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'directory_domain': directory_domain,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIdentityStoresOrgUnits(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_stores_org_units'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoresOrgUnitsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               directory_ldap_server,
               enforcement_point_path=None,
               ):
        """
        Fetch all organization units for a LDAP server.

        :type  directory_ldap_server: :class:`com.vmware.nsx_policy.model_client.DirectoryLdapServer`
        :param directory_ldap_server: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryOrgUnitListResults`
        :return: com.vmware.nsx_policy.model.DirectoryOrgUnitListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'directory_ldap_server': directory_ldap_server,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIpReputationFeed(VapiInterface):
    """
    
    """
    CREATE_OPERATION_ENABLE_AUTO_DOWNLOAD = "enable_auto_download"
    """
    Possible value for ``operation`` of method
    :func:`FirewallIpReputationFeed.create`.

    """
    CREATE_OPERATION_DISABLE_AUTO_DOWNLOAD = "disable_auto_download"
    """
    Possible value for ``operation`` of method
    :func:`FirewallIpReputationFeed.create`.

    """
    CREATE_OPERATION_DOWNLOAD = "download"
    """
    Possible value for ``operation`` of method
    :func:`FirewallIpReputationFeed.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_ip_reputation_feed'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIpReputationFeedStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               operation,
               ):
        """
        This API can be used to enable or disable auto-download of IP
        reputation feed, it can also be used to trigger download of IP
        reputation feed when required. Once auto-download is enabled, IP
        reputation feed will be downloaded at regular intervals of 720 mins(12
        hrs). Auto-download of IP reputation feed can be enabled using the
        action 'enable_auto_download', to disable use action
        'disable_auto_download' and to trigger a download use action
        'download'.

        :type  operation: :class:`str`
        :param operation: action (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallIpReputationConfig`
        :return: com.vmware.nsx_policy.model.PolicyFirewallIpReputationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'operation': operation,
                            })

    def get(self):
        """
        API to retrieve the current IP Reputation feed configuration.


        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallIpReputationConfig`
        :return: com.vmware.nsx_policy.model.PolicyFirewallIpReputationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)
class FirewallSchedulers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_schedulers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallSchedulersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               firewall_scheduler_id,
               force=None,
               ):
        """
        Deletes the specified PolicyFirewallScheduler. If scheduler is consumed
        in a security policy, it won't get deleted.

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            'force': force,
                            })

    def get(self,
            firewall_scheduler_id,
            ):
        """
        Get a PolicyFirewallScheduler by id

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :return: com.vmware.nsx_policy.model.PolicyFirewallScheduler
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get all PolicyFirewallSchedulers

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSchedulerListResult`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSchedulerListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              firewall_scheduler_id,
              policy_firewall_scheduler,
              ):
        """
        Creates/Updates a PolicyFirewallScheduler, which can be set at security
        policy. Note that at least one property out of \"days\",
        \"start_date\", \"time_interval\", \"end_date\" is required if
        \"recurring\" field is true. Also \"start_time\" and \"end_time\"
        should not be present. And if \"recurring\" field is false then
        \"start_date\" and \"end_date\" is mandatory, \"start_time\" and
        \"end_time\" is optional. Also the fields \"days\" and
        \"time_interval\" should not be present.

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :type  policy_firewall_scheduler: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :param policy_firewall_scheduler: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            'policy_firewall_scheduler': policy_firewall_scheduler,
                            })

    def update(self,
               firewall_scheduler_id,
               policy_firewall_scheduler,
               ):
        """
        Updates a PolicyFirewallScheduler, which can be set at security policy.
        Note that at least one property out of \"days\", \"start_date\",
        \"time_interval\", \"end_date\" is required if \"recurring\" field is
        true. Also \"start_time\" and \"end_time\" should not be present. And
        if \"recurring\" field is false then \"start_date\" and \"end_date\" is
        mandatory, \"start_time\" and \"end_time\" is optional. Also the fields
        \"days\" and \"time_interval\" should not be present.

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :type  policy_firewall_scheduler: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :param policy_firewall_scheduler: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :return: com.vmware.nsx_policy.model.PolicyFirewallScheduler
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            'policy_firewall_scheduler': policy_firewall_scheduler,
                            })
class FirewallSessionTimerProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_session_timer_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallSessionTimerProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               firewall_session_timer_profile_id,
               override=None,
               ):
        """
        API will delete Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            'override': override,
                            })

    def get(self,
            firewall_session_timer_profile_id,
            ):
        """
        API will get Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSessionTimerProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Firewall Session Timer Profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSessionTimerProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              firewall_session_timer_profile_id,
              policy_firewall_session_timer_profile,
              override=None,
              ):
        """
        API will create/update Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :type  policy_firewall_session_timer_profile: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :param policy_firewall_session_timer_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            'policy_firewall_session_timer_profile': policy_firewall_session_timer_profile,
                            'override': override,
                            })

    def update(self,
               firewall_session_timer_profile_id,
               policy_firewall_session_timer_profile,
               override=None,
               ):
        """
        API will update Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :type  policy_firewall_session_timer_profile: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :param policy_firewall_session_timer_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSessionTimerProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            'policy_firewall_session_timer_profile': policy_firewall_session_timer_profile,
                            'override': override,
                            })
class FloodProtectionProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.flood_protection_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FloodProtectionProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               flood_protection_profile_id,
               override=None,
               ):
        """
        API will delete Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Flood Protection Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            'override': override,
                            })

    def get(self,
            flood_protection_profile_id,
            ):
        """
        API will get Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Flood Protection Profile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.FloodProtectionProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Flood Protection Profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfileListResult`
        :return: com.vmware.nsx_policy.model.FloodProtectionProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              flood_protection_profile_id,
              flood_protection_profile,
              override=None,
              ):
        """
        API will create/update Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Firewall Flood Protection Profile ID (required)
        :type  flood_protection_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param flood_protection_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            'flood_protection_profile': flood_protection_profile,
                            'override': override,
                            })

    def update(self,
               flood_protection_profile_id,
               flood_protection_profile,
               override=None,
               ):
        """
        API will update Firewall Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Flood Protection Profile ID (required)
        :type  flood_protection_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param flood_protection_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.FloodProtectionProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            'flood_protection_profile': flood_protection_profile,
                            'override': override,
                            })
class FullSyncAction(VapiInterface):
    """
    
    """
    CREATE_ACTION_REQUEST_FULL_SYNC = "request_full_sync"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_ACTION_REQUEST_NOTIFICATIONS_FULL_SYNC = "request_notifications_full_sync"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_ACTION_ABORT_CURRENT_SYNC = "abort_current_sync"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_ACTION_PURGE_HISTORY = "purge_history"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_SYNC_TYPE_SYNC = "gm_to_lm_full_sync"
    """
    Possible value for ``syncType`` of method :func:`FullSyncAction.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.full_sync_action'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FullSyncActionStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               action,
               sync_type=None,
               ):
        """
        Performs realized object actions specified in the action.

        :type  action: :class:`str`
        :param action: (required)
        :type  sync_type: :class:`str` or ``None``
        :param sync_type: Type of full sync being requested (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'action': action,
                            'sync_type': sync_type,
                            })
class FullSyncStates(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.full_sync_states'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FullSyncStatesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            full_sync_id,
            ):
        """
        Get full sync state.

        :type  full_sync_id: :class:`str`
        :param full_sync_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.FullSyncState`
        :return: com.vmware.nsx_policy.model.FullSyncState
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'full_sync_id': full_sync_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List full sync state.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.FullSyncStateListResult`
        :return: com.vmware.nsx_policy.model.FullSyncStateListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class GatewayQosProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.gateway_qos_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GatewayQosProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               qos_profile_id,
               override=None,
               ):
        """
        Delete QoS profile

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'qos_profile_id': qos_profile_id,
                            'override': override,
                            })

    def get(self,
            qos_profile_id,
            ):
        """
        Read gateway QoS profile

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :return: com.vmware.nsx_policy.model.GatewayQosProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'qos_profile_id': qos_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all gateway QoS profle instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfileListResult`
        :return: com.vmware.nsx_policy.model.GatewayQosProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              qos_profile_id,
              gateway_qos_profile,
              override=None,
              ):
        """
        If profile with the qos-profile-id is not already present, create a new
        gateway QoS profile instance. If it already exists, update the gateway
        QoS profile instance with specified attributes.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :type  gateway_qos_profile: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :param gateway_qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'qos_profile_id': qos_profile_id,
                            'gateway_qos_profile': gateway_qos_profile,
                            'override': override,
                            })

    def update(self,
               qos_profile_id,
               gateway_qos_profile,
               override=None,
               ):
        """
        If profile with the qos-profile-id is not already present, create a new
        gateway QoS profile instance. If it already exists, replace the gateway
        QoS profile instance with this object.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :type  gateway_qos_profile: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :param gateway_qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :return: com.vmware.nsx_policy.model.GatewayQosProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'qos_profile_id': qos_profile_id,
                            'gateway_qos_profile': gateway_qos_profile,
                            'override': override,
                            })
class GlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        This rest routine is deprecated. Use /infra/connectivity-global-config
        for Connectivity global config and /infra/ops-global-config for
        Operations global config. Read global configuration.


        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def patch(self,
              global_config,
              ):
        """
        Update the global configuration. 
        This rest routine is deprecated. Use /infra/connectivity-global-config
        for Connectivity global config and /infra/ops-global-config for
        Operations global config.

        .. deprecated:: unknown

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.GlobalConfig.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'global_config': global_config,
                            })

    def update(self,
               global_config,
               ):
        """
        This rest routine is deprecated. Use /infra/connectivity-global-config
        for Connectivity global config and /infra/ops-global-config for
        Operations global config. Update the global configuration.

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'global_config': global_config,
                            })
class GroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             intent_path,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given object is a member. In Federation
        environment, if the given object is a global entity (eg: global
        segment) and if the entity is not stretched to the site specified in
        the enforcement_point_path parameter,then the following is returned:-
        1)If the entity is a member of any global group and that group is
        stretched to the enforcement_point_path site,then the API returns an
        empty list. 2)If the entity is not a member of any global group,this
        API returns an 'invalid path' error message. 3)If both the entity and
        its corresponding groups are stretched to the enforcement_point_path
        site , then the API returns the groups list.

        :type  intent_path: :class:`str`
        :param intent_path: String path of the intent object (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'intent_path': intent_path,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class GroupServiceAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.group_service_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GroupServiceAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             intent_path,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        The API returns all the services associated with the given Group. It
        also returns the services associated with the parent groups of the
        given group.

        :type  intent_path: :class:`str`
        :param intent_path: Path of the entity (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'intent_path': intent_path,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class HostSwitchProfiles(VapiInterface):
    """
    
    """
    LIST_DEPLOYMENT_TYPE_VIRTUAL_MACHINE = "VIRTUAL_MACHINE"
    """
    Possible value for ``deploymentType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_DEPLOYMENT_TYPE_PHYSICAL_MACHINE = "PHYSICAL_MACHINE"
    """
    Possible value for ``deploymentType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_DEPLOYMENT_TYPE_UNKNOWN = "UNKNOWN"
    """
    Possible value for ``deploymentType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYUPLINKHOSTSWITCHPROFILE = "PolicyUplinkHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYLLDPHOSTSWITCHPROFILE = "PolicyLldpHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYNIOCPROFILE = "PolicyNiocProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYEXTRACONFIGHOSTSWITCHPROFILE = "PolicyExtraConfigHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYVTEPHAHOSTSWITCHPROFILE = "PolicyVtepHAHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_NODE_TYPE_EDGENODE = "EdgeNode"
    """
    Possible value for ``nodeType`` of method :func:`HostSwitchProfiles.list`.

    """
    LIST_NODE_TYPE_PUBLICCLOUDGATEWAYNODE = "PublicCloudGatewayNode"
    """
    Possible value for ``nodeType`` of method :func:`HostSwitchProfiles.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.host_switch_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostSwitchProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               host_switch_profile_id,
               ):
        """
        Deletes a specified hostswitch profile.

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            })

    def get(self,
            host_switch_profile_id,
            ):
        """
        Returns information about a specified hostswitch profile.

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.PolicyBaseHostSwitchProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            })

    def list(self,
             cursor=None,
             deployment_type=None,
             hostswitch_profile_type=None,
             include_mark_for_delete_objects=None,
             include_system_owned=None,
             included_fields=None,
             max_active_uplink_count=None,
             node_type=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             uplink_teaming_policy_name=None,
             ):
        """
        Returns information about the configured hostswitch profiles.
        Hostswitch profiles define networking policies for hostswitches
        (sometimes referred to as bridges in OVS). Currently, following
        profiles are supported. UplinkHostSwitchProfile, LldpHostSwitchProfile,
        NiocProfile & ExtraConfigHostSwitchProfile. Uplink profile - teaming
        defined in this profile allows NSX to load balance traffic across
        different physical NICs (PNICs) on the hypervisor hosts. Multiple
        teaming policies are supported, including LACP active, LACP passive,
        load balancing based on source ID, and failover order. Lldp profile -
        Enable or disable sending LLDP packets NiocProfile - Network I/O
        Control settings: defines limits, shares and reservations for various
        host traffic types. ExtraConfig - Vendor specific configuration on
        HostSwitch, logical switch or logical port

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  deployment_type: :class:`str` or ``None``
        :param deployment_type: Supported edge deployment type. (optional)
        :type  hostswitch_profile_type: :class:`str` or ``None``
        :param hostswitch_profile_type: Supported HostSwitch profiles. (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  include_system_owned: :class:`bool` or ``None``
        :param include_system_owned: Whether the list result contains system resources (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  max_active_uplink_count: :class:`long` or ``None``
        :param max_active_uplink_count: Filter uplink profiles by number of active links in teaming policy.
            (optional)
        :type  node_type: :class:`str` or ``None``
        :param node_type: Fabric node type for which uplink profiles are to be listed
            (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  uplink_teaming_policy_name: :class:`str` or ``None``
        :param uplink_teaming_policy_name: The host switch profile's uplink teaming policy name (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostSwitchProfilesListResult`
        :return: com.vmware.nsx_policy.model.PolicyHostSwitchProfilesListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'deployment_type': deployment_type,
                            'hostswitch_profile_type': hostswitch_profile_type,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'include_system_owned': include_system_owned,
                            'included_fields': included_fields,
                            'max_active_uplink_count': max_active_uplink_count,
                            'node_type': node_type,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'uplink_teaming_policy_name': uplink_teaming_policy_name,
                            })

    def patch(self,
              host_switch_profile_id,
              policy_base_host_switch_profile,
              ):
        """
        Patch a hostswitch profile. The resource_type is required and needs to
        be one of the following, UplinkHostSwitchProfile,
        LldpHostSwitchProfile, NiocProfile & ExtraConfigHostSwitchProfile.
        Uplink profile - For uplink profiles, the teaming and policy parameters
        are required. By default, the mtu is 1600 and the transport_vlan is 0.
        The supported MTU range is 1280 through (uplink_mtu_threshold).
        uplink_mtu_threshold is 9000 by default. Range can be extended by
        modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
        required upper threshold. Teaming defined in this profile allows NSX to
        load balance traffic across different physical NICs (PNICs) on the
        hypervisor hosts. Multiple teaming policies are supported, including
        LACP active, LACP passive, load balancing based on source ID, and
        failover order. Lldp profile - Enable or disable sending LLDP packets
        NiocProfile - Network I/O Control settings: defines limits, shares and
        reservations for various host traffic types. ExtraConfig - Vendor
        specific configuration on HostSwitch, logical switch or logical port

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :type  policy_base_host_switch_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param policy_base_host_switch_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.PolicyBaseHostSwitchProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            'policy_base_host_switch_profile': policy_base_host_switch_profile,
                            })

    def update(self,
               host_switch_profile_id,
               policy_base_host_switch_profile,
               ):
        """
        Create or update a hostswitch profile. The resource_type is required
        and needs to be one of the following, UplinkHostSwitchProfile,
        LldpHostSwitchProfile, NiocProfile & ExtraConfigHostSwitchProfile.
        Uplink profile - For uplink profiles, the teaming and policy parameters
        are required. By default, the mtu is 1600 and the transport_vlan is 0.
        The supported MTU range is 1280 through (uplink_mtu_threshold).
        uplink_mtu_threshold is 9000 by default. Range can be extended by
        modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
        required upper threshold. Teaming defined in this profile allows NSX to
        load balance traffic across different physical NICs (PNICs) on the
        hypervisor hosts. Multiple teaming policies are supported, including
        LACP active, LACP passive, load balancing based on source ID, and
        failover order. Lldp profile - Enable or disable sending LLDP packets
        NiocProfile - Network I/O Control settings: defines limits, shares and
        reservations for various host traffic types. ExtraConfig - Vendor
        specific configuration on HostSwitch, logical switch or logical port

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :type  policy_base_host_switch_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param policy_base_host_switch_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.PolicyBaseHostSwitchProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            'policy_base_host_switch_profile': policy_base_host_switch_profile,
                            })
class HostTransportNodeProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.host_transport_node_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostTransportNodeProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               transport_node_profile_id,
               ):
        """
        Deletes the specified host transport node profile. A host transport
        node profile can be deleted only when it is not attached to any compute
        collection.

        :type  transport_node_profile_id: :class:`str`
        :param transport_node_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'transport_node_profile_id': transport_node_profile_id,
                            })

    def get(self,
            host_transport_node_profile_id,
            ):
        """
        Returns information about a specified host transport node profile.

        :type  host_transport_node_profile_id: :class:`str`
        :param host_transport_node_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfile`
        :return: com.vmware.nsx_policy.model.PolicyHostTransportNodeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'host_transport_node_profile_id': host_transport_node_profile_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Returns information about all host transport node profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyHostTransportNodeProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def update(self,
               transport_node_profile_id,
               policy_host_transport_node_profile,
               override_nsx_ownership=None,
               ):
        """
        Host transport node profile captures the configuration needed to create
        a host transport node. A host transport node profile can be attached to
        compute collections for automatic host transport node creation of
        member hosts. When configurations of a host transport node profile(TNP)
        are updated, all the host transport nodes in all the compute
        collections to which this TNP is attached are updated to reflect the
        updated configuration.

        :type  transport_node_profile_id: :class:`str`
        :param transport_node_profile_id: (required)
        :type  policy_host_transport_node_profile: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfile`
        :param policy_host_transport_node_profile: (required)
        :type  override_nsx_ownership: :class:`bool` or ``None``
        :param override_nsx_ownership: Override NSX Ownership (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfile`
        :return: com.vmware.nsx_policy.model.PolicyHostTransportNodeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'transport_node_profile_id': transport_node_profile_id,
                            'policy_host_transport_node_profile': policy_host_transport_node_profile,
                            'override_nsx_ownership': override_nsx_ownership,
                            })
class IdentityFirewallStores(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_firewall_stores'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IdentityFirewallStoresStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               identity_firewall_store_id,
               enforcement_point_path=None,
               ):
        """
        If the firewall identity store is removed, it will stop the identity
        store synchronization. User will not be able to define new IDFW rules

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: firewall identity store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            identity_firewall_store_id,
            enforcement_point_path=None,
            ):
        """
        Return a firewall identity store based on the store identifier

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: identity firewall store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStore
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def list(self,
             cursor=None,
             enforcement_point_path=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all firewall identity stores

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreListResults`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              identity_firewall_store_id,
              identity_firewall_store,
              enforcement_point_path=None,
              ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, update the firewall identity store with specified attributes.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: firewall identity store ID (required)
        :type  identity_firewall_store: :class:`vmware.vapi.struct.VapiStruct`
        :param identity_firewall_store: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'identity_firewall_store': identity_firewall_store,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               identity_firewall_store_id,
               identity_firewall_store,
               enforcement_point_path=None,
               ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, replace the firewall identity store instance with the new
        object.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: firewall identity store ID (required)
        :type  identity_firewall_store: :class:`vmware.vapi.struct.VapiStruct`
        :param identity_firewall_store: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStore
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'identity_firewall_store': identity_firewall_store,
                            'enforcement_point_path': enforcement_point_path,
                            })
class IdentityGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IdentityGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             identity_group_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given Identity Group is a member.

        :type  identity_group_external_id: :class:`str`
        :param identity_group_external_id: Identity Group external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'identity_group_external_id': identity_group_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class IgmpProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.igmp_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IgmpProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               igmp_profile_id,
               ):
        """
        Delete Igmp Profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            })

    def get(self,
            igmp_profile_id,
            ):
        """
        Read Igmp Profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :return: com.vmware.nsx_policy.model.PolicyIgmpProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all igmp profile.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyIgmpProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              igmp_profile_id,
              policy_igmp_profile,
              ):
        """
        Create a igmp profile with the igmp-profile-id is not already present,
        otherwise update the igmp profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :type  policy_igmp_profile: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :param policy_igmp_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            'policy_igmp_profile': policy_igmp_profile,
                            })

    def update(self,
               igmp_profile_id,
               policy_igmp_profile,
               ):
        """
        Create or update igmp profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :type  policy_igmp_profile: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :param policy_igmp_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :return: com.vmware.nsx_policy.model.PolicyIgmpProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            'policy_igmp_profile': policy_igmp_profile,
                            })
class IpAddressGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_address_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpAddressGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             ip_address,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given IP address is a member.

        :type  ip_address: :class:`str`
        :param ip_address: IPAddress (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'ip_address': ip_address,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class IpBlocks(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_blocks'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpBlocksStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ip_block_id,
               ):
        """
        Delete the IpAddressBlock with the given id.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ip_block_id': ip_block_id,
                            })

    def get(self,
            ip_block_id,
            ):
        """
        Read IpAddressBlock with given Id.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :return: com.vmware.nsx_policy.model.IpAddressBlock
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ip_block_id': ip_block_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of IpAddressBlocks.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressBlockListResult`
        :return: com.vmware.nsx_policy.model.IpAddressBlockListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ip_block_id,
              ip_address_block,
              ):
        """
        Creates a new IpAddressBlock with specified ID if not already present.
        If IpAddressBlock of given ID is already present, then the instance is
        updated with specified attributes.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :type  ip_address_block: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :param ip_address_block: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ip_block_id': ip_block_id,
                            'ip_address_block': ip_address_block,
                            })

    def update(self,
               ip_block_id,
               ip_address_block,
               ):
        """
        Create a new IpAddressBlock with given ID if it does not exist. If
        IpAddressBlock with given ID already exists, it will update existing
        instance. This is a full replace.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :type  ip_address_block: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :param ip_address_block: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :return: com.vmware.nsx_policy.model.IpAddressBlock
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ip_block_id': ip_block_id,
                            'ip_address_block': ip_address_block,
                            })
class IpDiscoveryProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_discovery_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpDiscoveryProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ip_discovery_profile_id,
               override=None,
               ):
        """
        API will delete IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            'override': override,
                            })

    def get(self,
            ip_discovery_profile_id,
            ):
        """
        API will get IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.IPDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all IP Discovery Profiles active in current discovery
        profile id.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfileListResult`
        :return: com.vmware.nsx_policy.model.IPDiscoveryProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ip_discovery_profile_id,
              ip_discovery_profile,
              override=None,
              ):
        """
        API will create IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :type  ip_discovery_profile: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :param ip_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            'ip_discovery_profile': ip_discovery_profile,
                            'override': override,
                            })

    def update(self,
               ip_discovery_profile_id,
               ip_discovery_profile,
               override=None,
               ):
        """
        API will update IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :type  ip_discovery_profile: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :param ip_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.IPDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            'ip_discovery_profile': ip_discovery_profile,
                            'override': override,
                            })
class IpPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ip_pool_id,
               ):
        """
        Delete the IpAddressPool with the given id.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ip_pool_id': ip_pool_id,
                            })

    def get(self,
            ip_pool_id,
            ):
        """
        Read IpAddressPool with given Id.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ip_pool_id': ip_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of IpAddressPools.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPoolListResult`
        :return: com.vmware.nsx_policy.model.IpAddressPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ip_pool_id,
              ip_address_pool,
              ):
        """
        Creates a new IpAddressPool with specified ID if not already present.
        If IpAddressPool of given ID is already present, then the instance is
        updated. This is a full replace.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :type  ip_address_pool: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :param ip_address_pool: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ip_pool_id': ip_pool_id,
                            'ip_address_pool': ip_address_pool,
                            })

    def update(self,
               ip_pool_id,
               ip_address_pool,
               ):
        """
        Create a new IpAddressPool with given ID if it does not exist. If
        IpAddressPool with given ID already exists, it will update existing
        instance. This is a full replace.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :type  ip_address_pool: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :param ip_address_pool: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ip_pool_id': ip_pool_id,
                            'ip_address_pool': ip_address_pool,
                            })
class IpfixDfwCollectorProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_dfw_collector_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixDfwCollectorProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_dfw_collector_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX dfw collector profile. Flow forwarding to collector
        will be stopped.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: IPFIX dfw collector Profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_dfw_collector_profile_id,
            ):
        """
        API will return details of IPFIX dfw collector profile. If profile does
        not exist, it will return 404.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: IPFIX dfw collector profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWCollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will provide list of all IPFIX dfw collector profiles and their
        details.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXDFWCollectorProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_dfw_collector_profile_id,
              i_pfixdfw_collector_profile,
              override=None,
              ):
        """
        Create a new IPFIX dfw collector profile if the IPFIX dfw collector
        profile with given id does not already exist. If the IPFIX dfw
        collector profile with the given id already exists, patch with the
        existing IPFIX dfw collector profile.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: (required)
        :type  i_pfixdfw_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :param i_pfixdfw_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            'i_pfixdfw_collector_profile': i_pfixdfw_collector_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_dfw_collector_profile_id,
               i_pfixdfw_collector_profile,
               override=None,
               ):
        """
        Create or Replace IPFIX dfw collector profile. IPFIX data will be sent
        to IPFIX collector port.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: IPFIX dfw collector profile id (required)
        :type  i_pfixdfw_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :param i_pfixdfw_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWCollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            'i_pfixdfw_collector_profile': i_pfixdfw_collector_profile,
                            'override': override,
                            })
class IpfixDfwProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_dfw_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixDfwProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_dfw_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX DFW Profile. Selected IPFIX Collectors will stop
        receiving flows.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_dfw_profile_id,
            ):
        """
        API will return details of IPFIX DFW profile.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW collection id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API provides list IPFIX DFW profiles available on selected logical DFW.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXDFWProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_dfw_profile_id,
              i_pfixdfw_profile,
              override=None,
              ):
        """
        Create a new IPFIX DFW profile if the IPFIX DFW profile with given id
        does not already exist. If the IPFIX DFW profile with the given id
        already exists, patch with the existing IPFIX DFW profile.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW Profile ID (required)
        :type  i_pfixdfw_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :param i_pfixdfw_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            'i_pfixdfw_profile': i_pfixdfw_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_dfw_profile_id,
               i_pfixdfw_profile,
               override=None,
               ):
        """
        Create or replace IPFIX DFW profile. Config will start forwarding data
        to provided IPFIX DFW collector.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW Profile ID (required)
        :type  i_pfixdfw_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :param i_pfixdfw_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            'i_pfixdfw_profile': i_pfixdfw_profile,
                            'override': override,
                            })
class IpfixL2CollectorProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_l2_collector_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixL2CollectorProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_l2_collector_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX collector profile. Flow forwarding to collector will
        be stopped.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector Profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_l2_collector_profile_id,
            ):
        """
        API will return details of IPFIX collector profile.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXL2CollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will provide list of all IPFIX collector profiles and their
        details.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXL2CollectorProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_l2_collector_profile_id,
              i_pfix_l2_collector_profile,
              override=None,
              ):
        """
        Create a new IPFIX collector profile if the IPFIX collector profile
        with given id does not already exist. If the IPFIX collector profile
        with the given id already exists, patch with the existing IPFIX
        collector profile.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector profile id (required)
        :type  i_pfix_l2_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :param i_pfix_l2_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            'i_pfix_l2_collector_profile': i_pfix_l2_collector_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_l2_collector_profile_id,
               i_pfix_l2_collector_profile,
               override=None,
               ):
        """
        Create or Replace IPFIX collector profile. IPFIX data will be sent to
        IPFIX collector.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector profile id (required)
        :type  i_pfix_l2_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :param i_pfix_l2_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXL2CollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            'i_pfix_l2_collector_profile': i_pfix_l2_collector_profile,
                            'override': override,
                            })
class IpfixL2Profiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_l2_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixL2ProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_l2_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX L2 Profile. Flow forwarding to selected collector
        will be stopped.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_l2_profile_id,
            ):
        """
        API will return details of IPFIX L2 profile.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :return: com.vmware.nsx_policy.model.IPFIXL2Profile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API provides list IPFIX L2 Profiles available on selected logical l2.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2ProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXL2ProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_l2_profile_id,
              i_pfix_l2_profile,
              override=None,
              ):
        """
        Create a new IPFIX L2 profile if the IPFIX L2 profile with given id
        does not already exist. If the IPFIX L2 profile with the given id
        already exists, patch with the existing IPFIX L2 profile.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 Profile ID (required)
        :type  i_pfix_l2_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :param i_pfix_l2_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            'i_pfix_l2_profile': i_pfix_l2_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_l2_profile_id,
               i_pfix_l2_profile,
               override=None,
               ):
        """
        Create or replace IPFIX L2 Profile. Profile is reusable entity. Single
        profile can attached multiple bindings e.g group, segment and port.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 Profile ID (required)
        :type  i_pfix_l2_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :param i_pfix_l2_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :return: com.vmware.nsx_policy.model.IPFIXL2Profile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            'i_pfix_l2_profile': i_pfix_l2_profile,
                            'override': override,
                            })
class IpsecVpnDpdProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipsec_vpn_dpd_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpsecVpnDpdProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dpd_profile_id,
               ):
        """
        Delete custom dead peer detection (DPD) profile. Profile can not be
        deleted if profile has references to it.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            })

    def get(self,
            dpd_profile_id,
            ):
        """
        Get custom dead peer detection (DPD) profile, given the particular id.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnDpdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all DPD Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfileListResult`
        :return: com.vmware.nsx_policy.model.IPSecVpnDpdProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dpd_profile_id,
              ip_sec_vpn_dpd_profile,
              ):
        """
        Create or patch dead peer detection (DPD) profile. Any change in
        profile affects all sessions consuming this profile. System will be
        provisioned with system owned editable default DPD profile. Any change
        in profile affects all sessions consuming this profile.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :type  ip_sec_vpn_dpd_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :param ip_sec_vpn_dpd_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            'ip_sec_vpn_dpd_profile': ip_sec_vpn_dpd_profile,
                            })

    def update(self,
               dpd_profile_id,
               ip_sec_vpn_dpd_profile,
               ):
        """
        Create or patch dead peer detection (DPD) profile. Any change in
        profile affects all sessions consuming this profile. System will be
        provisioned with system owned editable default DPD profile. Any change
        in profile affects all sessions consuming this profile. Revision is
        optional for creation and required for update.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :type  ip_sec_vpn_dpd_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :param ip_sec_vpn_dpd_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnDpdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            'ip_sec_vpn_dpd_profile': ip_sec_vpn_dpd_profile,
                            })
class IpsecVpnIkeProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipsec_vpn_ike_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpsecVpnIkeProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ike_profile_id,
               ):
        """
        Delete custom IKE Profile. Profile can not be deleted if profile has
        references to it.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ike_profile_id': ike_profile_id,
                            })

    def get(self,
            ike_profile_id,
            ):
        """
        Get custom IKE Profile, given the particular id.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnIkeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ike_profile_id': ike_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all IKE Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfileListResult`
        :return: com.vmware.nsx_policy.model.IPSecVpnIkeProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ike_profile_id,
              ip_sec_vpn_ike_profile,
              ):
        """
        Create or patch custom internet key exchange (IKE) Profile. IKE Profile
        is a reusable profile that captures IKE and phase one negotiation
        parameters. System will be pre provisioned with system owned editable
        default IKE profile and suggested set of profiles that can be used for
        peering with popular remote peers like AWS VPN. User can create custom
        profiles as needed. Any change in profile affects all sessions
        consuming this profile.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :type  ip_sec_vpn_ike_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :param ip_sec_vpn_ike_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ike_profile_id': ike_profile_id,
                            'ip_sec_vpn_ike_profile': ip_sec_vpn_ike_profile,
                            })

    def update(self,
               ike_profile_id,
               ip_sec_vpn_ike_profile,
               ):
        """
        Create or fully replace custom internet key exchange (IKE) Profile. IKE
        Profile is a reusable profile that captures IKE and phase one
        negotiation parameters. System will be pre provisioned with system
        owned editable default IKE profile and suggested set of profiles that
        can be used for peering with popular remote peers like AWS VPN. User
        can create custom profiles as needed. Any change in profile affects all
        sessions consuming this profile. Revision is optional for creation and
        required for update.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :type  ip_sec_vpn_ike_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :param ip_sec_vpn_ike_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnIkeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ike_profile_id': ike_profile_id,
                            'ip_sec_vpn_ike_profile': ip_sec_vpn_ike_profile,
                            })
class IpsecVpnTunnelProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipsec_vpn_tunnel_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpsecVpnTunnelProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               tunnel_profile_id,
               ):
        """
        Delete custom IPSec tunnel Profile. Profile can not be deleted if
        profile has references to it.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            })

    def get(self,
            tunnel_profile_id,
            ):
        """
        Get custom IPSec tunnel Profile, given the particular id.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnTunnelProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all IPSec tunnel Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfileListResult`
        :return: com.vmware.nsx_policy.model.IPSecVpnTunnelProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              tunnel_profile_id,
              ip_sec_vpn_tunnel_profile,
              ):
        """
        Create or patch custom IPSec tunnel profile. IPSec tunnel profile is a
        reusable profile that captures phase two negotiation parameters and
        tunnel properties. System will be provisioned with system owned
        editable default IPSec tunnel profile. Any change in profile affects
        all sessions consuming this profile.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :type  ip_sec_vpn_tunnel_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :param ip_sec_vpn_tunnel_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            'ip_sec_vpn_tunnel_profile': ip_sec_vpn_tunnel_profile,
                            })

    def update(self,
               tunnel_profile_id,
               ip_sec_vpn_tunnel_profile,
               ):
        """
        Create or fully replace custom IPSec tunnel profile. IPSec tunnel
        profile is a reusable profile that captures phase two negotiation
        parameters and tunnel properties. System will be provisioned with
        system owned editable default IPSec tunnel profile. Any change in
        profile affects all sessions consuming this profile. Revision is
        optional for creation and required for update.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :type  ip_sec_vpn_tunnel_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :param ip_sec_vpn_tunnel_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnTunnelProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            'ip_sec_vpn_tunnel_profile': ip_sec_vpn_tunnel_profile,
                            })
class Ipv6DadProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipv6_dad_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _Ipv6DadProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dad_profile_id,
               override=None,
               ):
        """
        Delete IPv6 DAD profile

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'dad_profile_id': dad_profile_id,
                            'override': override,
                            })

    def get(self,
            dad_profile_id,
            ):
        """
        Read IPv6 DAD profile

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :return: com.vmware.nsx_policy.model.Ipv6DadProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'dad_profile_id': dad_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all IPv6 DAD profile instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfileListResult`
        :return: com.vmware.nsx_policy.model.Ipv6DadProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dad_profile_id,
              ipv6_dad_profile,
              override=None,
              ):
        """
        If profile with the dad-profile-id is not already present, create a new
        IPv6 DAD profile instance. If it already exists, update the IPv6 DAD
        profile instance with specified attributes.

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :type  ipv6_dad_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :param ipv6_dad_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'dad_profile_id': dad_profile_id,
                            'ipv6_dad_profile': ipv6_dad_profile,
                            'override': override,
                            })

    def update(self,
               dad_profile_id,
               ipv6_dad_profile,
               override=None,
               ):
        """
        If profile with the dad-profile-id is not already present, create a new
        IPv6 DAD profile instance. If it already exists, replace the IPv6 DAD
        profile instance with this object.

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :type  ipv6_dad_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :param ipv6_dad_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :return: com.vmware.nsx_policy.model.Ipv6DadProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'dad_profile_id': dad_profile_id,
                            'ipv6_dad_profile': ipv6_dad_profile,
                            'override': override,
                            })
class Ipv6NdraProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipv6_ndra_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _Ipv6NdraProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ndra_profile_id,
               override=None,
               ):
        """
        Delete IPv6 NDRA profile

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            'override': override,
                            })

    def get(self,
            ndra_profile_id,
            ):
        """
        Read IPv6 NDRA profile

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :return: com.vmware.nsx_policy.model.Ipv6NdraProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all IPv6 NDRA profile instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfileListResult`
        :return: com.vmware.nsx_policy.model.Ipv6NdraProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ndra_profile_id,
              ipv6_ndra_profile,
              override=None,
              ):
        """
        If profile with the ndra-profile-id is not already present, create a
        new IPv6 NDRA profile instance. If it already exists, update the IPv6
        NDRA profile instance with specified attributes.

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :type  ipv6_ndra_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :param ipv6_ndra_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            'ipv6_ndra_profile': ipv6_ndra_profile,
                            'override': override,
                            })

    def update(self,
               ndra_profile_id,
               ipv6_ndra_profile,
               override=None,
               ):
        """
        If profile with the ndra-profile-id is not already present, create a
        new IPv6 NDRA profile instance. If it already exists, replace the IPv6
        NDRA profile instance with this object.

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :type  ipv6_ndra_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :param ipv6_ndra_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :return: com.vmware.nsx_policy.model.Ipv6NdraProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            'ipv6_ndra_profile': ipv6_ndra_profile,
                            'override': override,
                            })
class L7AccessProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.l7_access_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _L7AccessProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               l7_access_profile_id,
               override=None,
               ):
        """
        API will delete L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            'override': override,
                            })

    def get(self,
            l7_access_profile_id,
            ):
        """
        API will get L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :return: com.vmware.nsx_policy.model.L7AccessProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            })

    def list(self,
             cursor=None,
             include_entry_count=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all l7 access Profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_entry_count: :class:`bool` or ``None``
        :param include_entry_count: Include the count of entries in L7 Profile (optional, default to
            false)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfileListResult`
        :return: com.vmware.nsx_policy.model.L7AccessProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_entry_count': include_entry_count,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              l7_access_profile_id,
              l7_access_profile,
              override=None,
              ):
        """
        API will create/update L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: L7 Access Profile ID (required)
        :type  l7_access_profile: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :param l7_access_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :return: com.vmware.nsx_policy.model.L7AccessProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            'l7_access_profile': l7_access_profile,
                            'override': override,
                            })

    def update(self,
               l7_access_profile_id,
               l7_access_profile,
               override=None,
               ):
        """
        API will update L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: (required)
        :type  l7_access_profile: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :param l7_access_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :return: com.vmware.nsx_policy.model.L7AccessProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            'l7_access_profile': l7_access_profile,
                            'override': override,
                            })
class Labels(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.labels'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LabelsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               label_id,
               ):
        """
        Delete PolicyLabel object

        :type  label_id: :class:`str`
        :param label_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'label_id': label_id,
                            })

    def get(self,
            label_id,
            ):
        """
        Read a label.

        :type  label_id: :class:`str`
        :param label_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :return: com.vmware.nsx_policy.model.PolicyLabel
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'label_id': label_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all labels for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLabelListResult`
        :return: com.vmware.nsx_policy.model.PolicyLabelListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              label_id,
              policy_label,
              ):
        """
        Create label if not exists, otherwise take the partial updates. Note,
        once the label is created type attribute can not be changed.

        :type  label_id: :class:`str`
        :param label_id: (required)
        :type  policy_label: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :param policy_label: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'label_id': label_id,
                            'policy_label': policy_label,
                            })

    def update(self,
               label_id,
               policy_label,
               ):
        """
        Create label if not exists, otherwise replaces the existing label. If
        label already exists then type attribute cannot be changed.

        :type  label_id: :class:`str`
        :param label_id: (required)
        :type  policy_label: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :param policy_label: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :return: com.vmware.nsx_policy.model.PolicyLabel
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'label_id': label_id,
                            'policy_label': policy_label,
                            })
class LatencyProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.latency_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LatencyProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               profile_id,
               ):
        """
        Delete an existing latency profile

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'profile_id': profile_id,
                            })

    def get(self,
            profile_id,
            ):
        """
        Read latency profile.

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'profile_id': profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List latency profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              profile_id,
              policy_latency_stat_profile,
              ):
        """
        Patch latency profile.

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :type  policy_latency_stat_profile: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :param policy_latency_stat_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'profile_id': profile_id,
                            'policy_latency_stat_profile': policy_latency_stat_profile,
                            })

    def update(self,
               profile_id,
               policy_latency_stat_profile,
               ):
        """
        Create or Replace latency profile.

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :type  policy_latency_stat_profile: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :param policy_latency_stat_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'profile_id': profile_id,
                            'policy_latency_stat_profile': policy_latency_stat_profile,
                            })
class LbAppProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_app_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbAppProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_app_profile_id,
               force=None,
               ):
        """
        Delete the LBAppProfile along with all the entities contained by this
        LBAppProfile. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_app_profile_id,
            ):
        """
        Read a LBAppProfile. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBAppProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBAppProfiles. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBAppProfileListResult`
        :return: com.vmware.nsx_policy.model.LBAppProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_app_profile_id,
              lb_app_profile,
              ):
        """
        If a LBAppProfile with the lb-app-profile-id is not already present,
        create a new LBAppProfile. If it already exists, update the
        LBAppProfile. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :type  lb_app_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_app_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            'lb_app_profile': lb_app_profile,
                            })

    def update(self,
               lb_app_profile_id,
               lb_app_profile,
               ):
        """
        If a LBAppProfile with the lb-app-profile-id is not already present,
        create a new LBAppProfile. If it already exists, update the
        LBAppProfile. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :type  lb_app_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_app_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBAppProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            'lb_app_profile': lb_app_profile,
                            })
class LbClientSslProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_client_ssl_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbClientSslProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_client_ssl_profile_id,
               force=None,
               ):
        """
        Delete the LBClientSslProfile along with all the entities contained by
        this LBClientSslProfile. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_client_ssl_profile_id,
            ):
        """
        Read a LBClientSslProfile. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :return: com.vmware.nsx_policy.model.LBClientSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBClientSslProfiles. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfileListResult`
        :return: com.vmware.nsx_policy.model.LBClientSslProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_client_ssl_profile_id,
              lb_client_ssl_profile,
              ):
        """
        If a LBClientSslProfile with the lb-client-ssl-profile-id is not
        already present, create a new LBClientSslProfile. If it already exists,
        update the LBClientSslProfile. This is a full replace. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :type  lb_client_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :param lb_client_ssl_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            'lb_client_ssl_profile': lb_client_ssl_profile,
                            })

    def update(self,
               lb_client_ssl_profile_id,
               lb_client_ssl_profile,
               ):
        """
        If a LBClientSslProfile with the lb-client-ssl-profile-id is not
        already present, create a new LBClientSslProfile. If it already exists,
        update the LBClientSslProfile. This is a full replace. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :type  lb_client_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :param lb_client_ssl_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :return: com.vmware.nsx_policy.model.LBClientSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            'lb_client_ssl_profile': lb_client_ssl_profile,
                            })
class LbMonitorProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_monitor_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbMonitorProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_monitor_profile_id,
               force=None,
               ):
        """
        Delete the LBMonitorProfile along with all the entities contained by
        this LBMonitorProfile. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_monitor_profile_id,
            ):
        """
        Read a LBMonitorProfile. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBMonitorProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBMonitorProfiles for infra. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBMonitorProfileListResult`
        :return: com.vmware.nsx_policy.model.LBMonitorProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_monitor_profile_id,
              lb_monitor_profile,
              ):
        """
        If a LBMonitorProfile with the lb-monitor-profile-id is not already
        present, create a new LBMonitorProfile. If it already exists, update
        the LBMonitorProfile. This is a full replace. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :type  lb_monitor_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_monitor_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            'lb_monitor_profile': lb_monitor_profile,
                            })

    def update(self,
               lb_monitor_profile_id,
               lb_monitor_profile,
               ):
        """
        If a LBMonitorProfile with the lb-monitor-profile-id is not already
        present, create a new LBMonitorProfile. If it already exists, update
        the LBMonitorProfile. This is a full replace. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :type  lb_monitor_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_monitor_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBMonitorProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            'lb_monitor_profile': lb_monitor_profile,
                            })
class LbNodeUsage(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_node_usage'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbNodeUsageStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            node_path,
            ):
        """
        API is used to retrieve node usage for load balancer which contains
        basic information, LB entity usages and capacities for the given node.
        Currently only edge node is supported. The parameter
        ?node_path=<node-path> is required. For example, ?node_path=
        /infra/sites/default/enforcement-points/default/edge-clusters/
        85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes/
        86e077c0-449f-11e9-87c8-02004eb37029. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  node_path: :class:`str`
        :param node_path: The node path for load balancer node usage (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBNodeUsage
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBNodeUsage`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbNodeUsage.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'node_path': node_path,
                            })
class LbNodeUsageSummary(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_node_usage_summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbNodeUsageSummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            enforcement_point_path=None,
            include_usages=None,
            ):
        """
        The API is used to retrieve the load balancer node usage summary of all
        nodes for every enforcement point. - If the parameter
        ?include_usages=true exists, the property node_usages are included in
        response. By default, the property node_usages is not included in
        response. - If parameter
        ?enforcement_point_path=<enforcement-point-path> exists, only node
        usage summary from specific enforcement point is included in response.
        If no enforcement point path is specified, information will be
        aggregated from each enforcement point. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: enforcement point path (optional)
        :type  include_usages: :class:`bool` or ``None``
        :param include_usages: Whether to include usages (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateLBNodeUsageSummary`
        :return: com.vmware.nsx_policy.model.AggregateLBNodeUsageSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbNodeUsageSummary.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'enforcement_point_path': enforcement_point_path,
                            'include_usages': include_usages,
                            })
class LbPersistenceProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_persistence_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbPersistenceProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_persistence_profile_id,
               force=None,
               ):
        """
        Delete the LBPersistenceProfile along with all the entities contained
        by this LBPersistenceProfile. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_persistence_profile_id,
            ):
        """
        Read a LBPersistenceProfile. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBPersistenceProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBPersistenceProfiles for infra. This API is
        deprecated for the NSX-T Load Balancer, but not for the NSX-T
        Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfileListResult`
        :return: com.vmware.nsx_policy.model.LBPersistenceProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_persistence_profile_id,
              lb_persistence_profile,
              ):
        """
        If a LBPersistenceProfile with the lb-persistence-profile-id is not
        already present, create a new LBPersistenceProfile. If it already
        exists, update the LBPersistenceProfile. This is a full replace. This
        API is deprecated for the NSX-T Load Balancer, but not for the NSX-T
        Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :type  lb_persistence_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_persistence_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            'lb_persistence_profile': lb_persistence_profile,
                            })

    def update(self,
               lb_persistence_profile_id,
               lb_persistence_profile,
               ):
        """
        If a LBPersistenceProfile with the lb-persistence-profile-id is not
        already present, create a new LBPersistenceProfile. If it already
        exists, update the LBPersistenceProfile. This is a full replace. This
        API is deprecated for the NSX-T Load Balancer, but not for the NSX-T
        Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :type  lb_persistence_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_persistence_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBPersistenceProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            'lb_persistence_profile': lb_persistence_profile,
                            })
class LbPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_pool_id,
               force=None,
               ):
        """
        Delete the LBPool along with all the entities contained by this LBPool.
        This API is deprecated for the NSX-T Load Balancer, but not for the
        NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_pool_id': lb_pool_id,
                            'force': force,
                            })

    def get(self,
            lb_pool_id,
            ):
        """
        Read a LBPool. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :return: com.vmware.nsx_policy.model.LBPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_pool_id': lb_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBPools. This API is deprecated for the NSX-T
        Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPoolListResult`
        :return: com.vmware.nsx_policy.model.LBPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_pool_id,
              lb_pool,
              ):
        """
        If a LBPool with the lb-pool-id is not already present, create a new
        LBPool. If it already exists, update the LBPool. This is a full
        replace. This API is deprecated for the NSX-T Load Balancer, but not
        for the NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :type  lb_pool: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :param lb_pool: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_pool_id': lb_pool_id,
                            'lb_pool': lb_pool,
                            })

    def update(self,
               lb_pool_id,
               lb_pool,
               ):
        """
        If a LBPool with the lb-pool-id is not already present, create a new
        LBPool. If it already exists, update the LBPool. This is a full
        replace. This API is deprecated for the NSX-T Load Balancer, but not
        for the NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :type  lb_pool: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :param lb_pool: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :return: com.vmware.nsx_policy.model.LBPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'lb_pool_id': lb_pool_id,
                            'lb_pool': lb_pool,
                            })
class LbServerSslProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_server_ssl_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbServerSslProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_server_ssl_profile_id,
               force=None,
               ):
        """
        Delete the LBServerSslProfile along with all the entities contained by
        this LBServerSslProfile. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_server_ssl_profile_id,
            ):
        """
        Read a LBServerSslProfile. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :return: com.vmware.nsx_policy.model.LBServerSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBServerSslProfiles. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfileListResult`
        :return: com.vmware.nsx_policy.model.LBServerSslProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_server_ssl_profile_id,
              lb_server_ssl_profile,
              ):
        """
        If a LBServerSslProfile with the lb-server-ssl-profile-id is not
        already present, create a new LBServerSslProfile. If it already exists,
        update the LBServerSslProfile. This is a full replace. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :type  lb_server_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :param lb_server_ssl_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            'lb_server_ssl_profile': lb_server_ssl_profile,
                            })

    def update(self,
               lb_server_ssl_profile_id,
               lb_server_ssl_profile,
               ):
        """
        If a LBServerSslProfile with the lb-server-ssl-profile-id is not
        already present, create a new LBServerSslProfile. If it already exists,
        update the LBServerSslProfile. This is a full replace. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :type  lb_server_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :param lb_server_ssl_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :return: com.vmware.nsx_policy.model.LBServerSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            'lb_server_ssl_profile': lb_server_ssl_profile,
                            })
class LbServiceUsageSummary(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_service_usage_summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbServiceUsageSummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            include_usages=None,
            ):
        """
        API is used to retrieve the load balancer usage summary for all load
        balancer services. If the parameter ?include_usages=true exists, the
        property service-usages is included in the response. By default,
        service-usages is not included in the response. This API is deprecated
        for the NSX-T Load Balancer, but not for the NSX-T Distributed Load
        Balancer.

        :type  include_usages: :class:`bool` or ``None``
        :param include_usages: Whether to include usages (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServiceUsageSummary`
        :return: com.vmware.nsx_policy.model.LBServiceUsageSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'include_usages': include_usages,
                            })
class LbServices(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_service_id,
               force=None,
               ):
        """
        Delete the LBService along with all the entities contained by this
        LBService. This API is deprecated for the NSX-T Load Balancer, but not
        for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_service_id': lb_service_id,
                            'force': force,
                            })

    def get(self,
            lb_service_id,
            ):
        """
        Read an LBService. This API is deprecated for the NSX-T Load Balancer,
        but not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBService`
        :return: com.vmware.nsx_policy.model.LBService
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_service_id': lb_service_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBService. This API is deprecated for the NSX-T
        Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServiceListResult`
        :return: com.vmware.nsx_policy.model.LBServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_service_id,
              lb_service,
              ):
        """
        If a LBService with the lb-service-id is not already present, create a
        new LBService. If it already exists, update the LBService. This is a
        full replace. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :type  lb_service: :class:`com.vmware.nsx_policy.model_client.LBService`
        :param lb_service: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_service_id': lb_service_id,
                            'lb_service': lb_service,
                            })

    def update(self,
               lb_service_id,
               lb_service,
               ):
        """
        If a LBService with the lb-service-id is not already present, create a
        new LBService. If it already exists, update the LBService. This is a
        full replace. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :type  lb_service: :class:`com.vmware.nsx_policy.model_client.LBService`
        :param lb_service: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBService`
        :return: com.vmware.nsx_policy.model.LBService
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'lb_service_id': lb_service_id,
                            'lb_service': lb_service,
                            })
class LbSslCiphersAndProtocols(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_ssl_ciphers_and_protocols'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbSslCiphersAndProtocolsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Retrieve a list of supported SSL ciphers and protocols. 
         
         NSX-T Load Balancer is deprecated. 
         Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LbSslCipherAndProtocolListResult`
        :return: com.vmware.nsx_policy.model.LbSslCipherAndProtocolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbSslCiphersAndProtocols.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class LbVirtualServers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_virtual_servers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbVirtualServersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_virtual_server_id,
               force=None,
               ):
        """
        Delete the LBVirtualServer along with all the entities contained by
        this LBVirtualServer. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            'force': force,
                            })

    def get(self,
            lb_virtual_server_id,
            ):
        """
        Read a LBVirtualServer. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :return: com.vmware.nsx_policy.model.LBVirtualServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBVirtualServers. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBVirtualServerListResult`
        :return: com.vmware.nsx_policy.model.LBVirtualServerListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_virtual_server_id,
              lb_virtual_server,
              ):
        """
        If a LBVirtualServer with the lb-virtual-server-id is not already
        present, create a new LBVirtualServer. If it already exists, update the
        LBVirtualServer. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :type  lb_virtual_server: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :param lb_virtual_server: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            'lb_virtual_server': lb_virtual_server,
                            })

    def update(self,
               lb_virtual_server_id,
               lb_virtual_server,
               ):
        """
        If a LBVirtualServer with the lb-virtual-server-id is not already
        present, create a new LBVirtualServer. If it already exists, update the
        LBVirtualServer. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :type  lb_virtual_server: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :param lb_virtual_server: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :return: com.vmware.nsx_policy.model.LBVirtualServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            'lb_virtual_server': lb_virtual_server,
                            })
class Livetraces(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.livetraces'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LivetracesStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               livetrace_id,
               action=None,
               ):
        """
        Restart a livetrace session with the same set of parameters used in
        creating or updating of a livetrace config.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :type  action: :class:`str` or ``None``
        :param action: Action to be performed (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :return: com.vmware.nsx_policy.model.LiveTraceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'livetrace_id': livetrace_id,
                            'action': action,
                            })

    def delete(self,
               livetrace_id,
               ):
        """
        Delete livetrace config with the specified identifier.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'livetrace_id': livetrace_id,
                            })

    def get(self,
            livetrace_id,
            ):
        """
        Read livetrace config with the specified identifier.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :return: com.vmware.nsx_policy.model.LiveTraceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'livetrace_id': livetrace_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get a paginated list of all livetrace config entities.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfigListResult`
        :return: com.vmware.nsx_policy.model.LiveTraceConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              livetrace_id,
              live_trace_config,
              ):
        """
        If a livetrace config with the specified identifier is not present,
        then create a new livetrace config. If it already exists, update the
        livetrace config with a full replacement.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :type  live_trace_config: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :param live_trace_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'livetrace_id': livetrace_id,
                            'live_trace_config': live_trace_config,
                            })

    def update(self,
               livetrace_id,
               live_trace_config,
               ):
        """
        If a livetrace config with the specified identifier is not present,
        then create a new livetrace config. If it already exists, update the
        livetrace config with a full replacement.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :type  live_trace_config: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :param live_trace_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :return: com.vmware.nsx_policy.model.LiveTraceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'livetrace_id': livetrace_id,
                            'live_trace_config': live_trace_config,
                            })
class MacDiscoveryProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.mac_discovery_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _MacDiscoveryProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               mac_discovery_profile_id,
               override=None,
               ):
        """
        API will delete Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            'override': override,
                            })

    def get(self,
            mac_discovery_profile_id,
            ):
        """
        API will get Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.MacDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Mac Discovery Profiles active in current discovery
        profile id.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfileListResult`
        :return: com.vmware.nsx_policy.model.MacDiscoveryProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              mac_discovery_profile_id,
              mac_discovery_profile,
              override=None,
              ):
        """
        API will create Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :type  mac_discovery_profile: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :param mac_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            'mac_discovery_profile': mac_discovery_profile,
                            'override': override,
                            })

    def update(self,
               mac_discovery_profile_id,
               mac_discovery_profile,
               override=None,
               ):
        """
        API will update Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :type  mac_discovery_profile: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :param mac_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.MacDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            'mac_discovery_profile': mac_discovery_profile,
                            'override': override,
                            })
class ManagerIpPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.manager_ip_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ManagerIpPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            manager_ip_pool_id,
            ):
        """
        Read Manager Ip Pool with given Id.

        :type  manager_ip_pool_id: :class:`str`
        :param manager_ip_pool_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'manager_ip_pool_id': manager_ip_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of Manager Ip Pools.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPoolListResult`
        :return: com.vmware.nsx_policy.model.IpAddressPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class MetadataProxies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.metadata_proxies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _MetadataProxiesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               metadata_proxy_id,
               ):
        """
        API will delete Metadata Proxy Config with ID profile-id

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            })

    def get(self,
            metadata_proxy_id,
            ):
        """
        API will read Metadata Proxy Config with ID profile-id

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :return: com.vmware.nsx_policy.model.MetadataProxyConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all L2 Metadata Proxy Configurations

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfigListResult`
        :return: com.vmware.nsx_policy.model.MetadataProxyConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              metadata_proxy_id,
              metadata_proxy_config,
              ):
        """
        API will create or update Metadata Proxy Config with ID profile-id.
        Maximum 10 Metadata Proxy Configurations are supported.

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :type  metadata_proxy_config: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :param metadata_proxy_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            'metadata_proxy_config': metadata_proxy_config,
                            })

    def update(self,
               metadata_proxy_id,
               metadata_proxy_config,
               ):
        """
        API will create or update Metadata Proxy Config with ID profile-id

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :type  metadata_proxy_config: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :param metadata_proxy_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :return: com.vmware.nsx_policy.model.MetadataProxyConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            'metadata_proxy_config': metadata_proxy_config,
                            })
class NvdsUrt(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _NvdsUrtStub)
        self._VAPI_OPERATION_IDS = {}


    def cleanup(self):
        """
        Clean up all nvds upgrade related configurations 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown


        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.NvdsUrt.cleanup is deprecated.', DeprecationWarning)
        return self._invoke('cleanup', None)

    def ignoremigratestatus(self):
        """
        Set the migrate status key of ExtraConfigProfile of all Transport Nodes
        to IGNORE 
         URT feature won't be supported

        .. deprecated:: unknown


        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.NvdsUrt.ignoremigratestatus is deprecated.', DeprecationWarning)
        return self._invoke('ignoremigratestatus', None)
class OpsGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ops_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _OpsGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read global Operations Configuration


        :rtype: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :return: com.vmware.nsx_policy.model.OpsGlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def patch(self,
              ops_global_config,
              ):
        """
        Update the global Operationconfiguration

        :type  ops_global_config: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :param ops_global_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'ops_global_config': ops_global_config,
                            })

    def update(self,
               ops_global_config,
               ):
        """
        Update the global Operations Configuration

        :type  ops_global_config: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :param ops_global_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :return: com.vmware.nsx_policy.model.OpsGlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'ops_global_config': ops_global_config,
                            })
class PartnerServices(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.partner_services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PartnerServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            service_name,
            ):
        """
        Read the specific partner service identified by provided name.

        :type  service_name: :class:`str`
        :param service_name: Name of the service (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceDefinition`
        :return: com.vmware.nsx_policy.model.ServiceDefinition
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'service_name': service_name,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Read all the partner services available for service insertion

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceInsertionServiceListResult`
        :return: com.vmware.nsx_policy.model.ServiceInsertionServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class PhysicalServerGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.physical_server_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PhysicalServerGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             physical_server_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given Physical Server is a member.

        :type  physical_server_external_id: :class:`str`
        :param physical_server_external_id: Physical external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'physical_server_external_id': physical_server_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class PimProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.pim_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PimProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               pim_profile_id,
               ):
        """
        Delete Pim Profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'pim_profile_id': pim_profile_id,
                            })

    def get(self,
            pim_profile_id,
            ):
        """
        Read Pim Profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :return: com.vmware.nsx_policy.model.PolicyPimProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'pim_profile_id': pim_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all pim profile.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyPimProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              pim_profile_id,
              policy_pim_profile,
              ):
        """
        Create a pim profile with the pim-profile-id is not already present,
        otherwise update the pim profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :type  policy_pim_profile: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :param policy_pim_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'pim_profile_id': pim_profile_id,
                            'policy_pim_profile': policy_pim_profile,
                            })

    def update(self,
               pim_profile_id,
               policy_pim_profile,
               ):
        """
        Create or update pim profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :type  policy_pim_profile: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :param policy_pim_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :return: com.vmware.nsx_policy.model.PolicyPimProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'pim_profile_id': pim_profile_id,
                            'policy_pim_profile': policy_pim_profile,
                            })
class PodGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.pod_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PodGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             pod_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given pod is a member.

        :type  pod_id: :class:`str`
        :param pod_id: ContainerApplicationInstance (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'pod_id': pod_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class PortMirroringProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.port_mirroring_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PortMirroringProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               port_mirroring_profile_id,
               override=None,
               ):
        """
        API will delete port mirroring profile. Mirroring from source to
        destination ports will be stopped.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profile Id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            'override': override,
                            })

    def get(self,
            port_mirroring_profile_id,
            ):
        """
        API will return details of port mirroring profile.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profile Id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :return: com.vmware.nsx_policy.model.PortMirroringProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all port mirroring profiles group.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfileListResult`
        :return: com.vmware.nsx_policy.model.PortMirroringProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              port_mirroring_profile_id,
              port_mirroring_profile,
              override=None,
              ):
        """
        Create a new Port Mirroring Profile if the Port Mirroring Profile with
        given id does not already exist. If the Port Mirroring Profile with the
        given id already exists, patch with the existing Port Mirroring
        Profile. Realized entities of this API can be found using the path of
        monitoring profile binding map that is used to apply this profile.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profile Id (required)
        :type  port_mirroring_profile: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :param port_mirroring_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            'port_mirroring_profile': port_mirroring_profile,
                            'override': override,
                            })

    def update(self,
               port_mirroring_profile_id,
               port_mirroring_profile,
               override=None,
               ):
        """
        Create or Replace port mirroring profile. Packets will be mirrored from
        source group, segment, port to destination group. Realized entities of
        this API can be found using the path of monitoring profile binding map
        that is used to apply this profile.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profiles Id (required)
        :type  port_mirroring_profile: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :param port_mirroring_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :return: com.vmware.nsx_policy.model.PortMirroringProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            'port_mirroring_profile': port_mirroring_profile,
                            'override': override,
                            })
class QosProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.qos_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _QosProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               qos_profile_id,
               override=None,
               ):
        """
        API will delete QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'qos_profile_id': qos_profile_id,
                            'override': override,
                            })

    def get(self,
            qos_profile_id,
            ):
        """
        API will return details of QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :return: com.vmware.nsx_policy.model.QoSProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'qos_profile_id': qos_profile_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all QoS profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QosProfileListResult`
        :return: com.vmware.nsx_policy.model.QoSProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              qos_profile_id,
              qos_profile,
              override=None,
              ):
        """
        Create a new QoS profile if the QoS profile with given id does not
        already exist. If the QoS profile with the given id already exists,
        patch with the existing QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :type  qos_profile: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :param qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'qos_profile_id': qos_profile_id,
                            'qos_profile': qos_profile,
                            'override': override,
                            })

    def update(self,
               qos_profile_id,
               qos_profile,
               override=None,
               ):
        """
        Create or Replace QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :type  qos_profile: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :param qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :return: com.vmware.nsx_policy.model.QoSProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'qos_profile_id': qos_profile_id,
                            'qos_profile': qos_profile,
                            'override': override,
                            })
class Reactions(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.reactions'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ReactionsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               reaction_id,
               ):
        """
        Delete a Reaction under Infra.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'reaction_id': reaction_id,
                            })

    def get(self,
            reaction_id,
            ):
        """
        Get Reaction under Infra.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :return: com.vmware.nsx_policy.model.Reaction
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'reaction_id': reaction_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all Reactions under Infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ReactionListResult`
        :return: com.vmware.nsx_policy.model.ReactionListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              reaction_id,
              reaction,
              ):
        """
        Create or patch a Reaction under Infra.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :type  reaction: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :param reaction: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'reaction_id': reaction_id,
                            'reaction': reaction,
                            })

    def update(self,
               reaction_id,
               reaction,
               ):
        """
        Create or fully replace a Reaction under Infra. Revision is optional
        for creation and required for update.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :type  reaction: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :param reaction: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :return: com.vmware.nsx_policy.model.Reaction
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'reaction_id': reaction_id,
                            'reaction': reaction,
                            })
class SandboxedResources(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sandboxed_resources'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SandboxedResourcesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             intent_path=None,
             site_path=None,
             ):
        """
        Get sandbox resources

        :type  intent_path: :class:`str` or ``None``
        :param intent_path: intent path (optional)
        :type  site_path: :class:`str` or ``None``
        :param site_path: site path (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SandboxedResourceListResult`
        :return: com.vmware.nsx_policy.model.SandboxedResourceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'intent_path': intent_path,
                            'site_path': site_path,
                            })
class SecurityGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.security_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SecurityGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        This reads the security-global-config used for NSX Manager appliance
        certificates. These properties are not sent to the hosts.


        :rtype: :class:`com.vmware.nsx_policy.model_client.InfraSecurityConfig`
        :return: com.vmware.nsx_policy.model.InfraSecurityConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def update(self,
               infra_security_config,
               ):
        """
        This updates the security-global-config used for NSX Manager appliance
        certificates. These properties are not sent to the hosts.

        :type  infra_security_config: :class:`com.vmware.nsx_policy.model_client.InfraSecurityConfig`
        :param infra_security_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.InfraSecurityConfig`
        :return: com.vmware.nsx_policy.model.InfraSecurityConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'infra_security_config': infra_security_config,
                            })
class SegmentSecurityProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.segment_security_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SegmentSecurityProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               segment_security_profile_id,
               override=None,
               ):
        """
        API will delete segment security profile with the given id.

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            'override': override,
                            })

    def get(self,
            segment_security_profile_id,
            ):
        """
        API will return details of the segment security profile with given id.
        If the profile does not exist, it will return 404.

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :return: com.vmware.nsx_policy.model.SegmentSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all segment security profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfileListResult`
        :return: com.vmware.nsx_policy.model.SegmentSecurityProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              segment_security_profile_id,
              segment_security_profile,
              override=None,
              ):
        """
        Create a new segment security profile if the segment security profile
        with given id does not exist. Otherwise, PATCH the existing segment
        security profile

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :type  segment_security_profile: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :param segment_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            'segment_security_profile': segment_security_profile,
                            'override': override,
                            })

    def update(self,
               segment_security_profile_id,
               segment_security_profile,
               override=None,
               ):
        """
        Create or replace a segment security profile

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :type  segment_security_profile: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :param segment_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :return: com.vmware.nsx_policy.model.SegmentSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            'segment_security_profile': segment_security_profile,
                            'override': override,
                            })
class Segments(VapiInterface):
    """
    
    """
    LIST_SEGMENT_TYPE_DVPORTGROUP = "DVPortgroup"
    """
    Possible value for ``segmentType`` of method :func:`Segments.list`.

    """
    LIST_SEGMENT_TYPE_ALL = "ALL"
    """
    Possible value for ``segmentType`` of method :func:`Segments.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.segments'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SegmentsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               segment_id,
               ):
        """
        Delete infra segment

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'segment_id': segment_id,
                            })

    def delete_0(self,
                 segment_id,
                 cascade=None,
                 ):
        """
        Force delete bypasses validations during segment deletion. This may
        result in an inconsistent connectivity.

        :type  segment_id: :class:`str`
        :param segment_id: (required)
        :type  cascade: :class:`bool` or ``None``
        :param cascade: Flag to specify whether to delete related segment ports (optional,
            default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete_0',
                            {
                            'segment_id': segment_id,
                            'cascade': cascade,
                            })

    def deletedhcpleases(self,
                         segment_id,
                         dhcp_delete_leases,
                         enforcement_point_path=None,
                         ):
        """
        Delete one or multiple DHCP lease(s) specified by IP and MAC. If there
        is a DHCP server running upon the given segment, or this segment is
        using a DHCP server running in its connected Tier-0 or Tier-1, the DHCP
        lease(s) which match exactly the IP address and the MAC address will be
        deleted. If no such lease matches, the deletion for this lease will be
        ignored. The DHCP lease to be deleted will be removed by the system
        from both active and standby node. The system will report error if the
        DHCP lease could not be removed from both nodes. If the DHCP lease
        could not be removed on either node, please check the DHCP server
        status. Once the DHCP server status is UP, please invoke the deletion
        API again to ensure the lease gets deleted from both nodes.

        :type  segment_id: :class:`str`
        :param segment_id: (required)
        :type  dhcp_delete_leases: :class:`com.vmware.nsx_policy.model_client.DhcpDeleteLeases`
        :param dhcp_delete_leases: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Enforcement point path (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('deletedhcpleases',
                            {
                            'segment_id': segment_id,
                            'dhcp_delete_leases': dhcp_delete_leases,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            segment_id,
            ):
        """
        Read infra segment Note: Extended Segment: Please note that old vpn
        path deprecated. If user specify old l2vpn path in the \"l2_extension\"
        object in the PATCH API payload, the path returned in the GET response
        payload may include the new path instead of the deprecated l2vpn path.
        Both old and new l2vpn path refer to same resource. there is no
        functional impact. Also note that l2vpn path included in the error
        messages returned from validation may include the new VPN path instead
        of the deprecated l2vpn path. Both new path and old vpn path refer to
        same resource.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Segment`
        :return: com.vmware.nsx_policy.model.Segment
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'segment_id': segment_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             segment_type=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all segments under infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  segment_type: :class:`str` or ``None``
        :param segment_type: Segment type (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentListResult`
        :return: com.vmware.nsx_policy.model.SegmentListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'segment_type': segment_type,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              segment_id,
              segment,
              ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, update the segment with specified
        attributes.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })

    def patch_0(self,
                segment_id,
                segment,
                ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, update the segment with specified
        attributes. Force parameter is required when workload connectivity is
        indirectly impacted with the current update.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch_0',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })

    def update(self,
               segment_id,
               segment,
               ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, replace the segment with this object.
        Note: Extended Segment: Please note that old vpn path deprecated. If
        user specify old l2vpn path in the \"l2_extension\" object in the PATCH
        API payload, the path returned in the GET response payload may include
        the new path instead of the deprecated l2vpn path. Both old and new
        l2vpn path refer to same resource. there is no functional impact. Also
        note that l2vpn path included in the Alarm, GPRR, error messages
        returned from validation may include the new VPN path instead of the
        deprecated l2vpn path. Both new path and old vpn path refer to same
        resource.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Segment`
        :return: com.vmware.nsx_policy.model.Segment
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })

    def update_0(self,
                 segment_id,
                 segment,
                 ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, replace the segment with this object.
        Force parameter is required when workload connectivity is indirectly
        impacted with the current replacement. Note: Extended Segment: Please
        note that old vpn path deprecated. If user specify old l2vpn path in
        the \"l2_extension\" object in the PATCH API payload, the path returned
        in the GET response payload may include the new path instead of the
        deprecated l2vpn path. Both old and new l2vpn path refer to same
        resource. there is no functional impact. Also note that l2vpn path
        included in the Alarm, GPRR, error messages returned from validation
        may include the new VPN path instead of the deprecated l2vpn path. Both
        new path and old vpn path refer to same resource.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Segment`
        :return: com.vmware.nsx_policy.model.Segment
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update_0',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })
class ServiceChains(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.service_chains'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServiceChainsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_chain_id,
               ):
        """
        This API can be user to delete service chain with given
        service-chain-id.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Id of Service chain (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'service_chain_id': service_chain_id,
                            })

    def get(self,
            service_chain_id,
            ):
        """
        This API can be used to read service chain with given service-chain-id.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Id of Service chain (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :return: com.vmware.nsx_policy.model.PolicyServiceChain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'service_chain_id': service_chain_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all the service chains available for service insertion

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChainListResult`
        :return: com.vmware.nsx_policy.model.PolicyServiceChainListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_chain_id,
              policy_service_chain,
              ):
        """
        Create Service chain representing the sequence in which 3rd party
        services must be consumed.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Service chain id (required)
        :type  policy_service_chain: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :param policy_service_chain: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'service_chain_id': service_chain_id,
                            'policy_service_chain': policy_service_chain,
                            })

    def update(self,
               service_chain_id,
               policy_service_chain,
               ):
        """
        Create or update Service chain representing the sequence in which 3rd
        party services must be consumed.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Service chain id (required)
        :type  policy_service_chain: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :param policy_service_chain: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :return: com.vmware.nsx_policy.model.PolicyServiceChain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'service_chain_id': service_chain_id,
                            'policy_service_chain': policy_service_chain,
                            })
class ServiceReferences(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.service_references'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServiceReferencesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_reference_id,
               cascade=None,
               ):
        """
        This API can be used to delete a service reference with the given
        service-reference-id.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Id of Service Reference (required)
        :type  cascade: :class:`bool` or ``None``
        :param cascade: Flag to cascade delete all children associated with service
            reference (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'service_reference_id': service_reference_id,
                            'cascade': cascade,
                            })

    def get(self,
            service_reference_id,
            ):
        """
        This API can be used to read service reference with the given
        service-reference-id.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Id of Service Reference (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :return: com.vmware.nsx_policy.model.ServiceReference
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'service_reference_id': service_reference_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all the partner service references available for service insertion

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceReferenceListResult`
        :return: com.vmware.nsx_policy.model.ServiceReferenceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_reference_id,
              service_reference,
              ):
        """
        Create Service Reference representing the intent to consume a given 3rd
        party service.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Service reference id (required)
        :type  service_reference: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :param service_reference: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'service_reference_id': service_reference_id,
                            'service_reference': service_reference,
                            })

    def update(self,
               service_reference_id,
               service_reference,
               ):
        """
        Create Service Reference representing the intent to consume a given 3rd
        party service.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Service reference id (required)
        :type  service_reference: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :param service_reference: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :return: com.vmware.nsx_policy.model.ServiceReference
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'service_reference_id': service_reference_id,
                            'service_reference': service_reference,
                            })
class Services(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_id,
               ):
        """
        Delete Service

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'service_id': service_id,
                            })

    def get(self,
            service_id,
            ):
        """
        Read a service

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Service`
        :return: com.vmware.nsx_policy.model.Service
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'service_id': service_id,
                            })

    def list(self,
             cursor=None,
             default_service=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of Services for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  default_service: :class:`bool` or ``None``
        :param default_service: Fetch all default services (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceListResult`
        :return: com.vmware.nsx_policy.model.ServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'default_service': default_service,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_id,
              service,
              ):
        """
        Create a new service if a service with the given ID does not already
        exist. Creates new service entries if populated in the service. If a
        service with the given ID already exists, patch the service including
        the nested service entries.

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service: :class:`com.vmware.nsx_policy.model_client.Service`
        :param service: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'service_id': service_id,
                            'service': service,
                            })

    def update(self,
               service_id,
               service,
               ):
        """
        Create a new service if a service with the given ID does not already
        exist. Creates new service entries if populated in the service. If a
        service with the given ID already exists, update the service including
        the nested service entries. This is a full replace.

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service: :class:`com.vmware.nsx_policy.model_client.Service`
        :param service: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Service`
        :return: com.vmware.nsx_policy.model.Service
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'service_id': service_id,
                            'service': service,
                            })
class Shares(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.shares'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SharesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               share_id,
               ):
        """
        Delete a Share.

        :type  share_id: :class:`str`
        :param share_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'share_id': share_id,
                            })

    def get(self,
            share_id,
            ):
        """
        Get single instance of a share

        :type  share_id: :class:`str`
        :param share_id: Share ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Share`
        :return: com.vmware.nsx_policy.model.Share
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'share_id': share_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List shares

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ShareListResult`
        :return: com.vmware.nsx_policy.model.ShareListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              share_id,
              share,
              ):
        """
        If a Share with the given ID already exists, update the share entity.

        :type  share_id: :class:`str`
        :param share_id: Share ID (required)
        :type  share: :class:`com.vmware.nsx_policy.model_client.Share`
        :param share: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'share_id': share_id,
                            'share': share,
                            })

    def update(self,
               share_id,
               share,
               ):
        """
        If a Share with the given ID already exists, and the revision is 0,
        throw error

        :type  share_id: :class:`str`
        :param share_id: Share ID (required)
        :type  share: :class:`com.vmware.nsx_policy.model_client.Share`
        :param share: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Share`
        :return: com.vmware.nsx_policy.model.Share
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'share_id': share_id,
                            'share': share,
                            })
class Sites(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SitesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               force=None,
               ):
        """
        Delete a site under Infra.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  force: :class:`bool` or ``None``
        :param force: (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'force': force,
                            })

    def get(self,
            site_id,
            ):
        """
        Read a site under Infra.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Site`
        :return: com.vmware.nsx_policy.model.Site
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List Sites under Infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SiteListResult`
        :return: com.vmware.nsx_policy.model.SiteListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              site_id,
              site,
              ):
        """
        Create or patch Site under Infra.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  site: :class:`com.vmware.nsx_policy.model_client.Site`
        :param site: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'site': site,
                            })

    def update(self,
               site_id,
               site,
               ):
        """
        Create or fully replace a Site under Infra. Revision is optional for
        creation and required for update.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  site: :class:`com.vmware.nsx_policy.model_client.Site`
        :param site: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Site`
        :return: com.vmware.nsx_policy.model.Site
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'site': site,
                            })
class Span(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.span'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SpanStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            intent_path,
            site_path=None,
            ):
        """
        Get span for an entity with specified path.

        :type  intent_path: :class:`str`
        :param intent_path: String Path of the intent object (required)
        :type  site_path: :class:`str` or ``None``
        :param site_path: Policy Path of the site (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Span`
        :return: com.vmware.nsx_policy.model.Span
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'intent_path': intent_path,
                            'site_path': site_path,
                            })
class SpoofguardProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.spoofguard_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SpoofguardProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               spoofguard_profile_id,
               override=None,
               ):
        """
        API will delete SpoofGuard profile with the given id.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            'override': override,
                            })

    def get(self,
            spoofguard_profile_id,
            ):
        """
        API will return details of the SpoofGuard profile with given id. If the
        profile does not exist, it will return 404.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :return: com.vmware.nsx_policy.model.SpoofGuardProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all SpoofGuard profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfileListResult`
        :return: com.vmware.nsx_policy.model.SpoofGuardProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              spoofguard_profile_id,
              spoof_guard_profile,
              override=None,
              ):
        """
        Create a new SpoofGuard profile if the SpoofGuard profile with the
        given id does not exist. Otherwise, patch with the existing SpoofGuard
        profile.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :type  spoof_guard_profile: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :param spoof_guard_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            'spoof_guard_profile': spoof_guard_profile,
                            'override': override,
                            })

    def update(self,
               spoofguard_profile_id,
               spoof_guard_profile,
               override=None,
               ):
        """
        API will create or replace SpoofGuard profile.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :type  spoof_guard_profile: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :param spoof_guard_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :return: com.vmware.nsx_policy.model.SpoofGuardProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            'spoof_guard_profile': spoof_guard_profile,
                            'override': override,
                            })
class StaticMimeContents(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.static_mime_contents'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StaticMimeContentsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               static_mime_content_id,
               override=None,
               ):
        """
        API will delete static mime content

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: Static mime content id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            'override': override,
                            })

    def get(self,
            static_mime_content_id,
            ):
        """
        API will get static mime content

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: Static mime content id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :return: com.vmware.nsx_policy.model.StaticMimeContent
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all static mime contents

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContentListResult`
        :return: com.vmware.nsx_policy.model.StaticMimeContentListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              static_mime_content_id,
              static_mime_content,
              override=None,
              ):
        """
        API will create/update static mime content id

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: static mime content id (required)
        :type  static_mime_content: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :param static_mime_content: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :return: com.vmware.nsx_policy.model.StaticMimeContent
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            'static_mime_content': static_mime_content,
                            'override': override,
                            })

    def update(self,
               static_mime_content_id,
               static_mime_content,
               override=None,
               ):
        """
        API will create/update static mime content id

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: static mime content id (required)
        :type  static_mime_content: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :param static_mime_content: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :return: com.vmware.nsx_policy.model.StaticMimeContent
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            'static_mime_content': static_mime_content,
                            'override': override,
                            })
class Tags(VapiInterface):
    """
    
    """
    LIST_SOURCE_AMAZON = "Amazon"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """
    LIST_SOURCE_AZURE = "Azure"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """
    LIST_SOURCE_NSX = "NSX"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """
    LIST_SOURCE_ANY = "ANY"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tags'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TagsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             scope=None,
             sort_ascending=None,
             sort_by=None,
             source=None,
             tag=None,
             ):
        """
        Returns paginated list of all unique tags. Supports filtering by scope,
        tag and source from which tags are synched. Supports starts with,
        equals and contains operators on scope and tag values. To filter tags
        by starts with on scope or tag, use '\*' as prefix before the value. To
        filter tags by ends with on scope or tag, use '\*' as suffix after the
        value. To filter tags by contain on scope or tag, use '\*' as prefix
        and suffix on the value. Below special characters in the filter value
        needs to be escaped with hex values. - Character '&' needs to be
        escaped as '%26' - Character '[' needs to be escaped as '%5B' -
        Character ']' needs to be escaped as '%5D' - Character '+' needs to be
        escaped as '%2B' - Character '#' needs to be escaped as '%23' Sort
        option for list of unique tags is available only on tag and scope
        properties.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  scope: :class:`str` or ``None``
        :param scope: Tag scope (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (opt