/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class MapTest
extends FreeColTestCase {
    private final TileType highSeasType = MapTest.spec().getTileType("model.tile.highSeas");
    private final TileType lakeType = MapTest.spec().getTileType("model.tile.lake");
    private final TileType oceanType = MapTest.spec().getTileType("model.tile.ocean");
    private final TileType plainsType = MapTest.spec().getTileType("model.tile.plains");
    private final UnitType artilleryType = MapTest.spec().getUnitType("model.unit.artillery");
    private final UnitType colonistType = MapTest.spec().getUnitType("model.unit.freeColonist");
    private final UnitType galleonType = MapTest.spec().getUnitType("model.unit.galleon");
    private final UnitType pioneerType = MapTest.spec().getUnitType("model.unit.hardyPioneer");

    private Map getSingleLandPathMap(Game game) {
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(game);
        builder.setBaseTileType(this.oceanType);
        builder.setTileType(1, 11, this.plainsType);
        builder.setTileType(2, 10, this.plainsType);
        builder.setTileType(2, 9, this.plainsType);
        builder.setTileType(3, 8, this.plainsType);
        builder.setTileType(3, 7, this.plainsType);
        return builder.build();
    }

    private Map getShortLongPathMap(Game game) {
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(game);
        builder.setBaseTileType(this.oceanType);
        builder.setTileType(1, 11, this.plainsType);
        builder.setTileType(2, 10, this.plainsType);
        builder.setTileType(2, 9, this.plainsType);
        builder.setTileType(1, 9, this.plainsType);
        builder.setTileType(1, 7, this.plainsType);
        builder.setTileType(1, 5, this.plainsType);
        builder.setTileType(2, 6, this.plainsType);
        builder.setTileType(2, 7, this.plainsType);
        builder.setTileType(3, 8, this.plainsType);
        builder.setTileType(3, 7, this.plainsType);
        return builder.build();
    }

    public void testMapGameInt() throws FreeColException {
        int expectedWidth = 20;
        int expectedHeigth = 15;
        Game game = MapTest.getStandardGame();
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(game);
        Map map = builder.setDimensions(expectedWidth, expectedHeigth).build();
        MapTest.assertEquals((int)expectedWidth, (int)map.getWidth());
        MapTest.assertEquals((int)expectedHeigth, (int)map.getHeight());
    }

    public void testGetSurroundingTiles() {
        Game game = MapTest.getStandardGame();
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(game);
        Map map = builder.setDimensions(10, 15).build();
        game.changeMap(map);
        ArrayList<Tile> surroundingTiles = new ArrayList<Tile>();
        for (Tile t : map.getTile(4, 8).getSurroundingTiles(1)) {
            surroundingTiles.add(t);
        }
        MapTest.assertEquals((int)8, (int)surroundingTiles.size());
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(4, 6)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(4, 10)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(3, 8)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(5, 8)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(3, 7)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(4, 7)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(3, 9)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(4, 9)));
        surroundingTiles = new ArrayList();
        for (Tile t : map.getTile(0, 0).getSurroundingTiles(1)) {
            surroundingTiles.add(t);
        }
        MapTest.assertEquals((int)3, (int)surroundingTiles.size());
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(0, 2)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(1, 0)));
        MapTest.assertTrue((boolean)surroundingTiles.contains(map.getTile(0, 1)));
        surroundingTiles = new ArrayList();
        for (Tile t : map.getTile(4, 8).getSurroundingTiles(2)) {
            surroundingTiles.add(t);
        }
        MapTest.assertEquals((int)24, (int)surroundingTiles.size());
        surroundingTiles = new ArrayList();
        for (Tile t : map.getTile(4, 8).getSurroundingTiles(10)) {
            surroundingTiles.add(t);
        }
        MapTest.assertEquals((int)149, (int)surroundingTiles.size());
    }

    public void testGetReverseDirection() {
        MapTest.assertEquals((Object)Direction.S, (Object)Direction.N.getReverseDirection());
        MapTest.assertEquals((Object)Direction.N, (Object)Direction.S.getReverseDirection());
        MapTest.assertEquals((Object)Direction.E, (Object)Direction.W.getReverseDirection());
        MapTest.assertEquals((Object)Direction.W, (Object)Direction.E.getReverseDirection());
        MapTest.assertEquals((Object)Direction.NE, (Object)Direction.SW.getReverseDirection());
        MapTest.assertEquals((Object)Direction.NW, (Object)Direction.SE.getReverseDirection());
        MapTest.assertEquals((Object)Direction.SW, (Object)Direction.NE.getReverseDirection());
        MapTest.assertEquals((Object)Direction.SE, (Object)Direction.NW.getReverseDirection());
    }

    public void testGetTiles() {
        Game game = MapTest.getStandardGame();
        int xmax = 5;
        int ymax = 6;
        HashSet allTiles = new HashSet();
        Map map = new Map(game, 5, 6);
        map.populateTiles((x, y) -> {
            Tile tile = new Tile(game, this.plainsType, (int)x, (int)y);
            allTiles.add(tile);
            return tile;
        });
        int i = 0;
        for (Tile t : map.getTileList(CollectionUtils.alwaysTrue())) {
            ++i;
            MapTest.assertTrue((boolean)allTiles.remove(t));
        }
        MapTest.assertTrue((boolean)allTiles.isEmpty());
        MapTest.assertEquals((int)30, (int)i);
    }

    public void testRandomDirection() {
        Game game = MapTest.getStandardGame();
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(game);
        builder.setDimensions(10, 15).build();
        Direction[] dirs = Direction.getRandomDirections("testRandomDirection", null, new Random(1L));
        MapTest.assertNotNull((Object)dirs);
    }

    public void testNoPathAvailableDueToCampInTheWay() {
        Game game = MapTest.getStandardGame();
        Map map = this.getSingleLandPathMap(game);
        game.changeMap(map);
        Tile settlementTile = map.getTile(2, 10);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        builder.settlementTile(settlementTile).build();
        Player dutchPlayer = game.getPlayerByNationId("model.nation.dutch");
        Tile unitTile = map.getTile(1, 11);
        Tile destinationTile = map.getTile(3, 7);
        ServerUnit colonist = new ServerUnit(game, unitTile, dutchPlayer, this.colonistType);
        colonist.setDestination(destinationTile);
        PathNode path = colonist.findPath(destinationTile);
        MapTest.assertNull((String)"No path should be available", (Object)path);
    }

    public void testNoPathAvailableDueToColonyInTheWay() {
        Game game = MapTest.getStandardGame();
        Map map = this.getSingleLandPathMap(game);
        game.changeMap(map);
        Player frenchPlayer = game.getPlayerByNationId("model.nation.french");
        Tile settlementTile = map.getTile(2, 10);
        FreeColTestUtils.getColonyBuilder().player(frenchPlayer).colonyTile(settlementTile).build();
        MapTest.assertTrue((String)"French colony was not set properly on the map", (boolean)settlementTile.hasSettlement());
        Player dutchPlayer = game.getPlayerByNationId("model.nation.dutch");
        Tile unitTile = map.getTile(1, 11);
        Tile destinationTile = map.getTile(3, 7);
        ServerUnit colonist = new ServerUnit(game, unitTile, dutchPlayer, this.colonistType);
        colonist.setDestination(destinationTile);
        PathNode path = colonist.findPath(destinationTile);
        MapTest.assertNull((String)"No path should be available", (Object)path);
    }

    public void testMoveThroughTileWithEnemyUnit() {
        Game game = MapTest.getStandardGame();
        Map map = MapTest.getTestMap();
        game.changeMap(map);
        Tile enemyUnitTile = map.getTile(2, 1);
        Player frenchPlayer = game.getPlayerByNationId("model.nation.french");
        new ServerUnit(game, enemyUnitTile, frenchPlayer, this.pioneerType);
        Tile unitTile = map.getTile(1, 1);
        Tile otherTile = map.getTile(1, 2);
        Player dutchPlayer = game.getPlayerByNationId("model.nation.dutch");
        ServerUnit unit = new ServerUnit(game, unitTile, dutchPlayer, this.pioneerType);
        Tile unitDestination = map.getTile(3, 1);
        unit.setDestination(unitDestination);
        CostDecider decider = CostDeciders.avoidSettlementsAndBlockingUnits();
        MapTest.assertTrue((String)"No blocking unit, should be legal", (decider.getCost(unit, unitTile, otherTile, 4) != -1 ? 1 : 0) != 0);
        MapTest.assertTrue((String)"Blocking unit, should be illegal", (decider.getCost(unit, unitTile, enemyUnitTile, 4) == -1 ? 1 : 0) != 0);
    }

    public void testNoPathAvailableDueToUnitInTheWay() {
        Game game = MapTest.getStandardGame();
        Map map = this.getSingleLandPathMap(game);
        game.changeMap(map);
        Tile unitObstructionTile = map.getTile(2, 10);
        Player frenchPlayer = game.getPlayerByNationId("model.nation.french");
        new ServerUnit(game, unitObstructionTile, frenchPlayer, this.colonistType);
        Player dutchPlayer = game.getPlayerByNationId("model.nation.dutch");
        Tile unitTile = map.getTile(1, 11);
        Tile destinationTile = map.getTile(3, 7);
        ServerUnit colonist = new ServerUnit(game, unitTile, dutchPlayer, this.colonistType);
        colonist.setDestination(destinationTile);
        PathNode path = colonist.findPath(colonist.getTile(), destinationTile, null, CostDeciders.avoidSettlementsAndBlockingUnits(), null);
        MapTest.assertNull((String)"No path should be available", (Object)path);
    }

    public void testShortestPathObstructed() {
        Game game = MapTest.getStandardGame();
        Map map = this.getShortLongPathMap(MapTest.getGame());
        game.changeMap(map);
        Tile settlementTile = map.getTile(2, 10);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        builder.settlementTile(settlementTile).build();
        Player dutchPlayer = game.getPlayerByNationId("model.nation.dutch");
        Tile unitTile = map.getTile(1, 11);
        ServerUnit colonist = new ServerUnit(game, unitTile, dutchPlayer, this.colonistType);
        Tile destinationTile = map.getTile(3, 7);
        colonist.setDestination(destinationTile);
        PathNode path = colonist.findPath(destinationTile);
        MapTest.assertNotNull((String)"A path should be available", (Object)path);
    }

    public void testSearchForColony() {
        Game game = MapTest.getStandardGame();
        Map map = MapTest.getCoastTestMap(this.plainsType, true);
        game.changeMap(map);
        Player dutchPlayer = game.getPlayerByNationId("model.nation.dutch");
        Player frenchPlayer = game.getPlayerByNationId("model.nation.french");
        Tile unitTile = map.getTile(15, 5);
        Tile colonyTile = map.getTile(9, 9);
        ServerUnit galleon = new ServerUnit(game, unitTile, dutchPlayer, this.galleonType);
        ServerUnit artillery = new ServerUnit(game, galleon, dutchPlayer, this.artilleryType);
        FreeColTestUtils.getColonyBuilder().player(frenchPlayer).colonyTile(colonyTile).build();
        MapTest.assertTrue((String)"French colony not on the map", (boolean)colonyTile.hasSettlement());
        dutchPlayer.setStance(frenchPlayer, Stance.WAR);
        frenchPlayer.setStance(dutchPlayer, Stance.WAR);
        GoalDecider gd = new GoalDecider(){
            private PathNode found = null;
            private int score = -1;

            private int scoreTile(Tile tile) {
                return tile.getX() + tile.getY();
            }

            @Override
            public PathNode getGoal() {
                return this.found;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode pathNode) {
                int value;
                Settlement settlement = pathNode.getLocation().getSettlement();
                if (settlement != null && (value = this.scoreTile(pathNode.getTile())) > this.score) {
                    this.score = value;
                    this.found = pathNode;
                    return true;
                }
                return false;
            }
        };
        PathNode path = map.search(artillery, unitTile, gd, CostDeciders.avoidIllegal(), Integer.MAX_VALUE, galleon, null);
        MapTest.assertTrue((String)"Should find the French colony via a drop off", (path != null && path.getTransportDropNode() != null && path.getLastNode().getTile() == colonyTile ? 1 : 0) != 0);
        Tile colonyTile2 = map.getTile(5, 5);
        FreeColTestUtils.getColonyBuilder().player(frenchPlayer).colonyTile(colonyTile2).build();
        MapTest.assertTrue((String)"French colony not on the map", (boolean)colonyTile2.hasSettlement());
        path = map.search(artillery, unitTile, gd, CostDeciders.avoidIllegal(), Integer.MAX_VALUE, galleon, null);
        MapTest.assertTrue((String)"Should still find the first French colony via a drop off", (path != null && path.getTransportDropNode() != null && path.getLastNode().getTile() == colonyTile ? 1 : 0) != 0);
    }

    public void testLatitude() {
        Game game = MapTest.getStandardGame();
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(game);
        Map map = builder.setDimensions(1, 181).build();
        MapTest.assertEquals((int)181, (int)map.getHeight());
        MapTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(map.getLatitudePerRow()));
        MapTest.assertEquals((int)-90, (int)map.getLatitude(0));
        MapTest.assertEquals((int)0, (int)map.getRow(-90));
        MapTest.assertEquals((int)0, (int)map.getLatitude(90));
        MapTest.assertEquals((int)90, (int)map.getRow(0));
        MapTest.assertEquals((int)90, (int)map.getLatitude(180));
        MapTest.assertEquals((int)180, (int)map.getRow(90));
        builder = new FreeColTestCase.MapBuilder(game);
        map = builder.setDimensions(1, 91).build();
        MapTest.assertEquals((int)91, (int)map.getHeight());
        MapTest.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(map.getLatitudePerRow()));
        MapTest.assertEquals((int)-90, (int)map.getLatitude(0));
        MapTest.assertEquals((int)0, (int)map.getRow(-90));
        MapTest.assertEquals((int)0, (int)map.getLatitude(45));
        MapTest.assertEquals((int)45, (int)map.getRow(0));
        MapTest.assertEquals((int)90, (int)map.getLatitude(90));
        MapTest.assertEquals((int)90, (int)map.getRow(90));
        builder = new FreeColTestCase.MapBuilder(game);
        map = builder.setDimensions(1, 91).build();
        map.setMinimumLatitude(0);
        MapTest.assertEquals((int)91, (int)map.getHeight());
        MapTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(map.getLatitudePerRow()));
        MapTest.assertEquals((int)0, (int)map.getLatitude(0));
        MapTest.assertEquals((int)0, (int)map.getRow(0));
        MapTest.assertEquals((int)45, (int)map.getLatitude(45));
        MapTest.assertEquals((int)45, (int)map.getRow(45));
        MapTest.assertEquals((int)90, (int)map.getLatitude(90));
        MapTest.assertEquals((int)90, (int)map.getRow(90));
    }

    public void testCircleIterator() {
        Game game = MapTest.getStandardGame();
        Map map = MapTest.getCoastTestMap(this.plainsType, true);
        game.changeMap(map);
        Tile tile = map.getTile(10, 10);
        List<Tile> radiusMinusOneList = this.iteratorToList(map.getCircleIterator(tile, false, -1));
        MapTest.assertEquals((String)"Radius -1 should produce 0 tiles", (int)0, (int)radiusMinusOneList.size());
        List<Tile> radius0List = this.iteratorToList(map.getCircleIterator(tile, false, 0));
        MapTest.assertEquals((String)"Radius 0 should produce 0 tiles", (int)0, (int)radius0List.size());
        List<Tile> radius1List = this.iteratorToList(map.getCircleIterator(tile, false, 1));
        MapTest.assertEquals((String)"Radius 1", (int)8, (int)radius1List.size());
        List<Tile> radius2List = this.iteratorToList(map.getCircleIterator(tile, false, 2));
        MapTest.assertEquals((String)"Radius 2", (int)16, (int)radius2List.size());
        List<Tile> radius2FilledList = this.iteratorToList(map.getCircleIterator(tile, true, 2));
        MapTest.assertEquals((String)"Radius 2", (int)24, (int)radius2FilledList.size());
        MapTest.assertEquals((String)"The tiles should be returned in a certain order (spiraling clockwise outwards).", List.of(map.getTile(10, 9), map.getTile(11, 10), map.getTile(10, 11), map.getTile(10, 12), map.getTile(9, 11), map.getTile(9, 10), map.getTile(9, 9), map.getTile(10, 8), map.getTile(10, 7), map.getTile(11, 8), map.getTile(11, 9), map.getTile(12, 10), map.getTile(11, 11), map.getTile(11, 12), map.getTile(10, 13), map.getTile(10, 14), map.getTile(9, 13), map.getTile(9, 12), map.getTile(8, 11), map.getTile(8, 10), map.getTile(8, 9), map.getTile(9, 8), map.getTile(9, 7), map.getTile(10, 6)), radius2FilledList);
        Tile cornertile = map.getTile(0, 1);
        List<Tile> radius1CornerList = this.iteratorToList(map.getCircleIterator(cornertile, false, 1));
        MapTest.assertEquals((String)"Radius 1 in corner", (int)6, (int)radius1CornerList.size());
        Tile cornertile2 = map.getTile(map.getWidth() - 1, 1);
        List<Tile> radius1CornerList2 = this.iteratorToList(map.getCircleIterator(cornertile2, false, 1));
        MapTest.assertEquals((String)"Radius 1 in corner2", (int)4, (int)radius1CornerList2.size());
    }

    private <T> List<T> iteratorToList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public void testFindPath() {
        Game game = MapTest.getStandardGame();
        Map map = MapTest.getCoastTestMap(this.plainsType, true);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Europe europe = dutch.getEurope();
        Tile seaTile = map.getTile(13, 2);
        ServerUnit galleon = new ServerUnit(game, seaTile, dutch, this.galleonType);
        PathNode path = galleon.findOurNearestPort();
        MapTest.assertNotNull((String)"Nearest port should exist.", (Object)path);
        MapTest.assertEquals((String)"Nearest port should be Europe.", (Object)europe, (Object)path.getLastNode().getLocation());
        Tile settlementTile = map.getTile(9, 2);
        FreeColTestUtils.getColonyBuilder().player(dutch).colonyTile(settlementTile).build();
        MapTest.assertTrue((String)"Dutch colony should be on the map.", (boolean)settlementTile.hasSettlement());
        MapTest.assertTrue((String)"Dutch colony should be on the shore.", (boolean)settlementTile.isShore());
        path = galleon.findOurNearestPort();
        MapTest.assertNotNull((String)"Nearest port should exist.", (Object)path);
        MapTest.assertEquals((String)"Nearest port should be the colony.", (Object)settlementTile, (Object)path.getLastNode().getTile());
        ServerUnit colonist = new ServerUnit(game, settlementTile, dutch, this.colonistType);
        path = colonist.findPath(settlementTile, settlementTile);
        MapTest.assertNotNull((String)"Trivial path should exist.", (Object)path);
        MapTest.assertNull((String)"Trivial path should be trivial.", (Object)path.next);
        MapTest.assertEquals((String)"Trivial path should start at settlement.", (Object)settlementTile, (Object)path.getTile());
        path = map.findPath(colonist, settlementTile, seaTile, null, null, null);
        MapTest.assertNull((String)"Sea path should be illegal.", (Object)path);
        path = galleon.findPath(settlementTile, seaTile);
        MapTest.assertNotNull((String)"Sea path should be legal for naval unit.", (Object)path);
        MapTest.assertEquals((String)"Sea path should start at settlement.", (Object)settlementTile, (Object)path.getTile());
        MapTest.assertEquals((String)"Sea path should end at sea tile.", (Object)seaTile, (Object)path.getLastNode().getTile());
        path = colonist.findPath(settlementTile, seaTile, galleon);
        MapTest.assertNotNull((String)"Sea path should now be legal.", (Object)path);
        MapTest.assertEquals((String)"Sea path should start at settlement.", (Object)settlementTile, (Object)path.getTile());
        MapTest.assertEquals((String)"Sea path should end at sea tile.", (Object)seaTile, (Object)path.getLastNode().getTile());
        Tile landTile = map.getTile(2, 2);
        path = colonist.findPath(landTile, seaTile, galleon);
        MapTest.assertNotNull((String)"Sea path should still be legal.", (Object)path);
        MapTest.assertEquals((String)"Sea path should start at land tile.", (Object)landTile, (Object)path.getTile());
        MapTest.assertEquals((String)"Sea path should end at sea tile.", (Object)seaTile, (Object)path.getLastNode().getTile());
        while (!path.isOnCarrier()) {
            path = path.next;
        }
        MapTest.assertEquals((String)"Sea path should include pickup at settlement.", (Object)settlementTile, (Object)path.getTile());
        Tile shoreTile = map.getTile(9, 13);
        MapTest.assertTrue((String)"Shore tile should be on the shore.", (boolean)shoreTile.isShore());
        path = colonist.findPath(settlementTile, shoreTile, galleon);
        MapTest.assertNotNull((String)"Shore path should be legal.", (Object)path);
        MapTest.assertTrue((String)"Shore path should have carrier moves.", (boolean)path.usesCarrier());
        MapTest.assertNotNull((String)"Shore path should have drop node.", (Object)path.getCarrierMove().getTransportDropNode());
        Tile midTile = map.getTile(9, 4);
        path = colonist.findPath(map.getTile(2, 5), midTile, galleon);
        MapTest.assertNotNull((String)"Middle path should be legal.", (Object)path);
        MapTest.assertFalse((String)"Middle path should not not use carrier.", (boolean)path.usesCarrier());
        path = colonist.findPath(settlementTile, europe, galleon);
        MapTest.assertNotNull((String)"To-Europe path should be valid.", (Object)path);
        MapTest.assertEquals((String)"To-Europe path should end in Europe.", (Object)europe, (Object)path.getLastNode().getLocation());
        path = colonist.findPath(europe, landTile, galleon);
        MapTest.assertNotNull((String)"From-Europe path should be valid.", (Object)path);
        MapTest.assertEquals((String)"From-Europe path should start in Europe.", (Object)europe, (Object)path.getLocation());
        Tile lakeTile = map.getTile(8, 2);
        lakeTile.setType(this.lakeType);
        Tile anotherSettlementTile = map.getTile(7, 2);
        FreeColTestUtils.getColonyBuilder().player(dutch).colonyTile(anotherSettlementTile).build();
        path = galleon.findPath(anotherSettlementTile, europe);
        MapTest.assertNotNull((String)"From-lake-settlement path should be valid.", (Object)path);
        MapTest.assertEquals((String)"From-lake-settlement path should end in Europe.", (Object)europe, (Object)path.getLastNode().getLocation());
        colonist.setLocation(galleon);
        galleon.setLocation(seaTile);
        path = colonist.findPath(galleon, landTile, galleon);
        MapTest.assertNotNull((String)"From-galleon path should be valid.", (Object)path);
        MapTest.assertEquals((String)"From-galleon path should start at sea.", (Object)seaTile, (Object)path.getLocation());
        MapTest.assertTrue((String)"From-galleon path should start on carrier.", (boolean)path.isOnCarrier());
        MapTest.assertNotNull((String)"From-galleon path should have a drop node.", (Object)path.getTransportDropNode());
    }

    public void testCopy() {
        Game game = MapTest.getStandardGame();
        Map map = MapTest.getTestMap();
        game.changeMap(map);
        Colony colony = this.getStandardColony();
        Tile tile = colony.getTile();
        Map otherMap = (Map)map.copy(game);
        MapTest.assertNotNull((Object)otherMap);
        MapTest.assertFalse((otherMap == map ? 1 : 0) != 0);
        MapTest.assertEquals((String)otherMap.getId(), (String)map.getId());
        Tile otherTile = otherMap.getTile(tile.getX(), tile.getY());
        MapTest.assertNotNull((Object)otherTile);
        MapTest.assertFalse((otherTile == tile ? 1 : 0) != 0);
        MapTest.assertEquals((String)otherTile.getId(), (String)tile.getId());
        Colony otherColony = otherTile.getColony();
        MapTest.assertNotNull((Object)otherColony);
        MapTest.assertFalse((otherColony == colony ? 1 : 0) != 0);
        MapTest.assertEquals((String)otherColony.getId(), (String)colony.getId());
    }
}

