/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.trans;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.pentaho.di.core.annotations.Job(image="ui/images/TRN.png", id="TRANS", type=JobEntryType.TRANS, tooltip="JobEntry.Trans.Tooltip", category=0)
public class JobEntryTrans
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String transname;
    private String filename;
    private String directory;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean paramsFromPrevious;
    public boolean execPerRow;
    public String[] parameters;
    public String[] parameterFieldNames;
    public String[] parameterValues;
    public boolean clearResultRows;
    public boolean clearResultFiles;
    public boolean setLogfile;
    public boolean setAppendLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public int loglevel;
    private String directoryPath;
    private boolean clustering;
    public boolean waitingToFinish = true;
    public boolean followingAbortRemotely;
    private String remoteSlaveServerName;
    private boolean passingAllParameters = true;

    public JobEntryTrans(String name) {
        super(name, "");
        this.setJobEntryType(JobEntryType.TRANS);
    }

    public JobEntryTrans() {
        this("");
        this.clear();
    }

    @Override
    public Object clone() {
        JobEntryTrans je = (JobEntryTrans)super.clone();
        return je;
    }

    public JobEntryTrans(JobEntryBase jeb) {
        super(jeb);
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    public void setTransname(String transname) {
        this.transname = transname;
    }

    public String getTransname() {
        return this.transname;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + this.logfile;
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"transname", (String)this.transname));
        if (this.directory != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        } else if (this.directoryPath != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directoryPath));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"params_from_previous", (boolean)this.paramsFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_rows", (boolean)this.clearResultRows));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_files", (boolean)this.clearResultFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", (String)LogWriter.getLogLevelDesc((int)this.loglevel)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cluster", (boolean)this.clustering));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_server_name", (String)this.remoteSlaveServerName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wait_until_finished", (boolean)this.waitingToFinish));
        retval.append("      ").append(XMLHandler.addTagValue((String)"follow_abort_remote", (boolean)this.followingAbortRemotely));
        if (this.arguments != null) {
            for (i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XMLHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        if (this.parameters != null) {
            retval.append("      ").append(XMLHandler.openTag((String)"parameters"));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (i = 0; i < this.parameters.length; ++i) {
                retval.append("            ").append(XMLHandler.openTag((String)"parameter"));
                retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.parameterFieldNames[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("            ").append(XMLHandler.closeTag((String)"parameter"));
            }
            retval.append("      ").append(XMLHandler.closeTag((String)"parameters"));
        }
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.transname = XMLHandler.getTagValue((Node)entrynode, (String)"transname");
            this.directory = XMLHandler.getTagValue((Node)entrynode, (String)"directory");
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.paramsFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"params_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.clearResultRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_rows"));
            this.clearResultFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_files"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XMLHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XMLHandler.getTagValue((Node)entrynode, (String)"logext");
            this.loglevel = LogWriter.getLogLevel((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.clustering = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"cluster"));
            this.remoteSlaveServerName = XMLHandler.getTagValue((Node)entrynode, (String)"slave_server_name");
            this.setAppendLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            String wait = XMLHandler.getTagValue((Node)entrynode, (String)"wait_until_finished");
            this.waitingToFinish = Const.isEmpty((String)wait) ? true : "Y".equalsIgnoreCase(wait);
            this.followingAbortRemotely = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"follow_abort_remote"));
            int argnr = 0;
            while (XMLHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
            Node parametersNode = XMLHandler.getSubNode((Node)entrynode, (String)"parameters");
            String passAll = XMLHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Const.isEmpty((String)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.parameters = new String[nrParameters];
            this.parameterFieldNames = new String[nrParameters];
            this.parameterValues = new String[nrParameters];
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.parameterFieldNames[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
                this.parameterValues[i] = XMLHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'trans' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.transname = rep.getJobEntryAttributeString(id_jobentry, "name");
            this.directory = rep.getJobEntryAttributeString(id_jobentry, "dir_path");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "file_name");
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.paramsFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "params_from_previous");
            this.execPerRow = rep.getJobEntryAttributeBoolean(id_jobentry, "exec_per_row");
            this.clearResultRows = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_rows", true);
            this.clearResultFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_files", true);
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.loglevel = LogWriter.getLogLevel((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.clustering = rep.getJobEntryAttributeBoolean(id_jobentry, "cluster");
            this.remoteSlaveServerName = rep.getJobEntryAttributeString(id_jobentry, "slave_server_name");
            this.setAppendLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_append_logfile");
            this.waitingToFinish = rep.getJobEntryAttributeBoolean(id_jobentry, "wait_until_finished", true);
            this.followingAbortRemotely = rep.getJobEntryAttributeBoolean(id_jobentry, "follow_abort_remote");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
            int parameternr = rep.countNrJobEntryAttributes(id_jobentry, "parameter_name");
            this.parameters = new String[parameternr];
            this.parameterFieldNames = new String[parameternr];
            this.parameterValues = new String[parameternr];
            for (int a = 0; a < parameternr; ++a) {
                this.parameters[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_name");
                this.parameterFieldNames[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_stream_name");
                this.parameterValues[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_value");
            }
            this.passingAllParameters = rep.getJobEntryAttributeBoolean(id_jobentry, "pass_all_parameters", true);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'trans' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            int i;
            super.saveRep(rep, id_job);
            if (this.directory == null) {
                this.directory = rep.getImportBaseDirectory() != null ? rep.getImportBaseDirectory().getPath() : new RepositoryDirectory().getPath();
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "name", this.getTransname());
            rep.saveJobEntryAttribute(id_job, this.getID(), "dir_path", this.getDirectory() != null ? this.getDirectory() : "");
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_name", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "exec_per_row", this.execPerRow);
            rep.saveJobEntryAttribute(id_job, this.getID(), "clear_rows", this.clearResultRows);
            rep.saveJobEntryAttribute(id_job, this.getID(), "clear_files", this.clearResultFiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getID(), "loglevel", LogWriter.getLogLevelDesc((int)this.loglevel));
            rep.saveJobEntryAttribute(id_job, this.getID(), "cluster", this.clustering);
            rep.saveJobEntryAttribute(id_job, this.getID(), "slave_server_name", this.remoteSlaveServerName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_append_logfile", this.setAppendLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wait_until_finished", this.waitingToFinish);
            rep.saveJobEntryAttribute(id_job, this.getID(), "follow_abort_remote", this.followingAbortRemotely);
            if (this.arguments != null) {
                for (i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "argument", this.arguments[i]);
                }
            }
            if (this.parameters != null) {
                for (i = 0; i < this.parameters.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "parameter_name", this.parameters[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "parameter_stream_name", Const.NVL((String)this.parameterFieldNames[i], (String)""));
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "parameter_value", Const.NVL((String)this.parameterValues[i], (String)""));
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "pass_all_parameters", this.passingAllParameters);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'trans' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.transname = null;
        this.filename = null;
        this.directory = null;
        this.arguments = null;
        this.argFromPrevious = false;
        this.execPerRow = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.clearResultRows = false;
        this.clearResultFiles = false;
        this.remoteSlaveServerName = null;
        this.setAppendLogfile = false;
        this.waitingToFinish = true;
        this.followingAbortRemotely = false;
    }

    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        result.setEntryNr((long)nr);
        Log4jFileAppender appender = null;
        int backupLogLevel = log.getLogLevel();
        if (this.setLogfile) {
            try {
                appender = LogWriter.createFileAppender((String)this.environmentSubstitute(this.getLogFilename()), (boolean)true, (boolean)this.setAppendLogfile);
            }
            catch (KettleException e) {
                log.logError(this.toString(), Messages.getString("JobTrans.Error.UnableOpenAppender", this.getLogFilename(), e.toString()), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            log.addAppender((Appender)appender);
            log.setLogLevel(this.loglevel);
        }
        SlaveServer remoteSlaveServer = null;
        if (!Const.isEmpty((String)this.remoteSlaveServerName)) {
            String realRemoteSlaveServerName = this.environmentSubstitute(this.remoteSlaveServerName);
            remoteSlaveServer = parentJob.getJobMeta().findSlaveServer(realRemoteSlaveServerName);
            if (remoteSlaveServer == null) {
                throw new KettleException(Messages.getString("JobTrans.Exception.UnableToFindRemoteSlaveServer", realRemoteSlaveServerName));
            }
        }
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobTrans.Log.OpeningFile", this.environmentSubstitute(this.getFilename())), new Object[0]);
        }
        if (!Const.isEmpty((String)this.getFilename())) {
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobTrans.Log.OpeningTrans", this.environmentSubstitute(this.getFilename())), new Object[0]);
            }
        } else if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobTrans.Log.OpeningTransInDirec", this.environmentSubstitute(this.getFilename()), this.environmentSubstitute(this.directory)), new Object[0]);
        }
        TransMeta transMeta = this.getTransMeta(rep);
        int iteration = 0;
        String[] args1 = this.arguments;
        if (args1 == null || args1.length == 0) {
            args1 = parentJob.getJobMeta().getArguments();
        }
        String[] args = null;
        if (args1 != null) {
            args = new String[args1.length];
            for (int idx = 0; idx < args1.length; ++idx) {
                args[idx] = this.environmentSubstitute(args1[idx]);
            }
        }
        NamedParamsDefault namedParam = new NamedParamsDefault();
        if (this.parameters != null) {
            for (int idx = 0; idx < this.parameters.length; ++idx) {
                if (Const.isEmpty((String)this.parameters[idx])) continue;
                namedParam.addParameterDefinition(this.parameters[idx], "", "Job entry runtime");
                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                    String value = Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)"");
                    namedParam.setParameterValue(this.parameters[idx], value);
                    continue;
                }
                namedParam.setParameterValue(this.parameters[idx], "");
            }
        }
        RowMetaAndData resultRow = null;
        boolean first = true;
        ArrayList rows = new ArrayList(result.getRows());
        while (first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L && !parentJob.isStopped()) {
            block67: {
                if (this.execPerRow) {
                    result.getRows().clear();
                }
                first = false;
                resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
                try {
                    String fieldValue;
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobTrans.StartingTrans", this.getFilename(), this.getName(), this.getDescription()), new Object[0]);
                    }
                    transMeta.setPreviousResult(result);
                    if (this.clearResultRows) {
                        transMeta.getPreviousResult().setRows(new ArrayList());
                    }
                    if (this.clearResultFiles) {
                        transMeta.getPreviousResult().getResultFiles().clear();
                    }
                    if (this.execPerRow) {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        } else {
                            ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                            newList.add(resultRow);
                            transMeta.getPreviousResult().getRows().addAll(newList);
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Const.isEmpty((String)this.parameters[idx])) continue;
                                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    } else {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Const.isEmpty((String)this.parameters[idx])) continue;
                                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    }
                    transMeta.clearParameters();
                    String[] parameterNames = transMeta.listParameters();
                    for (int idx = 0; idx < parameterNames.length; ++idx) {
                        String parentValue;
                        String thisValue = namedParam.getParameterValue(parameterNames[idx]);
                        if (!Const.isEmpty((String)thisValue)) {
                            transMeta.setParameterValue(parameterNames[idx], thisValue);
                            continue;
                        }
                        if (!this.isPassingAllParameters() || Const.isEmpty((String)(parentValue = parentJob.getParameterValue(parameterNames[idx])))) continue;
                        transMeta.setParameterValue(parameterNames[idx], parentValue);
                    }
                    if (this.clustering) {
                        TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration();
                        executionConfiguration.setClusterPosting(true);
                        executionConfiguration.setClusterPreparing(true);
                        executionConfiguration.setClusterStarting(true);
                        executionConfiguration.setClusterShowingTransformation(false);
                        executionConfiguration.setSafeModeEnabled(false);
                        executionConfiguration.setRepository(rep);
                        executionConfiguration.setLogLevel(log.getLogLevel());
                        executionConfiguration.setVariables(transMeta);
                        executionConfiguration.setArgumentStrings(args);
                        TransSplitter transSplitter = Trans.executeClustered(transMeta, executionConfiguration);
                        long errors = Trans.monitorClusteredTransformation(this.toString(), transSplitter, parentJob);
                        Result clusterResult = Trans.getClusteredTransformationResult(this.toString(), transSplitter, parentJob);
                        result.clear();
                        result.add(clusterResult);
                        result.setNrErrors(result.getNrErrors() + errors);
                        break block67;
                    }
                    if (remoteSlaveServer != null) {
                        TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration();
                        transExecutionConfiguration.setPreviousResult(transMeta.getPreviousResult().clone());
                        transExecutionConfiguration.setVariables(transMeta);
                        transExecutionConfiguration.setArgumentStrings(args);
                        transExecutionConfiguration.setRemoteServer(remoteSlaveServer);
                        transExecutionConfiguration.setLogLevel(log.getLogLevel());
                        Map<String, String> params = transExecutionConfiguration.getParams();
                        for (String param : transMeta.listParameters()) {
                            String value = Const.NVL((String)transMeta.getParameterValue(param), (String)Const.NVL((String)transMeta.getParameterDefault(param), (String)transMeta.getVariable(param)));
                            params.put(param, value);
                        }
                        Trans.sendToSlaveServer(transMeta, transExecutionConfiguration, rep);
                        SlaveServerTransStatus transStatus = null;
                        while (!parentJob.isStopped() && this.waitingToFinish) {
                            block68: {
                                try {
                                    transStatus = remoteSlaveServer.getTransStatus(transMeta.getName());
                                    if (!transStatus.isRunning()) {
                                        Result remoteResult = transStatus.getResult();
                                        result.clear();
                                        result.add(remoteResult);
                                        if (remoteResult.isStopped()) {
                                            result.setNrErrors(result.getNrErrors() + 1L);
                                        }
                                        remoteSlaveServer.cleanupTransformation(transMeta.getName());
                                    }
                                    break block68;
                                }
                                catch (Exception e1) {
                                    log.logError(this.toString(), Messages.getString("JobTrans.Error.UnableContactSlaveServer", "" + remoteSlaveServer, transMeta.getName()), new Object[0]);
                                    result.setNrErrors(result.getNrErrors() + 1L);
                                }
                                break;
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (parentJob.isStopped() && (transStatus == null || transStatus.isRunning())) {
                            remoteSlaveServer.stopTransformation(transMeta.getName());
                            remoteSlaveServer.cleanupTransformation(transMeta.getName());
                            result.setNrErrors(result.getNrErrors() + 1L);
                        }
                        break block67;
                    }
                    Trans trans = new Trans(transMeta);
                    trans.setSocketRepository(parentJob.getSocketRepository());
                    if (parentJob.getJobMeta().isBatchIdPassed()) {
                        trans.setPassedBatchId(parentJob.getPassedBatchId());
                    }
                    trans.setParentJob(parentJob);
                    trans.setParentVariableSpace(parentJob);
                    Job rootJob = parentJob;
                    while (rootJob.getParentJob() != null) {
                        rootJob = rootJob.getParentJob();
                    }
                    trans.setJobStartDate(rootJob.getStartDate());
                    trans.setJobEndDate(rootJob.getEndDate());
                    try {
                        trans.execute(args);
                        while (!trans.isFinished() && !parentJob.isStopped() && trans.getErrors() == 0) {
                            try {
                                Thread.sleep(0L, 500);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (parentJob.isStopped() || trans.getErrors() != 0) {
                            trans.stopAll();
                            trans.waitUntilFinished();
                            trans.endProcessing("stop");
                            result.setNrErrors(1L);
                        } else {
                            trans.endProcessing("end");
                        }
                        Result newResult = trans.getResult();
                        result.clear();
                        result.add(newResult);
                        result.setRows(newResult.getRows());
                        if (this.setLogfile) {
                            ResultFile resultFile = new ResultFile(1, KettleVFS.getFileObject((String)this.getLogFilename()), parentJob.getJobname(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                    }
                    catch (KettleException e) {
                        log.logError(this.toString(), Messages.getString("JobTrans.Error.UnablePrepareExec"), (Throwable)e);
                        result.setNrErrors(1L);
                    }
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobTrans.ErrorUnableOpenTrans", e.getMessage()), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    result.setNrErrors(1L);
                }
            }
            ++iteration;
        }
        if (this.setLogfile) {
            if (appender != null) {
                log.removeAppender((Appender)appender);
                appender.close();
                ResultFile resultFile = new ResultFile(1, appender.getFile(), parentJob.getJobname(), this.getName());
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            }
            log.setLogLevel(backupLogLevel);
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        System.gc();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TransMeta getTransMeta(Repository rep) throws KettleException {
        try {
            LogWriter log = LogWriter.getInstance();
            TransMeta transMeta = null;
            if (!Const.isEmpty((String)this.getFilename())) {
                String filename = this.environmentSubstitute(this.getFilename());
                log.logBasic(this.toString(), "Loading transformation from XML file [" + filename + "]", new Object[0]);
                transMeta = new TransMeta(filename, null, true, this);
                transMeta.copyVariablesFrom(this);
            } else {
                if (Const.isEmpty((String)this.getTransname()) || this.getDirectory() == null) throw new KettleJobException(Messages.getString("JobTrans.Exception.TransNotSpecified"));
                String filename = this.environmentSubstitute(this.getTransname());
                log.logBasic(this.toString(), Messages.getString("JobTrans.Log.LoadingTransRepDirec", filename, "" + this.getDirectory()), new Object[0]);
                if (rep == null) throw new KettleException(Messages.getString("JobTrans.Exception.NoRepDefined"));
                transMeta = new TransMeta(rep, filename, rep.getDirectoryTree().findDirectory(this.environmentSubstitute(this.getDirectory())));
                transMeta.copyVariablesFrom(this);
            }
            transMeta.setArguments(this.arguments);
            return transMeta;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("JobTrans.Exception.MetaDataLoad"), (Throwable)e);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public List<SQLStatement> getSQLStatements(Repository repository, VariableSpace space) throws KettleException {
        this.copyVariablesFrom(space);
        TransMeta transMeta = this.getTransMeta(repository);
        return transMeta.getSQLStatements();
    }

    @Override
    public List<SQLStatement> getSQLStatements(Repository repository) throws KettleException {
        return this.getSQLStatements(repository, null);
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public boolean isClustering() {
        return this.clustering;
    }

    public void setClustering(boolean clustering) {
        this.clustering = clustering;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        if (this.setLogfile) {
            JobEntryValidatorUtils.andValidator().validate(this, "logfile", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        if (!Const.isEmpty((String)this.filename)) {
            JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        } else {
            JobEntryValidatorUtils.andValidator().validate(this, "transname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
            JobEntryValidatorUtils.andValidator().validate(this, "directory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository) throws KettleException {
        this.copyVariablesFrom(space);
        TransMeta transMeta = this.getTransMeta(repository);
        String proposedNewFilename = transMeta.exportResources(transMeta, definitions, namingInterface, repository);
        String newFilename = "${Internal.Job.Filename.Directory}/" + proposedNewFilename;
        transMeta.setFilename(newFilename);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    protected String getLogfile() {
        return this.logfile;
    }

    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public boolean isFollowingAbortRemotely() {
        return this.followingAbortRemotely;
    }

    public void setFollowingAbortRemotely(boolean followingAbortRemotely) {
        this.followingAbortRemotely = followingAbortRemotely;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }
}

