"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_PROPERTY_NAME = exports.METHOD_NAMES = exports.CLUSTER = exports.CLIENT_RULE_METHODS = exports.CLIENT_NOTIFICATIONS_METHODS = exports.CLIENT_LOGTYPE_METHODS = exports.CLIENT_FIELD_MAPPINGS_METHODS = exports.CLIENT_DETECTOR_METHODS = exports.CLIENT_CORRELATION_METHODS = exports.CLIENT_ALERTS_METHODS = exports.BASE_API_PATH = exports.API = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let CLUSTER;
exports.CLUSTER = CLUSTER;

(function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["SA"] = "opensearch_security_analytics";
  CLUSTER["DATA"] = "data";
})(CLUSTER || (exports.CLUSTER = CLUSTER = {}));

const BASE_API_PATH = '/_plugins/_security_analytics';
exports.BASE_API_PATH = BASE_API_PATH;
const API = {
  DETECTORS_BASE: `${BASE_API_PATH}/detectors`,
  CORRELATION_BASE: `${BASE_API_PATH}/correlation/rules`,
  SEARCH_DETECTORS: `${BASE_API_PATH}/detectors/_search`,
  INDICES_BASE: `${BASE_API_PATH}/indices`,
  FINDINGS_BASE: `${BASE_API_PATH}/findings`,
  GET_FINDINGS: `${BASE_API_PATH}/findings/_search`,
  DOCUMENT_IDS_QUERY: `${BASE_API_PATH}/document_ids_query`,
  TIME_RANGE_QUERY: `${BASE_API_PATH}/time_range_query`,
  MAPPINGS_BASE: `${BASE_API_PATH}/mappings`,
  MAPPINGS_VIEW: `${BASE_API_PATH}/mappings/view`,
  GET_ALERTS: `${BASE_API_PATH}/alerts`,
  RULES_BASE: `${BASE_API_PATH}/rules`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  PLUGINS: `${BASE_API_PATH}/_notifications/plugins`,
  ACKNOWLEDGE_ALERTS: `${BASE_API_PATH}/detectors/{detector_id}/_acknowledge/alerts`,
  UPDATE_ALIASES: `${BASE_API_PATH}/update_aliases`,
  CORRELATIONS: `${BASE_API_PATH}/correlations`,
  LOGTYPE_BASE: `${BASE_API_PATH}/logtype`
};
/**
 * Property with below name is added to the prototype of Opensearch client during setup.
 * @see ../clusters/securityAnalytics/securityAnalyticsPlugin
 */

exports.API = API;
const PLUGIN_PROPERTY_NAME = 'securityAnalytics';
exports.PLUGIN_PROPERTY_NAME = PLUGIN_PROPERTY_NAME;
const METHOD_NAMES = {
  //Rule methods
  CREATE_RULE: 'createRule',
  DELETE_RULE: 'deleteRule',
  GET_RULE: 'getRule',
  GET_RULES: 'getRules',
  UPDATE_RULE: 'updateRules',
  // Detector methods
  CREATE_DETECTOR: 'createDetector',
  DELETE_DETECTOR: 'deleteDetector',
  GET_DETECTOR: 'getDetector',
  SEARCH_DETECTORS: 'searchDetectors',
  UPDATE_DETECTOR: 'updateDetector',
  // Correlation methods
  GET_CORRELATION_RULES: 'getCorrelationRules',
  CREATE_CORRELATION_RULE: 'createCorrelationRule',
  UPDATE_CORRELATION_RULE: 'updateCorrelationRule',
  DELETE_CORRELATION_RULE: 'deleteCorrelationRule',
  GET_CORRELATED_FINDINGS: 'getCorrelatedFindings',
  GET_ALL_CORRELATIONS: 'getAllCorrelations',
  // Finding methods
  GET_FINDINGS: 'getFindings',
  // Field mapping methods
  GET_MAPPINGS_VIEW: 'getFieldMappingsView',
  CREATE_MAPPINGS: 'createMappings',
  GET_MAPPINGS: 'getMappings',
  // Alerts methods
  GET_ALERTS: 'getAlerts',
  ACKNOWLEDGE_ALERTS: 'acknowledgeAlerts',
  // Notifications methods
  GET_CHANNEl: 'getChannel',
  GET_CHANNElS: 'getChannels',
  // LogType methods
  SEARCH_LOGTYPES: 'searchLogTypes',
  CREATE_LOGTYPE: 'createLogType',
  UPDATE_LOGTYPE: 'updateLogType',
  DELETE_LOGTYPE: 'deleteLogType'
};
/**
 * These methods are defined on the Opensearch client instance by adding them to the client's
 * prototype under the @see PLUGIN_PROPERTY_NAME field.
 * @see ../clusters/securityAnalytics/securityAnalyticsPlugin
 */

exports.METHOD_NAMES = METHOD_NAMES;
const CLIENT_RULE_METHODS = {
  CREATE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_RULE}`,
  DELETE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_RULE}`,
  GET_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_RULE}`,
  GET_RULES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_RULES}`,
  UPDATE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_RULE}`
};
exports.CLIENT_RULE_METHODS = CLIENT_RULE_METHODS;
const CLIENT_DETECTOR_METHODS = {
  CREATE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_DETECTOR}`,
  DELETE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_DETECTOR}`,
  GET_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_DETECTOR}`,
  SEARCH_DETECTORS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_DETECTORS}`,
  UPDATE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_DETECTOR}`,
  GET_FINDINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_FINDINGS}`
};
exports.CLIENT_DETECTOR_METHODS = CLIENT_DETECTOR_METHODS;
const CLIENT_CORRELATION_METHODS = {
  GET_CORRELATION_RULES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CORRELATION_RULES}`,
  CREATE_CORRELATION_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_CORRELATION_RULE}`,
  UPDATE_CORRELATION_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_CORRELATION_RULE}`,
  DELETE_CORRELATION_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_CORRELATION_RULE}`,
  GET_CORRELATED_FINDINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CORRELATED_FINDINGS}`,
  GET_ALL_CORRELATIONS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_ALL_CORRELATIONS}`
};
exports.CLIENT_CORRELATION_METHODS = CLIENT_CORRELATION_METHODS;
const CLIENT_FIELD_MAPPINGS_METHODS = {
  GET_MAPPINGS_VIEW: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_MAPPINGS_VIEW}`,
  CREATE_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_MAPPINGS}`,
  GET_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_MAPPINGS}`
};
exports.CLIENT_FIELD_MAPPINGS_METHODS = CLIENT_FIELD_MAPPINGS_METHODS;
const CLIENT_ALERTS_METHODS = {
  ACKNOWLEDGE_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.ACKNOWLEDGE_ALERTS}`,
  GET_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_ALERTS}`
};
exports.CLIENT_ALERTS_METHODS = CLIENT_ALERTS_METHODS;
const CLIENT_NOTIFICATIONS_METHODS = {
  GET_CHANNEL: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CHANNEl}`,
  GET_CHANNELS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CHANNElS}`
};
exports.CLIENT_NOTIFICATIONS_METHODS = CLIENT_NOTIFICATIONS_METHODS;
const CLIENT_LOGTYPE_METHODS = {
  SEARCH_LOGTYPES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_LOGTYPES}`,
  CREATE_LOGTYPE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_LOGTYPE}`,
  UPDATE_LOGTYPE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_LOGTYPE}`,
  DELETE_LOGTYPE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_LOGTYPE}`
};
exports.CLIENT_LOGTYPE_METHODS = CLIENT_LOGTYPE_METHODS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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