/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.NumberFormatter;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class BuiltinOperators {
    private static final String DIV_BY_ZERO = "/ by zero";
    private static final double MIN_INT = -2.147483648E9;
    private static final double MAX_INT = 2.147483647E9;

    private BuiltinOperators() {
    }

    public static Value negate(LocaleContext ctx, Value param1) {
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = param1.getType();
        switch (mathType) {
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                double result = -param1.getAsDouble(ctx).doubleValue();
                return ValueSupport.toDateValueIfPossible(mathType, result);
            }
            case LONG: {
                return ValueSupport.toValue(-param1.getAsLongInt(ctx).intValue());
            }
            case DOUBLE: {
                return ValueSupport.toValue(-param1.getAsDouble(ctx).doubleValue());
            }
            case STRING: 
            case BIG_DEC: {
                return ValueSupport.toValue(param1.getAsBigDecimal(ctx).negate(NumberFormatter.DEC_MATH_CONTEXT));
            }
        }
        throw new EvalException("Unexpected type " + (Object)((Object)mathType));
    }

    public static Value add(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.SIMPLE);
        switch (mathType) {
            case STRING: {
                return BuiltinOperators.nonNullConcat(ctx, param1, param2);
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                double result = param1.getAsDouble(ctx) + param2.getAsDouble(ctx);
                return ValueSupport.toDateValueIfPossible(mathType, result);
            }
            case LONG: {
                return ValueSupport.toValue(param1.getAsLongInt(ctx) + param2.getAsLongInt(ctx));
            }
            case DOUBLE: {
                return ValueSupport.toValue(param1.getAsDouble(ctx) + param2.getAsDouble(ctx));
            }
            case BIG_DEC: {
                return ValueSupport.toValue(param1.getAsBigDecimal(ctx).add(param2.getAsBigDecimal(ctx), NumberFormatter.DEC_MATH_CONTEXT));
            }
        }
        throw new EvalException("Unexpected type " + (Object)((Object)mathType));
    }

    public static Value subtract(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.SIMPLE);
        switch (mathType) {
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                double result = param1.getAsDouble(ctx) - param2.getAsDouble(ctx);
                return ValueSupport.toDateValueIfPossible(mathType, result);
            }
            case LONG: {
                return ValueSupport.toValue(param1.getAsLongInt(ctx) - param2.getAsLongInt(ctx));
            }
            case DOUBLE: {
                return ValueSupport.toValue(param1.getAsDouble(ctx) - param2.getAsDouble(ctx));
            }
            case BIG_DEC: {
                return ValueSupport.toValue(param1.getAsBigDecimal(ctx).subtract(param2.getAsBigDecimal(ctx), NumberFormatter.DEC_MATH_CONTEXT));
            }
        }
        throw new EvalException("Unexpected type " + (Object)((Object)mathType));
    }

    public static Value multiply(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.GENERAL);
        switch (mathType) {
            case LONG: {
                return ValueSupport.toValue(param1.getAsLongInt(ctx) * param2.getAsLongInt(ctx));
            }
            case DOUBLE: {
                return ValueSupport.toValue(param1.getAsDouble(ctx) * param2.getAsDouble(ctx));
            }
            case BIG_DEC: {
                return ValueSupport.toValue(param1.getAsBigDecimal(ctx).multiply(param2.getAsBigDecimal(ctx), NumberFormatter.DEC_MATH_CONTEXT));
            }
        }
        throw new EvalException("Unexpected type " + (Object)((Object)mathType));
    }

    public static Value divide(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.GENERAL);
        switch (mathType) {
            case LONG: {
                int lp1 = param1.getAsLongInt(ctx);
                int lp2 = param2.getAsLongInt(ctx);
                if (lp1 % lp2 == 0) {
                    return ValueSupport.toValue(lp1 / lp2);
                }
                return ValueSupport.toValue((double)lp1 / (double)lp2);
            }
            case DOUBLE: {
                double d2 = param2.getAsDouble(ctx);
                if (d2 == 0.0) {
                    throw new ArithmeticException(DIV_BY_ZERO);
                }
                return ValueSupport.toValue(param1.getAsDouble(ctx) / d2);
            }
            case BIG_DEC: {
                return ValueSupport.toValue(BuiltinOperators.divide(param1.getAsBigDecimal(ctx), param2.getAsBigDecimal(ctx)));
            }
        }
        throw new EvalException("Unexpected type " + (Object)((Object)mathType));
    }

    public static Value intDivide(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.GENERAL);
        if (mathType.isString()) {
            throw new EvalException("Unexpected type " + (Object)((Object)mathType));
        }
        return ValueSupport.toValue(param1.getAsLongInt(ctx) / param2.getAsLongInt(ctx));
    }

    public static Value exp(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.GENERAL);
        if (mathType == Value.Type.BIG_DEC) {
            try {
                BigDecimal result = param1.getAsBigDecimal(ctx).pow(param2.getAsBigDecimal(ctx).intValueExact(), NumberFormatter.DEC_MATH_CONTEXT);
                return ValueSupport.toValue(result);
            }
            catch (ArithmeticException result) {
                // empty catch block
            }
        }
        double result = Math.pow(param1.getAsDouble(ctx), param2.getAsDouble(ctx));
        if (mathType == Value.Type.LONG && BuiltinOperators.isIntegral(result)) {
            return ValueSupport.toValue((int)result);
        }
        return ValueSupport.toValue(result);
    }

    public static Value mod(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        Value.Type mathType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.GENERAL);
        if (mathType.isString()) {
            throw new EvalException("Unexpected type " + (Object)((Object)mathType));
        }
        return ValueSupport.toValue(param1.getAsLongInt(ctx) % param2.getAsLongInt(ctx));
    }

    public static Value concat(LocaleContext ctx, Value param1, Value param2) {
        if (param1.isNull()) {
            param1 = ValueSupport.EMPTY_STR_VAL;
        }
        if (param2.isNull()) {
            param2 = ValueSupport.EMPTY_STR_VAL;
        }
        return BuiltinOperators.nonNullConcat(ctx, param1, param2);
    }

    private static Value nonNullConcat(LocaleContext ctx, Value param1, Value param2) {
        return ValueSupport.toValue(param1.getAsString(ctx).concat(param2.getAsString(ctx)));
    }

    public static Value not(LocaleContext ctx, Value param1) {
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(!param1.getAsBoolean(ctx));
    }

    public static Value lessThan(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(BuiltinOperators.nonNullCompareTo(ctx, param1, param2) < 0);
    }

    public static Value greaterThan(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(BuiltinOperators.nonNullCompareTo(ctx, param1, param2) > 0);
    }

    public static Value lessThanEq(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(BuiltinOperators.nonNullCompareTo(ctx, param1, param2) <= 0);
    }

    public static Value greaterThanEq(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(BuiltinOperators.nonNullCompareTo(ctx, param1, param2) >= 0);
    }

    public static Value equals(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(BuiltinOperators.nonNullCompareTo(ctx, param1, param2) == 0);
    }

    public static Value notEquals(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(BuiltinOperators.nonNullCompareTo(ctx, param1, param2) != 0);
    }

    public static Value and(LocaleContext ctx, Value param1, Value param2) {
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        boolean b1 = param1.getAsBoolean(ctx);
        if (!b1) {
            return ValueSupport.FALSE_VAL;
        }
        if (param2.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(param2.getAsBoolean(ctx));
    }

    public static Value or(LocaleContext ctx, Value param1, Value param2) {
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        boolean b1 = param1.getAsBoolean(ctx);
        if (b1) {
            return ValueSupport.TRUE_VAL;
        }
        if (param2.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(param2.getAsBoolean(ctx));
    }

    public static Value eqv(LocaleContext ctx, Value param1, Value param2) {
        boolean b2;
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        boolean b1 = param1.getAsBoolean(ctx);
        return ValueSupport.toValue(b1 == (b2 = param2.getAsBoolean(ctx)));
    }

    public static Value xor(LocaleContext ctx, Value param1, Value param2) {
        if (BuiltinOperators.anyParamIsNull(param1, param2)) {
            return ValueSupport.NULL_VAL;
        }
        boolean b1 = param1.getAsBoolean(ctx);
        boolean b2 = param2.getAsBoolean(ctx);
        return ValueSupport.toValue(b1 ^ b2);
    }

    public static Value imp(LocaleContext ctx, Value param1, Value param2) {
        if (param1.isNull()) {
            if (param2.isNull() || !param2.getAsBoolean(ctx)) {
                return ValueSupport.NULL_VAL;
            }
            return ValueSupport.TRUE_VAL;
        }
        boolean b1 = param1.getAsBoolean(ctx);
        if (!b1) {
            return ValueSupport.TRUE_VAL;
        }
        if (param2.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(param2.getAsBoolean(ctx));
    }

    public static Value isNull(Value param1) {
        return ValueSupport.toValue(param1.isNull());
    }

    public static Value isNotNull(Value param1) {
        return ValueSupport.toValue(!param1.isNull());
    }

    public static Value like(LocaleContext ctx, Value param1, Pattern pattern) {
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        return ValueSupport.toValue(pattern.matcher(param1.getAsString(ctx)).matches());
    }

    public static Value notLike(LocaleContext ctx, Value param1, Pattern pattern) {
        return BuiltinOperators.not(ctx, BuiltinOperators.like(ctx, param1, pattern));
    }

    public static Value between(LocaleContext ctx, Value param1, Value param2, Value param3) {
        if (BuiltinOperators.anyParamIsNull(param1, param2, param3)) {
            return ValueSupport.NULL_VAL;
        }
        Value min = param2;
        Value max = param3;
        Value gt = BuiltinOperators.greaterThan(ctx, min, max);
        if (gt.getAsBoolean(ctx)) {
            min = param3;
            max = param2;
        }
        return BuiltinOperators.and(ctx, BuiltinOperators.greaterThanEq(ctx, param1, min), BuiltinOperators.lessThanEq(ctx, param1, max));
    }

    public static Value notBetween(LocaleContext ctx, Value param1, Value param2, Value param3) {
        return BuiltinOperators.not(ctx, BuiltinOperators.between(ctx, param1, param2, param3));
    }

    public static Value in(LocaleContext ctx, Value param1, Value[] params) {
        if (param1.isNull()) {
            return ValueSupport.NULL_VAL;
        }
        for (Value val : params) {
            Value eq;
            if (val.isNull() || !(eq = BuiltinOperators.equals(ctx, param1, val)).getAsBoolean(ctx)) continue;
            return ValueSupport.TRUE_VAL;
        }
        return ValueSupport.FALSE_VAL;
    }

    public static Value notIn(LocaleContext ctx, Value param1, Value[] params) {
        return BuiltinOperators.not(ctx, BuiltinOperators.in(ctx, param1, params));
    }

    private static boolean anyParamIsNull(Value param1, Value param2) {
        return param1.isNull() || param2.isNull();
    }

    private static boolean anyParamIsNull(Value param1, Value param2, Value param3) {
        return param1.isNull() || param2.isNull() || param3.isNull();
    }

    protected static int nonNullCompareTo(LocaleContext ctx, Value param1, Value param2) {
        Value.Type compareType = BuiltinOperators.getMathTypePrecedence(ctx, param1, param2, CoercionType.COMPARE);
        switch (compareType) {
            case STRING: {
                if (param1.getType() != param2.getType()) {
                    throw new EvalException("Unexpected type " + (Object)((Object)compareType));
                }
                return param1.getAsString(ctx).compareToIgnoreCase(param2.getAsString(ctx));
            }
            case LONG: {
                return param1.getAsLongInt(ctx).compareTo(param2.getAsLongInt(ctx));
            }
            case DOUBLE: {
                return param1.getAsDouble(ctx).compareTo(param2.getAsDouble(ctx));
            }
            case BIG_DEC: {
                return param1.getAsBigDecimal(ctx).compareTo(param2.getAsBigDecimal(ctx));
            }
        }
        throw new EvalException("Unexpected type " + (Object)((Object)compareType));
    }

    private static Value.Type getMathTypePrecedence(LocaleContext ctx, Value param1, Value param2, CoercionType cType) {
        Value.Type t2;
        Value.Type t1 = param1.getType();
        if (t1 == (t2 = param2.getType())) {
            if (!cType._preferTemporal && t1.isTemporal()) {
                return t1.getPreferredNumericType();
            }
            return t1;
        }
        if (t1.isString() || t2.isString()) {
            Value.Type numericType;
            if (cType._allowCoerceStringToNum && (numericType = BuiltinOperators.coerceStringToNumeric(ctx, param1, param2, cType)) != null) {
                return numericType;
            }
            return Value.Type.STRING;
        }
        if (cType._preferTemporal && (t1.isTemporal() || t2.isTemporal())) {
            return t1.isTemporal() ? (t2.isTemporal() ? Value.Type.DATE_TIME : t1) : t2;
        }
        return BuiltinOperators.getPreferredNumericType(t1.getPreferredNumericType(), t2.getPreferredNumericType());
    }

    private static Value.Type getPreferredNumericType(Value.Type t1, Value.Type t2) {
        if (t1.isIntegral() && t2.isIntegral()) {
            return BuiltinOperators.max(t1, t2);
        }
        return BuiltinOperators.max(t1.getPreferredFPType(), t2.getPreferredFPType());
    }

    private static Value.Type coerceStringToNumeric(LocaleContext ctx, Value param1, Value param2, CoercionType cType) {
        Value.Type t1 = param1.getType();
        Value.Type t2 = param2.getType();
        Value.Type prefType = null;
        Value strParam = null;
        if (t1.isNumeric()) {
            prefType = t1;
            strParam = param2;
        } else if (t2.isNumeric()) {
            prefType = t2;
            strParam = param1;
        } else if (t1.isTemporal()) {
            prefType = cType._preferTemporal ? t1 : t1.getPreferredNumericType();
            strParam = param2;
        } else if (t2.isTemporal()) {
            prefType = cType._preferTemporal ? t2 : t2.getPreferredNumericType();
            strParam = param1;
        } else {
            return null;
        }
        try {
            strParam.getAsBigDecimal(ctx);
            if (prefType.isNumeric()) {
                prefType = prefType == Value.Type.BIG_DEC ? Value.Type.BIG_DEC : Value.Type.DOUBLE;
            }
            return prefType;
        }
        catch (EvalException evalException) {
            return null;
        }
    }

    private static Value.Type max(Value.Type t1, Value.Type t2) {
        return t1.compareTo(t2) > 0 ? t1 : t2;
    }

    static BigDecimal divide(BigDecimal num, BigDecimal denom) {
        return num.divide(denom, NumberFormatter.DEC_MATH_CONTEXT);
    }

    static boolean isIntegral(double d) {
        double id = Math.rint(d);
        return d == id && d >= -2.147483648E9 && d <= 2.147483647E9 && !Double.isInfinite(d) && !Double.isNaN(d);
    }

    private static enum CoercionType {
        SIMPLE(true, true),
        GENERAL(false, true),
        COMPARE(false, false);

        final boolean _preferTemporal;
        final boolean _allowCoerceStringToNum;

        private CoercionType(boolean preferTemporal, boolean allowCoerceStringToNum) {
            this._preferTemporal = preferTemporal;
            this._allowCoerceStringToNum = allowCoerceStringToNum;
        }
    }
}

