/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.tools.I18n;

public abstract class KeyedItem
extends TaggingPresetItem {
    protected static final String DIFFERENT = I18n.tr("<different>", new Object[0]);
    protected static final BooleanProperty PROP_FILL_DEFAULT = new BooleanProperty("taggingpreset.fill-default-for-tagged-primitives", false);
    static final Map<String, String> LAST_VALUES = new HashMap<String, String>();
    public String key;
    public String text;
    public String text_context;
    public String match = this.getDefaultMatch().getValue();

    protected static Usage determineTextUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        for (OsmPrimitive s : sel) {
            String v = s.get(key);
            if (v != null) {
                returnValue.values.add(v);
            } else {
                returnValue.hadEmpty = true;
            }
            if (!s.hasKeys()) continue;
            returnValue.hadKeys = true;
        }
        return returnValue;
    }

    protected static Usage determineBooleanUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        for (OsmPrimitive s : sel) {
            String booleanValue = OsmUtils.getNamedOsmBoolean(s.get(key));
            if (booleanValue == null) continue;
            returnValue.values.add(booleanValue);
        }
        return returnValue;
    }

    public boolean isKeyRequired() {
        MatchType type = MatchType.ofString(this.match);
        return MatchType.KEY_REQUIRED == type || MatchType.KEY_VALUE_REQUIRED == type;
    }

    public abstract MatchType getDefaultMatch();

    public abstract Collection<String> getValues();

    protected String getKeyTooltipText() {
        return I18n.tr("This corresponds to the key ''{0}''", this.key);
    }

    @Override
    protected Boolean matches(Map<String, String> tags) {
        switch (MatchType.ofString(this.match)) {
            case NONE: {
                return null;
            }
            case KEY: {
                return tags.containsKey(this.key) ? Boolean.TRUE : null;
            }
            case KEY_REQUIRED: {
                return tags.containsKey(this.key);
            }
            case KEY_VALUE: {
                return tags.containsKey(this.key) && this.getValues().contains(tags.get(this.key)) ? Boolean.TRUE : null;
            }
            case KEY_VALUE_REQUIRED: {
                return tags.containsKey(this.key) && this.getValues().contains(tags.get(this.key));
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return "KeyedItem [key=" + this.key + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + ']';
    }

    protected static class Usage {
        public final SortedSet<String> values = new TreeSet<String>();
        private boolean hadKeys;
        private boolean hadEmpty;

        protected Usage() {
        }

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.isEmpty();
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    protected static enum MatchType {
        NONE("none"),
        KEY("key"),
        KEY_REQUIRED("key!"),
        KEY_VALUE("keyvalue"),
        KEY_VALUE_REQUIRED("keyvalue!");

        private final String value;

        private MatchType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static MatchType ofString(String type) {
            for (MatchType i : EnumSet.allOf(MatchType.class)) {
                if (!i.getValue().equals(type)) continue;
                return i;
            }
            throw new IllegalArgumentException(type + " is not allowed");
        }
    }
}

