/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ChildProgress;
import org.openstreetmap.josm.gui.progress.ProgressException;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    private final CancelHandler cancelHandler;
    protected State state = State.INIT;
    private int ticksCount;
    private int ticks;
    private int childTicks;
    private String taskTitle;
    private String customText;
    private String extraText;
    private String shownTitle;
    private String shownCustomText;
    private boolean intermediateTask;
    private final Queue<Request> requests = new LinkedList<Request>();
    private AbstractProgressMonitor currentChild;
    private Request requestedState = new Request();

    protected abstract void doBeginTask();

    protected abstract void doFinishTask();

    protected abstract void doSetIntermediate(boolean var1);

    protected abstract void doSetTitle(String var1);

    protected abstract void doSetCustomText(String var1);

    protected AbstractProgressMonitor(CancelHandler cancelHandler) {
        this.cancelHandler = cancelHandler;
    }

    protected void checkState(State ... expectedStates) {
        for (State s : expectedStates) {
            if (s != this.state) continue;
            return;
        }
        throw new ProgressException("Expected states are %s but current state is %s", new Object[]{Arrays.asList(expectedStates).toString(), this.state});
    }

    @Override
    public void beginTask(String title) {
        this.beginTask(title, 10000);
    }

    @Override
    public synchronized void beginTask(String title, int ticks) {
        this.taskTitle = title;
        this.checkState(State.INIT);
        this.state = State.IN_TASK;
        this.doBeginTask();
        this.setTicksCount(ticks);
        this.resetState();
    }

    @Override
    public synchronized void finishTask() {
        if (this.state != State.FINISHED) {
            if (this.state == State.IN_SUBTASK) {
                this.requestedState.finishRequested = true;
            } else {
                this.checkState(State.IN_TASK);
                this.state = State.FINISHED;
                this.doFinishTask();
            }
        }
    }

    @Override
    public synchronized void invalidate() {
        if (this.state == State.INIT) {
            this.state = State.FINISHED;
            this.doFinishTask();
        }
    }

    @Override
    public synchronized void subTask(String title) {
        if (this.state == State.IN_SUBTASK) {
            if (title != null) {
                this.requestedState.title = title;
            }
            this.requestedState.intermediate = Boolean.FALSE;
        } else {
            this.checkState(State.IN_TASK);
            if (title != null) {
                this.taskTitle = title;
                this.resetState();
            }
            this.intermediateTask = false;
            this.doSetIntermediate(false);
        }
    }

    @Override
    public synchronized void indeterminateSubTask(String title) {
        if (this.state == State.IN_SUBTASK) {
            if (title != null) {
                this.requestedState.title = title;
            }
            this.requestedState.intermediate = Boolean.TRUE;
        } else {
            this.checkState(State.IN_TASK);
            if (title != null) {
                this.taskTitle = title;
                this.resetState();
            }
            this.intermediateTask = true;
            this.doSetIntermediate(true);
        }
    }

    @Override
    public synchronized void setCustomText(String text) {
        if (this.state == State.IN_SUBTASK) {
            this.requestedState.customText = text;
        } else {
            this.customText = text;
            this.resetState();
        }
    }

    @Override
    public synchronized void setExtraText(String text) {
        if (this.state == State.IN_SUBTASK) {
            this.requestedState.extraText = text;
        } else {
            this.extraText = text;
            this.resetState();
        }
    }

    @Override
    public void appendLogMessage(String message) {
    }

    private void resetState() {
        String newTitle = this.extraText != null ? this.taskTitle + ' ' + this.extraText : this.taskTitle;
        if (newTitle == null ? this.shownTitle != null : !newTitle.equals(this.shownTitle)) {
            this.shownTitle = newTitle;
            this.doSetTitle(this.shownTitle);
        }
        if (this.customText == null ? this.shownCustomText != null : !this.customText.equals(this.shownCustomText)) {
            this.shownCustomText = this.customText;
            this.doSetCustomText(this.shownCustomText);
        }
        this.doSetIntermediate(this.intermediateTask);
    }

    @Override
    public void cancel() {
        this.cancelHandler.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.cancelHandler.isCanceled();
    }

    @Override
    public void addCancelListener(ProgressMonitor.CancelListener listener) {
        this.cancelHandler.addCancelListener(listener);
    }

    @Override
    public void removeCancelListener(ProgressMonitor.CancelListener listener) {
        this.cancelHandler.removeCancelListener(listener);
    }

    protected abstract void updateProgress(double var1);

    @Override
    public synchronized void setTicks(int ticks) {
        if (ticks >= this.ticksCount) {
            ticks = this.ticksCount - 1;
        }
        this.ticks = ticks;
        this.internalUpdateProgress(0.0);
    }

    @Override
    public synchronized void setTicksCount(int ticks) {
        this.ticksCount = ticks;
        this.internalUpdateProgress(0.0);
    }

    @Override
    public void worked(int ticks) {
        if (ticks == -1) {
            this.setTicks(this.ticksCount - 1);
        } else {
            this.setTicks(this.ticks + ticks);
        }
    }

    private void internalUpdateProgress(double childProgress) {
        if (childProgress > 1.0) {
            childProgress = 1.0;
        }
        this.checkState(State.IN_TASK, State.IN_SUBTASK);
        this.updateProgress(this.ticksCount == 0 ? 0.0 : ((double)this.ticks + childProgress * (double)this.childTicks) / (double)this.ticksCount);
    }

    @Override
    public synchronized int getTicks() {
        return this.ticks;
    }

    @Override
    public synchronized int getTicksCount() {
        return this.ticksCount;
    }

    @Override
    public synchronized ProgressMonitor createSubTaskMonitor(int ticks, boolean internal) {
        if (ticks == -1) {
            ticks = this.ticksCount - this.ticks;
        }
        if (this.state == State.IN_SUBTASK) {
            Request request = new Request();
            request.originator = new ChildProgress(this, this.cancelHandler, internal);
            request.childTicks = ticks;
            this.requests.add(request);
            return request.originator;
        }
        this.checkState(State.IN_TASK);
        this.state = State.IN_SUBTASK;
        this.childTicks = ticks;
        this.currentChild = new ChildProgress(this, this.cancelHandler, internal);
        return this.currentChild;
    }

    private void applyChildRequest(Request request) {
        if (request.customText != null) {
            this.doSetCustomText(request.customText);
        }
        if (request.title != null) {
            this.doSetTitle(request.title);
        }
        if (request.intermediate != null) {
            this.doSetIntermediate(request.intermediate);
        }
        this.internalUpdateProgress(request.currentValue);
    }

    private void applyThisRequest(Request request) {
        if (request.finishRequested) {
            this.finishTask();
        } else {
            if (request.customText != null) {
                this.customText = request.customText;
            }
            if (request.title != null) {
                this.taskTitle = request.title;
            }
            if (request.intermediate != null) {
                this.intermediateTask = request.intermediate;
            }
            if (request.extraText != null) {
                this.extraText = request.extraText;
            }
            this.resetState();
        }
    }

    protected synchronized void childFinished(AbstractProgressMonitor child) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == child) {
            this.setTicks(this.ticks + this.childTicks);
            if (this.requests.isEmpty()) {
                this.state = State.IN_TASK;
                this.applyThisRequest(this.requestedState);
                this.requestedState = new Request();
            } else {
                Request newChild = this.requests.poll();
                this.currentChild = newChild.originator;
                this.childTicks = newChild.childTicks;
                this.applyChildRequest(newChild);
            }
        } else {
            Iterator it = this.requests.iterator();
            while (it.hasNext()) {
                if (((Request)it.next()).originator != child) continue;
                it.remove();
                return;
            }
            throw new ProgressException("Subtask %s not found", child);
        }
    }

    private Request getRequest(AbstractProgressMonitor child) {
        for (Request request : this.requests) {
            if (request.originator != child) continue;
            return request;
        }
        throw new ProgressException("Subtask %s not found", child);
    }

    protected synchronized void childSetProgress(AbstractProgressMonitor child, double value) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == child) {
            this.internalUpdateProgress(value);
        } else {
            this.getRequest(child).currentValue = value;
        }
    }

    protected synchronized void childSetTitle(AbstractProgressMonitor child, String title) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == child) {
            this.doSetTitle(title);
        } else {
            this.getRequest(child).title = title;
        }
    }

    protected synchronized void childSetCustomText(AbstractProgressMonitor child, String customText) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == child) {
            this.doSetCustomText(customText);
        } else {
            this.getRequest(child).customText = customText;
        }
    }

    protected synchronized void childSetIntermediate(AbstractProgressMonitor child, boolean value) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == child) {
            this.doSetIntermediate(value);
        } else {
            this.getRequest(child).intermediate = value;
        }
    }

    public static enum State {
        INIT,
        IN_TASK,
        IN_SUBTASK,
        FINISHED;

    }

    private static class Request {
        private AbstractProgressMonitor originator;
        private int childTicks;
        private double currentValue;
        private String title;
        private String customText;
        private String extraText;
        private Boolean intermediate;
        private boolean finishRequested;

        private Request() {
        }
    }
}

