/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.builder.multithreaded;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.lifecycle.internal.builder.multithreaded.ConcurrencyDependencyGraph;
import org.apache.maven.lifecycle.internal.builder.multithreaded.ThreadOutputMuxer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=Builder.class, hint="multithreaded")
public class MultiThreadedBuilder
implements Builder {
    @Requirement
    private Logger logger;
    @Requirement
    private LifecycleModuleBuilder lifecycleModuleBuilder;

    @Override
    public void build(MavenSession session2, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        int nThreads = Math.min(session2.getRequest().getDegreeOfConcurrency(), session2.getProjects().size());
        boolean parallel = nThreads >= 2;
        session2.setParallel(parallel);
        for (ProjectSegment segment : projectBuilds) {
            segment.getSession().setParallel(parallel);
        }
        ExecutorService executor = Executors.newFixedThreadPool(nThreads, new BuildThreadFactory());
        ExecutorCompletionService<ProjectSegment> service2 = new ExecutorCompletionService<ProjectSegment>(executor);
        ThreadOutputMuxer muxer = null;
        for (TaskSegment taskSegment : taskSegments) {
            ProjectBuildList segmentProjectBuilds = projectBuilds.getByTaskSegment(taskSegment);
            Map<MavenProject, ProjectSegment> projectBuildMap = projectBuilds.selectSegment(taskSegment);
            try {
                ConcurrencyDependencyGraph analyzer2 = new ConcurrencyDependencyGraph(segmentProjectBuilds, session2.getProjectDependencyGraph());
                this.multiThreadedProjectTaskSegmentBuild(analyzer2, reactorContext, session2, service2, taskSegment, projectBuildMap, muxer);
                if (!reactorContext.getReactorBuildStatus().isHalted()) continue;
            }
            catch (Exception e2) {
                session2.getResult().addException(e2);
            }
            break;
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private void multiThreadedProjectTaskSegmentBuild(ConcurrencyDependencyGraph analyzer2, ReactorContext reactorContext, MavenSession rootSession, CompletionService<ProjectSegment> service2, TaskSegment taskSegment, Map<MavenProject, ProjectSegment> projectBuildList, ThreadOutputMuxer muxer) {
        Set<String> duplicateArtifactIds = this.gatherDuplicateArtifactIds(projectBuildList.keySet());
        for (MavenProject mavenProject : analyzer2.getRootSchedulableBuilds()) {
            ProjectSegment projectSegment = projectBuildList.get(mavenProject);
            this.logger.debug("Scheduling: " + projectSegment.getProject());
            Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, projectSegment, reactorContext, taskSegment, muxer, duplicateArtifactIds);
            service2.submit(cb);
        }
        for (int i = 0; i < analyzer2.getNumberOfBuilds(); ++i) {
            try {
                ProjectSegment projectBuild = service2.take().get();
                if (reactorContext.getReactorBuildStatus().isHalted()) break;
                if (analyzer2.getNumberOfBuilds() <= 1) continue;
                List<MavenProject> newItemsThatCanBeBuilt = analyzer2.markAsFinished(projectBuild.getProject());
                for (MavenProject mavenProject : newItemsThatCanBeBuilt) {
                    ProjectSegment scheduledDependent = projectBuildList.get(mavenProject);
                    this.logger.debug("Scheduling: " + scheduledDependent);
                    Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, scheduledDependent, reactorContext, taskSegment, muxer, duplicateArtifactIds);
                    service2.submit(cb);
                }
                continue;
            }
            catch (InterruptedException e2) {
                rootSession.getResult().addException(e2);
                break;
            }
            catch (ExecutionException e3) {
                rootSession.getResult().addException(e3);
                break;
            }
        }
    }

    private Callable<ProjectSegment> createBuildCallable(final MavenSession rootSession, final ProjectSegment projectBuild, final ReactorContext reactorContext, final TaskSegment taskSegment, ThreadOutputMuxer muxer, final Set<String> duplicateArtifactIds) {
        return new Callable<ProjectSegment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProjectSegment call() {
                Thread currentThread = Thread.currentThread();
                String originalThreadName = currentThread.getName();
                MavenProject project2 = projectBuild.getProject();
                String threadNameSuffix = duplicateArtifactIds.contains(project2.getArtifactId()) ? project2.getGroupId() + ":" + project2.getArtifactId() : project2.getArtifactId();
                currentThread.setName("mvn-builder-" + threadNameSuffix);
                try {
                    MultiThreadedBuilder.this.lifecycleModuleBuilder.buildProject(projectBuild.getSession(), rootSession, reactorContext, project2, taskSegment);
                    ProjectSegment projectSegment = projectBuild;
                    return projectSegment;
                }
                finally {
                    currentThread.setName(originalThreadName);
                }
            }
        };
    }

    private Set<String> gatherDuplicateArtifactIds(Set<MavenProject> projects) {
        HashSet<String> artifactIds = new HashSet<String>(projects.size());
        HashSet<String> duplicateArtifactIds = new HashSet<String>();
        for (MavenProject project2 : projects) {
            if (artifactIds.add(project2.getArtifactId())) continue;
            duplicateArtifactIds.add(project2.getArtifactId());
        }
        return duplicateArtifactIds;
    }
}

