"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;

var _constants = require("../utils/constants");

var _operators = require("rxjs/operators");

var _router = _interopRequireDefault(require("./router"));

var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));

var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));

var _ad = _interopRequireWildcard(require("./routes/ad"));

var _alerting = _interopRequireWildcard(require("./routes/alerting"));

var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));

var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));

var _constants2 = require("./utils/constants");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "globalConfig$", void 0);

    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }

  async setup(core) {
    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch; // Create OpenSearch client w/ relevant plugins and headers

    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      plugins: [_adPlugin.default, _alertingPlugin.default],
      customHeaders: { ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    }); // Create router

    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH); // Create services & register with OpenSearch client

    const adService = new _ad.default(client);
    const alertingService = new _alerting.default(client);
    const opensearchService = new _opensearch.default(client);
    const sampleDataService = new _sampleData.default(client); // Register server routes with the service

    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    return {};
  }

  async start(core) {
    return {};
  }

}

exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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