'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = _interopDefault(require('react'));

var globalPrefix = "id";
var lastId = 0;
function nextId(localPrefix) {
  lastId++;
  return "".concat(localPrefix || globalPrefix).concat(lastId);
}
var resetId = function resetId() {
  lastId = 0;
};
var setPrefix = function setPrefix(newPrefix) {
  globalPrefix = newPrefix;
};

var getIds = function getIds(count, prefix) {
  var ids = [];

  for (var i = 0; i < count; i++) {
    ids.push(nextId(prefix));
  }

  return ids;
};

function usePrevious(value) {
  var ref = React.useRef();
  React.useEffect(function () {
    ref.current = value;
  });
  return ref.current;
}

function useId() {
  var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
  var prefix = arguments.length > 1 ? arguments[1] : undefined;
  var idsListRef = React.useRef([]);
  var prevCount = usePrevious(count);
  var prevPrefix = usePrevious(prefix);

  if (count !== prevCount || prevPrefix !== prefix) {
    idsListRef.current = getIds(count, prefix);
  }

  return idsListRef.current;
}

exports.default = nextId;
exports.resetId = resetId;
exports.setPrefix = setPrefix;
exports.useId = useId;
