"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasConfigPathIntersection = exports.isConfigPath = void 0;
/**
 * Checks whether specified value can be considered as config path.
 * @param value Value to check.
 * @public
 */
function isConfigPath(value) {
    if (!value) {
        return false;
    }
    if (typeof value === 'string') {
        return true;
    }
    return Array.isArray(value) && value.every((segment) => typeof segment === 'string');
}
exports.isConfigPath = isConfigPath;
const pathDelimiter = '.';
function hasConfigPathIntersection(leafPath, rootPath) {
    if (!leafPath) {
        throw new Error('leafPath cannot be empty');
    }
    if (!rootPath) {
        throw new Error('rootPath cannot be empty');
    }
    const leafSegments = leafPath.split(pathDelimiter);
    const rootSegments = rootPath.split(pathDelimiter);
    return rootSegments.every((rootSegment, index) => leafSegments[index] === rootSegment);
}
exports.hasConfigPathIntersection = hasConfigPathIntersection;
