/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.bridge;

import java.io.Serializable;
import org.apache.log4j.Appender;
import org.apache.log4j.bridge.FilterAdapter;
import org.apache.log4j.bridge.LogEventAdapter;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;

public class AppenderAdapter {
    private final Appender appender;
    private final Adapter adapter;

    public AppenderAdapter(Appender appender) {
        this.appender = appender;
        Filter appenderFilter = FilterAdapter.convertFilter(appender.getFilter());
        this.adapter = new Adapter(appender.getName(), appenderFilter, null, true, null);
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public class Adapter
    extends AbstractAppender {
        protected Adapter(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
            super(name, filter, layout, ignoreExceptions, properties);
        }

        public void append(LogEvent event) {
            AppenderAdapter.this.appender.doAppend(new LogEventAdapter(event));
        }

        public void stop() {
            AppenderAdapter.this.appender.close();
        }

        public Appender getAppender() {
            return AppenderAdapter.this.appender;
        }
    }
}

