/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.opengis.referencing.cs.AxisDirection;

public enum AxisType {
    X,
    Y,
    Z,
    T;

    private static final Map<String, Character> TYPES;
    private static final Map<Character, AxisType> VALUES;

    private static void addAxisTypes(AxisType axisType, char c, String ... stringArray) {
        Character c2 = Character.valueOf(c);
        for (String string : stringArray) {
            TYPES.put(string, c2);
        }
        VALUES.put(c2, axisType);
    }

    private static Character abbreviation(String string) {
        return string != null ? TYPES.get(string.toLowerCase(Locale.US)) : null;
    }

    public static char abbreviation(Variable variable) {
        Character c = AxisType.abbreviation(variable.getAxisType());
        if (c == null && (c = AxisType.abbreviation(variable.getAttributeAsString("standard_name"))) == null && (c = AxisType.abbreviation(variable.getDescription())) == null) {
            Unit<?> unit;
            if (Units.isAngular(variable.getUnit())) {
                unit = AxisDirections.absolute((AxisDirection)Axis.direction(variable.getUnitsString()));
                if (AxisDirection.EAST.equals((Object)unit)) {
                    return '\u03bb';
                }
                if (AxisDirection.NORTH.equals(unit)) {
                    return '\u03c6';
                }
            }
            if (c == null && (c = AxisType.abbreviation(variable.getName())) == null) {
                unit = variable.getUnit();
                if (Units.isTemporal(unit)) {
                    return 't';
                }
                if (Units.isPressure(unit)) {
                    return 'z';
                }
                return '\u0000';
            }
        }
        return c.charValue();
    }

    static AxisType valueOf(Variable variable) {
        char c = AxisType.abbreviation(variable);
        return c != '\u0000' ? VALUES.get(Character.valueOf(c)) : null;
    }

    static {
        TYPES = new HashMap<String, Character>(26);
        VALUES = new HashMap<Character, AxisType>(13);
        AxisType.addAxisTypes(X, '\u03bb', "longitude", "lon", "long");
        AxisType.addAxisTypes(Y, '\u03c6', "latitude", "lat");
        AxisType.addAxisTypes(Z, 'H', "pressure", "height", "altitude", "barometric_altitude", "elevation", "elev", "geoz");
        AxisType.addAxisTypes(Z, 'D', "depth", "depth_below_geoid");
        AxisType.addAxisTypes(X, 'E', "geox", "projection_x_coordinate");
        AxisType.addAxisTypes(Y, 'N', "geoy", "projection_y_coordinate");
        AxisType.addAxisTypes(T, 't', "t", "time", "runtime");
        AxisType.addAxisTypes(X, 'x', "x");
        AxisType.addAxisTypes(Y, 'y', "y");
        AxisType.addAxisTypes(Z, 'z', "z");
    }
}

