/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.converter.util.ObjectConverter;
import org.keycloak.common.Profile;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.WebAuthnCredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class WebAuthnCredentialProviderFactory
implements CredentialProviderFactory<WebAuthnCredentialProvider>,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "keycloak-webauthn";
    private ObjectConverter converter;

    public CredentialProvider create(KeycloakSession session) {
        return new WebAuthnCredentialProvider(session, this.createOrGetObjectConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectConverter createOrGetObjectConverter() {
        if (this.converter == null) {
            WebAuthnCredentialProviderFactory webAuthnCredentialProviderFactory = this;
            synchronized (webAuthnCredentialProviderFactory) {
                if (this.converter == null) {
                    this.converter = new ObjectConverter();
                }
            }
        }
        return this.converter;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.WEB_AUTHN);
    }
}

