/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMRunnerUtil;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMScripts;
import org.jboss.byteman.contrib.bmunit.BMUnit;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitConfigState;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class BMUnitRunner
extends BlockJUnit4ClassRunner {
    private BMUnitConfig classConfigAnnotation;
    BMScript classSingleScriptAnnotation;
    BMScripts classMultiScriptAnnotation;
    BMRules classMultiRuleAnnotation;
    BMRule classSingleRuleAnnotation;
    Class<?> testKlazz;
    private final BMRunnerUtil BMRunnerUtil = new BMRunnerUtil();

    public BMUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testKlazz = this.getTestClass().getJavaClass();
        this.classConfigAnnotation = this.testKlazz.getAnnotation(BMUnitConfig.class);
        this.classSingleScriptAnnotation = this.testKlazz.getAnnotation(BMScript.class);
        this.classMultiScriptAnnotation = this.testKlazz.getAnnotation(BMScripts.class);
        this.classMultiRuleAnnotation = this.testKlazz.getAnnotation(BMRules.class);
        this.classSingleRuleAnnotation = this.testKlazz.getAnnotation(BMRule.class);
        if (this.classMultiRuleAnnotation != null && this.classSingleRuleAnnotation != null) {
            throw new InitializationError("Use either BMRule or BMRules annotation but not both");
        }
        if (this.classMultiScriptAnnotation != null && this.classSingleScriptAnnotation != null) {
            throw new InitializationError("Use either BMScript or BMScripts annotation but not both");
        }
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement statement = super.childrenInvoker(notifier);
        statement = this.addClassSingleRuleLoader(statement, notifier);
        statement = this.addClassMultiRuleLoader(statement, notifier);
        statement = this.addClassSingleScriptLoader(statement, notifier);
        statement = this.addClassMultiScriptLoader(statement, notifier);
        statement = this.addClassConfigLoader(statement, notifier);
        return statement;
    }

    protected Statement addClassConfigLoader(final Statement statement, RunNotifier notifier) {
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classConfigAnnotation});
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    BMUnitConfigState.pushConfigurationState(BMUnitRunner.this.classConfigAnnotation, BMUnitRunner.this.testKlazz);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnitConfigState.popConfigurationState(BMUnitRunner.this.testKlazz);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement addClassSingleScriptLoader(final Statement statement, RunNotifier notifier) {
        if (this.classSingleScriptAnnotation == null) {
            return statement;
        }
        final String name = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.computeBMScriptName(this.classSingleScriptAnnotation.value());
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classSingleScriptAnnotation});
        final String loadDirectory = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.normaliseLoadDirectory(this.classSingleScriptAnnotation);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement addClassMultiScriptLoader(Statement statement, RunNotifier notifier) {
        if (this.classMultiScriptAnnotation == null) {
            return statement;
        }
        BMScript[] scriptAnnotations = this.classMultiScriptAnnotation.scripts();
        Statement result = statement;
        for (int i = scriptAnnotations.length; i > 0; --i) {
            BMScript scriptAnnotation = scriptAnnotations[i - 1];
            final String name = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.computeBMScriptName(scriptAnnotation.value());
            final RunNotifier fnotifier = notifier;
            final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{scriptAnnotation});
            final String loadDirectory = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.normaliseLoadDirectory(scriptAnnotation);
            final Statement nextStatement = result;
            result = new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                        try {
                            nextStatement.evaluate();
                        }
                        finally {
                            try {
                                BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                            }
                            catch (Exception e) {
                                fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                            }
                        }
                    }
                    catch (Exception e) {
                        fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                    }
                }
            };
        }
        return result;
    }

    protected Statement addClassMultiRuleLoader(final Statement statement, RunNotifier notifier) {
        if (this.classMultiRuleAnnotation == null) {
            return statement;
        }
        final String scriptText = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.constructScriptText(this.classMultiRuleAnnotation.rules());
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classMultiRuleAnnotation});
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, null, scriptText);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, null);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement addClassSingleRuleLoader(final Statement statement, RunNotifier notifier) {
        if (this.classSingleRuleAnnotation == null) {
            return statement;
        }
        final String scriptText = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.constructScriptText(new BMRule[]{this.classSingleRuleAnnotation});
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classSingleRuleAnnotation});
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, null, scriptText);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, null);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement statement = super.methodInvoker(method, test);
        statement = this.addMethodSingleRuleLoader(statement, method);
        statement = this.addMethodMultiRuleLoader(statement, method);
        statement = this.addMethodSingleScriptLoader(statement, method);
        statement = this.addMethodMultiScriptLoader(statement, method);
        statement = this.addMethodConfigLoader(statement, method);
        return statement;
    }

    protected Statement addMethodConfigLoader(final Statement statement, FrameworkMethod method) {
        final BMUnitConfig annotation = (BMUnitConfig)method.getAnnotation(BMUnitConfig.class);
        final Method testMethod = method.getMethod();
        return new Statement(){

            public void evaluate() throws Throwable {
                BMUnitConfigState.pushConfigurationState(annotation, testMethod);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnitConfigState.popConfigurationState(testMethod);
                }
            }
        };
    }

    protected Statement addMethodSingleScriptLoader(final Statement statement, FrameworkMethod method) {
        BMScript annotation = (BMScript)method.getAnnotation(BMScript.class);
        if (annotation == null) {
            return statement;
        }
        final String name = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.computeBMScriptName(annotation.value(), method.getMethod());
        final String loadDirectory = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.normaliseLoadDirectory(annotation);
        return new Statement(){

            public void evaluate() throws Throwable {
                BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                }
            }
        };
    }

    protected Statement addMethodMultiScriptLoader(Statement statement, FrameworkMethod method) {
        BMScripts scriptsAnnotation = (BMScripts)method.getAnnotation(BMScripts.class);
        if (scriptsAnnotation == null) {
            return statement;
        }
        BMScript[] scriptAnnotations = scriptsAnnotation.scripts();
        Statement result = statement;
        for (int i = scriptAnnotations.length; i > 0; --i) {
            BMScript scriptAnnotation = scriptAnnotations[i - 1];
            final Statement nextStatement = result;
            final String name = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.computeBMScriptName(scriptAnnotation.value(), method.getMethod());
            final String loadDirectory = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.normaliseLoadDirectory(scriptAnnotation);
            result = new Statement(){

                public void evaluate() throws Throwable {
                    BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                    try {
                        nextStatement.evaluate();
                    }
                    finally {
                        BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                    }
                }
            };
        }
        return result;
    }

    protected Statement addMethodMultiRuleLoader(final Statement statement, FrameworkMethod method) {
        BMRules annotation = (BMRules)method.getAnnotation(BMRules.class);
        if (annotation == null) {
            return statement;
        }
        final String name = method.getName();
        final String script = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.constructScriptText(annotation.rules());
        return new Statement(){

            public void evaluate() throws Throwable {
                BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, name, script);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, name);
                }
            }
        };
    }

    protected Statement addMethodSingleRuleLoader(final Statement statement, FrameworkMethod method) {
        BMRule annotation = (BMRule)method.getAnnotation(BMRule.class);
        if (annotation == null) {
            return statement;
        }
        final String name = method.getName();
        final String script = org.jboss.byteman.contrib.bmunit.BMRunnerUtil.constructScriptText(new BMRule[]{annotation});
        return new Statement(){

            public void evaluate() throws Throwable {
                BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, name, script);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, name);
                }
            }
        };
    }
}

