/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.architect.swingui.olap.VirtualCubePane;
import ca.sqlpower.architect.swingui.olap.action.CreateUsageAction;
import ca.sqlpower.object.SPObject;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CreateCubeUsageAction
extends CreateUsageAction<CubePane, VirtualCubePane> {
    private static final Logger logger = Logger.getLogger(CreateCubeUsageAction.class);

    public CreateCubeUsageAction(ArchitectSwingSession session, PlayPen pp) {
        super(session, pp, CubePane.class, VirtualCubePane.class, "Cube Usage", (Icon)OSUtils.CUBE_USAGE_ADD_ICON);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('x'));
    }

    @Override
    protected void createUsage(CubePane cp, VirtualCubePane vcp) {
        if (OLAPUtil.isNameUnique((OLAPObject)((Object)vcp.getModel()), MondrianModel.CubeUsage.class, ((MondrianModel.Cube)((Object)cp.getModel())).getName())) {
            try {
                this.getSession().getWorkspace().begin("Creating cube usage");
                MondrianModel.CubeUsage cu = new MondrianModel.CubeUsage();
                cu.setCubeName(((MondrianModel.Cube)((Object)cp.getModel())).getName());
                ((MondrianModel.VirtualCube)((Object)vcp.getModel())).getCubeUsage().addCubeUsage(cu);
                UsageComponent uc = new UsageComponent(this.getPlaypen().getContentPane(), cu, cp, vcp);
                this.getPlaypen().getContentPane().addChild((SPObject)uc, this.getPlaypen().getContentPane().getChildren().size());
                this.getSession().getWorkspace().commit();
            }
            catch (Throwable e) {
                this.getSession().getWorkspace().rollback("Error occurred: " + e.toString());
                throw new RuntimeException(e);
            }
        } else {
            String errorMsg = "Cube Usage \"" + ((MondrianModel.Cube)((Object)cp.getModel())).getName() + "\" alreadys exists in \"" + ((MondrianModel.VirtualCube)((Object)vcp.getModel())).getName() + "\"\nCube Usage was not created.";
            JOptionPane.showMessageDialog(this.getPlaypen(), errorMsg, "Duplicate Cube Usage", 1);
        }
    }
}

