/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Binding;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Return;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Symbol;

public final class dotimes
extends SpecialOperator {
    private static final dotimes DOTIMES = new dotimes();

    private dotimes() {
        super(Symbol.DOTIMES);
    }

    @Override
    public LispObject execute(LispObject args, Environment env) {
        LispObject bodyForm = args.cdr();
        args = args.car();
        Symbol var = Lisp.checkSymbol(args.car());
        LispObject countForm = args.cadr();
        LispThread thread = LispThread.currentThread();
        LispObject resultForm = args.cdr().cdr().car();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        LispObject bodyAndDecls = Lisp.parseBody(bodyForm, false);
        LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
        bodyForm = bodyAndDecls.car();
        LispObject blockId = new LispObject();
        Environment ext = new Environment(env);
        thread.envStack.push(ext);
        try {
            LispObject result;
            Object binding;
            ext.addBlock(Lisp.NIL, blockId);
            LispObject limit = Lisp.eval(countForm, ext, thread);
            LispObject localTags = Lisp.preprocessTagBody(bodyForm, ext);
            if (specials != Lisp.NIL && Lisp.memq(var, specials)) {
                thread.bindSpecial(var, null);
                binding = thread.getSpecialBinding(var);
                ext.declareSpecial(var);
            } else if (var.isSpecialVariable()) {
                thread.bindSpecial(var, null);
                binding = thread.getSpecialBinding(var);
            } else {
                ext.bind(var, null);
                binding = ext.getBinding(var);
            }
            while (specials != Lisp.NIL) {
                ext.declareSpecial(Lisp.checkSymbol(specials.car()));
                specials = specials.cdr();
            }
            if (limit instanceof Fixnum) {
                int i;
                int count = ((Fixnum)limit).value;
                for (i = 0; i < count; ++i) {
                    if (binding instanceof SpecialBinding) {
                        ((SpecialBinding)binding).value = Fixnum.getInstance(i);
                    } else {
                        ((Binding)binding).value = Fixnum.getInstance(i);
                    }
                    Lisp.processTagBody(bodyForm, localTags, ext);
                    if (!Lisp.interrupted) continue;
                    Lisp.handleInterrupt();
                }
                if (binding instanceof SpecialBinding) {
                    ((SpecialBinding)binding).value = Fixnum.getInstance(i);
                } else {
                    ((Binding)binding).value = Fixnum.getInstance(i);
                }
                result = Lisp.eval(resultForm, ext, thread);
            } else if (limit instanceof Bignum) {
                LispObject i = Fixnum.ZERO;
                while (((LispObject)i).isLessThan(limit)) {
                    if (binding instanceof SpecialBinding) {
                        ((SpecialBinding)binding).value = i;
                    } else {
                        ((Binding)binding).value = i;
                    }
                    Lisp.processTagBody(bodyForm, localTags, ext);
                    i = ((LispObject)i).incr();
                    if (!Lisp.interrupted) continue;
                    Lisp.handleInterrupt();
                }
                if (binding instanceof SpecialBinding) {
                    ((SpecialBinding)binding).value = i;
                } else {
                    ((Binding)binding).value = i;
                }
                result = Lisp.eval(resultForm, ext, thread);
            } else {
                LispObject lispObject = Lisp.type_error(limit, Symbol.INTEGER);
                return lispObject;
            }
            LispObject lispObject = result;
            return lispObject;
        }
        catch (Return ret) {
            if (ret.getBlock() == blockId) {
                LispObject lispObject = ret.getResult();
                return lispObject;
            }
            throw ret;
        }
        finally {
            thread.resetSpecialBindings(mark);
            ext.inactive = true;
            while (thread.envStack.pop() != ext) {
            }
        }
    }
}

