/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template.impl;

import com.damnhandy.uri.template.UriTemplate;

public enum Operator {
    NUL("", ",", false, UriTemplate.Encoding.U),
    RESERVED("+", ",", false, UriTemplate.Encoding.UR),
    NAME_LABEL(".", ".", false, UriTemplate.Encoding.U),
    PATH("/", "/", false, UriTemplate.Encoding.U),
    MATRIX(";", ";", true, UriTemplate.Encoding.U),
    QUERY("?", "&", true, UriTemplate.Encoding.U),
    CONTINUATION("&", "&", true, UriTemplate.Encoding.U),
    FRAGMENT("#", ",", false, UriTemplate.Encoding.UR);

    private String operator;
    private String separator;
    private boolean named;
    private UriTemplate.Encoding encoding = UriTemplate.Encoding.U;

    private Operator(String operator, String separator, boolean named, UriTemplate.Encoding encoding) {
        this.operator = operator;
        this.separator = separator;
        this.named = named;
        this.encoding = encoding;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public UriTemplate.Encoding getEncoding() {
        return this.encoding;
    }

    public boolean isNamed() {
        return this.named;
    }

    public String getListSeparator() {
        return ",";
    }

    public boolean useVarNameWhenExploded() {
        return this.named;
    }

    public String getPrefix() {
        return this.operator;
    }

    public static Operator fromOpCode(String opCode) throws IllegalArgumentException {
        for (Operator op : Operator.values()) {
            if (op.getOperator().equalsIgnoreCase(opCode)) {
                return op;
            }
            if (!"!".equals(opCode) && !"=".equals(opCode)) continue;
            throw new IllegalArgumentException(opCode + " is not a valid operator.");
        }
        return null;
    }
}

