/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.EnumFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.util.SafeXMLParsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractEnumField
extends PrimitiveFieldType {
    protected EnumMapping enumMapping;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.enumMapping = new EnumMapping(schema, this, args);
    }

    public EnumMapping getEnumMapping() {
        return this.enumMapping;
    }

    public EnumFieldValue toObject(IndexableField f) {
        Integer intValue = null;
        String stringValue = null;
        Number val = f.numericValue();
        if (val != null) {
            intValue = val.intValue();
            stringValue = this.enumMapping.intValueToStringValue(intValue);
        }
        return new EnumFieldValue(intValue, stringValue);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        FieldType.MultiValueSelector selector;
        if (field.multiValued() && null != (selector = field.type.getDefaultMultiValueSelectorForSort(field, top))) {
            SortField result = AbstractEnumField.getSortedSetSortField(field, selector.getSortedSetSelectorType(), top, SortField.STRING_FIRST, SortField.STRING_LAST);
            if (null == result.getMissingValue()) {
                result.setMissingValue(SortField.STRING_FIRST);
            }
            return result;
        }
        SortField result = AbstractEnumField.getSortField(field, SortField.Type.INT, top, Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (null == result.getMissingValue()) {
            result.setMissingValue((Object)Integer.MIN_VALUE);
        }
        return result;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new EnumFieldSource(field.getName(), this.enumMapping.enumIntToStringMap, this.enumMapping.enumStringToIntMap);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        Number val = f.numericValue();
        if (val == null) {
            writer.writeNull(name);
            return;
        }
        String readableValue = this.enumMapping.intValueToStringValue(val.intValue());
        writer.writeStr(name, readableValue, true);
    }

    @Override
    public boolean isTokenized() {
        return false;
    }

    @Override
    public NumberType getNumberType() {
        return NumberType.INTEGER;
    }

    @Override
    public String readableToIndexed(String val) {
        if (val == null) {
            return null;
        }
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.readableToIndexed(val, bytes);
        return bytes.get().utf8ToString();
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    @Override
    public String toExternal(IndexableField f) {
        Number val = f.numericValue();
        if (val == null) {
            return null;
        }
        return this.enumMapping.intValueToStringValue(val.intValue());
    }

    @Override
    public Object toNativeType(Object val) {
        if (val instanceof CharSequence) {
            String str = val.toString();
            Integer entry = this.enumMapping.enumStringToIntMap.get(str);
            if (entry != null) {
                return new EnumFieldValue(entry, str);
            }
            if (NumberUtils.isCreatable((String)str)) {
                int num = Integer.parseInt(str);
                return new EnumFieldValue(Integer.valueOf(num), this.enumMapping.enumIntToStringMap.get(num));
            }
        } else if (val instanceof Number) {
            int num = ((Number)val).intValue();
            return new EnumFieldValue(Integer.valueOf(num), this.enumMapping.enumIntToStringMap.get(num));
        }
        return super.toNativeType(val);
    }

    public static final class EnumMapping {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        public static final String PARAM_ENUMS_CONFIG = "enumsConfig";
        public static final String PARAM_ENUM_NAME = "enumName";
        public static final Integer DEFAULT_VALUE = -1;
        public final Map<String, Integer> enumStringToIntMap;
        public final Map<Integer, String> enumIntToStringMap;
        protected final String enumsConfigFile;
        protected final String enumName;

        public EnumMapping(IndexSchema schema, FieldType fieldType, Map<String, String> args) {
            String ftName = fieldType.getTypeName();
            HashMap<String, Integer> enumStringToIntMap = new HashMap<String, Integer>();
            HashMap<Integer, String> enumIntToStringMap = new HashMap<Integer, String>();
            this.enumsConfigFile = args.get(PARAM_ENUMS_CONFIG);
            if (this.enumsConfigFile == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, ftName + ": No enums config file was configured.");
            }
            this.enumName = args.get(PARAM_ENUM_NAME);
            if (this.enumName == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, ftName + ": No enum name was configured.");
            }
            SolrResourceLoader loader = schema.getResourceLoader();
            try {
                log.debug("Reloading enums config file from {}", (Object)this.enumsConfigFile);
                Document doc = SafeXMLParsing.parseConfigXML(log, (ResourceLoader)loader, this.enumsConfigFile);
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                String xpathStr = String.format(Locale.ROOT, "/enumsConfig/enum[@name='%s']", this.enumName);
                NodeList nodes = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
                int nodesLength = nodes.getLength();
                if (nodesLength == 0) {
                    String exceptionMessage = String.format(Locale.ENGLISH, "%s: No enum configuration found for enum '%s' in %s.", ftName, this.enumName, this.enumsConfigFile);
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, exceptionMessage);
                }
                if (nodesLength > 1) {
                    log.warn("{}: More than one enum configuration found for enum '{}' in {}. The last one was taken.", new Object[]{ftName, this.enumName, this.enumsConfigFile});
                }
                Node enumNode = nodes.item(nodesLength - 1);
                NodeList valueNodes = (NodeList)xpath.evaluate("value", enumNode, XPathConstants.NODESET);
                for (int i = 0; i < valueNodes.getLength(); ++i) {
                    Node valueNode = valueNodes.item(i);
                    String valueStr = valueNode.getTextContent();
                    if (valueStr == null || valueStr.length() == 0) {
                        String exceptionMessage = String.format(Locale.ENGLISH, "%s: A value was defined with an no value in enum '%s' in %s.", ftName, this.enumName, this.enumsConfigFile);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMessage);
                    }
                    if (enumStringToIntMap.containsKey(valueStr)) {
                        String exceptionMessage = String.format(Locale.ENGLISH, "%s: A duplicated definition was found for value '%s' in enum '%s' in %s.", ftName, valueStr, this.enumName, this.enumsConfigFile);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMessage);
                    }
                    enumIntToStringMap.put(i, valueStr);
                    enumStringToIntMap.put(valueStr, i);
                }
            }
            catch (IOException | XPathExpressionException | SAXException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ftName + ": Error while parsing enums config.", (Throwable)e);
            }
            if (enumStringToIntMap.size() == 0 || enumIntToStringMap.size() == 0) {
                String exceptionMessage = String.format(Locale.ENGLISH, "%s: Invalid configuration was defined for enum '%s' in %s.", ftName, this.enumName, this.enumsConfigFile);
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, exceptionMessage);
            }
            this.enumStringToIntMap = Collections.unmodifiableMap(enumStringToIntMap);
            this.enumIntToStringMap = Collections.unmodifiableMap(enumIntToStringMap);
            args.remove(PARAM_ENUMS_CONFIG);
            args.remove(PARAM_ENUM_NAME);
        }

        public String intValueToStringValue(Integer intVal) {
            if (intVal == null) {
                return null;
            }
            String enumString = this.enumIntToStringMap.get(intVal);
            if (enumString != null) {
                return enumString;
            }
            return DEFAULT_VALUE.toString();
        }

        public Integer stringValueToIntValue(String stringVal) {
            String enumString;
            if (stringVal == null) {
                return null;
            }
            Integer enumInt = this.enumStringToIntMap.get(stringVal);
            if (enumInt != null) {
                return enumInt;
            }
            Integer intValue = EnumMapping.tryParseInt(stringVal);
            if (intValue == null) {
                intValue = DEFAULT_VALUE;
            }
            if ((enumString = this.enumIntToStringMap.get(intValue)) != null) {
                return intValue;
            }
            return DEFAULT_VALUE;
        }

        private static Integer tryParseInt(String valueStr) {
            Integer intValue = null;
            try {
                intValue = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return intValue;
        }
    }
}

