/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct AppOverrideKeys_t")
public class AppOverrideKeys
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PCHKEY;
    public static final int PCHVALUE;

    public AppOverrideKeys(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AppOverrideKeys.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer pchKey() {
        return AppOverrideKeys.npchKey(this.address());
    }

    @NativeType(value="char *")
    public String pchKeyString() {
        return AppOverrideKeys.npchKeyString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pchValue(int capacity) {
        return AppOverrideKeys.npchValue(this.address(), capacity);
    }

    public AppOverrideKeys pchKey(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchKey(this.address(), value);
        return this;
    }

    public AppOverrideKeys pchValue(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchValue(this.address(), value);
        return this;
    }

    public AppOverrideKeys set(ByteBuffer pchKey, ByteBuffer pchValue) {
        this.pchKey(pchKey);
        this.pchValue(pchValue);
        return this;
    }

    public AppOverrideKeys set(AppOverrideKeys src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AppOverrideKeys malloc() {
        return (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AppOverrideKeys calloc() {
        return (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AppOverrideKeys create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AppOverrideKeys create(long address) {
        return (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)address);
    }

    @Nullable
    public static AppOverrideKeys createSafe(long address) {
        return address == 0L ? null : (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AppOverrideKeys.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AppOverrideKeys.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AppOverrideKeys mallocStack() {
        return AppOverrideKeys.mallocStack(MemoryStack.stackGet());
    }

    public static AppOverrideKeys callocStack() {
        return AppOverrideKeys.callocStack(MemoryStack.stackGet());
    }

    public static AppOverrideKeys mallocStack(MemoryStack stack) {
        return (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AppOverrideKeys callocStack(MemoryStack stack) {
        return (AppOverrideKeys)AppOverrideKeys.wrap(AppOverrideKeys.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AppOverrideKeys.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AppOverrideKeys.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AppOverrideKeys.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer npchKey(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHKEY)));
    }

    public static String npchKeyString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHKEY)));
    }

    public static ByteBuffer npchValue(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHVALUE)), (int)capacity);
    }

    public static void npchKey(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PCHKEY), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void npchValue(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCHVALUE), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHKEY)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHVALUE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AppOverrideKeys.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AppOverrideKeys.__struct((Struct.Member[])new Struct.Member[]{AppOverrideKeys.__member((int)POINTER_SIZE), AppOverrideKeys.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PCHKEY = layout.offsetof(0);
        PCHVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AppOverrideKeys, Buffer>
    implements NativeResource {
        private static final AppOverrideKeys ELEMENT_FACTORY = AppOverrideKeys.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AppOverrideKeys getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public ByteBuffer pchKey() {
            return AppOverrideKeys.npchKey(this.address());
        }

        @NativeType(value="char *")
        public String pchKeyString() {
            return AppOverrideKeys.npchKeyString(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pchValue(int capacity) {
            return AppOverrideKeys.npchValue(this.address(), capacity);
        }

        public Buffer pchKey(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchKey(this.address(), value);
            return this;
        }

        public Buffer pchValue(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchValue(this.address(), value);
            return this;
        }
    }
}

