/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import org.apache.logging.log4j.ThreadContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputStrategyExt;
import org.logstash.execution.ExecutionContextExt;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;

@JRubyClass(name={"OutputDelegator"})
public final class OutputDelegatorExt
extends AbstractOutputDelegatorExt {
    private static final long serialVersionUID = 1L;
    private transient IRubyObject outputClass;
    private OutputStrategyExt.AbstractOutputStrategyExt strategy;

    @JRubyMethod(required=5)
    public OutputDelegatorExt initialize(org.jruby.runtime.ThreadContext context, IRubyObject[] arguments) {
        return this.initialize(context, (RubyHash)arguments[4], (RubyClass)arguments[0], (AbstractMetricExt)arguments[1], (ExecutionContextExt)arguments[2], (OutputStrategyExt.OutputStrategyRegistryExt)arguments[3]);
    }

    public OutputDelegatorExt initialize(org.jruby.runtime.ThreadContext context, RubyHash args, RubyClass outputClass, AbstractMetricExt metric, ExecutionContextExt executionContext, OutputStrategyExt.OutputStrategyRegistryExt strategyRegistry) {
        this.outputClass = outputClass;
        this.initMetrics(args.op_aref(context, (IRubyObject)RubyString.newString((Ruby)context.runtime, (String)"id")).asJavaString(), metric);
        this.strategy = (OutputStrategyExt.AbstractOutputStrategyExt)strategyRegistry.classFor(context, this.concurrency(context)).newInstance(context, new IRubyObject[]{outputClass, this.namespacedMetric, executionContext, args}, Block.NULL_BLOCK);
        return this;
    }

    public OutputDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    @VisibleForTesting
    public OutputStrategyExt.AbstractOutputStrategyExt strategy() {
        return this.strategy;
    }

    @Override
    protected IRubyObject getConfigName(org.jruby.runtime.ThreadContext context) {
        return this.outputClass.callMethod(context, "config_name");
    }

    @Override
    protected IRubyObject getConcurrency(org.jruby.runtime.ThreadContext context) {
        return this.outputClass.callMethod(context, "concurrency");
    }

    @Override
    protected void doOutput(Collection<JrubyEventExtLibrary.RubyEvent> batch) {
        try {
            IRubyObject pluginId = this.getId();
            ThreadContext.put((String)"plugin.id", (String)pluginId.toString());
            this.strategy.multiReceive(RubyUtil.RUBY.getCurrentContext(), (IRubyObject)batch);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            ThreadContext.remove((String)"plugin.id");
        }
    }

    @Override
    protected void close(org.jruby.runtime.ThreadContext context) {
        this.strategy.doClose(context);
    }

    @Override
    protected void doRegister(org.jruby.runtime.ThreadContext context) {
        this.strategy.register(context);
    }

    @Override
    protected IRubyObject reloadable(org.jruby.runtime.ThreadContext context) {
        return this.outputClass.callMethod(context, "reloadable?");
    }
}

