/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.common.query;

import java.util.Map;

public final class QueryRequest {
    private final boolean created;
    private final boolean updated;
    private final boolean removed;
    private final String queryString;
    private final Map<String, Object> params;
    private final long skip;
    private final int limit;

    QueryRequest(boolean created, boolean updated, boolean removed, String query, Map<String, Object> params) {
        this.created = created;
        this.updated = updated;
        this.removed = removed;
        this.queryString = query;
        this.params = params;
        this.skip = 0L;
        this.limit = -1;
    }

    public QueryRequest(String queryString, Map<String, Object> params, long skip, int limit) {
        this.created = true;
        this.updated = true;
        this.removed = true;
        this.queryString = queryString;
        this.params = params;
        this.skip = skip;
        this.limit = limit;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isDeleted() {
        return this.removed;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public long skip() {
        return this.skip;
    }

    public int limit() {
        return this.limit;
    }
}

