/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.model.IConfigMapKeySelector;
import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.IObjectFieldSelector;
import com.openshift.restclient.model.ISecretKeySelector;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class EnvironmentVariable
extends ModelNodeAdapter
implements IEnvironmentVariable,
ResourcePropertyKeys {
    private static final String PROP_VALUE_FROM = "valueFrom";
    private static final String PROP_FIELD_REF = "fieldRef";
    private static final String PROP_CONFIG_MAP_KEY_REF = "configMapKeyRef";
    private static final String PROP_SECRET_KEY_REF = "secretKeyRef";

    public EnvironmentVariable(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "name");
    }

    @Override
    public String getValue() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "value");
    }

    @Override
    public IEnvironmentVariable.IEnvVarSource getValueFrom() {
        ModelNode valueFrom = this.getNode().get(PROP_VALUE_FROM);
        if (valueFrom == null) {
            return null;
        }
        if (valueFrom.hasDefined(PROP_FIELD_REF)) {
            return this.createObjectFieldSelector(valueFrom);
        }
        if (valueFrom.hasDefined(PROP_CONFIG_MAP_KEY_REF)) {
            return this.createConfigMapKeySelector(valueFrom);
        }
        if (valueFrom.hasDefined(PROP_SECRET_KEY_REF)) {
            return this.createSecretKeySelector(valueFrom);
        }
        return null;
    }

    private IEnvironmentVariable.IEnvVarSource createSecretKeySelector(final ModelNode valueFrom) {
        return new ISecretKeySelector(){

            @Override
            public String getName() {
                return JBossDmrExtentions.asString(valueFrom, EnvironmentVariable.this.getPropertyKeys(), "secretKeyRef.name");
            }

            @Override
            public String getKey() {
                return JBossDmrExtentions.asString(valueFrom, EnvironmentVariable.this.getPropertyKeys(), "secretKeyRef.key");
            }
        };
    }

    private IEnvironmentVariable.IEnvVarSource createConfigMapKeySelector(final ModelNode valueFrom) {
        return new IConfigMapKeySelector(){

            @Override
            public String getName() {
                return JBossDmrExtentions.asString(valueFrom, EnvironmentVariable.this.getPropertyKeys(), "configMapKeyRef.name");
            }

            @Override
            public String getKey() {
                return JBossDmrExtentions.asString(valueFrom, EnvironmentVariable.this.getPropertyKeys(), "configMapKeyRef.key");
            }
        };
    }

    private IEnvironmentVariable.IEnvVarSource createObjectFieldSelector(final ModelNode valueFrom) {
        return new IObjectFieldSelector(){

            @Override
            public String getFieldPath() {
                return JBossDmrExtentions.asString(valueFrom, EnvironmentVariable.this.getPropertyKeys(), "fieldRef.fieldPath");
            }
        };
    }

    public boolean equals(Object object) {
        if (!(object instanceof IEnvironmentVariable)) {
            return false;
        }
        IEnvironmentVariable otherVar = (IEnvironmentVariable)object;
        String thisName = this.getName();
        String otherName = otherVar.getName();
        if (thisName == null ? otherName != null : !thisName.equals(otherName)) {
            return false;
        }
        String thisValue = this.getValue();
        String otherValue = otherVar.getValue();
        return !(thisValue == null ? otherValue != null : !thisValue.equals(otherValue));
    }

    public int hashCode() {
        String name = this.getName();
        String value = this.getValue();
        return 37 * (name == null ? 0 : name.hashCode()) + (value == null ? 0 : value.hashCode());
    }
}

