/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.theme.Theme;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;

@Path(value="/")
public class WelcomeResource {
    protected static final Logger logger = Logger.getLogger(WelcomeResource.class);
    private static final String KEYCLOAK_STATE_CHECKER = "WELCOME_STATE_CHECKER";
    @Context
    private KeycloakSession session;

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getWelcomePage() throws URISyntaxException {
        this.checkBootstrap();
        String requestUri = this.session.getContext().getUri().getRequestUri().toString();
        if (!requestUri.endsWith("/")) {
            return Response.seeOther((URI)new URI(requestUri + "/")).build();
        }
        return this.createWelcomePage(null, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html; charset=utf-8"})
    public Response createUser(MultivaluedMap<String, String> formData) {
        this.checkBootstrap();
        if (!this.shouldBootstrap()) {
            return this.createWelcomePage(null, null);
        }
        if (!this.isLocal()) {
            ServicesLogger.LOGGER.rejectedNonLocalAttemptToCreateInitialUser(this.session.getContext().getConnection().getRemoteAddr());
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.csrfCheck(formData);
        String username = (String)formData.getFirst((Object)"username");
        String password = (String)formData.getFirst((Object)"password");
        String passwordConfirmation = (String)formData.getFirst((Object)"passwordConfirmation");
        if (username != null) {
            username = username.trim();
        }
        if (username == null || username.length() == 0) {
            return this.createWelcomePage(null, "Username is missing");
        }
        if (password == null || password.length() == 0) {
            return this.createWelcomePage(null, "Password is missing");
        }
        if (!password.equals(passwordConfirmation)) {
            return this.createWelcomePage(null, "Password and confirmation doesn't match");
        }
        this.expireCsrfCookie();
        ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(this.session);
        if (applianceBootstrap.isNoMasterUser()) {
            this.setBootstrap(false);
            applianceBootstrap.createMasterRealmUser(username, password);
            ServicesLogger.LOGGER.createdInitialAdminUser(username);
            return this.createWelcomePage("User created", null);
        }
        ServicesLogger.LOGGER.initialUserAlreadyCreated();
        return this.createWelcomePage(null, "Users already exists");
    }

    @GET
    @Path(value="/welcome-content/{path}")
    @Produces(value={"text/html; charset=utf-8"})
    public Response getResource(@PathParam(value="path") String path) {
        try {
            InputStream resource = this.getTheme().getResourceAsStream(path);
            if (resource != null) {
                String contentType = MimeTypeUtil.getContentType((String)path);
                Response.ResponseBuilder builder = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                return builder.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response createWelcomePage(String successMessage, String errorMessage) {
        try {
            Theme theme = this.getTheme();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("adminConsoleEnabled", WelcomeResource.isAdminConsoleEnabled());
            map.put("productName", "Keycloak");
            map.put("properties", theme.getProperties());
            map.put("adminUrl", this.session.getContext().getUri(UrlType.ADMIN).getBaseUriBuilder().path("/admin/").build(new Object[0]));
            map.put("resourcesPath", "resources/" + Version.RESOURCES_VERSION + "/" + theme.getType().toString().toLowerCase() + "/" + theme.getName());
            map.put("resourcesCommonPath", "resources/" + Version.RESOURCES_VERSION + "/common/keycloak");
            boolean bootstrap = this.shouldBootstrap();
            map.put("bootstrap", bootstrap);
            if (bootstrap) {
                boolean isLocal = this.isLocal();
                map.put("localUser", isLocal);
                map.put("localAdminUrl", "http://localhost:8080/auth");
                map.put("adminUserCreationMessage", "or use the add-user-keycloak script");
                if (isLocal) {
                    String stateChecker = this.setCsrfCookie();
                    map.put("stateChecker", stateChecker);
                }
            }
            if (successMessage != null) {
                map.put("successMessage", successMessage);
            }
            if (errorMessage != null) {
                map.put("errorMessage", errorMessage);
            }
            FreeMarkerProvider freeMarkerUtil = (FreeMarkerProvider)this.session.getProvider(FreeMarkerProvider.class);
            String result = freeMarkerUtil.processTemplate(map, "index.ftl", theme);
            Response.ResponseBuilder rb = Response.status((Response.Status)(errorMessage == null ? Response.Status.OK : Response.Status.BAD_REQUEST)).entity((Object)result).cacheControl(CacheControlUtil.noCache());
            return rb.build();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static boolean isAdminConsoleEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN2);
    }

    private Theme getTheme() {
        try {
            return this.session.theme().getTheme(Theme.Type.WELCOME);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void checkBootstrap() {
        if (this.shouldBootstrap()) {
            KeycloakApplication.BOOTSTRAP_ADMIN_USER.compareAndSet(true, new ApplianceBootstrap(this.session).isNoMasterUser());
        }
    }

    private boolean shouldBootstrap() {
        return KeycloakApplication.BOOTSTRAP_ADMIN_USER.get();
    }

    private void setBootstrap(boolean value) {
        KeycloakApplication.BOOTSTRAP_ADMIN_USER.set(value);
    }

    private boolean isLocal() {
        try {
            ClientConnection clientConnection = this.session.getContext().getConnection();
            InetAddress remoteInetAddress = InetAddress.getByName(clientConnection.getRemoteAddr());
            InetAddress localInetAddress = InetAddress.getByName(clientConnection.getLocalAddr());
            String xForwardedFor = this.session.getContext().getRequestHeaders().getHeaderString("X-Forwarded-For");
            logger.debugf("Checking WelcomePage. Remote address: %s, Local address: %s, X-Forwarded-For header: %s", (Object)remoteInetAddress.toString(), (Object)localInetAddress.toString(), (Object)xForwardedFor);
            return this.isLocalAddress(remoteInetAddress) && this.isLocalAddress(localInetAddress) && xForwardedFor == null;
        }
        catch (UnknownHostException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isLocalAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress();
    }

    private String setCsrfCookie() {
        String stateChecker = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes());
        String cookiePath = this.session.getContext().getUri().getPath();
        boolean secureOnly = this.session.getContext().getUri().getRequestUri().getScheme().equalsIgnoreCase("https");
        CookieHelper.addCookie(KEYCLOAK_STATE_CHECKER, stateChecker, cookiePath, null, null, 300, secureOnly, true, this.session);
        return stateChecker;
    }

    private void expireCsrfCookie() {
        String cookiePath = this.session.getContext().getUri().getPath();
        boolean secureOnly = this.session.getContext().getUri().getRequestUri().getScheme().equalsIgnoreCase("https");
        CookieHelper.addCookie(KEYCLOAK_STATE_CHECKER, "", cookiePath, null, null, 0, secureOnly, true, this.session);
    }

    private void csrfCheck(MultivaluedMap<String, String> formData) {
        String formStateChecker = (String)formData.getFirst((Object)"stateChecker");
        Cookie cookie = (Cookie)this.session.getContext().getRequestHeaders().getCookies().get(KEYCLOAK_STATE_CHECKER);
        if (cookie == null) {
            throw new ForbiddenException();
        }
        String cookieStateChecker = cookie.getValue();
        if (cookieStateChecker == null || !cookieStateChecker.equals(formStateChecker)) {
            throw new ForbiddenException();
        }
    }
}

