/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class SdkLogEmitterProviderBuilder {
    private final List<LogProcessor> logProcessors = new ArrayList<LogProcessor>();
    private Resource resource = Resource.getDefault();
    private Supplier<LogLimits> logLimitsSupplier = LogLimits::getDefault;
    private Clock clock = Clock.getDefault();

    SdkLogEmitterProviderBuilder() {
    }

    public SdkLogEmitterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkLogEmitterProviderBuilder setLogLimits(Supplier<LogLimits> logLimitsSupplier) {
        Objects.requireNonNull(logLimitsSupplier, "logLimitsSupplier");
        this.logLimitsSupplier = logLimitsSupplier;
        return this;
    }

    public SdkLogEmitterProviderBuilder addLogProcessor(LogProcessor processor) {
        Objects.requireNonNull(processor, "processor");
        this.logProcessors.add(processor);
        return this;
    }

    public SdkLogEmitterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkLogEmitterProvider build() {
        return new SdkLogEmitterProvider(this.resource, this.logLimitsSupplier, this.logProcessors, this.clock);
    }
}

