/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.PKCS5;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"OpenSSL::KDF"})
public class KDF {
    private static final String[] PBKDF2_ARGS = new String[]{"salt", "iterations", "length", "hash"};

    static void createKDF(Ruby runtime, RubyModule OpenSSL2, RubyClass OpenSSLError) {
        RubyModule KDF2 = OpenSSL2.defineModuleUnder("KDF");
        KDF2.defineClassUnder("KDFError", OpenSSLError, OpenSSLError.getAllocator());
        KDF2.defineAnnotatedMethods(KDF.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject pbkdf2_hmac(ThreadContext context2, IRubyObject self, IRubyObject pass, IRubyObject opts) {
        IRubyObject[] args = Utils.extractKeywordArgs(context2, (RubyHash)opts, PBKDF2_ARGS, 1);
        args[0] = pass;
        try {
            return PKCS5.pbkdf2Hmac(context2.runtime, args);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw KDF.newKDFError(context2.runtime, e.getMessage());
        }
    }

    static RaiseException newKDFError(Ruby runtime, String message) {
        return Utils.newError(runtime, KDF._KDF(runtime).getClass("KDFError"), message);
    }

    static RubyClass _KDF(Ruby runtime) {
        return (RubyClass)runtime.getModule("OpenSSL").getConstant("KDF");
    }
}

