/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.psych.PsychLibrary;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.io.EncodingUtils;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.LoadSettingsBuilder;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.common.SpecVersion;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.snakeyaml.engine.v2.exceptions.ParserException;
import org.snakeyaml.engine.v2.exceptions.ReaderException;
import org.snakeyaml.engine.v2.exceptions.ScannerException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.Scanner;
import org.snakeyaml.engine.v2.scanner.ScannerImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;
import org.snakeyaml.engine.v2.schema.CoreSchema;
import org.snakeyaml.engine.v2.schema.Schema;

public class PsychParser
extends RubyObject {
    public static final String JRUBY_CALL_SITES = "_jruby_call_sites";
    private Parser parser;
    private Event event;
    private final LoadSettingsBuilder loadSettingsBuilder;
    private final CachingCallSite path;
    private final CachingCallSite event_location;
    private final CachingCallSite start_stream;
    private final CachingCallSite start_document;
    private final CachingCallSite end_document;
    private final CachingCallSite alias;
    private final CachingCallSite scalar;
    private final CachingCallSite start_sequence;
    private final CachingCallSite end_sequence;
    private final CachingCallSite start_mapping;
    private final CachingCallSite end_mapping;
    private final CachingCallSite end_stream;

    public static void initPsychParser(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = ruby.defineClassUnder("Parser", ruby.getObject(), PsychParser::new, rubyModule);
        CachingCallSite[] cachingCallSiteArray = (CachingCallSite[])Arrays.stream(Call.values()).map(call -> new FunctionalCachingCallSite(call.name())).toArray(CachingCallSite[]::new);
        rubyClass.setInternalVariable(JRUBY_CALL_SITES, (Object)cachingCallSiteArray);
        ruby.getLoadService().require("psych/syntax_error");
        rubyClass.defineConstant("ANY", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_ANY_ENCODING.ordinal()));
        rubyClass.defineConstant("UTF8", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_UTF8_ENCODING.ordinal()));
        rubyClass.defineConstant("UTF16LE", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_UTF16LE_ENCODING.ordinal()));
        rubyClass.defineConstant("UTF16BE", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_UTF16BE_ENCODING.ordinal()));
        rubyClass.defineAnnotatedMethods(PsychParser.class);
    }

    public PsychParser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        CachingCallSite[] cachingCallSiteArray = (CachingCallSite[])rubyClass.getInternalVariable(JRUBY_CALL_SITES);
        this.path = cachingCallSiteArray[Call.path.ordinal()];
        this.event_location = cachingCallSiteArray[Call.event_location.ordinal()];
        this.start_stream = cachingCallSiteArray[Call.start_stream.ordinal()];
        this.start_document = cachingCallSiteArray[Call.start_document.ordinal()];
        this.end_document = cachingCallSiteArray[Call.end_document.ordinal()];
        this.alias = cachingCallSiteArray[Call.alias.ordinal()];
        this.scalar = cachingCallSiteArray[Call.scalar.ordinal()];
        this.start_sequence = cachingCallSiteArray[Call.start_sequence.ordinal()];
        this.end_sequence = cachingCallSiteArray[Call.end_sequence.ordinal()];
        this.start_mapping = cachingCallSiteArray[Call.start_mapping.ordinal()];
        this.end_mapping = cachingCallSiteArray[Call.end_mapping.ordinal()];
        this.end_stream = cachingCallSiteArray[Call.end_stream.ordinal()];
        this.loadSettingsBuilder = LoadSettings.builder().setSchema((Schema)new CoreSchema());
    }

    private IRubyObject stringOrNilForAnchor(ThreadContext threadContext, Optional<Anchor> optional) {
        if (!optional.isPresent()) {
            return threadContext.nil;
        }
        return this.stringFor(threadContext, optional.get().getValue());
    }

    private IRubyObject stringOrNilFor(ThreadContext threadContext, Optional<String> optional) {
        if (!optional.isPresent()) {
            return threadContext.nil;
        }
        return this.stringFor(threadContext, optional.get());
    }

    private IRubyObject stringFor(ThreadContext threadContext, String string) {
        Charset charset;
        Ruby ruby = threadContext.runtime;
        boolean bl = true;
        Charset charset2 = RubyEncoding.UTF8;
        Encoding encoding = ruby.getDefaultInternalEncoding();
        if (encoding == null) {
            encoding = UTF8Encoding.INSTANCE;
            charset2 = RubyEncoding.UTF8;
        } else {
            charset = encoding.getCharset();
            if (charset != null) {
                bl = charset == RubyEncoding.UTF8;
                charset2 = charset;
            }
        }
        charset = new ByteList(bl ? RubyEncoding.encodeUTF8((String)string) : RubyEncoding.encode((String)string, (Charset)charset2), encoding);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)charset);
        return rubyString;
    }

    private StreamReader readerFor(ThreadContext threadContext, IRubyObject iRubyObject, LoadSettings loadSettings) {
        if (iRubyObject instanceof RubyString) {
            return PsychParser.readerForString(threadContext, (RubyString)iRubyObject, loadSettings);
        }
        return PsychParser.readerForIO(threadContext, iRubyObject, loadSettings);
    }

    private static StreamReader readerForIO(ThreadContext threadContext, IRubyObject iRubyObject, LoadSettings loadSettings) {
        boolean bl = iRubyObject instanceof RubyIO;
        if (bl || iRubyObject.respondsTo("read")) {
            CharsetDecoder charsetDecoder;
            Charset charset = RubyEncoding.UTF8;
            if (bl && ((charsetDecoder = ((RubyIO)iRubyObject).getReadEncoding()) instanceof UTF16LEEncoding || charsetDecoder instanceof UTF16BEEncoding)) {
                charset = charsetDecoder.getCharset();
            }
            charsetDecoder = charset.newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            return new StreamReader(loadSettings, (Reader)new InputStreamReader((InputStream)new IOInputStream(iRubyObject), charsetDecoder));
        }
        Ruby ruby = threadContext.runtime;
        throw ruby.newTypeError(iRubyObject, ruby.getIO());
    }

    private static StreamReader readerForString(ThreadContext threadContext, RubyString rubyString, LoadSettings loadSettings) {
        ByteList byteList = rubyString.getByteList();
        Encoding encoding = byteList.getEncoding();
        if (!(encoding instanceof UnicodeEncoding)) {
            byteList = EncodingUtils.strConvEnc((ThreadContext)threadContext, (ByteList)byteList, (Encoding)encoding, (Encoding)UTF8Encoding.INSTANCE);
            encoding = UTF8Encoding.INSTANCE;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
        Charset charset = encoding.getCharset();
        assert (charset != null) : "charset for encoding " + encoding + " should not be null";
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, charset);
        return new StreamReader(loadSettings, (Reader)inputStreamReader);
    }

    @JRubyMethod(name={"_native_parse"})
    public IRubyObject parse(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.runtime;
        try {
            LoadSettings loadSettings = this.loadSettingsBuilder.build();
            this.parser = new ParserImpl(loadSettings, (Scanner)new ScannerImpl(loadSettings, this.readerFor(threadContext, iRubyObject2, loadSettings)));
            if (iRubyObject3.isNil() && iRubyObject2.respondsTo("path")) {
                iRubyObject3 = this.path.call(threadContext, (IRubyObject)this, iRubyObject2);
            }
            while (this.parser.hasNext()) {
                this.event = this.parser.next();
                Mark mark = (Mark)this.event.getStartMark().orElseThrow(RuntimeException::new);
                RubyFixnum rubyFixnum = ruby.newFixnum(mark.getLine());
                RubyFixnum rubyFixnum2 = ruby.newFixnum(mark.getColumn());
                Mark mark2 = (Mark)this.event.getEndMark().orElseThrow(RuntimeException::new);
                RubyFixnum rubyFixnum3 = ruby.newFixnum(mark2.getLine());
                RubyFixnum rubyFixnum4 = ruby.newFixnum(mark2.getColumn());
                this.event_location.call(threadContext, (IRubyObject)this, iRubyObject, new IRubyObject[]{rubyFixnum, rubyFixnum2, rubyFixnum3, rubyFixnum4});
                switch (this.event.getEventId()) {
                    case StreamStart: {
                        this.start_stream.call(threadContext, (IRubyObject)this, iRubyObject, (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_ANY_ENCODING.ordinal()));
                        break;
                    }
                    case DocumentStart: {
                        this.handleDocumentStart(threadContext, (DocumentStartEvent)this.event, iRubyObject);
                        break;
                    }
                    case DocumentEnd: {
                        RubyBoolean rubyBoolean = ruby.newBoolean(!((DocumentEndEvent)this.event).isExplicit());
                        this.end_document.call(threadContext, (IRubyObject)this, iRubyObject, (IRubyObject)rubyBoolean);
                        break;
                    }
                    case Alias: {
                        IRubyObject iRubyObject4 = this.stringOrNilForAnchor(threadContext, ((AliasEvent)this.event).getAnchor());
                        this.alias.call(threadContext, (IRubyObject)this, iRubyObject, iRubyObject4);
                        break;
                    }
                    case Scalar: {
                        this.handleScalar(threadContext, (ScalarEvent)this.event, iRubyObject);
                        break;
                    }
                    case SequenceStart: {
                        this.handleSequenceStart(threadContext, (SequenceStartEvent)this.event, iRubyObject);
                        break;
                    }
                    case SequenceEnd: {
                        this.end_sequence.call(threadContext, (IRubyObject)this, iRubyObject);
                        break;
                    }
                    case MappingStart: {
                        this.handleMappingStart(threadContext, (MappingStartEvent)this.event, iRubyObject);
                        break;
                    }
                    case MappingEnd: {
                        this.end_mapping.call(threadContext, (IRubyObject)this, iRubyObject);
                        break;
                    }
                    case StreamEnd: {
                        this.end_stream.call(threadContext, (IRubyObject)this, iRubyObject);
                    }
                }
            }
        }
        catch (ParserException parserException) {
            this.parser = null;
            PsychParser.raiseParserException(threadContext, (MarkedYamlEngineException)parserException, iRubyObject3);
        }
        catch (ScannerException scannerException) {
            this.parser = null;
            StringBuilder stringBuilder = new StringBuilder("syntax error");
            if (scannerException.getProblemMark() != null) {
                stringBuilder.append(scannerException.getProblemMark().toString());
            }
            PsychParser.raiseParserException(threadContext, (MarkedYamlEngineException)scannerException, iRubyObject3);
        }
        catch (ReaderException readerException) {
            this.parser = null;
            PsychParser.raiseParserException(threadContext, readerException, iRubyObject3);
        }
        catch (YamlEngineException yamlEngineException) {
            Throwable throwable = yamlEngineException.getCause();
            if (throwable instanceof MalformedInputException) {
                PsychParser.raiseParserException(threadContext, (MalformedInputException)throwable, iRubyObject3);
            }
            throw yamlEngineException;
        }
        catch (Throwable throwable) {
            Helpers.throwException((Throwable)throwable);
            return this;
        }
        return this;
    }

    private void handleDocumentStart(ThreadContext threadContext, DocumentStartEvent documentStartEvent, IRubyObject iRubyObject) {
        RubyArray rubyArray;
        int n;
        Ruby ruby = threadContext.runtime;
        Optional optional = documentStartEvent.getSpecVersion();
        RubyArray rubyArray2 = optional.isPresent() ? RubyArray.newArray((Ruby)ruby, (IRubyObject)ruby.newFixnum(((SpecVersion)optional.get()).getMajor()), (IRubyObject)ruby.newFixnum(((SpecVersion)optional.get()).getMinor())) : RubyArray.newEmptyArray((Ruby)ruby);
        Map map = documentStartEvent.getTags();
        if (map != null && (n = map.size()) > 0) {
            rubyArray = RubyArray.newArray((Ruby)ruby, (int)n);
            for (Map.Entry entry : map.entrySet()) {
                IRubyObject iRubyObject2 = this.stringFor(threadContext, (String)entry.getKey());
                IRubyObject iRubyObject3 = this.stringFor(threadContext, (String)entry.getValue());
                rubyArray.append((IRubyObject)RubyArray.newArray((Ruby)ruby, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3));
            }
        } else {
            rubyArray = RubyArray.newEmptyArray((Ruby)ruby);
        }
        RubyBoolean rubyBoolean = ruby.newBoolean(!documentStartEvent.isExplicit());
        this.start_document.call(threadContext, (IRubyObject)this, iRubyObject, (IRubyObject)rubyArray2, (IRubyObject)rubyArray, (IRubyObject)rubyBoolean);
    }

    private void handleMappingStart(ThreadContext threadContext, MappingStartEvent mappingStartEvent, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = this.stringOrNilForAnchor(threadContext, mappingStartEvent.getAnchor());
        IRubyObject iRubyObject3 = this.stringOrNilFor(threadContext, mappingStartEvent.getTag());
        RubyBoolean rubyBoolean = ruby.newBoolean(mappingStartEvent.isImplicit());
        RubyFixnum rubyFixnum = ruby.newFixnum(PsychParser.translateFlowStyle(mappingStartEvent.getFlowStyle()));
        this.start_mapping.call(threadContext, (IRubyObject)this, iRubyObject, new IRubyObject[]{iRubyObject2, iRubyObject3, rubyBoolean, rubyFixnum});
    }

    private void handleScalar(ThreadContext threadContext, ScalarEvent scalarEvent, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = this.stringOrNilForAnchor(threadContext, scalarEvent.getAnchor());
        IRubyObject iRubyObject3 = this.stringOrNilFor(threadContext, scalarEvent.getTag());
        ImplicitTuple implicitTuple = scalarEvent.getImplicit();
        RubyBoolean rubyBoolean = ruby.newBoolean(implicitTuple.canOmitTagInPlainScalar());
        RubyBoolean rubyBoolean2 = ruby.newBoolean(implicitTuple.canOmitTagInNonPlainScalar());
        RubyFixnum rubyFixnum = ruby.newFixnum(PsychParser.translateStyle(scalarEvent.getScalarStyle()));
        IRubyObject iRubyObject4 = this.stringFor(threadContext, scalarEvent.getValue());
        this.scalar.call(threadContext, (IRubyObject)this, iRubyObject, new IRubyObject[]{iRubyObject4, iRubyObject2, iRubyObject3, rubyBoolean, rubyBoolean2, rubyFixnum});
    }

    private void handleSequenceStart(ThreadContext threadContext, SequenceStartEvent sequenceStartEvent, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = this.stringOrNilForAnchor(threadContext, sequenceStartEvent.getAnchor());
        IRubyObject iRubyObject3 = this.stringOrNilFor(threadContext, sequenceStartEvent.getTag());
        RubyBoolean rubyBoolean = ruby.newBoolean(sequenceStartEvent.isImplicit());
        RubyFixnum rubyFixnum = ruby.newFixnum(PsychParser.translateFlowStyle(sequenceStartEvent.getFlowStyle()));
        this.start_sequence.call(threadContext, (IRubyObject)this, iRubyObject, new IRubyObject[]{iRubyObject2, iRubyObject3, rubyBoolean, rubyFixnum});
    }

    private static void raiseParserException(ThreadContext threadContext, ReaderException readerException, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        RubyClass rubyClass = (RubyClass)ruby.getModule("Psych").getConstant("SyntaxError");
        IRubyObject iRubyObject2 = rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject, RubyFixnum.zero((Ruby)ruby), RubyFixnum.zero((Ruby)ruby), ruby.newFixnum(readerException.getPosition()), null == readerException.getName() ? threadContext.nil : ruby.newString(readerException.getName()), null == readerException.toString() ? threadContext.nil : ruby.newString(readerException.toString())}, Block.NULL_BLOCK);
        RubyKernel.raise((ThreadContext)threadContext, (IRubyObject)ruby.getKernel(), (IRubyObject[])new IRubyObject[]{iRubyObject2}, (Block)Block.NULL_BLOCK);
    }

    private static void raiseParserException(ThreadContext threadContext, MarkedYamlEngineException markedYamlEngineException, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        RubyClass rubyClass = (RubyClass)ruby.getModule("Psych").getConstant("SyntaxError");
        Mark mark = (Mark)markedYamlEngineException.getProblemMark().get();
        IRubyObject iRubyObject2 = rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject, ruby.newFixnum(mark.getLine() + 1), ruby.newFixnum(mark.getColumn() + 1), ruby.newFixnum(mark.getIndex()), null == markedYamlEngineException.getProblem() ? threadContext.nil : ruby.newString(markedYamlEngineException.getProblem()), null == markedYamlEngineException.getContext() ? threadContext.nil : ruby.newString(markedYamlEngineException.getContext())}, Block.NULL_BLOCK);
        RubyKernel.raise((ThreadContext)threadContext, (IRubyObject)ruby.getKernel(), (IRubyObject[])new IRubyObject[]{iRubyObject2}, (Block)Block.NULL_BLOCK);
    }

    private static void raiseParserException(ThreadContext threadContext, MalformedInputException malformedInputException, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        RubyClass rubyClass = (RubyClass)ruby.getModule("Psych").getConstant("SyntaxError");
        malformedInputException.getInputLength();
        IRubyObject iRubyObject2 = rubyClass.newInstance(threadContext, Helpers.arrayOf((IRubyObject)iRubyObject, (IRubyObject[])new IRubyObject[]{RubyFixnum.minus_one((Ruby)ruby), RubyFixnum.minus_one((Ruby)ruby), ruby.newFixnum(malformedInputException.getInputLength()), threadContext.nil, threadContext.nil}), Block.NULL_BLOCK);
        RubyKernel.raise((ThreadContext)threadContext, (IRubyObject)ruby.getKernel(), (IRubyObject[])new IRubyObject[]{iRubyObject2}, (Block)Block.NULL_BLOCK);
    }

    private static int translateStyle(ScalarStyle scalarStyle) {
        if (scalarStyle == null) {
            return 0;
        }
        switch (scalarStyle) {
            case PLAIN: {
                return 1;
            }
            case SINGLE_QUOTED: {
                return 2;
            }
            case DOUBLE_QUOTED: {
                return 3;
            }
            case LITERAL: {
                return 4;
            }
            case FOLDED: {
                return 5;
            }
        }
        return 0;
    }

    private static int translateFlowStyle(FlowStyle flowStyle) {
        switch (flowStyle) {
            case AUTO: {
                return 0;
            }
            case BLOCK: {
                return 1;
            }
        }
        return 2;
    }

    @JRubyMethod
    public IRubyObject mark(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        Event event = null;
        Parser parser = this.parser;
        if (parser != null) {
            event = parser.hasNext() ? parser.peekEvent() : this.event;
        }
        if (event == null) {
            return ((RubyClass)ruby.getClassFromPath("Psych::Parser::Mark")).newInstance(threadContext, (IRubyObject)RubyFixnum.zero((Ruby)ruby), (IRubyObject)RubyFixnum.zero((Ruby)ruby), (IRubyObject)RubyFixnum.zero((Ruby)ruby), Block.NULL_BLOCK);
        }
        Mark mark = (Mark)event.getStartMark().orElseThrow(RuntimeException::new);
        return ((RubyClass)ruby.getClassFromPath("Psych::Parser::Mark")).newInstance(threadContext, (IRubyObject)RubyFixnum.zero((Ruby)ruby), (IRubyObject)ruby.newFixnum(mark.getLine()), (IRubyObject)ruby.newFixnum(mark.getColumn()), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"max_aliases_for_collections="})
    public IRubyObject max_aliases_for_collections_set(IRubyObject iRubyObject) {
        this.loadSettingsBuilder.setMaxAliasesForCollections(iRubyObject.convertToInteger().getIntValue());
        return iRubyObject;
    }

    @JRubyMethod(name={"max_aliases_for_collections"})
    public IRubyObject max_aliases_for_collections(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.buildSettings().getMaxAliasesForCollections());
    }

    @JRubyMethod(name={"allow_duplicate_keys="})
    public IRubyObject allow_duplicate_keys_set(IRubyObject iRubyObject) {
        this.loadSettingsBuilder.setAllowDuplicateKeys(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod(name={"allow_duplicate_keys"})
    public IRubyObject allow_duplicate_keys(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.buildSettings().getAllowDuplicateKeys());
    }

    @JRubyMethod(name={"allow_recursive_keys="})
    public IRubyObject allow_recursive_keys_set(IRubyObject iRubyObject) {
        this.loadSettingsBuilder.setAllowRecursiveKeys(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod(name={"allow_recursive_keys"})
    public IRubyObject allow_recursive_keys(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.buildSettings().getAllowRecursiveKeys());
    }

    @JRubyMethod(name={"code_point_limit="})
    public IRubyObject code_point_limit_set(IRubyObject iRubyObject) {
        this.loadSettingsBuilder.setCodePointLimit(iRubyObject.convertToInteger().getIntValue());
        return iRubyObject;
    }

    @JRubyMethod(name={"code_point_limit"})
    public IRubyObject code_point_limit(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.buildSettings().getCodePointLimit());
    }

    private LoadSettings buildSettings() {
        return this.loadSettingsBuilder.build();
    }

    private static enum Call {
        path,
        event_location,
        start_stream,
        start_document,
        end_document,
        alias,
        scalar,
        start_sequence,
        end_sequence,
        start_mapping,
        end_mapping,
        end_stream;

    }
}

