/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import com.kenai.jffi.UnsafeMemoryIO;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class MemoryIO {
    final Foreign foreign = Foreign.getInstance();
    static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static MemoryIO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static MemoryIO getCheckedInstance() {
        return CheckedMemorySingletonHolder.INSTANCE;
    }

    MemoryIO() {
    }

    private static MemoryIO newMemoryIO() {
        try {
            if (Boolean.getBoolean("jffi.memory.checked")) {
                return MemoryIO.newNativeCheckedImpl();
            }
            return !Boolean.getBoolean("jffi.unsafe.disabled") && MemoryIO.isUnsafeAvailable() ? MemoryIO.newUnsafeImpl() : MemoryIO.newNativeImpl();
        }
        catch (Throwable t) {
            return MemoryIO.newNativeImpl();
        }
    }

    private static MemoryIO newNativeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newNativeImpl32() : MemoryIO.newNativeImpl64();
    }

    private static MemoryIO newNativeCheckedImpl() {
        return Foreign.isMemoryProtectionEnabled() ? new CheckedNativeImpl() : MemoryIO.newNativeImpl();
    }

    private static MemoryIO newNativeImpl32() {
        return new NativeImpl32();
    }

    private static MemoryIO newNativeImpl64() {
        return new NativeImpl64();
    }

    private static MemoryIO newUnsafeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newUnsafeImpl32() : MemoryIO.newUnsafeImpl64();
    }

    private static MemoryIO newUnsafeImpl32() {
        return new UnsafeMemoryIO.UnsafeMemoryIO32();
    }

    private static MemoryIO newUnsafeImpl64() {
        return new UnsafeMemoryIO.UnsafeMemoryIO64();
    }

    public abstract byte getByte(long var1);

    public abstract short getShort(long var1);

    public abstract int getInt(long var1);

    public abstract long getLong(long var1);

    public abstract float getFloat(long var1);

    public abstract double getDouble(long var1);

    public abstract long getAddress(long var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putShort(long var1, short var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putLong(long var1, long var3);

    public abstract void putFloat(long var1, float var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putAddress(long var1, long var3);

    public final void copyMemory(long src, long dst, long size2) {
        if (dst + size2 <= src || src + size2 <= dst) {
            this._copyMemory(src, dst, size2);
        } else {
            this.memmove(dst, src, size2);
        }
    }

    abstract void _copyMemory(long var1, long var3, long var5);

    public abstract void setMemory(long var1, long var3, byte var5);

    public abstract void memcpy(long var1, long var3, long var5);

    public abstract void memmove(long var1, long var3, long var5);

    public final void memset(long address2, int value2, long size2) {
        this.setMemory(address2, size2, (byte)value2);
    }

    public abstract long memchr(long var1, int var3, long var4);

    public abstract void putByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void getByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void putCharArray(long var1, char[] var3, int var4, int var5);

    public abstract void getCharArray(long var1, char[] var3, int var4, int var5);

    public abstract void putShortArray(long var1, short[] var3, int var4, int var5);

    public abstract void getShortArray(long var1, short[] var3, int var4, int var5);

    public abstract void putIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void getIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void putLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void getLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void putFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void getFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract void getDoubleArray(long var1, double[] var3, int var4, int var5);

    public final long allocateMemory(long size2, boolean clear2) {
        return Foreign.allocateMemory(size2, clear2) & ADDRESS_MASK;
    }

    public final void freeMemory(long address2) {
        Foreign.freeMemory(address2);
    }

    public abstract long getStringLength(long var1);

    public abstract byte[] getZeroTerminatedByteArray(long var1);

    public abstract byte[] getZeroTerminatedByteArray(long var1, int var3);

    @Deprecated
    public final byte[] getZeroTerminatedByteArray(long address2, long maxlen) {
        return this.getZeroTerminatedByteArray(address2, (int)maxlen);
    }

    public abstract void putZeroTerminatedByteArray(long var1, byte[] var3, int var4, int var5);

    public final long indexOf(long address2, byte value2) {
        long location = this.memchr(address2, value2, Integer.MAX_VALUE);
        return location != 0L ? location - address2 : -1L;
    }

    public final long indexOf(long address2, byte value2, int maxlen) {
        long location = this.memchr(address2, value2, maxlen);
        return location != 0L ? location - address2 : -1L;
    }

    public final ByteBuffer newDirectByteBuffer(long address2, int capacity) {
        return this.foreign.newDirectByteBuffer(address2, capacity);
    }

    public final long getDirectBufferAddress(Buffer buffer) {
        return this.foreign.getDirectBufferAddress(buffer);
    }

    private static void verifyAccessor(Class unsafeClass, Class primitive) throws NoSuchMethodException {
        String primitiveName = primitive.getSimpleName();
        String typeName = primitiveName.substring(0, 1).toUpperCase() + primitiveName.substring(1);
        Method get2 = unsafeClass.getDeclaredMethod("get" + typeName, Long.TYPE);
        if (!get2.getReturnType().equals(primitive)) {
            throw new NoSuchMethodException("Incorrect return type for " + get2.getName());
        }
        unsafeClass.getDeclaredMethod("put" + typeName, Long.TYPE, primitive);
    }

    static boolean isUnsafeAvailable() {
        try {
            Class[] primitiveTypes;
            Class<?> sunClass = Class.forName("sun.misc.Unsafe");
            for (Class type2 : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                MemoryIO.verifyAccessor(sunClass, type2);
            }
            sunClass.getDeclaredMethod("getAddress", Long.TYPE);
            sunClass.getDeclaredMethod("putAddress", Long.TYPE, Long.TYPE);
            sunClass.getDeclaredMethod("allocateMemory", Long.TYPE);
            sunClass.getDeclaredMethod("freeMemory", Long.TYPE);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static /* synthetic */ MemoryIO access$000() {
        return MemoryIO.newMemoryIO();
    }

    static /* synthetic */ MemoryIO access$100() {
        return MemoryIO.newNativeCheckedImpl();
    }

    private static final class SingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$000();

        private SingletonHolder() {
        }
    }

    private static final class CheckedMemorySingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$100();

        private CheckedMemorySingletonHolder() {
        }
    }

    private static final class CheckedNativeImpl
    extends MemoryIO {
        private CheckedNativeImpl() {
        }

        @Override
        public final byte getByte(long address2) {
            return Foreign.getByteChecked(address2);
        }

        @Override
        public final short getShort(long address2) {
            return Foreign.getShortChecked(address2);
        }

        @Override
        public final int getInt(long address2) {
            return Foreign.getIntChecked(address2);
        }

        @Override
        public final long getLong(long address2) {
            return Foreign.getLongChecked(address2);
        }

        @Override
        public final float getFloat(long address2) {
            return Foreign.getFloatChecked(address2);
        }

        @Override
        public final double getDouble(long address2) {
            return Foreign.getDoubleChecked(address2);
        }

        @Override
        public final void putByte(long address2, byte value2) {
            Foreign.putByteChecked(address2, value2);
        }

        @Override
        public final void putShort(long address2, short value2) {
            Foreign.putShortChecked(address2, value2);
        }

        @Override
        public final void putInt(long address2, int value2) {
            Foreign.putIntChecked(address2, value2);
        }

        @Override
        public final void putLong(long address2, long value2) {
            Foreign.putLongChecked(address2, value2);
        }

        @Override
        public final void putFloat(long address2, float value2) {
            Foreign.putFloatChecked(address2, value2);
        }

        @Override
        public final void putDouble(long address2, double value2) {
            Foreign.putDoubleChecked(address2, value2);
        }

        @Override
        public final void setMemory(long address2, long size2, byte value2) {
            Foreign.setMemoryChecked(address2, size2, value2);
        }

        @Override
        public final void _copyMemory(long src, long dst, long size2) {
            Foreign.copyMemoryChecked(src, dst, size2);
        }

        @Override
        public final long getAddress(long address2) {
            return Foreign.getAddressChecked(address2) & ADDRESS_MASK;
        }

        @Override
        public final void putAddress(long address2, long value2) {
            Foreign.putAddressChecked(address2, value2);
        }

        @Override
        public final void memcpy(long dst, long src, long size2) {
            Foreign.memcpyChecked(dst, src, size2);
        }

        @Override
        public final void memmove(long dst, long src, long size2) {
            Foreign.memmoveChecked(dst, src, size2);
        }

        @Override
        public final long memchr(long address2, int value2, long size2) {
            return Foreign.memchrChecked(address2, value2, size2);
        }

        @Override
        public final void putByteArray(long address2, byte[] data2, int offset2, int length2) {
            Foreign.putByteArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getByteArray(long address2, byte[] data2, int offset2, int length2) {
            Foreign.getByteArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void putCharArray(long address2, char[] data2, int offset2, int length2) {
            Foreign.putCharArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getCharArray(long address2, char[] data2, int offset2, int length2) {
            Foreign.getCharArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void putShortArray(long address2, short[] data2, int offset2, int length2) {
            Foreign.putShortArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getShortArray(long address2, short[] data2, int offset2, int length2) {
            Foreign.getShortArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void putIntArray(long address2, int[] data2, int offset2, int length2) {
            Foreign.putIntArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getIntArray(long address2, int[] data2, int offset2, int length2) {
            Foreign.getIntArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void putLongArray(long address2, long[] data2, int offset2, int length2) {
            Foreign.putLongArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getLongArray(long address2, long[] data2, int offset2, int length2) {
            Foreign.getLongArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void putFloatArray(long address2, float[] data2, int offset2, int length2) {
            Foreign.putFloatArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getFloatArray(long address2, float[] data2, int offset2, int length2) {
            Foreign.getFloatArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void putDoubleArray(long address2, double[] data2, int offset2, int length2) {
            Foreign.putDoubleArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final void getDoubleArray(long address2, double[] data2, int offset2, int length2) {
            Foreign.getDoubleArrayChecked(address2, data2, offset2, length2);
        }

        @Override
        public final long getStringLength(long address2) {
            return Foreign.strlenChecked(address2);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address2) {
            return Foreign.getZeroTerminatedByteArrayChecked(address2);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address2, int maxlen) {
            return Foreign.getZeroTerminatedByteArrayChecked(address2, maxlen);
        }

        @Override
        public final void putZeroTerminatedByteArray(long address2, byte[] data2, int offset2, int length2) {
            Foreign.putZeroTerminatedByteArrayChecked(address2, data2, offset2, length2);
        }
    }

    private static final class NativeImpl32
    extends NativeImpl {
        private NativeImpl32() {
        }

        @Override
        public final long getAddress(long address2) {
            return (long)Foreign.getInt(address2) & ADDRESS_MASK;
        }

        @Override
        public final void putAddress(long address2, long value2) {
            Foreign.putInt(address2, (int)value2);
        }
    }

    private static final class NativeImpl64
    extends NativeImpl {
        private NativeImpl64() {
        }

        @Override
        public final long getAddress(long address2) {
            return Foreign.getLong(address2);
        }

        @Override
        public final void putAddress(long address2, long value2) {
            Foreign.putLong(address2, value2);
        }
    }

    private static abstract class NativeImpl
    extends MemoryIO {
        private NativeImpl() {
        }

        @Override
        public final byte getByte(long address2) {
            return Foreign.getByte(address2);
        }

        @Override
        public final short getShort(long address2) {
            return Foreign.getShort(address2);
        }

        @Override
        public final int getInt(long address2) {
            return Foreign.getInt(address2);
        }

        @Override
        public final long getLong(long address2) {
            return Foreign.getLong(address2);
        }

        @Override
        public final float getFloat(long address2) {
            return Foreign.getFloat(address2);
        }

        @Override
        public final double getDouble(long address2) {
            return Foreign.getDouble(address2);
        }

        @Override
        public final void putByte(long address2, byte value2) {
            Foreign.putByte(address2, value2);
        }

        @Override
        public final void putShort(long address2, short value2) {
            Foreign.putShort(address2, value2);
        }

        @Override
        public final void putInt(long address2, int value2) {
            Foreign.putInt(address2, value2);
        }

        @Override
        public final void putLong(long address2, long value2) {
            Foreign.putLong(address2, value2);
        }

        @Override
        public final void putFloat(long address2, float value2) {
            Foreign.putFloat(address2, value2);
        }

        @Override
        public final void putDouble(long address2, double value2) {
            Foreign.putDouble(address2, value2);
        }

        @Override
        public final void setMemory(long address2, long size2, byte value2) {
            Foreign.setMemory(address2, size2, value2);
        }

        @Override
        public final void _copyMemory(long src, long dst, long size2) {
            Foreign.copyMemory(src, dst, size2);
        }

        @Override
        public final void memcpy(long dst, long src, long size2) {
            Foreign.memcpy(dst, src, size2);
        }

        @Override
        public final void memmove(long dst, long src, long size2) {
            Foreign.memmove(dst, src, size2);
        }

        @Override
        public final long memchr(long address2, int value2, long size2) {
            return Foreign.memchr(address2, value2, size2);
        }

        @Override
        public final void putByteArray(long address2, byte[] data2, int offset2, int length2) {
            Foreign.putByteArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getByteArray(long address2, byte[] data2, int offset2, int length2) {
            Foreign.getByteArray(address2, data2, offset2, length2);
        }

        @Override
        public final void putCharArray(long address2, char[] data2, int offset2, int length2) {
            Foreign.putCharArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getCharArray(long address2, char[] data2, int offset2, int length2) {
            Foreign.getCharArray(address2, data2, offset2, length2);
        }

        @Override
        public final void putShortArray(long address2, short[] data2, int offset2, int length2) {
            Foreign.putShortArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getShortArray(long address2, short[] data2, int offset2, int length2) {
            Foreign.getShortArray(address2, data2, offset2, length2);
        }

        @Override
        public final void putIntArray(long address2, int[] data2, int offset2, int length2) {
            Foreign.putIntArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getIntArray(long address2, int[] data2, int offset2, int length2) {
            Foreign.getIntArray(address2, data2, offset2, length2);
        }

        @Override
        public final void putLongArray(long address2, long[] data2, int offset2, int length2) {
            Foreign.putLongArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getLongArray(long address2, long[] data2, int offset2, int length2) {
            Foreign.getLongArray(address2, data2, offset2, length2);
        }

        @Override
        public final void putFloatArray(long address2, float[] data2, int offset2, int length2) {
            Foreign.putFloatArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getFloatArray(long address2, float[] data2, int offset2, int length2) {
            Foreign.getFloatArray(address2, data2, offset2, length2);
        }

        @Override
        public final void putDoubleArray(long address2, double[] data2, int offset2, int length2) {
            Foreign.putDoubleArray(address2, data2, offset2, length2);
        }

        @Override
        public final void getDoubleArray(long address2, double[] data2, int offset2, int length2) {
            Foreign.getDoubleArray(address2, data2, offset2, length2);
        }

        @Override
        public final long getStringLength(long address2) {
            return Foreign.strlen(address2);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address2) {
            return Foreign.getZeroTerminatedByteArray(address2);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address2, int maxlen) {
            return Foreign.getZeroTerminatedByteArray(address2, maxlen);
        }

        @Override
        public final void putZeroTerminatedByteArray(long address2, byte[] data2, int offset2, int length2) {
            Foreign.putZeroTerminatedByteArray(address2, data2, offset2, length2);
        }
    }
}

