/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.util.Collection;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.Attributes;

public class JRChartFactory
extends JRBaseFactory {
    private static final String ATTRIBUTE_isShowLegend = "isShowLegend";
    private static final String ATTRIBUTE_evaluationTime = "evaluationTime";
    private static final String ATTRIBUTE_evaluationGroup = "evaluationGroup";
    private static final String ATTRIBUTE_hyperlinkType = "hyperlinkType";
    private static final String ATTRIBUTE_hyperlinkTarget = "hyperlinkTarget";
    private static final String ATTRIBUTE_bookmarkLevel = "bookmarkLevel";
    private static final String ATTRIBUTE_customizerClass = "customizerClass";

    public Object createObject(Attributes atts) {
        String chartCustomizerClass;
        String bookmarkLevelAttr;
        Byte hyperlinkTarget;
        Byte hyperlinkType;
        Byte evaluationTime;
        JRXmlLoader xmlLoader = (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
        Collection groupEvaluatedCharts = xmlLoader.getGroupEvaluatedCharts();
        JRDesignChart chart = (JRDesignChart)this.digester.peek();
        String isShowLegend = atts.getValue(ATTRIBUTE_isShowLegend);
        if (isShowLegend != null && isShowLegend.length() > 0) {
            chart.setShowLegend(Boolean.valueOf(isShowLegend));
        }
        if ((evaluationTime = (Byte)JRXmlConstants.getEvaluationTimeMap().get(atts.getValue(ATTRIBUTE_evaluationTime))) != null) {
            chart.setEvaluationTime(evaluationTime);
        }
        if (chart.getEvaluationTime() == 5) {
            groupEvaluatedCharts.add(chart);
            String groupName = atts.getValue(ATTRIBUTE_evaluationGroup);
            if (groupName != null) {
                JRDesignGroup group = new JRDesignGroup();
                group.setName(groupName);
                chart.setEvaluationGroup(group);
            }
        }
        if ((hyperlinkType = (Byte)JRXmlConstants.getHyperlinkTypeMap().get(atts.getValue(ATTRIBUTE_hyperlinkType))) != null) {
            chart.setHyperlinkType(hyperlinkType);
        }
        if ((hyperlinkTarget = (Byte)JRXmlConstants.getHyperlinkTargetMap().get(atts.getValue(ATTRIBUTE_hyperlinkTarget))) != null) {
            chart.setHyperlinkTarget(hyperlinkTarget);
        }
        if ((bookmarkLevelAttr = atts.getValue(ATTRIBUTE_bookmarkLevel)) != null) {
            chart.setBookmarkLevel(Integer.parseInt(bookmarkLevelAttr));
        }
        if ((chartCustomizerClass = atts.getValue(ATTRIBUTE_customizerClass)) != null && chartCustomizerClass.length() > 0) {
            chart.setCustomizerClass(chartCustomizerClass);
        }
        return chart;
    }

    public static class JRChartSubtitleFactory
    extends JRBaseFactory {
        private static final String ATTRIBUTE_color = "color";

        public Object createObject(Attributes atts) {
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            String color = atts.getValue(ATTRIBUTE_color);
            if (color != null && color.length() > 0) {
                char firstChar = color.charAt(0);
                if (firstChar == '#') {
                    chart.setSubtitleColor(new Color(Integer.parseInt(color.substring(1), 16)));
                } else if ('0' <= firstChar && firstChar <= '9') {
                    chart.setSubtitleColor(new Color(Integer.parseInt(color)));
                } else if (JRXmlConstants.getColorMap().containsKey(color)) {
                    chart.setSubtitleColor((Color)JRXmlConstants.getColorMap().get(color));
                } else {
                    chart.setSubtitleColor(Color.black);
                }
            }
            return chart;
        }
    }

    public static class JRChartTitleFactory
    extends JRBaseFactory {
        private static final String ATTRIBUTE_position = "position";
        private static final String ATTRIBUTE_color = "color";

        public Object createObject(Attributes atts) {
            String color;
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            String position = atts.getValue(ATTRIBUTE_position);
            if (position != null && position.length() > 0) {
                chart.setTitlePosition((Byte)JRXmlConstants.getChartTitlePositionMap().get(position));
            }
            if ((color = atts.getValue(ATTRIBUTE_color)) != null && color.length() > 0) {
                char firstChar = color.charAt(0);
                if (firstChar == '#') {
                    chart.setTitleColor(new Color(Integer.parseInt(color.substring(1), 16)));
                } else if ('0' <= firstChar && firstChar <= '9') {
                    chart.setTitleColor(new Color(Integer.parseInt(color)));
                } else if (JRXmlConstants.getColorMap().containsKey(color)) {
                    chart.setTitleColor((Color)JRXmlConstants.getColorMap().get(color));
                } else {
                    chart.setTitleColor(Color.black);
                }
            }
            return chart;
        }
    }
}

