/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_as extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09f0\u09ac \u0986\u09ae\u09bf\u09f0\u09be\u09a4 \u09a1\u09bf\u09f0\u09b9\u09c7\u09ae" },
            { "afn", "\u0986\u09ab\u0997\u09be\u09a8 \u0986\u09ab\u0997\u09be\u09a8\u09c0" },
            { "all", "\u0986\u09b2\u09ac\u09c7\u09a8\u09c0\u09af\u09bc \u09b2\u09c7\u0995" },
            { "amd", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09cd\u09f0\u09be\u09ae" },
            { "ang", "\u09a8\u09c7\u09a1\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1\u099b \u098f\u09a3\u09cd\u099f\u09bf\u09b2\u09bf\u09af\u09bc\u09c7\u09a8 \u0997\u09bf\u09b2\u09cd\u09a1\u09be\u09f0" },
            { "aoa", "\u098f\u0982\u0997\u09cb\u09b2\u09be\u09a8 \u0995\u09cb\u09f1\u09be\u099e\u09cd\u099c\u09be" },
            { "ars", "\u0986\u09f0\u09cd\u099c\u09c7\u09a3\u09cd\u099f\u09be\u0987\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "aud", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "awg", "\u0986\u09f0\u09c1\u09ac\u09be\u09a8 \u09ab\u09cd\u09b2\u2019\u09f0\u09bf\u09a8" },
            { "azn", "\u0986\u099c\u09c7\u09f0\u09ac\u09be\u0987\u099c\u09be\u09a8\u09c0 \u09ae\u09be\u09a8\u09be\u09a4" },
            { "bam", "\u09ac\u2019\u099b\u09a8\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09b9\u09be\u09f0\u09cd\u099c\u09c7\u0997\u2019\u09ad\u09bf\u09a8\u09be \u0995\u09a8\u09ad\u09be\u09f0\u09cd\u099f\u09bf\u09ac\u09cd\u200c\u09b2 \u09ae\u09be\u09f0\u09cd\u0995" },
            { "bbd", "\u09ac\u09be\u09f0\u09cd\u09ac\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "bdt", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6\u09c0 \u099f\u09be\u0995\u09be" },
            { "bgn", "\u09ac\u09c1\u09b2\u0997\u09c7\u09f0\u09c0\u09af\u09bc \u09b2\u09c7\u09ad" },
            { "bhd", "\u09ac\u09be\u09b9\u09f0\u09c7\u0987\u09a8\u09c0 \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "bif", "\u09ac\u09c1\u09f0\u09c1\u09a3\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "bmd", "\u09ac\u09be\u09f0\u09cd\u09ae\u09c1\u09a1\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "bnd", "\u09ac\u09cd\u09f0\u09c1\u09a8\u09c7\u0987 \u09a1\u09b2\u09be\u09f0" },
            { "bob", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8\u09cb" },
            { "brl", "\u09ac\u09cd\u09f0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "bsd", "\u09ac\u09be\u09b9\u09be\u09ae\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "btn", "\u09ad\u09c1\u099f\u09be\u09a8\u09c0 \u09a8\u0982\u0997\u09b2\u099f\u09cd\u09f0\u09be\u09ae" },
            { "bwp", "\u09ac\u2019\u099f\u099a\u09cb\u09f1\u09be\u09a8\u09be\u09a8 \u09aa\u09c1\u09b2\u09be" },
            { "byn", "\u09ac\u09c7\u09b2\u09be\u09f0\u09c1\u099b\u09c0\u09af\u09bc \u09f0\u09c1\u09ac\u09c7\u09b2" },
            { "bzd", "\u09ac\u09c7\u09b2\u09bf\u099c \u09a1\u09b2\u09be\u09f0" },
            { "cad", "\u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "cdf", "\u0995\u0982\u0997\u09cb \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "chf", "\u099a\u09c1\u0987\u099b \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "clp", "\u099a\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "cnh", "\u099a\u09c0\u09a8\u09be \u0987\u0989\u09f1\u09be\u09a8 (\u0985\u09ab\u09b6\u09cd\u09ac\u2019\u09f0)" },
            { "cny", "\u099a\u09c0\u09a8\u09be \u0987\u0989\u09f1\u09be\u09a8" },
            { "cop", "\u0995\u09b2\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "crc", "\u0995\u09cb\u09b7\u09cd\u099f\u09be \u09f0\u09bf\u0995\u09be\u09a8 \u0995\u09cb\u09b2\u09a8" },
            { "cuc", "\u0995\u09bf\u0989\u09ac\u09be\u09a8 \u09f0\u09c2\u09aa\u09be\u09a8\u09cd\u09a4\u09f0\u09af\u09cb\u0997\u09cd\u09af \u09aa\u09c7\u099b\u09cb" },
            { "cup", "\u0995\u09bf\u0989\u09ac\u09be\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "cve", "\u0995\u09c7\u09aa \u09ad\u09be\u09f0\u09cd\u09a6\u09c7 \u098f\u099b\u0995\u09c1\u09a1\u09cb" },
            { "czk", "\u099a\u09c7\u0995 \u0995\u09cb\u09f0\u09c1\u09a8\u09be" },
            { "djf", "\u099c\u09bf\u09ac\u09c1\u099f\u09bf \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "dkk", "\u09a1\u09c7\u09a8\u09bf\u099a \u0995\u09cd\u09f0\u09cb\u09a8" },
            { "dop", "\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "dzd", "\u0986\u09b2\u099c\u09c7\u09f0\u09c0\u09af\u09bc \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "egp", "\u0987\u099c\u09bf\u09aa\u09cd\u09a4\u09f0 \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "ern", "\u098f\u09f0\u09bf\u099f\u09cd\u09f0\u09bf\u09af\u09bc\u09a8 \u09a8\u09be\u0995\u09cd\u200c\u09ab\u09be" },
            { "etb", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09bf\u09f0" },
            { "eur", "\u0987\u0989\u09f0\u09cb" },
            { "fjd", "\u09ab\u09bf\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "fkp", "\u09ab\u0995\u09b2\u09c7\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c\u09f0 \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "gbp", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "gel", "\u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09b2\u09be\u09f0\u09bf" },
            { "ghs", "\u0998\u09be\u09a8\u09be\u09f0 \u099a\u09c7\u09a1\u09bf" },
            { "gip", "\u099c\u09bf\u09ac\u09cd\u09f0\u09be\u09b2\u09cd\u099f\u09f0 \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "gmd", "\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be \u09a1\u09be\u09b2\u09be\u099b\u09bf" },
            { "gnf", "\u0997\u09bf\u09a8\u09bf \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "gtq", "\u0997\u09c1\u09f1\u09be\u099f\u09c7\u09ae\u09be\u09b2\u09be \u0995\u09c1\u09f1\u09c7\u09ce\u099c\u09be\u09b2" },
            { "gyd", "\u0997\u09be\u09af\u09bc\u09be\u09a8\u09bf\u099c \u09a1\u09b2\u09be\u09f0" },
            { "hkd", "\u09b9\u0982 \u0995\u0982 \u09a1\u09b2\u09be\u09f0" },
            { "hnl", "\u09b9\u09cb\u09a8\u09cd\u09a6\u09c1\u09f0\u09be\u09a8 \u09b2\u09c7\u09ae\u09cd\u09aa\u09bf\u09f0\u09be" },
            { "hrk", "\u0995\u09cd\u09f0\u09cb\u09f1\u09c7\u099b\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09c1\u09a8\u09be" },
            { "htg", "\u09b9\u09be\u0987\u099f\u09bf\u09af\u09bc\u09be\u09a8 \u0997\u09cc\u09f0\u09cd\u09a1" },
            { "huf", "\u09b9\u09be\u0982\u0997\u09c7\u09f0\u09c0\u09af\u09bc\u09be\u09a8 \u09ab\u2019\u09f0\u09bf\u09a3\u09cd\u099f" },
            { "idr", "\u0987\u09a3\u09cd\u09a1\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09c1\u09aa\u09bf\u09af\u09bc\u09be\u09b9" },
            { "ils", "\u0987\u099c\u09f0\u09be\u0987\u09b2\u09c0 \u09a8\u09bf\u0989 \u09b6\u09cd\u09ac\u09c7\u0995\u09c7\u09b2" },
            { "inr", "\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u09f0\u09c1\u09aa\u09c0" },
            { "iqd", "\u0987\u09f0\u09be\u0995\u09c0 \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "irr", "\u0987\u09f0\u09be\u09a8\u09c0\u09af\u09bc\u09be\u09a8 \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "isk", "\u0986\u0987\u099a\u09b2\u09c7\u09a3\u09cd\u09a1\u09bf\u0995 \u0995\u09cd\u09f0\u09cb\u09a8\u09be" },
            { "jmd", "\u099c\u09be\u09ae\u09be\u0987\u0995\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "jod", "\u099c\u09f0\u09cd\u09a1\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "jpy", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u09af\u09bc\u09c7\u09a8" },
            { "kes", "\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b6\u09cd\u09ac\u09bf\u09b2\u09bf\u0982" },
            { "kgs", "\u0995\u09bf\u09f0\u09cd\u0997\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09c0 \u099b\u09cb\u09ae" },
            { "khr", "\u0995\u09c7\u09ae\u09cd\u09ac\u2019\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "kmf", "\u0995\u2019\u09ae\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "kpw", "\u0989\u09a4\u09cd\u09a4\u09f0 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09f0 \u0993\u09f1\u09be\u09a8" },
            { "krw", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09f0 \u0993\u09f1\u09be\u09a8" },
            { "kwd", "\u0995\u09c1\u09f1\u09c7\u0987\u099f\u09bf \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "kyd", "\u0995\u09c7\u0987\u09ae\u09c7\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c\u09f0 \u09a1\u09b2\u09be\u09f0" },
            { "kzt", "\u0995\u09be\u099c\u09be\u0996\u09b8\u09cd\u09a4\u09be\u09a8\u09c0 \u09a4\u09c7\u099e\u09cd\u099c" },
            { "lak", "\u09b2\u09be\u0993\u099a\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09bf\u09aa" },
            { "lbp", "\u09b2\u09c7\u09ac\u09be\u09a8\u09c0\u099c \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "lkr", "\u09b6\u09cd\u09f0\u09c0\u09b2\u0982\u0995\u09be\u09a8 \u09f0\u09c1\u09aa\u09c0" },
            { "lrd", "\u09b2\u09be\u0987\u09ac\u09c7\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "lyd", "\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "mad", "\u09ae\u09f0\u09cb\u0995\u09cd\u0995\u09be\u09a8 \u09a1\u09bf\u09f0\u09b9\u09be\u09ae" },
            { "mdl", "\u09ae\u09cb\u09b2\u09a1\u09cb\u09ad\u09be\u09a8 \u09b2\u09c7\u0989" },
            { "mga", "\u09ae\u09be\u09b2\u09be\u0997\u09be\u099b\u09c0 \u098f\u09f0\u09bf\u09af\u09bc\u09be\u09f0\u09c0" },
            { "mkd", "\u09ae\u09c7\u099a\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc \u09a1\u09c7\u09a8\u09be\u09f0" },
            { "mmk", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0 \u0995\u09bf\u09af\u09bc\u09be\u099f" },
            { "mnt", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u099f\u09c1\u09f0\u09cd\u0997\u09bf\u0995" },
            { "mop", "\u09ae\u09c7\u0995\u09be\u09a8\u09c0\u099c \u09aa\u09be\u099f\u09be\u0995\u09be" },
            { "mro", "\u09ae\u2019\u09f0\u09bf\u099f\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u0994\u0997\u09c1\u0987\u09af\u09bc\u09be (1973\u20132017)" },
            { "mru", "\u09ae\u2019\u09f0\u09bf\u099f\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u0994\u0997\u09c1\u0987\u09af\u09bc\u09be" },
            { "mur", "\u09ae\u09f0\u09bf\u099a\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09c1\u09aa\u09c0" },
            { "mvr", "\u09ae\u09be\u09b2\u09a1\u09bf\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09c1\u09ab\u09bf\u09af\u09bc\u09be" },
            { "mwk", "\u09ae\u09be\u09b2\u09be\u0989\u0987\u09af\u09bc\u09be\u09a8 \u0995\u09cb\u09f1\u09be\u099a\u09be" },
            { "mxn", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "myr", "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09c7\u099a\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09bf\u0982\u0997\u09bf\u099f" },
            { "mzn", "\u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995\u09be\u09a8 \u09ae\u09c7\u099f\u09bf\u0995\u09b2" },
            { "nad", "\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "ngn", "\u09a8\u09be\u0987\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09be\u0987\u09f0\u09be" },
            { "nio", "\u09a8\u09bf\u0995\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09be\u09a8 \u0995\u09cb\u09f0\u09cd\u09a1\u09cb\u09ac\u09be" },
            { "nok", "\u09a8\u09f0\u09f1\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09f0\u09cb\u09a8" },
            { "npr", "\u09a8\u09c7\u09aa\u09be\u09b2\u09c0 \u09f0\u09c1\u09aa\u09c0" },
            { "nzd", "\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09c7\u09a3\u09cd\u09a1 \u09a1\u09b2\u09be\u09f0" },
            { "omr", "\u0993\u09ae\u09be\u09a8\u09bf \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "pab", "\u09aa\u09be\u09a8\u09be\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09be\u09b2\u09cd\u09ac\u09cb\u09f1\u09be" },
            { "pen", "\u09aa\u09c7\u09f0\u09c1\u09ad\u09bf\u09af\u09bc\u09be\u09a8 \u099b\u2019\u09b2" },
            { "pgk", "\u09aa\u09be\u09aa\u09c1\u09f1\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf \u0995\u09bf\u09a8\u09be" },
            { "php", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09bf\u09a8 \u09aa\u09c7\u0987\u099b\u2019" },
            { "pkr", "\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09c0 \u09f0\u09c1\u09aa\u09c0" },
            { "pln", "\u09aa\u2019\u09b2\u09bf\u099a \u099c\u09cb\u09b2\u09cd\u099f\u09c0" },
            { "pyg", "\u09aa\u09be\u09f0\u09be\u0997\u09c1\u09af\u09bc\u09be\u09a8 \u0997\u09c1\u09f1\u09be\u09f0\u09be\u09a8\u09bf" },
            { "qar", "\u0995\u09be\u099f\u09be\u09f0\u09bf \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "ron", "\u09f0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc \u09b2\u09c7\u0989" },
            { "rsd", "\u099a\u09be\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "rub", "\u09f0\u09be\u099b\u09bf\u09af\u09bc\u09be\u09a8 \u09f0\u09c1\u09ac\u09cd\u200c\u09b2" },
            { "rwf", "\u09f0\u09cb\u09f1\u09be\u09a8\u09cd\u09a6\u09be\u09a8 \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "sar", "\u099a\u09cc\u09a1\u09bf \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "sbd", "\u099a\u09cb\u09b2\u09cb\u09ae\u09cb\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c\u09f0 \u09a1\u09b2\u09be\u09f0" },
            { "scr", "\u099b\u09c7\u099a\u09c7\u09b2\u09f1\u09be \u09f0\u09c1\u09aa\u09c0" },
            { "sdg", "\u099a\u09c1\u09a1\u09be\u09a8\u09c0 \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "sek", "\u099a\u09c1\u0987\u09a1\u09bf\u099b \u0995\u09cd\u09f0\u09cb\u09a8\u09be" },
            { "sgd", "\u099b\u09bf\u0982\u0997\u09be\u09aa\u09c1\u09f0 \u09a1\u09b2\u09be\u09f0" },
            { "shp", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "sll", "\u099a\u09bf\u09af\u09bc\u09c7\u09f0\u09be \u09b2\u09bf\u0985\u2019\u09a8\u09f0 \u09b2\u09bf\u0985\u2019\u09a8" },
            { "sos", "\u099a\u09cb\u09ae\u09be\u09b2\u09bf \u09b6\u09cd\u09ac\u09bf\u09b2\u09bf\u0982" },
            { "srd", "\u099b\u09c1\u09f0\u09bf\u09a8\u09be\u09ae\u09c0 \u09a1\u09b2\u09be\u09f0" },
            { "ssp", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c1\u09a1\u09be\u09a8\u09c0\u099c \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "std", "\u099a\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u0986\u09f0\u09c1 \u09aa\u09cd\u09f0\u09bf\u09a8\u099a\u09bf\u09aa\u09c7 \u09a1\u09cb\u09ac\u09cd\u200c\u09f0\u09be (1977\u20132017)" },
            { "stn", "\u099a\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u0986\u09f0\u09c1 \u09aa\u09cd\u09f0\u09bf\u09a8\u099a\u09bf\u09aa\u09c7 \u09a1\u09cb\u09ac\u09cd\u200c\u09f0\u09be" },
            { "syp", "\u099a\u09bf\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09be\u0989\u09a3\u09cd\u09a1" },
            { "szl", "\u09b8\u09cd\u09ac\u09be\u099c\u09bf \u09b2\u09bf\u09b2\u09c7\u0982\u0997\u09c7\u09a8\u09bf" },
            { "thb", "\u09a5\u09be\u0987 \u09ac\u09be\u09a4" },
            { "tjs", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09c0 \u099b\u09cb\u09ae\u09a8\u09bf" },
            { "tmt", "\u09a4\u09c1\u09f0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09c0 \u09ae\u09be\u09a8\u09be\u09a4" },
            { "tnd", "\u099f\u09c1\u09a8\u09bf\u099a\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09bf\u09a8\u09be\u09f0" },
            { "top", "\u099f\u0982\u0997\u09be\u09a8 \u09aa\u09be\u0986\u0982\u0997\u09be" },
            { "try", "\u09a4\u09c1\u09f0\u09cd\u0995\u09c0\u09f0 \u09b2\u09bf\u09f0\u09be" },
            { "ttd", "\u099f\u09cd\u09f0\u09bf\u09a8\u09bf\u09a1\u09be\u09a1 \u0986\u09f0\u09c1 \u099f\u09cb\u09ac\u09be\u0997\u09cb \u09a1\u09b2\u09be\u09f0" },
            { "twd", "\u09a8\u09bf\u0989 \u099f\u09be\u0987\u09f1\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "tzs", "\u099f\u09be\u09a8\u099c\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8 \u09b6\u09cd\u09ac\u09bf\u09b2\u09bf\u0982" },
            { "uah", "\u0987\u0989\u0995\u09cd\u09f0\u09c7\u0987\u09a8\u09c0\u09af\u09bc \u09b9\u09c3\u09ad\u09a8\u09bf\u09af\u09bc\u09be" },
            { "ugx", "\u0989\u0997\u09be\u09a3\u09cd\u09a1\u09be\u09a8 \u09b6\u09cd\u09ac\u09bf\u09b2\u09bf\u0982" },
            { "usd", "\u0987\u0989. \u098f\u099b. \u09a1\u09b2\u09be\u09f0" },
            { "uyu", "\u0989\u09f0\u09c1\u0997\u09c1\u09f1\u09c7\u09af\u09bc\u09be\u09a8 \u09aa\u09c7\u099b\u09cb" },
            { "uzs", "\u0989\u099c\u09ac\u09c7\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8\u09c0 \u099b\u09cb\u09ae" },
            { "vef", "\u09ad\u09c7\u09a8\u09bf\u099c\u09c1\u09f1\u09c7\u09b2\u09be\u09a8 \u09ac\u09b2\u09bf\u09ad\u09be\u09f0" },
            { "vnd", "\u09ad\u09bf\u09af\u09bc\u09c7\u099f\u09a8\u09be\u09ae\u09c0\u099c \u09a1\u0982" },
            { "vuv", "\u09ad\u09be\u09a8\u09be\u099f\u09c1\u09f0 \u09ad\u09be\u099f\u09c1" },
            { "wst", "\u099b\u09be\u09ae\u09cb\u09f1\u09be\u09a8 \u099f\u09be\u09b2\u09be" },
            { "xaf", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be\u09a8 CFA \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "xcd", "\u0987\u09b7\u09cd\u099f \u0995\u09c7\u09f0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a1\u09b2\u09be\u09f0" },
            { "xof", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be\u09a8 CFA \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "xpf", "CFP \u09ab\u09cd\u09f0\u09c7\u0982\u0995" },
            { "xxx", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u09ae\u09c1\u09a6\u09cd\u09f0\u09be" },
            { "yer", "\u09af\u09bc\u09c7\u09ae\u09c7\u09a8\u09c0 \u09f0\u09bf\u09af\u09bc\u09c7\u09b2" },
            { "zar", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be\u09f0 \u09f0\u09be\u09a3\u09cd\u09a1" },
            { "zmw", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cb\u09f1\u09be\u099a\u09be" },
        };
        return data;
    }
}
