/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

public class NamespaceReducer
extends ProxyReceiver
implements NamespaceResolver {
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;
    private boolean[] disinheritStack = new boolean[50];
    private int[] pendingUndeclarations = null;

    public NamespaceReducer() {
    }

    public NamespaceReducer(Receiver base) {
        this.setUnderlyingReceiver(base);
        if (this.pipelineConfiguration == null) {
            this.pipelineConfiguration = base.getPipelineConfiguration();
        }
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        if (this.depth > 0 && this.disinheritStack[this.depth - 1]) {
            this.pendingUndeclarations = new int[this.namespacesSize];
            System.arraycopy(this.namespaces, 0, this.pendingUndeclarations, 0, this.namespacesSize);
        } else {
            this.pendingUndeclarations = null;
        }
        this.countStack[this.depth] = 0;
        boolean bl = this.disinheritStack[this.depth] = (properties & 0x80) != 0;
        if (++this.depth >= this.countStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, newstack, 0, this.depth);
            boolean[] disStack2 = new boolean[this.depth * 2];
            System.arraycopy(this.disinheritStack, 0, disStack2, 0, this.depth);
            this.countStack = newstack;
            this.disinheritStack = disStack2;
        }
        if ((properties & 0x40) == 0) {
            this.namespace(this.getNamePool().allocateNamespaceCode(nameCode), 0);
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.isNeeded(namespaceCode)) {
            this.addToStack(namespaceCode);
            int n = this.depth - 1;
            this.countStack[n] = this.countStack[n] + 1;
            this.nextReceiver.namespace(namespaceCode, properties);
        }
    }

    private boolean isNeeded(int nscode) {
        if (nscode == 65537) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            for (int p = 0; p < this.pendingUndeclarations.length; ++p) {
                if (nscode >> 16 != this.pendingUndeclarations[p] >> 16) continue;
                this.pendingUndeclarations[p] = -1;
            }
        }
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] == nscode) {
                return false;
            }
            if (this.namespaces[i] >> 16 != nscode >> 16) continue;
            return true;
        }
        return nscode != 0;
    }

    private void addToStack(int nscode) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] newlist = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, newlist, 0, this.namespacesSize);
            this.namespaces = newlist;
        }
        this.namespaces[this.namespacesSize++] = nscode;
    }

    public void startContent() throws XPathException {
        if (this.pendingUndeclarations != null) {
            for (int i = 0; i < this.pendingUndeclarations.length; ++i) {
                int nscode = this.pendingUndeclarations[i];
                if (nscode == -1) continue;
                this.namespace(nscode & 0xFFFF0000, 0);
            }
        }
        this.pendingUndeclarations = null;
        this.nextReceiver.startContent();
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        this.namespacesSize -= this.countStack[this.depth];
        this.nextReceiver.endElement();
    }

    protected short getURICode(short prefixCode) {
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] >> 16 != prefixCode) continue;
            return (short)(this.namespaces[i] & 0xFFFF);
        }
        if (prefixCode == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NamePool pool = this.getNamePool();
        if (!(prefix != null && prefix.length() != 0 || useDefault)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short prefixCode = pool.getCodeForPrefix(prefix);
        short uriCode = this.getURICode(prefixCode);
        if (uriCode == -1) {
            return null;
        }
        return pool.getURIFromURICode(uriCode);
    }

    public Iterator iteratePrefixes() {
        NamePool pool = this.getNamePool();
        ArrayList<String> prefixes = new ArrayList<String>(this.namespacesSize);
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String prefix = pool.getPrefixFromNamespaceCode(this.namespaces[i]);
            if (prefixes.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }
}

