/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.no;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.no.NorwegianMinimalStemFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class NorwegianMinimalStemFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "norwegianMinimalStem";
    private final int flags;

    public NorwegianMinimalStemFilterFactory(Map<String, String> args) {
        super(args);
        String variant = this.get(args, "variant");
        if (variant == null || "nb".equals(variant)) {
            this.flags = 1;
        } else if ("nn".equals(variant)) {
            this.flags = 2;
        } else if ("no".equals(variant)) {
            this.flags = 3;
        } else {
            throw new IllegalArgumentException("invalid variant: " + variant);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new NorwegianMinimalStemFilter(input, this.flags);
    }
}

