/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.services.ec2.model.VpcEndpoint;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateVpcEndpoint
extends BaseCmd {
    public static final String[] VPC_ID_DESC = new String[]{"The ID of the VPC in which the endpoint will be used."};
    public static final String[] SERVICE_NAME_DESC = new String[]{"The name of the AWS service to which you are creating the endpoint."};
    public static final String[] POLICY_DOCUMENT_FILE_DESC = new String[]{"Specifies the file containing the policy to associate with the endpoint.", "If none is specified, a default policy is attached that allows access to the specified service."};
    public static final String[] ROUTE_TABLE_IDS_DESC = new String[]{"One or more route table IDs."};

    public CreateVpcEndpoint(String[] args) {
        super("ec2cve", "ec2-create-vpc-endpoint");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)CreateVpcEndpoint.joinDescription(VPC_ID_DESC));
        o.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"service-name");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SERVICE_NAME");
        OptionBuilder.withDescription((String)CreateVpcEndpoint.joinDescription(SERVICE_NAME_DESC));
        o.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"policy-document-file");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"POLICY_DOCUMENT_FILE");
        OptionBuilder.withDescription((String)CreateVpcEndpoint.joinDescription(POLICY_DOCUMENT_FILE_DESC));
        o.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"route-table");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ROUTE_TABLE");
        OptionBuilder.withDescription((String)CreateVpcEndpoint.joinDescription(ROUTE_TABLE_IDS_DESC));
        o.addOption(OptionBuilder.create((String)"r"));
        o.addOption(CreateVpcEndpoint.createOptionWithArgs(null, "client-token", CLIENT_TOKEN_DESC, "TOKEN"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "-c VPC -s SERVICE_NAME (-p POLICY_DOCUMENT_FILE) (-r ROUTE_TABLE (, -r ROUTE_TABLE)) (CLIENT_TOKEN)";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a VPC endpoint for a specified AWS service. An endpoint enables you to create a private connection between your VPC and another AWS service in your account. You can specify a policy to attach to the endpoint that will control access to the service from your VPC. You can also specify the VPC route tables that will be used by the endpoint.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
        this.printOption("service-name");
        this.printOption("policy-document-file");
        this.printOption("route-table");
        this.printOption("client-token");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("vpc");
        this.assertOptionSet("service-name");
        this.warnIfTooManyNonOptions();
        String vpcId = this.getOptionValue("vpc");
        String serviceName = this.getOptionValue("service-name");
        String policyDocument = this.readPolicyDocument(this.getOptionValue("policy-document-file"));
        String[] routeTableIds = this.getOptionValues("route-table");
        String clientToken = this.getOptionValue("client-token");
        RequestResultPair result = jec2.createVpcEndpoint(vpcId, serviceName, routeTableIds, policyDocument, clientToken);
        out.outputVpcEndpoint(System.out, (VpcEndpoint)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new CreateVpcEndpoint(args).invoke();
    }
}

