"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLDataSource = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PPLDataSource {
  constructor(pplDataSource, dataType) {
    this.pplDataSource = pplDataSource;
    this.dataType = dataType;

    _defineProperty(this, "addStatsMapping", () => {
      var _visData$metadata;

      const visData = this.pplDataSource;
      /**
       * Add vis mapping for runtime fields
       * json data structure added to response will be
       * [{
       *  agent: "mozilla",
       *  avg(bytes): 5756
       *  ...
       * }, {
       *  agent: "MSIE",
       *  avg(bytes): 5605
       *  ...
       * }, {
       *  agent: "chrome",
       *  avg(bytes): 5648
       *  ...
       * }] 
       */

      let res = [];

      if (visData !== null && visData !== void 0 && (_visData$metadata = visData.metadata) !== null && _visData$metadata !== void 0 && _visData$metadata.fields) {
        const queriedFields = visData.metadata.fields;

        for (let i = 0; i < visData.size; i++) {
          const entry = {};
          queriedFields.map(field => {
            const statsDataSet = visData === null || visData === void 0 ? void 0 : visData.data;
            entry[field.name] = statsDataSet[field.name][i];
          });
          res.push(entry);
        }

        visData['jsonData'] = res;
      }
    });

    _defineProperty(this, "addSchemaRowMapping", () => {
      const pplRes = this.pplDataSource;
      const data = [];

      _lodash.default.forEach(pplRes.datarows, row => {
        const record = {};

        for (let i = 0; i < pplRes.schema.length; i++) {
          const cur = pplRes.schema[i];

          if (typeof row[i] === 'object') {
            record[cur.name] = JSON.stringify(row[i]);
          } else if (typeof row[i] === 'boolean') {
            record[cur.name] = row[i].toString();
          } else {
            record[cur.name] = row[i];
          }
        }

        data.push(record);
      });

      pplRes['jsonData'] = data;
    });

    _defineProperty(this, "getDataSource", () => this.pplDataSource);

    if (this.dataType === 'jdbc') {
      this.addSchemaRowMapping();
    } else if (this.dataType === 'viz') {
      this.addStatsMapping();
    }
  }

}

exports.PPLDataSource = PPLDataSource;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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