"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;

var _operators = require("rxjs/operators");

var _clusters = require("./clusters");

var _services = require("./services");

var _routes = require("../server/routes");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "globalConfig$", void 0);

    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }

  async setup(core) {
    this.logger.debug('customImportMap: Setup');
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig); // Initialize services

    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter(); // Register server side APIs

    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router);
    return {};
  }

  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }

  stop() {}

}

exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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