/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActivityRecordSearchTerm {
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d+)(?:-(\\d+)?(?:-(\\d+)?)?)?");
    private static final int YEAR_GROUP = 1;
    private static final int MONTH_GROUP = 2;
    private static final int DAY_GROUP = 3;
    private final Date startDate;
    private final Date endDate;
    private final String term;

    private static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    private static Calendar getEndOfYear(Calendar calendar) {
        Calendar endOfYear = Calendar.getInstance();
        endOfYear.clear();
        endOfYear.set(1, calendar.get(1) + 1);
        endOfYear.add(14, -1);
        return endOfYear;
    }

    private static Calendar getEndOfMonth(Calendar calendar) {
        Calendar endOfMonth = Calendar.getInstance();
        endOfMonth.clear();
        endOfMonth.set(1, calendar.get(1));
        endOfMonth.set(2, calendar.get(2));
        endOfMonth.add(2, 1);
        endOfMonth.add(14, -1);
        return endOfMonth;
    }

    private static Calendar getEndOfDay(Calendar calendar) {
        Calendar endOfMonth = Calendar.getInstance();
        endOfMonth.clear();
        endOfMonth.set(1, calendar.get(1));
        endOfMonth.set(2, calendar.get(2));
        endOfMonth.set(5, calendar.get(5));
        endOfMonth.add(5, 1);
        endOfMonth.add(14, -1);
        return endOfMonth;
    }

    public ActivityRecordSearchTerm(String term) {
        if (term == null) {
            throw new NullPointerException("Search terms may not be null");
        }
        this.term = term;
        Matcher matcher = DATE_PATTERN.matcher(term);
        if (matcher.matches()) {
            String year = matcher.group(1);
            String month = matcher.group(2);
            String day = matcher.group(3);
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.clear();
            startCalendar.set(Integer.parseInt(year), ActivityRecordSearchTerm.parseInt(month, 1) - 1, ActivityRecordSearchTerm.parseInt(day, 1));
            Calendar endCalendar = month == null ? ActivityRecordSearchTerm.getEndOfYear(startCalendar) : (day == null ? ActivityRecordSearchTerm.getEndOfMonth(startCalendar) : ActivityRecordSearchTerm.getEndOfDay(startCalendar));
            this.startDate = startCalendar.getTime();
            this.endDate = endCalendar.getTime();
        } else {
            this.startDate = null;
            this.endDate = null;
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getTerm() {
        return this.term;
    }

    public int hashCode() {
        return this.term.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ActivityRecordSearchTerm)) {
            return false;
        }
        return ((ActivityRecordSearchTerm)obj).getTerm().equals(this.getTerm());
    }
}

