# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2022 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.sites.enforcement_points.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ClusterControlPlanes(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ClusterControlPlanesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               enforcementpoint_id,
               cluster_control_plane_id,
               cascade=None,
               ):
        """
        Delete a Cluster Control Plane Node

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :type  cascade: :class:`bool` or ``None``
        :param cascade: Flag to indicate if force delete cluster references from the
            firewall security policies. (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            'cascade': cascade,
                            })

    def get(self,
            site_id,
            enforcementpoint_id,
            cluster_control_plane_id,
            ):
        """
        Returns information about a specified Cluster Control Plane .

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ClusterControlPlane`
        :return: com.vmware.nsx_policy.model.ClusterControlPlane
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            })

    def list(self,
             site_id,
             enforcementpoint_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        list all Cluster Control Planes

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ClusterControlPlaneListResult`
        :return: com.vmware.nsx_policy.model.ClusterControlPlaneListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def update(self,
               site_id,
               enforcementpoint_id,
               cluster_control_plane_id,
               cluster_control_plane,
               ):
        """
        Joins a Cluster Control Plane to NSX-T

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_control_plane_id: :class:`str`
        :param cluster_control_plane_id: (required)
        :type  cluster_control_plane: :class:`com.vmware.nsx_policy.model_client.ClusterControlPlane`
        :param cluster_control_plane: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ClusterControlPlane`
        :return: com.vmware.nsx_policy.model.ClusterControlPlane
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_control_plane_id': cluster_control_plane_id,
                            'cluster_control_plane': cluster_control_plane,
                            })
class ClusterControlPlanesHeartbeatConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes_heartbeat_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ClusterControlPlanesHeartbeatConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             site_id,
             enforcementpoint_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Antrea cluster heartbeat config

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AntreaHeartbeatConfigListResult`
        :return: com.vmware.nsx_policy.model.AntreaHeartbeatConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class ClusterControlPlanesStatus(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes_status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ClusterControlPlanesStatusStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             site_id,
             enforcementpoint_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Antrea cluster status

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AntreaClusterListResult`
        :return: com.vmware.nsx_policy.model.AntreaClusterListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class ContainerClusterNcpstatus(VapiInterface):
    """
    
    """
    LIST_STATUS_UNKNOWN = "UNKNOWN"
    """
    Possible value for ``status`` of method :func:`ContainerClusterNcpstatus.list`.

    """
    LIST_STATUS_HEALTHY = "HEALTHY"
    """
    Possible value for ``status`` of method :func:`ContainerClusterNcpstatus.list`.

    """
    LIST_STATUS_DOWN = "DOWN"
    """
    Possible value for ``status`` of method :func:`ContainerClusterNcpstatus.list`.

    """
    LIST_STATUS_DEGRADED = "DEGRADED"
    """
    Possible value for ``status`` of method :func:`ContainerClusterNcpstatus.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.container_cluster_ncpstatus'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ContainerClusterNcpstatusStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               site_id,
               enforcement_point_id,
               container_cluster_status,
               ):
        """
        Create container cluster status

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  container_cluster_status: :class:`com.vmware.nsx_policy.model_client.ContainerClusterStatus`
        :param container_cluster_status: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ContainerClusterStatus`
        :return: com.vmware.nsx_policy.model.ContainerClusterStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'container_cluster_status': container_cluster_status,
                            })

    def list(self,
             site_id,
             enforcement_point_id,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             status=None,
             ):
        """
        Get all the container cluster status

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  status: :class:`str` or ``None``
        :param status: Container status type (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ContainerClusterStatusList`
        :return: com.vmware.nsx_policy.model.ContainerClusterStatusList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'status': status,
                            })
class EdgeBridgeProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.edge_bridge_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EdgeBridgeProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               enforcement_point_id,
               profile_id,
               ):
        """
        API will delete L2 bridge profile with ID profile-id

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  profile_id: :class:`str`
        :param profile_id: profile ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'profile_id': profile_id,
                            })

    def get(self,
            site_id,
            enforcement_point_id,
            profile_id,
            ):
        """
        Read L2 bridge profile with ID profile-id

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  profile_id: :class:`str`
        :param profile_id: profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L2BridgeEndpointProfile`
        :return: com.vmware.nsx_policy.model.L2BridgeEndpointProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'profile_id': profile_id,
                            })

    def list(self,
             site_id,
             enforcement_point_id,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all L2 bridge profiles

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L2BridgeEndpointProfileListResult`
        :return: com.vmware.nsx_policy.model.L2BridgeEndpointProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              site_id,
              enforcement_point_id,
              profile_id,
              l2_bridge_endpoint_profile,
              ):
        """
        API will create or update L2 bridge profile with ID profile-id. L2
        Bridge profile is only allowed under an enforcement-point with path
        /infra/sites/default/enforcement-points/default.

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  profile_id: :class:`str`
        :param profile_id: profile ID (required)
        :type  l2_bridge_endpoint_profile: :class:`com.vmware.nsx_policy.model_client.L2BridgeEndpointProfile`
        :param l2_bridge_endpoint_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'profile_id': profile_id,
                            'l2_bridge_endpoint_profile': l2_bridge_endpoint_profile,
                            })

    def update(self,
               site_id,
               enforcement_point_id,
               profile_id,
               l2_bridge_endpoint_profile,
               ):
        """
        API will create or update L2 bridge profile with ID profile-id. L2
        Bridge profile is only allowed under an enforcement-point with path
        /infra/sites/default/enforcement-points/default.

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  profile_id: :class:`str`
        :param profile_id: profile ID (required)
        :type  l2_bridge_endpoint_profile: :class:`com.vmware.nsx_policy.model_client.L2BridgeEndpointProfile`
        :param l2_bridge_endpoint_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L2BridgeEndpointProfile`
        :return: com.vmware.nsx_policy.model.L2BridgeEndpointProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'profile_id': profile_id,
                            'l2_bridge_endpoint_profile': l2_bridge_endpoint_profile,
                            })
class EdgeClusters(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EdgeClustersStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            site_id,
            enforcementpoint_id,
            edge_cluster_id,
            ):
        """
        Read a Edge Cluster under an Enforcement Point

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  edge_cluster_id: :class:`str`
        :param edge_cluster_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyEdgeCluster`
        :return: com.vmware.nsx_policy.model.PolicyEdgeCluster
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'edge_cluster_id': edge_cluster_id,
                            })

    def list(self,
             site_id,
             enforcementpoint_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Edge Clusters under an Enforcement Point

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyEdgeClusterListResult`
        :return: com.vmware.nsx_policy.model.PolicyEdgeClusterListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class HostTransportNodes(VapiInterface):
    """
    
    """
    UPDATEMAINTENANCEMODE_ACTION_ENTER_MAINTENANCE_MODE = "enter_maintenance_mode"
    """
    Possible value for ``action`` of method
    :func:`HostTransportNodes.updatemaintenancemode`.

    """
    UPDATEMAINTENANCEMODE_ACTION_FORCED_ENTER_MAINTENANCE_MODE = "forced_enter_maintenance_mode"
    """
    Possible value for ``action`` of method
    :func:`HostTransportNodes.updatemaintenancemode`.

    """
    UPDATEMAINTENANCEMODE_ACTION_EXIT_MAINTENANCE_MODE = "exit_maintenance_mode"
    """
    Possible value for ``action`` of method
    :func:`HostTransportNodes.updatemaintenancemode`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostTransportNodesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               enforcementpoint_id,
               host_transport_node_id,
               force=None,
               unprepare_host=None,
               ):
        """
        Deletes the specified transport node. Query param force can be used to
        force delete the host nodes. It also removes the specified host node
        from system. If unprepare_host option is set to false, then host will
        be deleted without uninstalling the NSX components from the host. If
        transport node delete is called with query param force not being set or
        set to false and uninstall of NSX components in the host fails,
        TransportNodeState object will be retained. If transport node delete is
        called with query param force set to true and uninstall of NSX
        components in the host fails, TransportNodeState object will be
        deleted.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :type  unprepare_host: :class:`bool` or ``None``
        :param unprepare_host: Uninstall NSX components from host while deleting (optional,
            default to true)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            'force': force,
                            'unprepare_host': unprepare_host,
                            })

    def get(self,
            site_id,
            enforcementpoint_id,
            host_transport_node_id,
            ):
        """
        Returns information about a specified transport node.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HostTransportNode`
        :return: com.vmware.nsx_policy.model.HostTransportNode
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            })

    def list(self,
             site_id,
             enforcementpoint_id,
             cursor=None,
             discovered_node_id=None,
             in_maintenance_mode=None,
             included_fields=None,
             node_ip=None,
             node_types=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             transport_zone_path=None,
             ):
        """
        Returns information about all host transport nodes along with
        underlying host details. A transport node is a host that contains
        hostswitches. A hostswitch can have virtual machines connected to them.
        Because each transport node has hostswitches, transport nodes can also
        have virtual tunnel endpoints, which means that they can be part of the
        overlay.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  discovered_node_id: :class:`str` or ``None``
        :param discovered_node_id: discovered node id (optional)
        :type  in_maintenance_mode: :class:`bool` or ``None``
        :param in_maintenance_mode: maintenance mode flag (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_ip: :class:`str` or ``None``
        :param node_ip: Transport node IP address (optional)
        :type  node_types: :class:`str` or ``None``
        :param node_types: a list of node types separated by comma or a single type (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  transport_zone_path: :class:`str` or ``None``
        :param transport_zone_path: Transport zone path (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeListResult`
        :return: com.vmware.nsx_policy.model.HostTransportNodeListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cursor': cursor,
                            'discovered_node_id': discovered_node_id,
                            'in_maintenance_mode': in_maintenance_mode,
                            'included_fields': included_fields,
                            'node_ip': node_ip,
                            'node_types': node_types,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'transport_zone_path': transport_zone_path,
                            })

    def patch(self,
              site_id,
              enforcementpoint_id,
              host_transport_node_id,
              host_transport_node,
              esx_mgmt_if_migration_dest=None,
              if_id=None,
              ping_ip=None,
              skip_validation=None,
              vnic=None,
              vnic_migration_dest=None,
              ):
        """
        Transport nodes are hypervisor hosts that will participate in an NSX-T
        overlay. For a hypervisor host, this means that it hosts VMs that will
        communicate over NSX-T logical switches. This API creates transport
        node for a host node (hypervisor) in the transport network. When you
        run this command for a host, NSX Manager attempts to install the NSX
        kernel modules, which are packaged as VIB, RPM, or DEB files. For the
        installation to succeed, you must provide the host login credentials
        and the host thumbprint. To get the ESXi host thumbprint, SSH to the
        host and run the **openssl x509 -in /etc/vmware/ssl/rui.crt
        -fingerprint -sha256 -noout** command. To generate host key thumbprint
        using SHA-256 algorithm please follow the steps below. Log into the
        host, making sure that the connection is not vulnerable to a man in the
        middle attack. Check whether a public key already exists. Host public
        key is generally located at '/etc/ssh/ssh_host_rsa_key.pub'. If the key
        is not present then generate a new key by running the following command
        and follow the instructions. **ssh-keygen -t rsa** Now generate a
        SHA256 hash of the key using the following command. Please make sure to
        pass the appropriate file name if the public key is stored with a
        different file name other than the default 'id_rsa.pub'. **awk '{print
        $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .\*$//' | xxd -r
        -p | base64** Additional documentation on creating a transport node can
        be found in the NSX-T Installation Guide. In order for the transport
        node to forward packets, the host_switch_spec property must be
        specified. Host switches (called bridges in OVS on KVM hypervisors) are
        the individual switches within the host virtual switch. Virtual
        machines are connected to the host switches. When creating a transport
        node, you need to specify if the host switches are already manually
        preconfigured on the node, or if NSX should create and manage the host
        switches. You specify this choice by the type of host switches you pass
        in the host_switch_spec property of the TransportNode request payload.
        For a KVM host, you can preconfigure the host switch, or you can have
        NSX Manager perform the configuration. For an ESXi host NSX Manager
        always configures the host switch. To preconfigure the host switches on
        a KVM host, pass an array of PreconfiguredHostSwitchSpec objects that
        describes those host switches. In the current NSX-T release, only one
        prefonfigured host switch can be specified. See the
        PreconfiguredHostSwitchSpec schema definition for documentation on the
        properties that must be provided. Preconfigured host switches are only
        supported on KVM hosts, not on ESXi hosts. To allow NSX to manage the
        host switch configuration on KVM hosts, ESXi hosts, pass an array of
        StandardHostSwitchSpec objects in the host_switch_spec property, and
        NSX will automatically create host switches with the properties you
        provide. In the current NSX-T release, up to 16 host switches can be
        automatically managed. See the StandardHostSwitchSpec schema definition
        for documentation on the properties that must be provided. The request
        should provide node_deployement_info.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :type  host_transport_node: :class:`com.vmware.nsx_policy.model_client.HostTransportNode`
        :param host_transport_node: (required)
        :type  esx_mgmt_if_migration_dest: :class:`str` or ``None``
        :param esx_mgmt_if_migration_dest: The network ids to which the ESX vmk interfaces will be migrated
            (optional)
        :type  if_id: :class:`str` or ``None``
        :param if_id: The ESX vmk interfaces to migrate (optional)
        :type  ping_ip: :class:`str` or ``None``
        :param ping_ip: IP Addresses to ping right after ESX vmk interfaces were migrated.
            (optional)
        :type  skip_validation: :class:`bool` or ``None``
        :param skip_validation: Whether to skip front-end validation for vmk/vnic/pnic migration
            (optional, default to false)
        :type  vnic: :class:`str` or ``None``
        :param vnic: The ESX vmk interfaces and/or VM NIC to migrate (optional)
        :type  vnic_migration_dest: :class:`str` or ``None``
        :param vnic_migration_dest: The migration destinations of ESX vmk interfaces and/or VM NIC
            (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            'host_transport_node': host_transport_node,
                            'esx_mgmt_if_migration_dest': esx_mgmt_if_migration_dest,
                            'if_id': if_id,
                            'ping_ip': ping_ip,
                            'skip_validation': skip_validation,
                            'vnic': vnic,
                            'vnic_migration_dest': vnic_migration_dest,
                            })

    def restoreclusterconfig(self,
                             site_id,
                             enforcementpoint_id,
                             host_transport_node_id,
                             ):
        """
        A host can be overridden to have different configuration than Transport
        Node Profile(TNP) on cluster. This action will restore such overridden
        host back to cluster level TNP. This API can be used in other case.
        When TNP is applied to a cluster, if any validation fails (e.g. VMs
        running on host) then existing transport node (TN) is not updated. In
        that case after the issue is resolved manually (e.g. VMs powered off),
        you can call this API to update TN as per cluster level TNP.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('restoreclusterconfig',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            })

    def resynchostconfig(self,
                         site_id,
                         enforcementpoint_id,
                         host_transport_node_id,
                         ):
        """
        Resync the TransportNode configuration on a host. It is similar to
        updating the TransportNode with existing configuration, but force synce
        these configurations to the host (no backend optimizations).

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('resynchostconfig',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            })

    def update(self,
               site_id,
               enforcementpoint_id,
               host_transport_node_id,
               host_transport_node,
               esx_mgmt_if_migration_dest=None,
               if_id=None,
               ping_ip=None,
               skip_validation=None,
               vnic=None,
               vnic_migration_dest=None,
               ):
        """
        Transport nodes are hypervisor hosts that will participate in an NSX-T
        overlay. For a hypervisor host, this means that it hosts VMs that will
        communicate over NSX-T logical switches. This API creates transport
        node for a host node (hypervisor) in the transport network. When you
        run this command for a host, NSX Manager attempts to install the NSX
        kernel modules, which are packaged as VIB, RPM, or DEB files. For the
        installation to succeed, you must provide the host login credentials
        and the host thumbprint. To get the ESXi host thumbprint, SSH to the
        host and run the **openssl x509 -in /etc/vmware/ssl/rui.crt
        -fingerprint -sha256 -noout** command. To generate host key thumbprint
        using SHA-256 algorithm please follow the steps below. Log into the
        host, making sure that the connection is not vulnerable to a man in the
        middle attack. Check whether a public key already exists. Host public
        key is generally located at '/etc/ssh/ssh_host_rsa_key.pub'. If the key
        is not present then generate a new key by running the following command
        and follow the instructions. **ssh-keygen -t rsa** Now generate a
        SHA256 hash of the key using the following command. Please make sure to
        pass the appropriate file name if the public key is stored with a
        different file name other than the default 'id_rsa.pub'. **awk '{print
        $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .\*$//' | xxd -r
        -p | base64** Additional documentation on creating a transport node can
        be found in the NSX-T Installation Guide. In order for the transport
        node to forward packets, the host_switch_spec property must be
        specified. Host switches (called bridges in OVS on KVM hypervisors) are
        the individual switches within the host virtual switch. Virtual
        machines are connected to the host switches. When creating a transport
        node, you need to specify if the host switches are already manually
        preconfigured on the node, or if NSX should create and manage the host
        switches. You specify this choice by the type of host switches you pass
        in the host_switch_spec property of the TransportNode request payload.
        For a KVM host, you can preconfigure the host switch, or you can have
        NSX Manager perform the configuration. For an ESXi host NSX Manager
        always configures the host switch. To preconfigure the host switches on
        a KVM host, pass an array of PreconfiguredHostSwitchSpec objects that
        describes those host switches. In the current NSX-T release, only one
        prefonfigured host switch can be specified. See the
        PreconfiguredHostSwitchSpec schema definition for documentation on the
        properties that must be provided. Preconfigured host switches are only
        supported on KVM hosts, not on ESXi hosts. To allow NSX to manage the
        host switch configuration on KVM hosts, ESXi hosts, pass an array of
        StandardHostSwitchSpec objects in the host_switch_spec property, and
        NSX will automatically create host switches with the properties you
        provide. In the current NSX-T release, up to 16 host switches can be
        automatically managed. See the StandardHostSwitchSpec schema definition
        for documentation on the properties that must be provided. The request
        should provide node_deployement_info.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :type  host_transport_node: :class:`com.vmware.nsx_policy.model_client.HostTransportNode`
        :param host_transport_node: (required)
        :type  esx_mgmt_if_migration_dest: :class:`str` or ``None``
        :param esx_mgmt_if_migration_dest: The network ids to which the ESX vmk interfaces will be migrated
            (optional)
        :type  if_id: :class:`str` or ``None``
        :param if_id: The ESX vmk interfaces to migrate (optional)
        :type  ping_ip: :class:`str` or ``None``
        :param ping_ip: IP Addresses to ping right after ESX vmk interfaces were migrated.
            (optional)
        :type  skip_validation: :class:`bool` or ``None``
        :param skip_validation: Whether to skip front-end validation for vmk/vnic/pnic migration
            (optional, default to false)
        :type  vnic: :class:`str` or ``None``
        :param vnic: The ESX vmk interfaces and/or VM NIC to migrate (optional)
        :type  vnic_migration_dest: :class:`str` or ``None``
        :param vnic_migration_dest: The migration destinations of ESX vmk interfaces and/or VM NIC
            (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HostTransportNode`
        :return: com.vmware.nsx_policy.model.HostTransportNode
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            'host_transport_node': host_transport_node,
                            'esx_mgmt_if_migration_dest': esx_mgmt_if_migration_dest,
                            'if_id': if_id,
                            'ping_ip': ping_ip,
                            'skip_validation': skip_validation,
                            'vnic': vnic,
                            'vnic_migration_dest': vnic_migration_dest,
                            })

    def updatemaintenancemode(self,
                              site_id,
                              enforcementpoint_id,
                              host_transport_node_id,
                              action=None,
                              ):
        """
        Put transport node into maintenance mode or exit from maintenance mode.
        When HostTransportNode is in maintenance mode no configuration changes
        are allowed

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  host_transport_node_id: :class:`str`
        :param host_transport_node_id: (required)
        :type  action: :class:`str` or ``None``
        :param action: (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('updatemaintenancemode',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'host_transport_node_id': host_transport_node_id,
                            'action': action,
                            })
class HostTransportNodesAggstatus(VapiInterface):
    """
    
    """
    GET_NODE_TYPE_HOST = "HOST"
    """
    Possible value for ``nodeType`` of method
    :func:`HostTransportNodesAggstatus.get`.

    """
    GET_NODE_TYPE_EDGE = "EDGE"
    """
    Possible value for ``nodeType`` of method
    :func:`HostTransportNodesAggstatus.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes_aggstatus'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostTransportNodesAggstatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            site_id,
            enforcement_point_id,
            node_type=None,
            ):
        """
        Get high-level summary of all transport nodes. The service layer does
        not support source = realtime or cached.

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  node_type: :class:`str` or ``None``
        :param node_type: Transport node type (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HeatMapTransportZoneStatus`
        :return: com.vmware.nsx_policy.model.HeatMapTransportZoneStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'node_type': node_type,
                            })
class HostTransportNodesStatus(VapiInterface):
    """
    
    """
    GETALL_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method
    :func:`HostTransportNodesStatus.getall`.

    """
    GETALL_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method
    :func:`HostTransportNodesStatus.getall`.

    """
    GETALL_STATUS_UP = "UP"
    """
    Possible value for ``status`` of method
    :func:`HostTransportNodesStatus.getall`.

    """
    GETALL_STATUS_DOWN = "DOWN"
    """
    Possible value for ``status`` of method
    :func:`HostTransportNodesStatus.getall`.

    """
    GETALL_STATUS_DEGRADED = "DEGRADED"
    """
    Possible value for ``status`` of method
    :func:`HostTransportNodesStatus.getall`.

    """
    GETALL_STATUS_UNKNOWN = "UNKNOWN"
    """
    Possible value for ``status`` of method
    :func:`HostTransportNodesStatus.getall`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes_status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostTransportNodesStatusStub)
        self._VAPI_OPERATION_IDS = {}


    def getall(self,
               site_id,
               enforcement_point_id,
               cursor=None,
               included_fields=None,
               page_size=None,
               sort_ascending=None,
               sort_by=None,
               source=None,
               status=None,
               ):
        """
        Read status of all the transport nodes

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :type  status: :class:`str` or ``None``
        :param status: Transport node (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TransportNodeStatusListResult`
        :return: com.vmware.nsx_policy.model.TransportNodeStatusListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('getall',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'source': source,
                            'status': status,
                            })
class TransportNodeCollections(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.transport_node_collections'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TransportNodeCollectionsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               enforcementpoint_id,
               transport_node_collection_id,
               ):
        """
        By deleting transport node collection, we are detaching the transport
        node profile(TNP) from the compute collection. It has no effect on
        existing transport nodes. However, new hosts added to the compute
        collection will no longer be automatically converted to NSX transport
        node. Detaching TNP from compute collection does not delete TNP.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collection_id: :class:`str`
        :param transport_node_collection_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collection_id': transport_node_collection_id,
                            })

    def get(self,
            site_id,
            enforcementpoint_id,
            transport_node_collection_id,
            ):
        """
        Returns transport node collection by id

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collection_id: :class:`str`
        :param transport_node_collection_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeCollection`
        :return: com.vmware.nsx_policy.model.HostTransportNodeCollection
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collection_id': transport_node_collection_id,
                            })

    def installformicroseg(self,
                           site_id,
                           enforcementpoint_id,
                           transport_node_collection_id,
                           host_transport_node_collection,
                           ):
        """
        This API configures a compute collection for security. In the request
        body, specify a Transport Node Collection with only the ID of the
        target compute collection meant for security. Specifically, a Transport
        Node Profile ID should not be specified. This API will define a
        system-generated security Transport Node Profile and apply it on the
        compute collection to create the Transport Node Collection.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collection_id: :class:`str`
        :param transport_node_collection_id: (required)
        :type  host_transport_node_collection: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeCollection`
        :param host_transport_node_collection: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('installformicroseg',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collection_id': transport_node_collection_id,
                            'host_transport_node_collection': host_transport_node_collection,
                            })

    def list(self,
             site_id,
             enforcementpoint_id,
             cluster_moid=None,
             compute_collection_id=None,
             vc_instance_uuid=None,
             ):
        """
        Returns all Transport Node collections

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cluster_moid: :class:`str` or ``None``
        :param cluster_moid: Managed object ID of cluster in VC (optional)
        :type  compute_collection_id: :class:`str` or ``None``
        :param compute_collection_id: Compute collection id (optional)
        :type  vc_instance_uuid: :class:`str` or ``None``
        :param vc_instance_uuid: UUID for VC deployment (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeCollectionListResult`
        :return: com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cluster_moid': cluster_moid,
                            'compute_collection_id': compute_collection_id,
                            'vc_instance_uuid': vc_instance_uuid,
                            })

    def patch(self,
              site_id,
              enforcementpoint_id,
              transport_node_collection_id,
              host_transport_node_collection,
              ):
        """
        Attach different transport node profile to compute collection by
        updating transport node collection.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collection_id: :class:`str`
        :param transport_node_collection_id: (required)
        :type  host_transport_node_collection: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeCollection`
        :param host_transport_node_collection: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collection_id': transport_node_collection_id,
                            'host_transport_node_collection': host_transport_node_collection,
                            })

    def removensx(self,
                  site_id,
                  enforcementpoint_id,
                  transport_node_collection_id,
                  ):
        """
        This API uninstalls NSX applied to the Transport Node Collection with
        the ID corresponding to the one specified in the request.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collection_id: :class:`str`
        :param transport_node_collection_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('removensx',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collection_id': transport_node_collection_id,
                            })

    def retryprofilerealization(self,
                                site_id,
                                enforcementpoint_id,
                                transport_node_collection_id,
                                ):
        """
        This API is relevant for compute collection on which vLCM is enabled.
        This API should be invoked to retry the realization of transport node
        profile on the compute collection. This is useful when profile
        realization had failed because of error in vLCM. This API has no effect
        if vLCM is not enabled on the computer collection.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collection_id: :class:`str`
        :param transport_node_collection_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('retryprofilerealization',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collection_id': transport_node_collection_id,
                            })

    def update(self,
               site_id,
               enforcementpoint_id,
               transport_node_collections_id,
               host_transport_node_collection,
               apply_profile=None,
               ):
        """
        When transport node collection is created the hosts which are part of
        compute collection will be prepared automatically i.e. NSX Manager
        attempts to install the NSX components on hosts. Transport nodes for
        these hosts are created using the configuration specified in transport
        node profile. Pass apply_profile to false, if you do not want to apply
        transport node profile on the existing transport node with overridden
        host flag set and ignore overridden hosts flag is set to true on the
        transport node profile.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_node_collections_id: :class:`str`
        :param transport_node_collections_id: (required)
        :type  host_transport_node_collection: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeCollection`
        :param host_transport_node_collection: (required)
        :type  apply_profile: :class:`bool` or ``None``
        :param apply_profile: Indicates if the Transport Node Profile (TNP) configuration should
            be applied during creation (optional, default to true)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HostTransportNodeCollection`
        :return: com.vmware.nsx_policy.model.HostTransportNodeCollection
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_node_collections_id': transport_node_collections_id,
                            'host_transport_node_collection': host_transport_node_collection,
                            'apply_profile': apply_profile,
                            })
class TransportZones(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.transport_zones'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TransportZonesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               enforcementpoint_id,
               transport_zone_id,
               ):
        """
        Delete a Transport Zone under an Enforcement Point.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_zone_id: :class:`str`
        :param transport_zone_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_zone_id': transport_zone_id,
                            })

    def get(self,
            site_id,
            enforcementpoint_id,
            transport_zone_id,
            ):
        """
        Read a Transport Zone under an Enforcement Point

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_zone_id: :class:`str`
        :param transport_zone_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZone`
        :return: com.vmware.nsx_policy.model.PolicyTransportZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_zone_id': transport_zone_id,
                            })

    def list(self,
             site_id,
             enforcementpoint_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Transport Zones under an Enforcement Point

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneListResult`
        :return: com.vmware.nsx_policy.model.PolicyTransportZoneListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              site_id,
              enforcementpoint_id,
              transport_zone_id,
              policy_transport_zone,
              ):
        """
        Patch a Transport Zone under an Enforcement Point

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_zone_id: :class:`str`
        :param transport_zone_id: (required)
        :type  policy_transport_zone: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZone`
        :param policy_transport_zone: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZone`
        :return: com.vmware.nsx_policy.model.PolicyTransportZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_zone_id': transport_zone_id,
                            'policy_transport_zone': policy_transport_zone,
                            })

    def update(self,
               site_id,
               enforcementpoint_id,
               transport_zone_id,
               policy_transport_zone,
               ):
        """
        PUT a Transport Zone under an Enforcement Point

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  enforcementpoint_id: :class:`str`
        :param enforcementpoint_id: (required)
        :type  transport_zone_id: :class:`str`
        :param transport_zone_id: (required)
        :type  policy_transport_zone: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZone`
        :param policy_transport_zone: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZone`
        :return: com.vmware.nsx_policy.model.PolicyTransportZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'enforcementpoint_id': enforcementpoint_id,
                            'transport_zone_id': transport_zone_id,
                            'policy_transport_zone': policy_transport_zone,
                            })
class TransportZonesAggstatus(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites.enforcement_points.transport_zones_aggstatus'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TransportZonesAggstatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            site_id,
            enforcement_point_id,
            ):
        """
        Get high-level summary of all transport zone status. The service layer
        does not support source = realtime or cached.

        :type  site_id: :class:`str`
        :param site_id: site ID (required)
        :type  enforcement_point_id: :class:`str`
        :param enforcement_point_id: enforcement point ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.HeatMapTransportNodesAggregateStatus`
        :return: com.vmware.nsx_policy.model.HeatMapTransportNodesAggregateStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            'enforcement_point_id': enforcement_point_id,
                            })
class _ClusterControlPlanesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
            'cascade': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cascade': 'cascade',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_control_plane_id': type.StringType(),
            'cluster_control_plane': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ClusterControlPlane'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes/{cluster-control-plane-id}',
            request_body_parameter='cluster_control_plane',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'cluster_control_plane_id': 'cluster-control-plane-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ClusterControlPlane'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ClusterControlPlaneListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ClusterControlPlane'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ClusterControlPlanesHeartbeatConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes-heartbeat-config',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaHeartbeatConfigListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes_heartbeat_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ClusterControlPlanesStatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/cluster-control-planes-status',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AntreaClusterListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes_status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ContainerClusterNcpstatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'container_cluster_status': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ContainerClusterStatus'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/container-cluster-ncpstatus',
            request_body_parameter='container_cluster_status',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'status': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/container-cluster-ncpstatus',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'status': 'status',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ContainerClusterStatus'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ContainerClusterStatusList'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.container_cluster_ncpstatus',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _EdgeBridgeProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'profile_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-bridge-profiles/{profile-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'profile_id': 'profile-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-bridge-profiles/{profile-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'profile_id': 'profile-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-bridge-profiles',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
            },
             header_parameters={
                           },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'profile_id': type.StringType(),
            'l2_bridge_endpoint_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'L2BridgeEndpointProfile'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-bridge-profiles/{profile-id}',
            request_body_parameter='l2_bridge_endpoint_profile',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'profile_id': 'profile-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'profile_id': type.StringType(),
            'l2_bridge_endpoint_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'L2BridgeEndpointProfile'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/edge-bridge-profiles/{profile-id}',
            request_body_parameter='l2_bridge_endpoint_profile',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
                'profile_id': 'profile-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'L2BridgeEndpointProfile'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'L2BridgeEndpointProfileListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'L2BridgeEndpointProfile'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.edge_bridge_profiles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _EdgeClustersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'edge_cluster_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/edge-clusters/{edge-cluster-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'edge_cluster_id': 'edge-cluster-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/edge-clusters',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyEdgeCluster'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyEdgeClusterListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _HostTransportNodesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
            'force': type.OptionalType(type.BooleanType()),
            'unprepare_host': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                       },
            query_parameters={
                'force': 'force',
                'unprepare_host': 'unprepare_host',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'discovered_node_id': type.OptionalType(type.StringType()),
            'in_maintenance_mode': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'node_ip': type.OptionalType(type.StringType()),
            'node_types': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'transport_zone_path': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                                     },
            query_parameters={
                'cursor': 'cursor',
                'discovered_node_id': 'discovered_node_id',
                'in_maintenance_mode': 'in_maintenance_mode',
                'included_fields': 'included_fields',
                'node_ip': 'node_ip',
                'node_types': 'node_types',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'transport_zone_path': 'transport_zone_path',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
            'host_transport_node': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNode'),
            'esx_mgmt_if_migration_dest': type.OptionalType(type.StringType()),
            'if_id': type.OptionalType(type.StringType()),
            'ping_ip': type.OptionalType(type.StringType()),
            'skip_validation': type.OptionalType(type.BooleanType()),
            'vnic': type.OptionalType(type.StringType()),
            'vnic_migration_dest': type.OptionalType(type.StringType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}',
            request_body_parameter='host_transport_node',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                                 },
            query_parameters={
                'esx_mgmt_if_migration_dest': 'esx_mgmt_if_migration_dest',
                'if_id': 'if_id',
                'ping_ip': 'ping_ip',
                'skip_validation': 'skip_validation',
                'vnic': 'vnic',
                'vnic_migration_dest': 'vnic_migration_dest',
            },
            content_type='application/json'
        )

        # properties for restoreclusterconfig operation
        restoreclusterconfig_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
        })
        restoreclusterconfig_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        restoreclusterconfig_input_value_validator_list = [
        ]
        restoreclusterconfig_output_validator_list = [
        ]
        restoreclusterconfig_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}?action=restore_cluster_config',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for resynchostconfig operation
        resynchostconfig_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
        })
        resynchostconfig_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        resynchostconfig_input_value_validator_list = [
        ]
        resynchostconfig_output_validator_list = [
        ]
        resynchostconfig_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}?action=resync_host_config',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
            'host_transport_node': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNode'),
            'esx_mgmt_if_migration_dest': type.OptionalType(type.StringType()),
            'if_id': type.OptionalType(type.StringType()),
            'ping_ip': type.OptionalType(type.StringType()),
            'skip_validation': type.OptionalType(type.BooleanType()),
            'vnic': type.OptionalType(type.StringType()),
            'vnic_migration_dest': type.OptionalType(type.StringType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}',
            request_body_parameter='host_transport_node',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                                 },
            query_parameters={
                'esx_mgmt_if_migration_dest': 'esx_mgmt_if_migration_dest',
                'if_id': 'if_id',
                'ping_ip': 'ping_ip',
                'skip_validation': 'skip_validation',
                'vnic': 'vnic',
                'vnic_migration_dest': 'vnic_migration_dest',
            },
            content_type='application/json'
        )

        # properties for updatemaintenancemode operation
        updatemaintenancemode_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'host_transport_node_id': type.StringType(),
            'action': type.OptionalType(type.StringType()),
        })
        updatemaintenancemode_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        updatemaintenancemode_input_value_validator_list = [
        ]
        updatemaintenancemode_output_validator_list = [
        ]
        updatemaintenancemode_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/host-transport-nodes/{host-transport-node-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'host_transport_node_id': 'host-transport-node-id',
            },
             header_parameters={
                     },
            query_parameters={
                'action': 'action',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNode'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'restoreclusterconfig': {
                'input_type': restoreclusterconfig_input_type,
                'output_type': type.VoidType(),
                'errors': restoreclusterconfig_error_dict,
                'input_value_validator_list': restoreclusterconfig_input_value_validator_list,
                'output_validator_list': restoreclusterconfig_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'resynchostconfig': {
                'input_type': resynchostconfig_input_type,
                'output_type': type.VoidType(),
                'errors': resynchostconfig_error_dict,
                'input_value_validator_list': resynchostconfig_input_value_validator_list,
                'output_validator_list': resynchostconfig_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNode'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'updatemaintenancemode': {
                'input_type': updatemaintenancemode_input_type,
                'output_type': type.VoidType(),
                'errors': updatemaintenancemode_error_dict,
                'input_value_validator_list': updatemaintenancemode_input_value_validator_list,
                'output_validator_list': updatemaintenancemode_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'restoreclusterconfig': restoreclusterconfig_rest_metadata,
            'resynchostconfig': resynchostconfig_rest_metadata,
            'update': update_rest_metadata,
            'updatemaintenancemode': updatemaintenancemode_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _HostTransportNodesAggstatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'node_type': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/host-transport-nodes-aggstatus',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
            },
             header_parameters={
                   },
            query_parameters={
                'node_type': 'node_type',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HeatMapTransportZoneStatus'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes_aggstatus',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _HostTransportNodesStatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for getall operation
        getall_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
            'status': type.OptionalType(type.StringType()),
        })
        getall_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        getall_input_value_validator_list = [
        ]
        getall_output_validator_list = [
        ]
        getall_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/host-transport-nodes-status',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
            },
             header_parameters={
                               },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'source': 'source',
                'status': 'status',
            },
            content_type='application/json'
        )

        operations = {
            'getall': {
                'input_type': getall_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TransportNodeStatusListResult'),
                'errors': getall_error_dict,
                'input_value_validator_list': getall_input_value_validator_list,
                'output_validator_list': getall_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'getall': getall_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes_status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TransportNodeCollectionsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collection_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collection-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collection_id': 'transport-node-collection-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collection_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collection-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collection_id': 'transport-node-collection-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for installformicroseg operation
        installformicroseg_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collection_id': type.StringType(),
            'host_transport_node_collection': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeCollection'),
        })
        installformicroseg_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        installformicroseg_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        installformicroseg_output_validator_list = [
        ]
        installformicroseg_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collection-id}?action=install_for_microseg',
            request_body_parameter='host_transport_node_collection',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collection_id': 'transport-node-collection-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cluster_moid': type.OptionalType(type.StringType()),
            'compute_collection_id': type.OptionalType(type.StringType()),
            'vc_instance_uuid': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                       },
            query_parameters={
                'cluster_moid': 'cluster_moid',
                'compute_collection_id': 'compute_collection_id',
                'vc_instance_uuid': 'vc_instance_uuid',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collection_id': type.StringType(),
            'host_transport_node_collection': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeCollection'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collection-id}',
            request_body_parameter='host_transport_node_collection',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collection_id': 'transport-node-collection-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for removensx operation
        removensx_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collection_id': type.StringType(),
        })
        removensx_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        removensx_input_value_validator_list = [
        ]
        removensx_output_validator_list = [
        ]
        removensx_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collection-id}?action=remove_nsx',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collection_id': 'transport-node-collection-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for retryprofilerealization operation
        retryprofilerealization_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collection_id': type.StringType(),
        })
        retryprofilerealization_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        retryprofilerealization_input_value_validator_list = [
        ]
        retryprofilerealization_output_validator_list = [
        ]
        retryprofilerealization_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collection-id}?action=retry_profile_realization',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collection_id': 'transport-node-collection-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_node_collections_id': type.StringType(),
            'host_transport_node_collection': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeCollection'),
            'apply_profile': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-node-collections/{transport-node-collections-id}',
            request_body_parameter='host_transport_node_collection',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_node_collections_id': 'transport-node-collections-id',
            },
             header_parameters={
                       },
            query_parameters={
                'apply_profile': 'apply_profile',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeCollection'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'installformicroseg': {
                'input_type': installformicroseg_input_type,
                'output_type': type.VoidType(),
                'errors': installformicroseg_error_dict,
                'input_value_validator_list': installformicroseg_input_value_validator_list,
                'output_validator_list': installformicroseg_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeCollectionListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'removensx': {
                'input_type': removensx_input_type,
                'output_type': type.VoidType(),
                'errors': removensx_error_dict,
                'input_value_validator_list': removensx_input_value_validator_list,
                'output_validator_list': removensx_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'retryprofilerealization': {
                'input_type': retryprofilerealization_input_type,
                'output_type': type.VoidType(),
                'errors': retryprofilerealization_error_dict,
                'input_value_validator_list': retryprofilerealization_input_value_validator_list,
                'output_validator_list': retryprofilerealization_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HostTransportNodeCollection'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'installformicroseg': installformicroseg_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'removensx': removensx_rest_metadata,
            'retryprofilerealization': retryprofilerealization_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.transport_node_collections',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TransportZonesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_zone_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-zones/{transport-zone-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_zone_id': 'transport-zone-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_zone_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-zones/{transport-zone-id}',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_zone_id': 'transport-zone-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-zones',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_zone_id': type.StringType(),
            'policy_transport_zone': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyTransportZone'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-zones/{transport-zone-id}',
            request_body_parameter='policy_transport_zone',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_zone_id': 'transport-zone-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcementpoint_id': type.StringType(),
            'transport_zone_id': type.StringType(),
            'policy_transport_zone': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyTransportZone'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcementpoint-id}/transport-zones/{transport-zone-id}',
            request_body_parameter='policy_transport_zone',
            path_variables={
                'site_id': 'site-id',
                'enforcementpoint_id': 'enforcementpoint-id',
                'transport_zone_id': 'transport-zone-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyTransportZone'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyTransportZoneListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyTransportZone'),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyTransportZone'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.transport_zones',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TransportZonesAggstatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'site_id': type.StringType(),
            'enforcement_point_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/sites/{site-id}/enforcement-points/{enforcement-point-id}/transport-zones-aggstatus',
            path_variables={
                'site_id': 'site-id',
                'enforcement_point_id': 'enforcement-point-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'HeatMapTransportNodesAggregateStatus'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.sites.enforcement_points.transport_zones_aggstatus',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ClusterControlPlanes': ClusterControlPlanes,
        'ClusterControlPlanesHeartbeatConfig': ClusterControlPlanesHeartbeatConfig,
        'ClusterControlPlanesStatus': ClusterControlPlanesStatus,
        'ContainerClusterNcpstatus': ContainerClusterNcpstatus,
        'EdgeBridgeProfiles': EdgeBridgeProfiles,
        'EdgeClusters': EdgeClusters,
        'HostTransportNodes': HostTransportNodes,
        'HostTransportNodesAggstatus': HostTransportNodesAggstatus,
        'HostTransportNodesStatus': HostTransportNodesStatus,
        'TransportNodeCollections': TransportNodeCollections,
        'TransportZones': TransportZones,
        'TransportZonesAggstatus': TransportZonesAggstatus,
        'cluster_control_planes': 'com.vmware.nsx_policy.infra.sites.enforcement_points.cluster_control_planes_client.StubFactory',
        'container_cluster': 'com.vmware.nsx_policy.infra.sites.enforcement_points.container_cluster_client.StubFactory',
        'edge_clusters': 'com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters_client.StubFactory',
        'host_transport_nodes': 'com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes_client.StubFactory',
        'transport_node_collections': 'com.vmware.nsx_policy.infra.sites.enforcement_points.transport_node_collections_client.StubFactory',
        'transport_zones': 'com.vmware.nsx_policy.infra.sites.enforcement_points.transport_zones_client.StubFactory',
    }

