/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.json.ConfigurationService;
import org.apache.guacamole.auth.json.CryptoService;
import org.apache.guacamole.auth.json.RequestValidationService;
import org.apache.guacamole.auth.json.user.UserData;
import org.apache.guacamole.auth.json.user.UserDataConnection;
import org.apache.guacamole.auth.json.user.UserDataDenylist;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleDirectory;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserDataService {
    private static final Logger logger = LoggerFactory.getLogger(UserDataService.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final UserDataDenylist denylist = new UserDataDenylist();
    @Inject
    private ConfigurationService confService;
    @Inject
    private RequestValidationService requestService;
    @Inject
    private CryptoService cryptoService;
    @Inject
    private Provider<UserDataConnection> userDataConnectionProvider;
    public static final String ENCRYPTED_DATA_PARAMETER = "data";

    public UserData fromCredentials(Credentials credentials) {
        String json;
        byte[] correctSignature;
        HttpServletRequest request = credentials.getRequest();
        if (request == null) {
            return null;
        }
        if (!this.requestService.isAuthenticationAllowed(request)) {
            return null;
        }
        String base64 = request.getParameter(ENCRYPTED_DATA_PARAMETER);
        if (base64 == null) {
            return null;
        }
        try {
            byte[] decrypted = this.cryptoService.decrypt(this.cryptoService.createEncryptionKey(this.confService.getSecretKey()), BaseEncoding.base64().decode(base64));
            if (decrypted.length <= 32) {
                logger.warn("Submitted data is too small to contain both a signature and JSON.");
                return null;
            }
            byte[] receivedSignature = Arrays.copyOf(decrypted, 32);
            byte[] receivedJSON = Arrays.copyOfRange(decrypted, 32, decrypted.length);
            correctSignature = this.cryptoService.sign(this.cryptoService.createSignatureKey(this.confService.getSecretKey()), receivedJSON);
            if (!Arrays.equals(receivedSignature, correctSignature)) {
                logger.warn("Signature of submitted data is incorrect.");
                return null;
            }
            json = new String(receivedJSON, "UTF-8");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Submitted data is not proper base64.");
            logger.debug("Invalid base64 data.", (Throwable)e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unexpected lack of support for UTF-8: {}", (Object)e.getMessage());
            logger.debug("Unable to decode base64 data as UTF-8.", (Throwable)e);
            return null;
        }
        catch (GuacamoleException e) {
            logger.error("Decryption of received data failed: {}", (Object)e.getMessage());
            logger.debug("Unable to decrypt received data.", (Throwable)e);
            return null;
        }
        try {
            UserData userData = mapper.readValue(json, UserData.class);
            if (userData.isExpired()) {
                return null;
            }
            if (userData.isSingleUse() && !this.denylist.add(userData, correctSignature)) {
                return null;
            }
            return userData;
        }
        catch (IOException e) {
            logger.error("Received JSON is invalid: {}", (Object)e.getMessage());
            logger.debug("Error parsing UserData JSON.", (Throwable)e);
            return null;
        }
    }

    public Set<String> getUserIdentifiers(UserData userData) {
        return Collections.singleton(userData.getUsername());
    }

    public User getUser(final UserData userData) {
        return new SimpleUser(userData.getUsername()){

            public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet(UserDataService.this.getUserIdentifiers(userData));
            }

            public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet(UserDataService.this.getConnectionIdentifiers(userData));
            }

            public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet(UserDataService.this.getConnectionGroupIdentifiers(userData));
            }
        };
    }

    public Set<String> getConnectionIdentifiers(UserData userData) {
        Map<String, UserData.Connection> connections = userData.getConnections();
        if (connections == null || userData.isExpired()) {
            return Collections.emptySet();
        }
        return connections.keySet();
    }

    public Directory<Connection> getConnectionDirectory(UserData userData) {
        Map<String, UserData.Connection> connections = userData.getConnections();
        if (connections == null || userData.isExpired()) {
            return new SimpleDirectory();
        }
        HashMap<String, UserDataConnection> directoryContents = new HashMap<String, UserDataConnection>();
        for (Map.Entry<String, UserData.Connection> entry : connections.entrySet()) {
            String identifier = entry.getKey();
            UserData.Connection connection = entry.getValue();
            UserDataConnection guacConnection = this.userDataConnectionProvider.get().init(userData, identifier, connection);
            directoryContents.put(identifier, guacConnection);
        }
        return new SimpleDirectory(directoryContents);
    }

    public Set<String> getConnectionGroupIdentifiers(UserData userData) {
        return Collections.singleton("ROOT");
    }
}

