/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyUtils.class);

    public static PrivateKey createKey(String path, String algorithm) {
        PrivateKey key = PrivateKeyUtils.readPemPrivateKey(path);
        if (key == null) {
            return PrivateKeyUtils.readDERPrivateKey(path, algorithm);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPemPrivateKey(String path) {
        LOGGER.debug("Attempting to read as PEM [{}]", (Object)path);
        File file = new File(path);
        FileReader isr = null;
        BufferedReader br = null;
        try {
            isr = new FileReader(file);
            br = new BufferedReader(isr);
            PEMParser pp = new PEMParser(br);
            PEMKeyPair pemKeyPair = (PEMKeyPair)pp.readObject();
            KeyPair kp = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
            PrivateKey privateKey = kp.getPrivate();
            return privateKey;
        }
        catch (Exception e) {
            LOGGER.error("Unable to read key", (Throwable)e);
            PrivateKey privateKey = null;
            return privateKey;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readDERPrivateKey(String path, String algorithm) {
        LOGGER.debug("Attempting to read key as DER [{}]", (Object)path);
        File file = new File(path);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            long byteLength = file.length();
            byte[] bytes = new byte[(int)byteLength];
            fis.read(bytes, 0, (int)byteLength);
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(algorithm);
            PrivateKey privateKey = factory.generatePrivate(privSpec);
            return privateKey;
        }
        catch (Exception e) {
            LOGGER.error("Unable to read key", (Throwable)e);
            PrivateKey privateKey = null;
            return privateKey;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

