/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.configuration.settings;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import javax.inject.Provider;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.guice.configuration.settings.ConfigurationSetting;

public final class JavaTypeAndHandlerConfigurationSettingProvider
implements Provider<ConfigurationSetting> {
    @Inject
    private Injector injector;
    private final Wrapper<?> wrapper;

    private JavaTypeAndHandlerConfigurationSettingProvider(Wrapper<?> wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public ConfigurationSetting get() {
        return this.wrapper.get(this.injector);
    }

    public static <T> JavaTypeAndHandlerConfigurationSettingProvider create(Class<T> type, Key<? extends TypeHandler<? extends T>> key) {
        return new JavaTypeAndHandlerConfigurationSettingProvider(new Wrapper(type, key));
    }

    private static class Wrapper<T> {
        private final Class<T> type;
        private final Key<? extends TypeHandler<? extends T>> key;

        private Wrapper(Class<T> type, Key<? extends TypeHandler<? extends T>> key) {
            this.type = type;
            this.key = key;
        }

        ConfigurationSetting get(Injector injector) {
            final TypeHandler<? extends T> handlerInstance = injector.getInstance(this.key);
            return new ConfigurationSetting(){

                @Override
                public void applyConfigurationSetting(Configuration configuration) {
                    configuration.getTypeHandlerRegistry().register(Wrapper.this.type, handlerInstance);
                }
            };
        }
    }
}

