/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) + dvec2(-0.1lf, -1.2lf)) => dvec2(-0.2lf, -2.4lf)
 * (dvec2(-0.1lf, -1.2lf) + dvec2(-0.42lf, 0.48lf)) => dvec2(-0.52lf, -0.72lf)
 * (dvec2(-0.42lf, 0.48lf) + dvec2(-0.1lf, -1.2lf)) => dvec2(-0.52lf, -0.72lf)
 * (dvec2(-0.42lf, 0.48lf) + dvec2(-0.42lf, 0.48lf)) => dvec2(-0.84lf, 0.96lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) + dvec2(-0.1lf, -1.2lf)), dvec2(-0.2lf, -2.4lf)) <= 2.4083189157584595e-05lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) + dvec2(-0.42lf, 0.48lf)), dvec2(-0.52lf, -0.72lf)) <= 8.881441324469807e-06lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) + dvec2(-0.1lf, -1.2lf)), dvec2(-0.52lf, -0.72lf)) <= 8.881441324469807e-06lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) + dvec2(-0.42lf, 0.48lf)), dvec2(-0.84lf, 0.96lf)) <= 1.2756174975281581e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
