"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkbenchPlugin = void 0;

var _routes = _interopRequireDefault(require("./routes"));

var _sqlPlugin = _interopRequireDefault(require("./clusters/sql/sqlPlugin"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class WorkbenchPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('queryWorkbenchDashboards: Setup');
    const router = core.http.createRouter();
    const client = core.opensearch.legacy.createClient('query_workbench', {
      plugins: [_sqlPlugin.default]
    }); // Register server side APIs

    (0, _routes.default)(router, client);
    return {};
  }

  start(core) {
    this.logger.debug('queryWorkbenchDashboards: Started');
    return {};
  }

  stop() {}

}

exports.WorkbenchPlugin = WorkbenchPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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