/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.concurrent;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/utils/concurrent/Job;", "", "command", "Ljava/lang/Runnable;", "nextRunTime", "Ljava/time/Instant;", "(Ljava/lang/Runnable;Ljava/time/Instant;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "getCommand", "()Ljava/lang/Runnable;", "getNextRunTime", "()Ljava/time/Instant;", "setNextRunTime", "(Ljava/time/Instant;)V", "ready", "now", "run", "", "toString", "", "jitsi-utils"})
public class Job {
    @NotNull
    private final Runnable command;
    @NotNull
    private Instant nextRunTime;
    private boolean cancelled;

    public Job(@NotNull Runnable command, @NotNull Instant nextRunTime) {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(nextRunTime, "nextRunTime");
        this.command = command;
        this.nextRunTime = nextRunTime;
    }

    @NotNull
    public final Runnable getCommand() {
        return this.command;
    }

    @NotNull
    public final Instant getNextRunTime() {
        return this.nextRunTime;
    }

    public final void setNextRunTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "<set-?>");
        this.nextRunTime = instant;
    }

    public final boolean getCancelled() {
        return this.cancelled;
    }

    public final void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public final void run() {
        this.command.run();
    }

    public final boolean ready(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter(now, "now");
        return this.nextRunTime.compareTo(now) <= 0;
    }

    @NotNull
    public String toString() {
        StringBuffer $this$toString_u24lambda_u2d0 = new StringBuffer();
        boolean bl = false;
        $this$toString_u24lambda_u2d0.append("next run time: " + this.nextRunTime);
        String string = $this$toString_u24lambda_u2d0.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(StringBuffer()) {\n \u2026\n        toString()\n    }");
        return string;
    }
}

