/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.impl.protocol.xmpp.RegistrationListener;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.AvModerationHandlerKt;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/jicofo/xmpp/AvModerationHandler;", "Lorg/jitsi/impl/protocol/xmpp/RegistrationListener;", "Lorg/jivesoftware/smack/StanzaListener;", "xmppProvider", "Lorg/jitsi/impl/protocol/xmpp/XmppProvider;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Lorg/jitsi/impl/protocol/xmpp/XmppProvider;Lorg/jitsi/jicofo/ConferenceStore;)V", "avModerationAddress", "Lorg/jxmpp/jid/DomainBareJid;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "processStanza", "", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "registrationChanged", "registered", "", "shutdown", "jicofo"})
public final class AvModerationHandler
implements RegistrationListener,
StanzaListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final ConferenceStore conferenceStore;
    @Nullable
    private DomainBareJid avModerationAddress;
    @NotNull
    private final Logger logger;

    public AvModerationHandler(@NotNull XmppProvider xmppProvider, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter(xmppProvider, "xmppProvider");
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        this.xmppProvider = xmppProvider;
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.xmppProvider.getXmppConnection().addSyncStanzaListener(this, MessageTypeFilter.NORMAL);
        this.xmppProvider.addRegistrationListener(this);
        this.registrationChanged(this.xmppProvider.isRegistered());
    }

    @Override
    public void processStanza(@NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter(stanza, "stanza");
        if (!Intrinsics.areEqual(stanza.getFrom(), this.avModerationAddress)) {
            return;
        }
        JsonMessageExtension jsonMessageExtension = stanza.getExtension(JsonMessageExtension.class);
        if (jsonMessageExtension == null) {
            Unit unit;
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.logger.warn("Skip processing stanza without JsonMessageExtension");
            return;
        }
        JsonMessageExtension jsonMessage = jsonMessageExtension;
        TaskPools.Companion.getIoPool().execute(() -> AvModerationHandler.processStanza$lambda-2(jsonMessage, this, stanza));
    }

    @Override
    public void registrationChanged(boolean registered) {
        if (!registered) {
            this.avModerationAddress = null;
            return;
        }
        try {
            List<DiscoverInfo.Identity> avModIdentities;
            DiscoverInfo info;
            BareJid bareJid = JidCreate.bareFrom(XmppConfig.client.getXmppDomain());
            Intrinsics.checkNotNullExpressionValue(bareJid, "bareFrom(XmppConfig.client.xmppDomain)");
            DiscoverInfo discoverInfo = info = this.xmppProvider.discoverInfo(bareJid);
            List<DiscoverInfo.Identity> list = avModIdentities = discoverInfo != null ? discoverInfo.getIdentities("component", "av_moderation") : null;
            if (avModIdentities != null && avModIdentities.size() > 0) {
                this.avModerationAddress = JidCreate.domainBareFrom(avModIdentities.get(0).getName());
                this.logger.info("Discovered av_moderation component at " + this.avModerationAddress + ".");
            } else {
                this.avModerationAddress = null;
                this.logger.info("Did not discover av_moderation component.");
            }
        }
        catch (Exception e) {
            this.avModerationAddress = null;
            this.logger.error("Error checking for av_moderation component", e);
        }
    }

    public final void shutdown() {
        this.xmppProvider.getXmppConnection().removeSyncStanzaListener(this);
    }

    private static final void processStanza$lambda-2(JsonMessageExtension $jsonMessage, AvModerationHandler this$0, Stanza $stanza) {
        Intrinsics.checkNotNullParameter($jsonMessage, "$jsonMessage");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($stanza, "$stanza");
        try {
            Object object = new JSONParser().parse($jsonMessage.getJson());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.simple.JSONObject");
            }
            JSONObject incomingJson = (JSONObject)object;
            if (Intrinsics.areEqual(incomingJson.get("type"), "av_moderation")) {
                Object v = incomingJson.get("room");
                EntityBareJid conferenceJid = JidCreate.entityBareFrom(v != null ? v.toString() : null);
                ConferenceStore conferenceStore = this$0.conferenceStore;
                Intrinsics.checkNotNullExpressionValue(conferenceJid, "conferenceJid");
                JitsiMeetConference jitsiMeetConference = conferenceStore.getConference(conferenceJid);
                if (jitsiMeetConference == null) {
                    throw new IllegalStateException("Conference " + conferenceJid + " does not exist.");
                }
                JitsiMeetConference conference = jitsiMeetConference;
                ChatRoom chatRoom = conference.getChatRoom();
                if (chatRoom == null) {
                    throw new IllegalStateException("Conference has no associated chatRoom.");
                }
                ChatRoom chatRoom2 = chatRoom;
                Boolean enabled2 = (Boolean)incomingJson.get("enabled");
                if (enabled2 != null) {
                    Object v2 = incomingJson.get("mediaType");
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    MediaType mediaType = MediaType.parseString((String)v2);
                    boolean oldEnabledValue = chatRoom2.isAvModerationEnabled(mediaType);
                    chatRoom2.setAvModerationEnabled(mediaType, enabled2);
                    if (!Intrinsics.areEqual(oldEnabledValue, enabled2) && enabled2.booleanValue()) {
                        Object v3 = incomingJson.get("actor");
                        if (v3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        this$0.logger.info("Moderation had been enabled for conferenceJid=" + conferenceJid + ", by=" + (String)v3 + ", for mediaType=" + mediaType);
                        conference.muteAllParticipants(mediaType);
                    }
                } else {
                    Object v4 = incomingJson.get("whitelists");
                    if (v4 != null) {
                        Object it = v4;
                        boolean bl = false;
                        chatRoom2.updateAvModerationWhitelists(AvModerationHandlerKt.access$parseAsMapOfStringToListOfString(it));
                    }
                }
            }
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to process av_moderation request from " + $stanza.getFrom(), e);
        }
    }
}

