/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.ChatRoomImpl;
import org.jitsi.impl.protocol.xmpp.ChatRoomMember;
import org.jitsi.jicofo.conference.source.SourceInfo;
import org.jitsi.jicofo.conference.source.SourceInfoKt;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jitsimeet.AudioMutedExtension;
import org.jitsi.xmpp.extensions.jitsimeet.FeaturesExtension;
import org.jitsi.xmpp.extensions.jitsimeet.JitsiParticipantRegionPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.StartMutedPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.StatsId;
import org.jitsi.xmpp.extensions.jitsimeet.UserInfoPacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.VideoMutedExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smackx.muc.Occupant;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class ChatMemberImpl
implements ChatRoomMember {
    private final Logger logger;
    @NotNull
    private final Resourcepart resourcepart;
    private String region;
    private final ChatRoomImpl chatRoom;
    private final int joinOrderNumber;
    @NotNull
    private final EntityFullJid occupantJid;
    private Jid jid = null;
    private Presence presence;
    private boolean robot = false;
    private boolean isJigasi = false;
    private boolean isJibri = false;
    private MemberRole role;
    private String statsId;
    private boolean isAudioMuted = true;
    private boolean isVideoMuted = true;
    @NotNull
    private Set<SourceInfo> sourceInfos = Collections.emptySet();

    public ChatMemberImpl(EntityFullJid fullJid, ChatRoomImpl chatRoom, Logger parentLogger, int joinOrderNumber) {
        this.occupantJid = fullJid;
        this.resourcepart = fullJid.getResourceOrThrow();
        this.chatRoom = chatRoom;
        this.joinOrderNumber = joinOrderNumber;
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.logger.addContext("occupant", this.resourcepart.toString());
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public EntityFullJid getOccupantJid() {
        return this.occupantJid;
    }

    @Override
    public String getName() {
        return this.resourcepart.toString();
    }

    @Override
    public MemberRole getRole() {
        if (this.role == null) {
            Occupant o = this.chatRoom.getOccupant(this);
            if (o == null) {
                return MemberRole.GUEST;
            }
            this.role = MemberRole.fromSmack(o.getRole(), o.getAffiliation());
        }
        return this.role;
    }

    void resetCachedRole() {
        this.role = null;
    }

    @Override
    public void setRole(MemberRole role) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public Jid getJid() {
        if (this.jid == null) {
            this.jid = this.chatRoom.getJid(this.occupantJid);
        }
        return this.jid;
    }

    @Override
    public int getJoinOrderNumber() {
        return this.joinOrderNumber;
    }

    @Override
    public boolean isRobot() {
        return this.robot || this.isJigasi || this.isJibri;
    }

    @Override
    public boolean isJigasi() {
        return this.isJigasi;
    }

    @Override
    public boolean isJibri() {
        return this.isJibri;
    }

    @Override
    public boolean isAudioMuted() {
        return this.isAudioMuted;
    }

    @Override
    public boolean isVideoMuted() {
        return this.isVideoMuted;
    }

    private void setSourceInfo(String sourceInfoString) {
        Set<SourceInfo> sourceInfos;
        try {
            sourceInfos = SourceInfoKt.parseSourceInfoJson(sourceInfoString);
        }
        catch (Exception e) {
            this.logger.warn("Ignoring invalid SourceInfo JSON", e);
            return;
        }
        this.sourceInfos = sourceInfos;
    }

    @Override
    @NotNull
    public Set<SourceInfo> getSourceInfos() {
        return this.sourceInfos;
    }

    void processPresence(Presence presence) {
        StatsId statsIdPacketExt;
        StartMutedPacketExtension ext;
        JitsiParticipantRegionPacketExtension regionPE;
        StandardExtensionElement sourceInfo;
        Boolean newStatus;
        if (!this.occupantJid.equals(presence.getFrom())) {
            throw new IllegalArgumentException(String.format("Presence for another member: %s, my jid: %s", presence.getFrom(), this.occupantJid));
        }
        this.presence = presence;
        UserInfoPacketExt userInfoPacketExt = presence.getExtension(UserInfoPacketExt.class);
        if (userInfoPacketExt != null && (newStatus = userInfoPacketExt.isRobot()) != null && this.robot != newStatus) {
            this.logger.debug(() -> "robot: " + this.robot);
            this.robot = newStatus;
        }
        this.setSourceInfo((sourceInfo = (StandardExtensionElement)presence.getExtension("SourceInfo", "jabber:client")) == null ? "{}" : sourceInfo.getText());
        FeaturesExtension features = presence.getExtension(FeaturesExtension.class);
        if (features != null) {
            this.isJigasi = features.getFeatureExtensions().stream().anyMatch(feature -> "http://jitsi.org/protocol/jigasi".equals(feature.getVar()));
            if (features.getFeatureExtensions().stream().anyMatch(feature -> "http://jitsi.org/protocol/jibri".equals(feature.getVar()))) {
                if (this.isJidTrusted()) {
                    this.isJibri = true;
                } else {
                    DomainBareJid domain2 = this.getJid() == null ? null : this.getJid().asDomainBareJid();
                    this.logger.warn("Jibri signaled from a non-trusted domain: " + domain2 + ". The domain can be configured as trusted with the jicofo.xmpp.trusted-domains property.");
                    this.isJibri = false;
                }
            }
        } else {
            this.isJigasi = false;
            this.isJibri = false;
        }
        if ((regionPE = presence.getExtension(JitsiParticipantRegionPacketExtension.class)) != null) {
            this.region = regionPE.getRegionId();
        }
        if ((ext = presence.getExtension(StartMutedPacketExtension.class)) != null) {
            boolean[] startMuted = new boolean[]{ext.getAudioMuted(), ext.getVideoMuted()};
            if (MemberRoleKt.hasAdministratorRights(this.getRole())) {
                this.chatRoom.setStartMuted(startMuted);
            }
        }
        if ((statsIdPacketExt = presence.getExtension(StatsId.class)) != null) {
            this.statsId = statsIdPacketExt.getStatsId();
        }
        boolean wasAudioMuted = this.isAudioMuted;
        AudioMutedExtension audioMutedExt = presence.getExtension(AudioMutedExtension.class);
        boolean bl = this.isAudioMuted = audioMutedExt == null || audioMutedExt.isAudioMuted() != false;
        if (this.isAudioMuted != wasAudioMuted) {
            this.logger.debug(() -> "isAudioMuted = " + this.isAudioMuted);
            if (this.isAudioMuted) {
                this.chatRoom.removeAudioSender();
            } else {
                this.chatRoom.addAudioSender();
            }
        }
        boolean wasVideoMuted = this.isVideoMuted;
        VideoMutedExtension videoMutedExt = presence.getExtension(VideoMutedExtension.class);
        boolean bl2 = this.isVideoMuted = videoMutedExt == null || videoMutedExt.isVideoMuted() != false;
        if (this.isVideoMuted != wasVideoMuted) {
            this.logger.debug(() -> "isVideoMuted = " + this.isVideoMuted);
            if (this.isVideoMuted) {
                this.chatRoom.removeVideoSender();
            } else {
                this.chatRoom.addVideoSender();
            }
        }
    }

    private boolean isJidTrusted() {
        Jid jid = this.getJid();
        return jid != null && XmppConfig.config.getTrustedDomains().contains(jid.asDomainBareJid());
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getStatsId() {
        return this.statsId;
    }

    public String toString() {
        return String.format("ChatMember[%s, jid: %s]@%s", this.occupantJid, this.jid, this.hashCode());
    }

    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put("resourcepart", this.resourcepart.toString());
        o.put("region", String.valueOf(this.region));
        o.put("join_order_number", (Object)this.joinOrderNumber);
        o.put("occupant_jid", this.occupantJid.toString());
        o.put("jid", String.valueOf(this.jid));
        o.put("robot", (Object)this.robot);
        o.put("is_jibri", (Object)this.isJibri);
        o.put("is_jigasi", (Object)this.isJigasi);
        o.put("role", String.valueOf((Object)this.role));
        o.put("stats_id", String.valueOf(this.statsId));
        o.put("is_audio_muted", (Object)this.isAudioMuted);
        o.put("is_video_muted", (Object)this.isVideoMuted);
        return o;
    }
}

