/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.security;

import com.google.inject.servlet.RequestScoped;
import javax.inject.Inject;
import org.traccar.api.security.ServiceAccountUser;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.ManagedUser;
import org.traccar.model.ScheduledModel;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.model.UserRestrictions;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@RequestScoped
public class PermissionsService {
    private final Storage storage;
    private Server server;
    private User user;

    @Inject
    public PermissionsService(Storage storage) {
        this.storage = storage;
    }

    public Server getServer() throws StorageException {
        if (this.server == null) {
            this.server = this.storage.getObject(Server.class, new Request(new Columns.All()));
        }
        return this.server;
    }

    public User getUser(long userId) throws StorageException {
        if (this.user == null && userId > 0L) {
            this.user = userId == 9000000000000000000L ? new ServiceAccountUser() : this.storage.getObject(User.class, new Request(new Columns.All(), new Condition.Equals("id", "id", userId)));
        }
        return this.user;
    }

    public boolean notAdmin(long userId) throws StorageException {
        return !this.getUser(userId).getAdministrator();
    }

    public void checkAdmin(long userId) throws StorageException, SecurityException {
        if (!this.getUser(userId).getAdministrator()) {
            throw new SecurityException("Administrator access required");
        }
    }

    public void checkManager(long userId) throws StorageException, SecurityException {
        if (!this.getUser(userId).getAdministrator() && this.getUser(userId).getUserLimit() == 0) {
            throw new SecurityException("Manager access required");
        }
    }

    public void checkRestriction(long userId, CheckRestrictionCallback callback) throws StorageException, SecurityException {
        if (!this.getUser(userId).getAdministrator() && (callback.denied(this.getServer()) || callback.denied(this.getUser(userId)))) {
            throw new SecurityException("Operation restricted");
        }
    }

    public void checkEdit(long userId, Class<?> clazz, boolean addition) throws StorageException, SecurityException {
        if (!this.getUser(userId).getAdministrator()) {
            boolean denied = false;
            if (this.getServer().getReadonly() || this.getUser(userId).getReadonly()) {
                denied = true;
            } else if (clazz.equals(Device.class)) {
                boolean bl = denied = this.getServer().getDeviceReadonly() || this.getUser(userId).getDeviceReadonly() || addition && this.getUser(userId).getDeviceLimit() == 0;
                if (addition && this.getUser(userId).getDeviceLimit() > 0) {
                    int deviceCount = this.storage.getObjects(Device.class, new Request(new Columns.Include("id"), new Condition.Permission(User.class, userId, Device.class))).size();
                    denied = deviceCount >= this.getUser(userId).getDeviceLimit();
                }
            } else if (clazz.equals(Command.class)) {
                boolean bl = denied = this.getServer().getLimitCommands() || this.getUser(userId).getLimitCommands();
            }
            if (denied) {
                throw new SecurityException("Write access denied");
            }
        }
    }

    public void checkEdit(long userId, Object object, boolean addition) throws StorageException, SecurityException {
        if (!this.getUser(userId).getAdministrator()) {
            long calendarId;
            long groupId;
            this.checkEdit(userId, object.getClass(), addition);
            boolean denied = false;
            if (object instanceof GroupedModel && (groupId = ((GroupedModel)object).getGroupId()) > 0L) {
                this.checkPermission(Group.class, userId, groupId);
            }
            if (object instanceof ScheduledModel && (calendarId = ((ScheduledModel)object).getCalendarId()) > 0L) {
                denied = this.storage.getPermissions(User.class, userId, Calendar.class, calendarId).isEmpty();
            }
            if (denied) {
                throw new SecurityException("Write access denied");
            }
        }
    }

    public void checkUser(long userId, long managedUserId) throws StorageException, SecurityException {
        if (!(userId == managedUserId || this.getUser(userId).getAdministrator() || this.getUser(userId).getManager() && !this.storage.getPermissions(User.class, userId, ManagedUser.class, managedUserId).isEmpty())) {
            throw new SecurityException("User access denied");
        }
    }

    public void checkUserUpdate(long userId, User before, User after) throws StorageException, SecurityException {
        User user;
        if (before.getAdministrator() != after.getAdministrator() || before.getDeviceLimit() != after.getDeviceLimit() || before.getUserLimit() != after.getUserLimit()) {
            this.checkAdmin(userId);
        }
        if ((user = this.getUser(userId)) != null && user.getExpirationTime() != null && (after.getExpirationTime() == null || user.getExpirationTime().compareTo(after.getExpirationTime()) < 0)) {
            this.checkAdmin(userId);
        }
        if (before.getReadonly() != after.getReadonly() || before.getDeviceReadonly() != after.getDeviceReadonly() || before.getDisabled() != after.getDisabled() || before.getLimitCommands() != after.getLimitCommands() || before.getDisableReports() != after.getDisableReports() || before.getFixedEmail() != after.getFixedEmail()) {
            if (userId == after.getId()) {
                this.checkAdmin(userId);
            } else {
                this.checkUser(userId, after.getId());
            }
        }
        if (before.getFixedEmail() && !before.getEmail().equals(after.getEmail())) {
            this.checkAdmin(userId);
        }
    }

    public <T extends BaseModel> void checkPermission(Class<T> clazz, long userId, long objectId) throws StorageException, SecurityException {
        BaseModel object;
        if (!(this.getUser(userId).getAdministrator() || clazz.equals(User.class) && userId == objectId || (object = (BaseModel)this.storage.getObject(clazz, new Request(new Columns.Include("id"), new Condition.And(new Condition.Equals("id", "id", objectId), new Condition.Permission(User.class, userId, clazz.equals(User.class) ? ManagedUser.class : clazz))))) != null)) {
            throw new SecurityException(clazz.getSimpleName() + " access denied");
        }
    }

    public static interface CheckRestrictionCallback {
        public boolean denied(UserRestrictions var1);
    }
}

