/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.DHEServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDheServerKeyExchangePreparator
extends DHEServerKeyExchangePreparator<PskDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskDheServerKeyExchangeMessage msg;

    public PskDheServerKeyExchangePreparator(Chooser chooser, PskDheServerKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentityHint(this.chooser.getPSKIdentityHint());
        this.msg.setIdentityHintLength(((byte[])this.msg.getIdentityHint().getValue()).length);
        this.setPskDheParams();
        this.preparePskPublicKey(this.msg);
        super.prepareDheParams();
    }

    private void setPskDheParams() {
        this.msg.prepareComputations();
        this.setComputedPskDhGenerator(this.msg);
        this.setComputedPskDhModulus(this.msg);
        this.setComputedPskDhPrivateKey(this.msg);
    }

    protected void setComputedPskDhPrivateKey(PskDheServerKeyExchangeMessage msg) {
        msg.getComputations().setPrivateKey(this.chooser.getPSKServerPrivateKey());
        LOGGER.debug("PrivateKey: " + msg.getComputations().getPrivateKey().getValue());
    }

    protected void setComputedPskDhModulus(PskDheServerKeyExchangeMessage msg) {
        msg.getComputations().setModulus(this.chooser.getPSKModulus());
        LOGGER.debug("Modulus used for Computations: " + ((BigInteger)msg.getComputations().getModulus().getValue()).toString(16));
    }

    protected void setComputedPskDhGenerator(PskDheServerKeyExchangeMessage msg) {
        msg.getComputations().setGenerator(this.chooser.getPSKGenerator());
        LOGGER.debug("Generator used for Computations: " + ((BigInteger)msg.getComputations().getGenerator().getValue()).toString(16));
    }

    private void preparePskPublicKey(PskDheServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.chooser.getPSKServerPublicKey().toByteArray());
        LOGGER.debug("PublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }
}

